/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock003.createWebDAVSchema();
        TestLock003.addGlobalMessage((String)("prepare test " + TestLock003.getTestClassId()), (char)'I', (String)"lock on a null resource");
        host = new String(TestLock003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock003.getPort();
        baseUrl = TestLock003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock003.addGlobalMessage((String)"1. DELETE resource /TestLock003.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if ((locktoken = TestLock003.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock003.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists()) {
            TestLock003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() != 200) {
                TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 200 OK.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock003.addGlobalMessage((String)"3. LOCK the non-existent resource /TestLock003.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        try {
            if (resource.exists()) {
                locktoken = TestLock003.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            }
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            TestLock003.addGlobalMessage((String)"4. PUT the resource TestLock003.txt", (char)'I', (String)"Test was successful!");
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock003.addGlobalMessage((String)"4. PUT the resource TestLock003.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock003.addGlobalMessage((String)"4. PUT the resource TestLock003.txt", (char)'I', (String)"Expected result: 201 Created");
        }
        catch (Exception exc) {
            TestLock003.addGlobalMessage((String)"4. PUT the resource TestLock003.txt", (char)'E', (String)("  Java exception: " + exc));
            exc.printStackTrace();
            TestLock003.addGlobalMessage((String)"4. PUT the resource TestLock003.txt", (char)'I', (String)("Skipping test " + TestLock003.getTestClassId()));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestLock003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock003.addGlobalMessage((String)"5. DELETE the resource /TestLock003.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock003.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock003.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

