/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.headtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TestHead003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String lastModifiedStr = null;

    public static void prepare() throws TestCaseException {
        TestHead003.createWebDAVSchema();
        TestHead003.addGlobalMessage((String)("prepare test " + TestHead003.getTestClassId()), (char)'I', (String)"head on a resource to check the 'Last-Modified' header object");
        host = new String(TestHead003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestHead003.getPort();
        baseUrl = TestHead003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestHead003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestHead003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestHead003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestHead003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestHead003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestHead003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestHead003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestHead003.addGlobalMessage((String)"1. DELETE resource /TestHead003.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestHead003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestHead003.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        SimpleDateFormat sdf_fulldate = new SimpleDateFormat("EEE, dd MMM yyyy", new Locale("en"));
        SimpleDateFormat sdf_fulltime = new SimpleDateFormat("HH:mm:ss z", new Locale("en"));
        Date date = new Date();
        lastModifiedStr = String.valueOf(sdf_fulldate.format(date)) + " " + sdf_fulltime.format(date);
    }

    public void run() {
        try {
            resource.HEAD(null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestHead003.addGlobalMessage((String)("3. call the HEAD method for the resource http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestHead003.addGlobalMessage((String)("3. call the HEAD method for the resource http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestHead003.addGlobalMessage((String)("3. call the HEAD method for the resource http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestHead003.addGlobalMessage((String)("3. call the HEAD method for the resource http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature.");
        }
        String lastModifiedStr_R = new String();
        lastModifiedStr_R = resource.getResponseHeaders().lastModified();
        if (lastModifiedStr_R != null) {
            if (lastModifiedStr_R.equalsIgnoreCase(lastModifiedStr)) {
                TestHead003.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value is in the response header", (char)'I', (String)"Test was successful!");
            } else {
                TestHead003.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value is in the response header", (char)'W', (String)("expected value: " + lastModifiedStr + "\n" + "received value: " + lastModifiedStr_R + "\n\n" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128986"));
            }
        } else {
            TestHead003.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value is in the response header", (char)'E', (String)"The 'Last-Modified' field is NOT existent");
            TestHead003.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value is in the response header", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestHead003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

