/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class User {
    private String mName = null;
    private String mMode = "dba";
    private boolean mExclusive = false;
    private String mPassword = null;
    private TestDatabase mDatabase;

    public User(TestDatabase pDatabase, String pName, String pPassword) {
        this.mName = pName;
        this.mPassword = pPassword;
        this.mDatabase = pDatabase;
    }

    public Connection connect() throws TestDatabaseException {
        return this.mDatabase.connect(this.mName, this.mPassword);
    }

    public static User create(TestStatement pTestStmt, TestDatabase pDatabase, String pName, String pPassword, String pMode, boolean pIsExclusive) throws SQLException {
        String lSql = "create user " + pName + " " + pPassword + " " + pMode;
        lSql = pIsExclusive ? lSql + " exclusive" : lSql + " not exclusive";
        pTestStmt.executeUpdate(lSql);
        return new User(pDatabase, pName, pPassword);
    }

    public static TestStatement drop(TestStatement pTestStmt, User pUser) throws SQLException {
        pTestStmt.executeUpdate("drop user " + pUser.getName());
        return pTestStmt;
    }

    public TestDatabase getDatabase() {
        return this.mDatabase;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getName() {
        return this.mName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public boolean isExclusive() {
        return this.mExclusive;
    }
}

