/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.utilities.DBInputStream;
import com.sap.sapdb.testframe.utilities.Table;
import com.sap.sapdb.testframe.utilities.TableField;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;

class TableFillerThread
extends Thread {
    private Table mTable;
    private TestCase mTestCase;
    private Connection mConnection;
    private int mNoOfRows;
    private boolean mHasError = false;
    private Exception mException = null;
    private int mBatchSize = 1000;
    private static int mInstanceCounter = 0;

    public TableFillerThread(Table pTable, TestCase pTestCase, Connection pConnection, int pNoOfRows) {
        ++mInstanceCounter;
        this.mTable = pTable;
        this.mTestCase = pTestCase;
        this.mConnection = pConnection;
        this.mNoOfRows = pNoOfRows;
        this.mBatchSize = this.mTable.isTableHasLong() ? 5 : 1000;
    }

    private void fill() throws Exception {
        TestPreparedStatement lPStmt = null;
        int lNumberOfFields = this.mTable.getNumberOfFields();
        if (lNumberOfFields == 0) {
            return;
        }
        String lHostVar = "";
        for (int i = 1; i <= lNumberOfFields; ++i) {
            lHostVar = lHostVar + "?";
            if (i >= lNumberOfFields) continue;
            lHostVar = lHostVar + ",";
        }
        String lSql = "insert into " + this.mTable.getName() + " values (" + lHostVar + ")";
        lPStmt = new TestPreparedStatement(this.mTestCase, this.mConnection, lSql);
        int lBatchEntries = 0;
        for (int i = 0; i < this.mNoOfRows; ++i) {
            for (int j = 0; j < this.mTable.getNumberOfFields(); ++j) {
                this.setFieldValue(lPStmt, this.mTable.getField(j));
            }
            lPStmt.addBatch();
            if (++lBatchEntries < this.mBatchSize) continue;
            lPStmt.executeBatch();
            lPStmt.clearBatch();
            this.mConnection.commit();
            lBatchEntries = 0;
        }
        if (lBatchEntries > 0) {
            lPStmt.executeBatch();
            lPStmt.clearBatch();
            this.mConnection.commit();
        }
        lPStmt.close();
    }

    public Exception getException() {
        return this.mException;
    }

    public Table getTable() {
        return this.mTable;
    }

    public boolean hasError() {
        return this.mHasError;
    }

    public void run() {
        this.mHasError = false;
        try {
            this.fill();
        }
        catch (Exception e) {
            this.mHasError = true;
            this.mException = e;
        }
    }

    private final boolean setFieldValue(TestPreparedStatement pTestStmt, TableField pField) throws SQLException {
        TableField lField = pField;
        switch (lField.getTypeInternal()) {
            case -7: {
                pTestStmt.setBoolean(lField.getPosition(), this.mTable.getRandomGen().determineBoolean(lField));
                break;
            }
            case -6: {
                pTestStmt.setByte(lField.getPosition(), this.mTable.getRandomGen().determineByte(lField));
                break;
            }
            case 5: {
                pTestStmt.setShort(lField.getPosition(), this.mTable.getRandomGen().determineShort(lField));
                break;
            }
            case 4: {
                pTestStmt.setInt(lField.getPosition(), this.mTable.getRandomGen().determineInt(lField));
                break;
            }
            case -5: {
                pTestStmt.setLong(lField.getPosition(), this.mTable.getRandomGen().determineLong(lField));
                break;
            }
            case 6: {
                pTestStmt.setFloat(lField.getPosition(), this.mTable.getRandomGen().determineFloat(lField));
                break;
            }
            case 7: {
                pTestStmt.setFloat(lField.getPosition(), this.mTable.getRandomGen().determineFloat(lField));
                break;
            }
            case 8: {
                pTestStmt.setDouble(lField.getPosition(), this.mTable.getRandomGen().determineDouble(lField));
                break;
            }
            case 2: {
                pTestStmt.setBigDecimal(lField.getPosition(), this.mTable.getRandomGen().determineBigDecimal(lField));
                break;
            }
            case 3: {
                pTestStmt.setBigDecimal(lField.getPosition(), this.mTable.getRandomGen().determineBigDecimal(lField));
                break;
            }
            case 1: {
                pTestStmt.setString(lField.getPosition(), this.mTable.getRandomGen().determineString(lField));
                break;
            }
            case 12: {
                pTestStmt.setString(lField.getPosition(), this.mTable.getRandomGen().determineString(lField));
                break;
            }
            case -1: {
                DBInputStream dbi = this.mTable.getRandomGen().determineAsciiStream(lField);
                pTestStmt.setAsciiStream(lField.getPosition(), (InputStream)dbi.getBis(), dbi.getLen());
                try {
                    dbi.getBis().close();
                }
                catch (IOException e) {}
                break;
            }
            case 91: {
                pTestStmt.setDate(lField.getPosition(), this.mTable.getRandomGen().determineDate(lField));
                break;
            }
            case 92: {
                pTestStmt.setTime(lField.getPosition(), this.mTable.getRandomGen().determineTime(lField));
                break;
            }
            case 93: {
                pTestStmt.setTimestamp(lField.getPosition(), this.mTable.getRandomGen().determineTimestamp(lField));
                break;
            }
            case -2: {
                pTestStmt.setBytes(lField.getPosition(), this.mTable.getRandomGen().determineBytes(lField));
                break;
            }
            case -3: {
                pTestStmt.setBytes(lField.getPosition(), this.mTable.getRandomGen().determineBytes(lField));
                break;
            }
            case -4: {
                DBInputStream dbi = this.mTable.getRandomGen().determineBinaryStream(lField);
                pTestStmt.setBinaryStream(lField.getPosition(), (InputStream)dbi.getBis(), dbi.getLen());
                try {
                    dbi.getBis().close();
                }
                catch (IOException e) {}
                break;
            }
            case 0: {
                break;
            }
            case 1111: {
                pTestStmt.setNull(lField.getPosition(), 1111);
                break;
            }
            case 2000: {
                pTestStmt.setNull(lField.getPosition(), 2000);
                break;
            }
            case 2001: {
                pTestStmt.setNull(lField.getPosition(), 2001);
                break;
            }
            case 2002: {
                pTestStmt.setNull(lField.getPosition(), 2002);
                break;
            }
            case 2003: {
                pTestStmt.setNull(lField.getPosition(), 2003);
                break;
            }
            case 2004: {
                pTestStmt.setNull(lField.getPosition(), 2004);
                break;
            }
            case 2005: {
                pTestStmt.setNull(lField.getPosition(), 2005);
                break;
            }
            case 2006: {
                pTestStmt.setNull(lField.getPosition(), 2006);
                break;
            }
            default: {
                throw new RuntimeException("Unknown sql field type. Method TableFiller.fill");
            }
        }
        return true;
    }

    public void setTable(Table newTable) {
        this.mTable = newTable;
    }
}

