/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.utilities.Session;
import com.sap.sapdb.testframe.utilities.SessionChecked;
import com.sap.sapdb.testframe.utilities.User;
import java.util.ArrayList;

public class SessionManager {
    private ArrayList mSessionThreads = new ArrayList();
    private boolean mParallel = true;
    private int mIsolationLevel = 2;

    public SessionManager(boolean pParallel) {
        this.mParallel = pParallel;
    }

    public int getIsolationLevel() {
        return this.mIsolationLevel;
    }

    public void interruptAllSessions() throws InterruptedException {
        Thread lThread = null;
        while (this.mSessionThreads.iterator().hasNext()) {
            lThread = (Thread)this.mSessionThreads.iterator().next();
            if (lThread == null || !lThread.isAlive()) continue;
            this.mSessionThreads.remove(lThread);
            lThread.interrupt();
        }
    }

    public boolean isSessionActive() {
        Thread lThread = null;
        while (this.mSessionThreads.iterator().hasNext()) {
            lThread = (Thread)this.mSessionThreads.iterator().next();
            if (lThread != null && lThread.isAlive()) {
                return true;
            }
            this.mSessionThreads.remove(lThread);
        }
        return false;
    }

    public void joinAllSessions() throws InterruptedException {
        while (this.isSessionActive()) {
            Thread.sleep(1000L);
        }
    }

    public int runSession(TestCase pTestCase, User pUser, String pSql) {
        Session ls = new Session(pTestCase, pUser, pSql);
        ls.setIsolationLevel(this.mIsolationLevel);
        Thread lThread = new Thread(ls);
        this.mSessionThreads.add(lThread);
        lThread.start();
        try {
            if (!this.mParallel) {
                lThread.join();
            }
        }
        catch (InterruptedException ie) {
            System.err.println("Session manager: join for thread failed");
            ie.printStackTrace(System.err);
        }
        return this.mSessionThreads.indexOf(lThread);
    }

    public int runSession(Session pSession) {
        Thread lThread = new Thread(pSession);
        this.mSessionThreads.add(lThread);
        lThread.start();
        try {
            if (!this.mParallel) {
                lThread.join();
            }
        }
        catch (InterruptedException ie) {
            System.err.println("Session manager: join for thread failed");
            ie.printStackTrace(System.err);
        }
        return this.mSessionThreads.indexOf(lThread);
    }

    public int runSessionChecked(TestCase pTestCase, User pUser, String pSql, int pResultCounter) {
        SessionChecked lsc = new SessionChecked(pTestCase, pUser, pSql, pResultCounter);
        lsc.setIsolationLevel(this.mIsolationLevel);
        Thread lThread = new Thread(lsc);
        this.mSessionThreads.add(lThread);
        lThread.start();
        try {
            if (!this.mParallel) {
                lThread.join();
            }
        }
        catch (InterruptedException ie) {
            System.err.println("Session manager: join for thread failed");
            ie.printStackTrace(System.err);
        }
        return this.mSessionThreads.indexOf(lThread);
    }

    public void setIsolationLevel(int newIsolationLevel) {
        this.mIsolationLevel = newIsolationLevel;
    }
}

