/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.IndexField;
import com.sap.sapdb.testframe.utilities.Table;
import java.sql.SQLException;
import java.sql.Statement;

public class Index {
    private Table mTable;
    private boolean mUnique;
    private IndexField[] mFields;
    private String mName;

    public Index(String pName, Table pTable, IndexField[] pFields, boolean pUnique) {
        this.mName = pName;
        this.mTable = pTable;
        this.mFields = pFields;
        this.mUnique = pUnique;
    }

    public Index(String pName, Table pTable, String[] pFields, boolean pUnique) {
        this.mName = pName;
        this.mTable = pTable;
        this.mUnique = pUnique;
        if (pFields != null) {
            this.mFields = new IndexField[pFields.length];
            for (int i = 0; i < pFields.length; ++i) {
                String s = pFields[i];
                this.mFields[i] = s.toUpperCase().endsWith("ASC") ? new IndexField(s.substring(0, s.toUpperCase().lastIndexOf("ASC"))) : (s.toUpperCase().endsWith("DESC") ? new IndexField(s.substring(0, s.toUpperCase().lastIndexOf("DESC")), "DESC") : new IndexField(s));
            }
        }
    }

    public TestStatement create(TestStatement pTStmt) throws SQLException {
        String lSql = "";
        String lFields = "";
        for (int i = 0; i < this.mFields.length; ++i) {
            lFields = lFields + this.mFields[i].getName() + " " + this.mFields[i].getSortOrder();
            if (i >= this.mFields.length - 1) continue;
            lFields = lFields + " , ";
        }
        lSql = this.mUnique ? "create unique index " + this.mName + " on " + this.mTable.getName() : "create index " + this.mName + " on " + this.mTable.getName();
        lSql = lSql + " ( " + lFields + " ) ";
        pTStmt.executeUpdate(lSql);
        return pTStmt;
    }

    public Statement drop(Statement pTStmt) throws SQLException {
        return this.drop(pTStmt, true);
    }

    public Statement drop(Statement pTStmt, boolean pThrowException) throws SQLException {
        block2: {
            try {
                pTStmt.execute("drop index " + this.mName + " on " + this.mTable.getName());
            }
            catch (SQLException se) {
                if (!pThrowException) break block2;
                throw se;
            }
        }
        return pTStmt;
    }

    public boolean isUnique() {
        return this.mUnique;
    }
}

