/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.io.File;
import java.io.FileFilter;

public class DirectoryCleaner {
    private File mDir = null;
    private String mFileMask = null;
    private int mInterval = -1;
    private CleanerThread mCleanerThread = null;

    public DirectoryCleaner(File dir, String fileMask, int interval) throws IllegalArgumentException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory");
        }
        if (fileMask == null) {
            throw new IllegalArgumentException("Empty fileMask");
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Zero interval");
        }
        this.mDir = dir;
        this.mFileMask = fileMask;
        this.mInterval = interval;
        this.mCleanerThread = new CleanerThread();
    }

    public void start() {
        if (this.mCleanerThread != null) {
            this.mCleanerThread.start();
        }
    }

    public void stop() {
        this.mCleanerThread.setStop(true);
    }

    public int getDeletedFilesCounter() {
        if (this.mCleanerThread != null) {
            return this.mCleanerThread.getDeletedFilesCounter();
        }
        return 0;
    }

    static /* synthetic */ String access$100(DirectoryCleaner x0) {
        return x0.mFileMask;
    }

    private final class CleanerThread
    extends Thread {
        private boolean mStopped = false;
        private FileFilter mFilter = null;
        private int mDeletedFilesCounter = 0;

        public CleanerThread() {
            try {
                this.setPriority(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mFilter = new FileFilter(this){
                private final /* synthetic */ CleanerThread this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    if (!f.isFile()) {
                        return false;
                    }
                    String fname = f.getName();
                    if (DirectoryCleaner.access$100(CleanerThread.access$000(this.this$1)).charAt(DirectoryCleaner.access$100(CleanerThread.access$000(this.this$1)).length() - 1) == '*') {
                        String tmpMask = DirectoryCleaner.access$100(CleanerThread.access$000(this.this$1)).substring(0, DirectoryCleaner.access$100(CleanerThread.access$000(this.this$1)).length() - 1);
                        if (tmpMask.length() > fname.length()) {
                            return false;
                        }
                        return fname.startsWith(tmpMask);
                    }
                    return fname.equals(DirectoryCleaner.access$100(CleanerThread.access$000(this.this$1)));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.mStopped = false;
            this.mDeletedFilesCounter = 0;
            while (!this.mStopped) {
                File[] matchingFiles = DirectoryCleaner.this.mDir.listFiles(this.mFilter);
                if (matchingFiles != null) {
                    int i;
                    long max = 0L;
                    int maxi = -1;
                    for (i = 0; i < matchingFiles.length; ++i) {
                        if (matchingFiles[i].lastModified() < max) continue;
                        max = matchingFiles[i].lastModified();
                        maxi = i;
                    }
                    if (maxi != -1) {
                        matchingFiles[maxi] = null;
                    }
                    for (i = 0; i < matchingFiles.length; ++i) {
                        if (matchingFiles[i] == null) continue;
                        try {
                            matchingFiles[i].delete();
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        ++this.mDeletedFilesCounter;
                    }
                }
                CleanerThread cleanerThread = this;
                synchronized (cleanerThread) {
                    try {
                        this.wait(DirectoryCleaner.this.mInterval);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public int getDeletedFilesCounter() {
            return this.mDeletedFilesCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStop(boolean b) {
            this.mStopped = b;
            if (this.mStopped) {
                CleanerThread cleanerThread = this;
                synchronized (cleanerThread) {
                    this.notifyAll();
                }
            }
        }

        static /* synthetic */ DirectoryCleaner access$000(CleanerThread x0) {
            return x0.DirectoryCleaner.this;
        }
    }
}

