/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;

public class VerificationDataUnitTest
extends TestCase {
    VerificationData veri = null;
    BigDecimal a;
    BigDecimal b;
    BigDecimal c;
    Integer i;
    Integer l;
    Integer m;
    Object nu1 = null;
    Object nu2 = null;

    protected void setUp() throws Exception {
        this.veri = new VerificationDataComplete();
    }

    public void testCompareNumbers() {
        this.a = new BigDecimal("123");
        this.b = new BigDecimal("123");
        this.c = new BigDecimal("321");
        this.i = new Integer(123);
        this.l = new Integer(123);
        this.m = new Integer(321);
        this.veri.compareNumber(this.a, 0, 0, (Object)this.b);
        this.veri.compareNumber(this.a, 0, 0, (Object)this.i);
        this.veri.compareNumber(this.i, 0, 0, (Object)this.a);
        this.veri.compareNumber(this.i, 0, 0, (Object)this.l);
        try {
            this.veri.compareNumber(this.c, 0, 0, (Object)this.a);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found <" + this.c + ">."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.c, 0, 0, (Object)this.i);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.i + ">, but found <" + this.c + ">."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.i, 0, 0, (Object)this.c);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.c + ">, but found <" + this.i + ">."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.i, 0, 0, (Object)this.m);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.m + ">, but found <" + this.i + ">."), (String)e.getMessage());
        }
        this.veri.compareNumber("nan", 0, 0, (Object)"NAN");
        this.veri.compareNumber("NaN", 0, 0, (Object)"NaN");
        try {
            this.veri.compareNumber("NaN", 0, 0, (Object)this.a);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found <NaN>."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber("NaN", 0, 0, (Object)this.i);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.i + ">, but found <NaN>."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.b, 0, 0, (Object)"NaN");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <NaN>, but found <" + this.a + ">."), (String)e.getMessage());
        }
        this.veri.compareNumber(this.nu1, 0, 0, this.nu2);
        try {
            this.veri.compareNumber(this.a, 0, 0, this.nu1);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting NULL value, but found <" + this.a + ">."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.nu1, 0, 0, (Object)this.a);
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:100/130");
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:120/3%");
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:<130");
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:>120");
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:<=123");
        this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:>=123");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:100/130");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:120/3%");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:<130");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:>120");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:<=123");
        this.veri.compareNumber(this.i, 0, 0, (Object)"RANGE:>=123");
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:100/130");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:120/3%");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:<130");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:>120");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:<=123");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
        try {
            this.veri.compareNumber(this.a, 0, 0, (Object)"RANGE:>=123");
        }
        catch (RuntimeException e) {
            VerificationDataUnitTest.assertEquals((String)("Wrong value in row <0>, column <0>: Expecting <" + this.a + ">, but found NULL value."), (String)e.getMessage());
        }
    }

    public void testCreateRowHash() {
        ArrayList<Object> al1 = new ArrayList<Object>();
        ArrayList<Object> al2 = new ArrayList<Object>();
        ArrayList<Object> al3 = new ArrayList<Object>();
        al1.add(new Integer(1));
        al2.add(new Long(1L));
        al3.add(new BigDecimal("1"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add("Bla");
        al2.add("Bla");
        al3.add("Bla");
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new Integer(123456789));
        al2.add(new BigDecimal("123456789"));
        al3.add(new BigDecimal("123456789.00000"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al3.set(2, new BigDecimal("123456789.00001"));
        VerificationDataUnitTest.assertFalse((boolean)this.compareRowHash(al1, al3));
        al3.set(2, new BigDecimal("123456789.0000000000"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new Long(123456789123456789L));
        al2.add(new BigDecimal("123456789123456789"));
        al3.add(new BigDecimal("123456789123456789.000000000000000000"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new Long(123456789000000000L));
        al2.add(new BigDecimal("123456789000000000"));
        al3.add(new BigDecimal(new BigInteger("123456789"), -9));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new BigDecimal("1234567891234567890000000000000000"));
        al2.add(new BigDecimal(new BigInteger("123456789123456789"), -16));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(new BigDecimal("-1234567891234567890000000000000000"));
        al2.add(new BigDecimal(new BigInteger("-123456789123456789"), -16));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(new BigDecimal("11.60000000000000000000000000000000000000"));
        al2.add(new BigDecimal("11.6"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.clear();
        al2.clear();
        al3.clear();
        al1.add(new Integer(116));
        al2.add(new BigDecimal("116.00000000000000000000000000000000000000"));
        al3.add(new BigDecimal("116"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new Integer(-1));
        al2.add(new Long(-1L));
        al3.add(new BigDecimal("-1"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al3));
        al1.add(new BigDecimal("-1E-64"));
        al2.add(new BigDecimal("-1E-64"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(null);
        al2.add(null);
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(new BigDecimal(new BigInteger("1"), 30));
        al2.add(new BigDecimal(".000000000000000000000000000001"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(new BigDecimal(new BigInteger("1"), 18));
        al2.add(new BigDecimal(".000000000000000001"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        Random ran = new Random();
        float f1 = ran.nextFloat();
        al1.add(new Float(f1));
        al2.add(new Float(f1));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
        al1.add(new BigDecimal("0.24121224011259E+20"));
        al2.add(new BigDecimal("24121224011259000000"));
        VerificationDataUnitTest.assertTrue((boolean)this.compareRowHash(al1, al2));
    }

    private boolean compareRowHash(ArrayList val1, ArrayList val2) {
        int h2;
        int h1 = VerificationData.createRowHash(val1, val1.size(), null);
        return h1 == (h2 = VerificationData.createRowHash(val2, val2.size(), null).intValue());
    }
}

