/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.driver.TestDriverProtocol;
import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.driver.TestResultDatabase;
import com.sap.sapdb.testframe.driver.TestStatistic;
import com.sap.sapdb.testframe.driver.TestTrace;
import com.sap.sapdb.testframe.driver.UnknownUserException;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestParameter;
import com.sap.sapdb.testframe.testcase.TestParameterException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sapdb.testframe.testcase.VerificationItemData;
import com.sap.sapdb.testframe.testcase.VerificationObject;
import com.sap.sapdb.testframe.testcase.VerificationRefObject;
import com.sap.sapdb.testframe.testcase.VerificationTestObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class TestCase
implements Runnable {
    private static String sUser;
    private static String sPassword;
    protected static Properties mTestDriverOptions;
    private static TestDriver sTestDriver;
    protected static TestDriverConfiguration mTestDriverConfiguration;
    private static TestDatabase sDatabase;
    private static TestProtocol sProtocol;
    private static TestDriverProtocol sTDProtocol;
    private static TestParameter sParameterObject;
    private Vector mTestDatabaseSAP = new Vector(2);
    private String mTestId = null;
    private static boolean sSave;
    private static String sReferenceDbSysName;
    private static final DecimalFormat STEP_FORMAT;
    private static final boolean sSystemOut = true;
    private boolean mPrintResultsDirectToScreen = false;
    private static TestResultDatabase sResultDatabase;
    private static int sInfoCounter;
    private static int sWarningCounter;
    private static int sErrorCounter;
    private static int sCustomMessageCounter;
    private static int sReminderCounter;
    private boolean mTestIsAborted;
    private boolean mTestIsInterruptedByCaller;
    private VerificationObject mReadObject;
    private VerificationObject mWriteObject;
    private HashMap mStepMap;
    private TestStatement[] mActiveStatements = new TestStatement[50];
    private TestStatement mLastStatement;
    private String mLastErrorMessage = null;
    private static String sTestClassId;
    private static String sTestNameForProtocol;
    private static String sTestNumber;
    private static char sRunMode;
    private boolean mAutoStep = true;
    private boolean mRefRun = false;
    private boolean mDevTrace = false;
    private int mMaxActiveStatement;
    private String mLastStep = null;
    private TestTrace mTrace;
    private static ArrayList sErrorMessages;
    private String status = "not available";
    private PropertyChangeSupport properties = new PropertyChangeSupport(this);
    private static String sTestName;
    private static String sTestClassName;
    private String dbRoot = null;
    private String secondDbRoot = null;
    private String secondDbHost = null;
    private int secondDbPort;

    public TestCase() throws SQLException, TestDatabaseException {
        this.mStepMap = new HashMap();
        String lTestDbSysName = null;
        if (TestCase.getDatabase() != null) {
            lTestDbSysName = TestCase.getDatabase().getId();
        }
        switch (Character.toUpperCase(TestCase.getRunMode())) {
            case 'A': {
                this.mWriteObject = new VerificationTestObject(TestCase.getTestClassId(), lTestDbSysName, TestCase.getResultDatabase());
                this.mReadObject = null;
                this.mRefRun = false;
                break;
            }
            case 'B': {
                this.mWriteObject = new VerificationTestObject(TestCase.getTestClassId(), lTestDbSysName, TestCase.getResultDatabase());
                if (TestCase.getReferenceDbSysName() == null || TestCase.getReferenceDbSysName().trim().equals("")) {
                    throw new RuntimeException("Invalid reference database system name");
                }
                this.mReadObject = VerificationRefObject.read(TestCase.getTestClassId(), TestCase.getReferenceDbSysName(), TestCase.getResultDatabase());
                if (this.mReadObject == null) {
                    TestCase.addGlobalMessage("Test Case constructor", 'E', "Can't compare to a reference object. No reference object available!!!");
                }
                this.mRefRun = false;
                break;
            }
            case 'C': {
                this.mWriteObject = new VerificationRefObject(TestCase.getTestClassId(), lTestDbSysName, TestCase.getResultDatabase());
                this.mReadObject = null;
                this.mRefRun = true;
                break;
            }
            default: {
                throw new RuntimeException("Mode " + TestCase.getRunMode() + " not possible. Please choose A, B or C");
            }
        }
        if (TestCase.isSave()) {
            this.mWriteObject.setSaveOnFinalize(TestCase.isSave());
        }
    }

    public final void setDBRoot(String newDBRoot) {
        this.dbRoot = newDBRoot != null ? new String(newDBRoot) : null;
    }

    public final String getDBRoot() {
        return new String(this.dbRoot);
    }

    public final void setSecondDBRoot(String newSecondDBRoot) {
        this.secondDbRoot = newSecondDBRoot != null ? new String(newSecondDBRoot) : null;
    }

    public final String getSecondDBRoot() {
        return this.secondDbRoot;
    }

    public final void setSecondDBHost(String newDBSecondHost) {
        this.secondDbHost = newDBSecondHost != null ? new String(newDBSecondHost) : null;
    }

    public final String getSecondDBHost() {
        return this.secondDbHost;
    }

    public final int getSecondDBPort() {
        return this.secondDbPort;
    }

    public final void setSecondDBPort(int newDBSecondport) {
        this.secondDbPort = newDBSecondport > 0 ? newDBSecondport : 7210;
    }

    protected final void abort(String pMessageId, String pMessageText, Exception pException, String pSql) throws TestCaseException {
        this.addMessage(pMessageId, 'A', pMessageText, pException, pSql);
        throw new TestCaseException("Test aborted by abort method");
    }

    private static final synchronized void addCounters(char pMessageType) {
        switch (Character.toUpperCase(pMessageType)) {
            case 'I': {
                ++sInfoCounter;
                break;
            }
            case 'W': {
                ++sWarningCounter;
                break;
            }
            case 'E': {
                ++sErrorCounter;
                break;
            }
            case 'R': {
                ++sReminderCounter;
                break;
            }
            default: {
                ++sCustomMessageCounter;
            }
        }
    }

    private static final synchronized void addErrors(char pMessageType, String pMessageText, String pSQL) {
        if (sErrorMessages.size() > 11) {
            return;
        }
        if (Character.toUpperCase(pMessageType) == 'E' || Character.toUpperCase(pMessageType) == 'A') {
            if (pSQL != null && !pSQL.trim().equals("")) {
                sErrorMessages.add(pSQL + " :\n" + pMessageText);
            } else {
                sErrorMessages.add(pMessageText);
            }
        }
    }

    protected static final void addGlobalMessage(String pMessageId, char pMessageType, String pMessageText) {
        TestCase.getProtocol().addItem(TestCase.getTestClassId(), pMessageId, pMessageType, pMessageText);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, null);
    }

    protected static final void addGlobalMessage(String pMessageId, char pMessageType, String pMessageText, Exception pException, String pSql) {
        TestCase.getProtocol().addExceptionSqlItem(TestCase.getTestClassId(), pMessageId, pMessageType, pMessageText, pException, pSql);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, pSql);
    }

    public final void addMessage(String pMessageId, char pMessageType, String pMessageText) {
        TestCase.getProtocol().addItem(this.getTestId(), pMessageId, pMessageType, pMessageText);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, null);
    }

    public final void addErrorMessageWithFile(String pMessageId, String pMessageText) {
        TestCase.getProtocol().addItem(this.getTestId(), pMessageId, 'E', pMessageText, this.getLogFileName());
        TestCase.addCounters('E');
        TestCase.addErrors('E', pMessageText, null);
    }

    public final void addErrorMessageWithFile(String pMessageId, String pMessageText, String pFileName) {
        TestCase.getProtocol().addItem(this.getTestId(), pMessageId, 'E', pMessageText, pFileName);
        TestCase.addCounters('E');
        TestCase.addErrors('E', pMessageText, null);
    }

    public final void addMessage(String pMessageId, char pMessageType, String pMessageText, Exception pException) {
        TestCase.getProtocol().addExceptionItem(this.getTestId(), pMessageId, pMessageType, pMessageText, pException);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, null);
    }

    public final void addMessage(String pMessageId, char pMessageType, String pMessageText, Exception pException, String pSql) {
        TestCase.getProtocol().addExceptionSqlItem(this.getTestId(), pMessageId, pMessageType, pMessageText, pException, pSql);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, pSql);
    }

    public final void addMessage(String pMessageId, char pMessageType, String pMessageText, String pSql) {
        TestCase.getProtocol().addSqlItem(this.getTestId(), pMessageId, pMessageType, pMessageText, pSql);
        TestCase.addCounters(pMessageType);
        TestCase.addErrors(pMessageType, pMessageText, pSql);
    }

    public final void addMessage(String pMessageId, char pMessageType, String pMessageText, int pTraceLevel) {
        if (pTraceLevel == 0) {
            return;
        }
        if (pTraceLevel == 1) {
            this.addMessage(pMessageId, pMessageType, pMessageText);
            return;
        }
        if (pTraceLevel == 2) {
            System.out.println(pMessageId + " -> " + pMessageText);
            return;
        }
        if (pTraceLevel == 3) {
            System.out.println(pMessageId + " -> " + pMessageText);
            this.addMessage(pMessageId, pMessageType, pMessageText);
            return;
        }
        System.out.println("Wrong parameter pTraceLevel. get: " + pTraceLevel);
    }

    private final void addStatementResult(TestStatement pStatement, String pStep) throws TestCaseException {
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        this.mWriteObject.putItem(pStep, pStatement.cloneResultData());
        try {
            if (this.mPrintResultsDirectToScreen) {
                this.mWriteObject.print();
            }
        }
        catch (IOException e) {
            this.addMessage("addStatement", 'I', "Error printing result object", e);
        }
    }

    private final void addStatementResultAndData(TestStatement pStatement, String pStep) throws TestCaseException {
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        VerificationItemData lItemData = pStatement.cloneResultData();
        try {
            ResultSet lRs = pStatement.getResultSet();
            if (lRs != null) {
                lItemData.setVerificationData(new VerificationDataSorted(lRs));
            } else {
                lItemData.setVerificationData(null);
            }
        }
        catch (SQLException e) {
            this.addMessage("addStatement", 'I', "Error getting result set from test statement", e);
        }
        this.mWriteObject.putItem(pStep, lItemData);
        try {
            if (this.mPrintResultsDirectToScreen) {
                this.mWriteObject.print();
            }
        }
        catch (IOException e) {
            this.addMessage("addStatement", 'I', "Error printing result object", e);
        }
    }

    protected boolean checkErrorCode(TestStatement pStatement, int pErrorCode) throws TestCaseException {
        return this.checkErrorCode(pStatement, pErrorCode, "");
    }

    protected boolean checkErrorCode(TestStatement pStatement, int pErrorCode, String pStep) throws TestCaseException {
        String lStep = null;
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        if (pStatement.getException() != null) {
            int lErrorCode = ((SQLException)pStatement.getException()).getErrorCode();
            if (lErrorCode != pErrorCode) {
                this.addMessage(lStep, 'E', "Different error codes: Reference = " + pErrorCode + " Actual = " + lErrorCode, pStatement.getException(), pStatement.getSqlString());
                return false;
            }
            return true;
        }
        this.addMessage(lStep, 'E', "Different error codes: Reference = " + pErrorCode + " Actual = No exception thrown - No error code available", pStatement.getSqlString());
        return false;
    }

    protected boolean checkFile(String pFile1, String pFile2) {
        File fileOne = new File(pFile1);
        File fileTwo = new File(pFile2);
        return this.checkFile(fileOne, fileTwo);
    }

    protected boolean checkFile(File fileOne, File fileTwo) {
        if (fileOne == null) {
            this.addMessage("CheckFile", 'E', "Unknown File1!");
            return false;
        }
        if (fileTwo == null) {
            this.addMessage("CheckFile", 'E', "Unknown File2!");
            return false;
        }
        if (!fileOne.exists()) {
            this.addMessage("CheckFile", 'E', fileOne.getAbsolutePath() + " doesn't exist!");
            return false;
        }
        if (!fileTwo.exists()) {
            this.addMessage("CheckFile", 'E', fileTwo.getAbsolutePath() + " doesn't exist!");
            return false;
        }
        if (fileOne.length() != fileTwo.length()) {
            this.addMessage("CheckFile", 'E', "Different file size. " + fileOne.getName() + " = " + fileOne.length() + " Bytes <-> " + fileTwo.getName() + " = " + fileTwo.length() + " Bytes.");
            return false;
        }
        try {
            String lineOne = "";
            String lineTwo = "";
            int row = 0;
            int differCounter = 0;
            boolean differ = false;
            RandomAccessFile inputFileOne = new RandomAccessFile(fileOne, "r");
            RandomAccessFile inputFileTwo = new RandomAccessFile(fileTwo, "r");
            boolean endRead = false;
            while (!endRead && differCounter < 5) {
                lineOne = inputFileOne.readLine();
                lineTwo = inputFileTwo.readLine();
                if (lineOne == null) {
                    endRead = true;
                    continue;
                }
                ++row;
                if (lineOne.equals(lineTwo)) continue;
                this.addMessage("CheckFile", 'E', ++differCounter + ". difference between " + fileOne.getName() + " and " + fileTwo.getName() + " in line: " + row + "\n" + fileOne.getName() + " : " + lineOne + "\n" + fileTwo.getName() + " : " + lineTwo);
                differ = true;
            }
            return !differ;
        }
        catch (Exception e) {
            System.out.println("CheckFile! Exception: " + e.getMessage());
            return false;
        }
    }

    protected boolean checkQuery(TestStatement pStatement, VerificationData pVeriData) throws TestCaseException {
        return this.checkQuery(pStatement, pVeriData, "", 'E');
    }

    protected boolean checkQuery(TestStatement pStatement, VerificationData pVeriData, char pMessageType) throws TestCaseException {
        return this.checkQuery(pStatement, pVeriData, "", pMessageType);
    }

    protected boolean checkQuery(TestStatement pStatement, VerificationData pVeriData, String pStep) throws TestCaseException {
        return this.checkQuery(pStatement, pVeriData, pStep, 'E');
    }

    protected boolean checkQuery(TestStatement pStatement, VerificationData pVeriData, String pStep, char pMessageType) throws TestCaseException {
        boolean lEqual = false;
        String lStep = null;
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        try {
            lEqual = pVeriData.equals(pStatement.getResultSet());
            if (!lEqual) {
                switch (pMessageType) {
                    case 'I': {
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        this.addMessage(lStep, 'I', pVeriData.getErrorMessage(), pStatement.getSqlString());
                        break;
                    }
                    case 'E': {
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        this.addMessage(lStep, 'E', pVeriData.getErrorMessage(), pStatement.getSqlString());
                        break;
                    }
                    case 'W': {
                        this.addMessage(lStep, 'W', pVeriData.getErrorMessage(), pStatement.getSqlString());
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        break;
                    }
                    case 'N': {
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        break;
                    }
                    case 'R': {
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        this.addMessage(lStep, 'R', pVeriData.getErrorMessage(), pStatement.getSqlString());
                        break;
                    }
                    default: {
                        this.mLastErrorMessage = pVeriData.getErrorMessage();
                        this.addMessage(lStep, 'E', pVeriData.getErrorMessage(), pStatement.getSqlString());
                    }
                }
            }
        }
        catch (SQLException e) {
            this.addMessage("checkQuery", 'E', "Couldn't get result set", pStatement.getSqlString());
        }
        return lEqual;
    }

    public boolean checkResultCounter(TestStatement pStatement, int pResultCounter) throws TestCaseException {
        return this.checkResultCounter(pStatement, pResultCounter, "");
    }

    protected boolean checkResultCounter(TestStatement pStatement, int pResultCounter, String pStep) throws TestCaseException {
        String lStep = null;
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        if (!pStatement.isScrollable() && pStatement.getResultCounter() == -1) {
            try {
                pStatement.forceReadResultCounter();
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
        if (pStatement.getResultCounter() != pResultCounter) {
            this.addMessage(lStep, 'E', "Different result counter: Reference = " + pResultCounter + " Actual = " + pStatement.getResultCounter(), pStatement.getSqlString());
            return false;
        }
        return true;
    }

    protected boolean checkStrategy(TestStatement pStatement, ExplainObject pExplainObject) throws TestCaseException {
        return this.checkStrategy(pStatement, pExplainObject, "");
    }

    protected boolean checkStrategy(TestStatement pStatement, ExplainObject pExplainObject, String pStep) throws TestCaseException {
        return this.checkStrategy(pStatement, pExplainObject, pStep, 'E');
    }

    protected boolean checkStrategy(TestStatement pStatement, ExplainObject pExplainObject, String pStep, char pMessageType) throws TestCaseException {
        boolean lEqual = false;
        String lStep = null;
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        if (!pStatement.isExplainOn()) {
            throw new RuntimeException("Explaination for statement " + pStatement.getSqlString() + " switched OFF. Check explain not possible!!!");
        }
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        if (!(lEqual = pExplainObject.equals(pStatement.getResultData().getExplainObject()))) {
            StringBuffer ls1 = new StringBuffer();
            ls1.append(pExplainObject.getEqualsMessage() + "\n");
            ls1.append("Expected:\n");
            ExplainDataIteratorPretty it = pExplainObject.iteratorPretty();
            if (it != null) {
                while (it.hasNext()) {
                    ls1.append(it.next());
                }
            }
            ls1.append("\nActual:\n");
            it = null;
            it = pStatement.getExplainObject().iteratorPretty();
            if (it != null) {
                while (it.hasNext()) {
                    ls1.append(it.next());
                }
            }
            this.addMessage(lStep, pMessageType, ls1.toString(), pStatement.getSqlString());
        }
        return lEqual;
    }

    public static void cleanUp() throws TestCaseException {
    }

    private final boolean compareStatementData(TestStatement pStatement, String pStep) throws TestCaseException {
        boolean lEqual;
        block10: {
            lEqual = false;
            if (this.isInterrupted()) {
                throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
            }
            if (this.isAborted()) {
                throw new TestCaseException("Aborted exception: Test Case manually aborted");
            }
            try {
                if (pStatement.getResultSet() != null) {
                    lEqual = this.mReadObject.getItem(pStep).getData().getVerificationData().equals(pStatement.getResultSet());
                    if (!lEqual) {
                        this.addMessage(pStep, 'E', this.mReadObject.getItem(pStep).getData().getVerificationData().getErrorMessage(), pStatement.getSqlString());
                    }
                    break block10;
                }
                try {
                    if (this.mReadObject.getItem(pStep).getData().getVerificationData() != null) {
                        this.addMessage(pStep, 'E', "No actual result set, but reference contains a result for this step!!!", pStatement.getSqlString());
                        lEqual = false;
                    }
                }
                catch (NullPointerException e) {}
            }
            catch (SQLException e) {
                this.addMessage(pStep, 'E', "Couldn't get result set", e, pStatement.getSqlString());
            }
            catch (NullPointerException e) {
                this.addMessage(pStep, 'E', "Couldn't verify result data. No reference data available", pStatement.getSqlString());
            }
        }
        return lEqual;
    }

    private final boolean compareStatementResult(TestStatement pStatement, String pStep) throws TestCaseException {
        if (this.isInterrupted()) {
            throw new TestCaseException("Interrupted exception: Test Case interrupted by Caller");
        }
        if (this.isAborted()) {
            throw new TestCaseException("Aborted exception: Test Case manually aborted");
        }
        if (this.mReadObject == null) {
            this.addMessage(pStep, 'I', "Couldn't verify statement result. No reference result available", pStatement.getSqlString());
            return false;
        }
        if (pStep == null) {
            this.addMessage(pStep, 'E', "No step id. Couldn't verify statement result.", pStatement.getSqlString());
            return false;
        }
        Iterator lIt = this.mReadObject.compareItem(this.mWriteObject, pStep);
        if (lIt == null) {
            return true;
        }
        while (lIt.hasNext()) {
            this.addMessage(pStep, 'E', lIt.next().toString(), pStatement.getSqlString());
        }
        return false;
    }

    protected final void disableTrace() {
        this.mDevTrace = false;
        if (this.mTrace != null) {
            this.mTrace.flush();
        }
    }

    public final void enableTrace(boolean pOnScreen, boolean pWithResults, boolean pWithExplain) {
        this.mDevTrace = true;
        this.mTrace = pOnScreen ? new TestTrace() : new TestTrace(TestCase.getProtocol().getFilePath(), TestCase.getProtocol().getFileNamePrefix(), "trc", TestCase.getProtocol().getSaveFileVersion());
        this.mTrace.setPrintExplain(pWithExplain);
        this.mTrace.setPrintResults(pWithResults);
    }

    public void finalize() throws Throwable {
        try {
            this.storeResultObject();
        }
        catch (SQLException e) {
            this.addMessage("interrupt", 'E', "Cannot store result object");
        }
        for (int i = 0; i < this.mMaxActiveStatement; ++i) {
            if (this.mActiveStatements[i] == null) continue;
            try {
                this.mActiveStatements[i].cancel();
                continue;
            }
            catch (SQLException e) {
                this.addMessage("interrupt", 'W', "Cannot cancel active Statement\n" + e.getLocalizedMessage());
            }
        }
        if (this.mTrace != null) {
            this.mTrace.finalize();
        }
        super.finalize();
        if (this.mTestDatabaseSAP != null && this.mTestDatabaseSAP.size() != 0) {
            int counter = 0;
            do {
                TestDatabaseSap addiDB;
                if ((addiDB = (TestDatabaseSap)this.mTestDatabaseSAP.get(counter)).exists()) {
                    if (addiDB.isKeep()) {
                        addiDB.switchState(addiDB.getKeepState());
                        this.addMessage("TestCase", 'I', "TestCase finalize: " + addiDB.getName() + " switching to " + addiDB.getKeepState() + ".");
                        continue;
                    }
                    if (addiDB.isDrop()) {
                        addiDB.dropInstance();
                        this.addMessage("TestCase", 'I', "TestCase finalize: Dropping " + addiDB.getName() + ".");
                        continue;
                    }
                    if (!addiDB.isKeep() && TestStatistic.getTotalErrors() == 0) {
                        addiDB.dropInstance();
                        this.addMessage("TestCase", 'I', "TestCase finalize: Dropping " + addiDB.getName() + " because no errors occur.");
                        continue;
                    }
                    addiDB.switchState(addiDB.getKeepState());
                    this.addMessage("TestCase", 'I', "TestCase finalize: " + addiDB.getName() + " switching to " + addiDB.getKeepState() + "...");
                    continue;
                }
                this.addMessage("TestCase", 'I', "TestCase finalize: " + addiDB.getName() + " database does not exists.");
            } while (++counter < this.mTestDatabaseSAP.size());
            this.mTestDatabaseSAP = null;
        }
    }

    public String getLogFile() {
        return null;
    }

    public String getLogFileName() {
        return null;
    }

    public String getLastErrorMessage() {
        return this.mLastErrorMessage;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getDataOutputPath() {
        String jtestRoot = TestDriver.getJTestRoot();
        if (jtestRoot == null) {
            this.addMessage("getDataOutputPath", 'E', "Can't retrieve $JTEST_ROOT.");
            return null;
        }
        String myFullName = this.getClass().getName();
        String testDir = null;
        if (myFullName.lastIndexOf(46) != -1) {
            String myClassName = myFullName.substring(myFullName.lastIndexOf(46) + 1);
            String myLastPackageName = myFullName.substring(0, myFullName.length() - (myClassName.length() + 1));
            myLastPackageName = myLastPackageName.substring(myLastPackageName.lastIndexOf(46) + 1);
            testDir = myLastPackageName + File.separator + myClassName;
        } else {
            testDir = myFullName;
        }
        String dataDir = jtestRoot + File.separator + "tests" + File.separator + "output" + File.separator + testDir;
        File fileDataDir = new File(dataDir);
        if (fileDataDir.exists()) {
            if (fileDataDir.isDirectory()) return dataDir;
            this.addMessage("getDataOutputPath", 'E', "Desired data output path <" + dataDir + "> exists, but is a file.");
            return null;
        }
        if (fileDataDir.mkdirs()) {
            this.addMessage("getDataOutputPath", 'I', "Datadir '" + dataDir + "' created.");
            return dataDir;
        }
        this.addMessage("getDataOutputPath", 'E', "Can't create datadir '" + dataDir + "'.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getDataInputPath() {
        String jtestRoot = TestDriver.getJTestRoot();
        if (jtestRoot == null) {
            this.addMessage("getDataInputPath", 'E', "Can't retrieve $JTEST_ROOT.");
            return null;
        }
        String myFullName = this.getClass().getName();
        String testDir = null;
        if (myFullName.lastIndexOf(46) != -1) {
            String myClassName = myFullName.substring(myFullName.lastIndexOf(46) + 1);
            String myLastPackageName = myFullName.substring(0, myFullName.length() - (myClassName.length() + 1));
            myLastPackageName = myLastPackageName.substring(myLastPackageName.lastIndexOf(46) + 1);
            testDir = myLastPackageName + File.separator + myClassName;
        } else {
            testDir = myFullName;
        }
        String dataDir = jtestRoot + File.separator + "tests" + File.separator + "input" + File.separator + testDir;
        File fileDataDir = new File(dataDir);
        if (fileDataDir.exists()) {
            if (fileDataDir.isDirectory()) return dataDir;
            this.addMessage("getDataInputPath", 'E', "Desired data input path <" + dataDir + "> exists, but is a file.");
            return null;
        }
        if (fileDataDir.mkdirs()) {
            this.addMessage("getDataInputPath", 'I', "Datadir '" + dataDir + "' created.");
            return dataDir;
        }
        this.addMessage("getDataInputPath", 'E', "Can't create datadir '" + dataDir + "'.");
        return null;
    }

    public String getProtocolPath() {
        String jtestRoot = TestDriver.getJTestRoot();
        if (jtestRoot == null) {
            this.addMessage("getProtocolPath", 'E', "Can't retrieve $JTEST_ROOT.");
            return null;
        }
        String protDir = jtestRoot + File.separator + "protocols";
        return protDir;
    }

    public static final TestDatabase getDatabase() {
        return sDatabase;
    }

    public static final int getErrorCounter() {
        return sErrorCounter;
    }

    public static final ArrayList getErrorMessages() {
        return sErrorMessages;
    }

    public static final int getInfoCounter() {
        return sInfoCounter;
    }

    public final String getStatus() {
        return new String(this.status);
    }

    protected final void setStatus(String s) {
        String old = this.status;
        this.status = new String(s);
        this.properties.firePropertyChange("status", old, this.status);
    }

    public final void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.properties.addPropertyChangeListener(prop, l);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.properties.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.properties.removePropertyChangeListener(prop, l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.properties.removePropertyChangeListener(l);
    }

    public static String getMaximumRelease() {
        return "*";
    }

    public static String getMinimumRelease() {
        return "*";
    }

    public String getParameterFileLocation() {
        if (TestCase.getParameterObject() != null) {
            return TestCase.getParameterObject().getParameterFileLocation();
        }
        return null;
    }

    public static final boolean getParameterBoolean(String pParameterName, boolean pDefault) {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getBooleanParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
        return pDefault;
    }

    public static final char getParameterChar(String pParameterName, char pDefault) {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getCharParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
        return pDefault;
    }

    public static final float getParameterFloat(String pParameterName, float pDefault) throws NumberFormatException {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getFloatParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
        return pDefault;
    }

    public static final int getParameterInt(String pParameterName, int pDefault) throws NumberFormatException {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getIntParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
        return pDefault;
    }

    public static final long getParameterLong(String pParameterName, long pDefault) throws NumberFormatException {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getLongParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, String.valueOf(pDefault));
        return pDefault;
    }

    private static final TestParameter getParameterObject() {
        return sParameterObject;
    }

    public static final String getParameterString(String pParameterName, String pDefault) {
        if (TestCase.getParameterObject() != null) {
            try {
                return TestCase.getParameterObject().getStringParameter(pParameterName);
            }
            catch (TestParameterException e) {
                TestCase.getParameterObject().setParameter(pParameterName, pDefault);
                return pDefault;
            }
        }
        TestCase.getParameterObject().setParameter(pParameterName, pDefault);
        return pDefault;
    }

    public static final String getPassword() {
        return sPassword;
    }

    private static final TestProtocol getProtocol() {
        return sProtocol;
    }

    private static final String getReferenceDbSysName() {
        return sReferenceDbSysName;
    }

    protected static final TestResultDatabase getResultDatabase() {
        return sResultDatabase;
    }

    public static final char getRunMode() {
        return sRunMode;
    }

    public final String getStep() {
        return this.mLastStep;
    }

    public static String getTestNameForProtocol() {
        return sTestNameForProtocol;
    }

    public static String getTestNumber() {
        return sTestNumber;
    }

    public static String getTestClassId() {
        return sTestClassId;
    }

    public final String getTestId() {
        return this.mTestId;
    }

    public final String getTestName() {
        return sTestName;
    }

    public final String getTestClassName() {
        return sTestClassName;
    }

    public static long getTimeout() {
        return -1L;
    }

    public Date getTestDriverStart() {
        return TestDriver.getStartTime();
    }

    private TestTrace getTrace() {
        return this.mTrace;
    }

    public static final ArrayList getUnnamedParameterList() {
        if (TestCase.getParameterObject() == null) {
            return null;
        }
        return TestCase.getParameterObject().getUnnamedParameterList();
    }

    public static final HashMap getParameterList() {
        if (TestCase.getParameterObject() == null) {
            return null;
        }
        return TestCase.getParameterObject().getParameterList();
    }

    public static final String getUser() {
        return sUser;
    }

    public static final int getWarningCounter() {
        return sWarningCounter;
    }

    protected void handleExceptions(Exception pException) {
        if (pException instanceof SQLException) {
            for (SQLException lEx = (SQLException)pException; lEx != null; lEx = lEx.getNextException()) {
                if (this.mLastStatement == null) {
                    this.addMessage("handleException", 'E', "Exception occured. The last verified step number was: " + this.mLastStep, lEx);
                    continue;
                }
                String lSql = this.mLastStatement.getSqlString();
                this.addMessage("handleException", 'E', "Exception occured. The last verified step number was " + this.mLastStep + "\n" + lEx.getLocalizedMessage(), lEx, lSql);
            }
        } else if (this.mLastStatement == null) {
            this.addMessage("handleException", 'E', "Exception occured! The last verified step number was " + this.mLastStep, pException);
        } else {
            String lSql = this.mLastStatement.getResultData().getSqlStatement();
            this.addMessage("handleException", 'E', "Exception occured!  The last verified step number was " + this.mLastStep, pException, lSql);
        }
    }

    protected static void handleGlobalExceptions(Exception pException) {
        if (pException instanceof BatchUpdateException) {
            SQLException lEx = ((BatchUpdateException)pException).getNextException();
            while (lEx != null) {
                TestCase.addGlobalMessage("handleGlobalException", 'E', "Exception occured", lEx, null);
                lEx = ((BatchUpdateException)pException).getNextException();
            }
        } else {
            TestCase.addGlobalMessage("handleGlobalException", 'E', "Exception occured", pException, null);
        }
    }

    public final void interrupt() throws SecurityException {
        if (this.mTestIsInterruptedByCaller) {
            return;
        }
        this.mTestIsInterruptedByCaller = true;
        this.addMessage("interrupt", 'E', "Thread interrupted because test timeout exceeded (look into driver protocol)");
        for (int i = 0; i < this.mMaxActiveStatement; ++i) {
            if (this.mActiveStatements[i] == null) continue;
            try {
                this.mActiveStatements[i].cancel();
                continue;
            }
            catch (SQLException e) {
                this.addMessage("interrupt", 'E', "Cannot cancel active Statement");
            }
        }
        Thread.currentThread().interrupt();
        SimpleDateFormat myStartDate = new SimpleDateFormat("HH:mm:ss.S");
        System.out.println("Interrupt method at " + myStartDate.format(new Date(System.currentTimeMillis())) + " called");
    }

    public final boolean isAborted() {
        return this.mTestIsAborted;
    }

    protected boolean isAutoStep() {
        return this.mAutoStep;
    }

    protected final boolean isDevTrace() {
        return this.mDevTrace;
    }

    public final boolean isInterrupted() {
        return this.mTestIsInterruptedByCaller;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    private static final boolean isSave() {
        return sSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextStep(String pStep) {
        String lStep = null;
        if (pStep == null) {
            pStep = "";
        }
        pStep = pStep.trim();
        HashMap hashMap = this.mStepMap;
        synchronized (hashMap) {
            int i;
            Integer lSubStep = (Integer)this.mStepMap.get(pStep);
            if (lSubStep != null) {
                i = lSubStep;
                ++i;
            } else {
                i = 1;
            }
            this.mStepMap.put(pStep, new Integer(i));
            lStep = pStep.trim().equals("") ? STEP_FORMAT.format(i) : pStep + "-" + STEP_FORMAT.format(i);
            this.mLastStep = lStep;
        }
        return lStep;
    }

    public static void prepare() throws TestCaseException {
    }

    protected static void printParametersToProtocol() {
        if (TestCase.getParameterObject() != null && TestCase.getProtocol() != null) {
            String lPara = TestCase.getParameterObject().getParametersAsString();
            TestCase.addGlobalMessage("Properties", 'I', "Following test parameters were used:" + System.getProperty("line.separator") + lPara);
        }
    }

    protected void printResultObject() {
        if (!this.isDevTrace()) {
            try {
                this.mWriteObject.print();
            }
            catch (IOException e) {
                System.out.println("Couldn't printl result object");
            }
        }
    }

    protected void printResultObjectDirect(boolean pDirect) {
        if (!this.isDevTrace()) {
            this.mPrintResultsDirectToScreen = pDirect;
        }
    }

    protected void printTrace(TestStatement pStatement, String pStep) {
        this.printTrace(pStatement, pStep, pStatement.getSqlString());
    }

    protected void printTrace(TestStatement pStatement, String pStep, String pSqlString) {
        if (!this.isDevTrace()) {
            return;
        }
        this.getTrace().print(pStatement, pStep, pSqlString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetActiveStatement(int pStatementNumber) {
        TestStatement[] testStatementArray = this.mActiveStatements;
        synchronized (this.mActiveStatements) {
            this.mActiveStatements[pStatementNumber] = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static final synchronized void resetCounters() {
        sInfoCounter = 0;
        sWarningCounter = 0;
        sErrorCounter = 0;
        sCustomMessageCounter = 0;
        sErrorMessages.clear();
    }

    public static final synchronized void resetTestClassId() {
        sTestNameForProtocol = null;
        sTestClassId = null;
    }

    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int setActiveStatement(TestStatement pActiveStatement) {
        boolean free = false;
        int i = 0;
        TestStatement[] testStatementArray = this.mActiveStatements;
        synchronized (this.mActiveStatements) {
            for (i = 0; i < this.mActiveStatements.length; ++i) {
                if (this.mActiveStatements[i] != null) continue;
                this.mActiveStatements[i] = pActiveStatement;
                free = true;
                if (i <= this.mMaxActiveStatement) break;
                this.mMaxActiveStatement = i;
                break;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (free) {
                return i;
            }
            throw new RuntimeException("Too many active statements (More then 50).");
        }
    }

    protected void setAutoStep(boolean pAutoStep) {
        this.mAutoStep = pAutoStep;
    }

    public static final synchronized void setDatabase(TestDatabase pDatabase) {
        if (sDatabase == null) {
            sDatabase = pDatabase;
        }
    }

    public static final synchronized void resetDatabase(TestDatabase pDatabase) {
        sDatabase = pDatabase;
    }

    protected static void setInfoMessageFilter(boolean pInfoMessageFilter) {
        TestCase.getProtocol().setInfoMessageFilter(pInfoMessageFilter);
    }

    final void setLastStatement(TestStatement pLastStatement) {
        this.mLastStatement = pLastStatement;
    }

    public static final synchronized void setParameterObject(TestParameter pParameterObject) {
        sParameterObject = pParameterObject;
    }

    public static final synchronized void setPassword(String pPassword) {
        if (sPassword == null) {
            sPassword = pPassword;
        }
    }

    public static final synchronized void setProtocol(TestProtocol pProtocol) {
        if (sProtocol == null) {
            sProtocol = pProtocol;
        }
    }

    public static final synchronized void setTestDriverProtocol(TestDriverProtocol pProtocol) {
        if (sTDProtocol == null) {
            sTDProtocol = pProtocol;
        }
    }

    public static final synchronized void setProtocolForced(TestProtocol prot) {
        sProtocol = prot;
    }

    public static final synchronized void setReferenceDbSysName(String pReferenceDbSysName) {
        sReferenceDbSysName = pReferenceDbSysName;
    }

    public static final synchronized void setResultDatabase(TestResultDatabase pResultDatabase) {
        sResultDatabase = pResultDatabase;
    }

    public static final synchronized void setRunMode(char pRunMode) {
        sRunMode = pRunMode;
    }

    public static final synchronized void setTestDriverOptions(Properties pOptions) {
        mTestDriverOptions = new Properties();
        mTestDriverOptions.putAll((Map<?, ?>)pOptions);
    }

    public static final void setTestDriver(TestDriver pTestDriver) {
        sTestDriver = pTestDriver;
    }

    public static final synchronized void setTestDriverConfiguration(TestDriverConfiguration pTestConfig) {
        mTestDriverConfiguration = new TestDriverConfiguration();
        if (pTestConfig != null) {
            mTestDriverConfiguration.setConfiguration(pTestConfig.getConfiguration());
            if (pTestConfig.getDBDeviceList() != null) {
                mTestDriverConfiguration.setDBDeviceList(pTestConfig.getDBDeviceList());
            }
            if (pTestConfig.getDBParameterMap() != null) {
                mTestDriverConfiguration.setDBParameterMap(pTestConfig.getDBParameterMap());
            }
        }
    }

    public static final synchronized void setSave(boolean pSave) {
        sSave = pSave;
    }

    public static final synchronized void setTestClassId(String pTestClassId) {
        sTestClassId = pTestClassId;
    }

    public static final synchronized void setTestNameForProtocol(String pTestName) {
        sTestNameForProtocol = pTestName;
    }

    public static final synchronized void setTestNumber(String pTestNumber) {
        sTestNumber = pTestNumber;
    }

    public final void setTestId(String pTestId) {
        this.mTestId = pTestId;
    }

    public final void setTestName(String pTestName) {
        sTestName = pTestName;
    }

    public final void setTestClassName(String pTestClassName) {
        sTestClassName = pTestClassName;
    }

    public static final synchronized void setUser(String pUser) {
        sUser = pUser;
    }

    protected final int storeResultObject() throws SQLException, TestDatabaseException {
        if (!this.isDevTrace()) {
            if (TestCase.isSave()) {
                return this.mWriteObject.save();
            }
            return -1;
        }
        return 0;
    }

    protected boolean verify(TestStatement pStatement) throws TestCaseException {
        return this.verify(pStatement, "");
    }

    protected boolean verify(TestStatement pStatement, String pStep) throws TestCaseException {
        String lStep = null;
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        this.addStatementResult(pStatement, lStep);
        if (this.mRefRun) {
            return true;
        }
        if (this.mReadObject != null) {
            return this.compareStatementResult(pStatement, lStep);
        }
        return true;
    }

    protected boolean verifyIndexDef(String pTableName, String pIndexName, Connection pCon) throws TestCaseException {
        return this.verifyIndexDef(pTableName, pIndexName, pCon, "");
    }

    protected boolean verifyIndexDef(String pTableName, String pIndexName, Connection pCon, String pStep) throws TestCaseException {
        String lStep = null;
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        TestStatement lstmt = null;
        String lsql = "Select \"TYPE\", \"COLUMNNAME\", \"SORT\", \"COLUMNNO\", \"DATATYPE\", \"LEN\", \"DISABLED\" ";
        lsql = lsql + "from domain.indexcolumns where tablename = '" + pTableName.toUpperCase() + "' and INDEXNAME = '" + pIndexName.toUpperCase() + "'";
        try {
            lstmt = new TestStatement(this, pCon);
            lstmt.enableExplain(false);
            lstmt.executeQuery(lsql);
        }
        catch (SQLException e) {
            this.addMessage(lStep, 'E', "Error checking index definition", e, lstmt.getSqlString());
            return false;
        }
        if (this.isDevTrace()) {
            this.printTrace(lstmt, lStep, "Index definition of index: " + pTableName.toUpperCase() + "." + pIndexName.toUpperCase());
        }
        this.addStatementResultAndData(lstmt, lStep);
        if (this.mRefRun) {
            return true;
        }
        if (this.mReadObject != null) {
            boolean lEqual = false;
            lEqual = this.compareStatementResult(lstmt, lStep);
            if (lEqual) {
                lEqual = this.compareStatementData(lstmt, lStep);
            }
            return lEqual;
        }
        return true;
    }

    protected boolean verifyQuery(TestStatement pStatement) throws TestCaseException {
        return this.verifyQuery(pStatement, "");
    }

    protected boolean verifyQuery(TestStatement pStatement, String pStep) throws TestCaseException {
        String lStep = null;
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        if (this.isDevTrace()) {
            this.printTrace(pStatement, lStep);
        }
        this.addStatementResultAndData(pStatement, lStep);
        if (this.mRefRun) {
            return true;
        }
        if (this.mReadObject != null) {
            boolean lEqual = false;
            lEqual = this.compareStatementResult(pStatement, lStep);
            if (lEqual) {
                lEqual = this.compareStatementData(pStatement, lStep);
            }
            return lEqual;
        }
        return true;
    }

    protected boolean verifyTableDef(String pTableName, Connection pCon) throws TestCaseException {
        return this.verifyTableDef(pTableName, pCon, "");
    }

    protected boolean verifyTableDef(String pTableName, Connection pCon, String pStep) throws TestCaseException {
        String lStep = null;
        lStep = this.isAutoStep() ? this.nextStep(pStep) : pStep;
        TestStatement lstmt = null;
        String lsql = "Select \"COLUMNNAME\", \"MODE\", \"DATATYPE\", \"CODETYPE\", \"LEN\", \"DEC\", \"COLUMNPRIVILEGES\", \"DEFAULT\" ";
        lsql = lsql + "from domain.columns where tablename = '" + pTableName.toUpperCase() + "'";
        try {
            lstmt = new TestStatement(this, pCon);
            lstmt.enableExplain(false);
            lstmt.executeQuery(lsql);
        }
        catch (SQLException e) {
            this.addMessage(lStep, 'E', "Error checking table definition", e, lstmt.getSqlString());
            return false;
        }
        if (this.isDevTrace()) {
            this.printTrace(lstmt, lStep, "Table definition of table: " + pTableName.toUpperCase());
        }
        this.addStatementResultAndData(lstmt, lStep);
        if (this.mRefRun) {
            return true;
        }
        if (this.mReadObject != null) {
            boolean lEqual = false;
            lEqual = this.compareStatementResult(lstmt, lStep);
            if (lEqual) {
                lEqual = this.compareStatementData(lstmt, lStep);
            }
            return lEqual;
        }
        return true;
    }

    public int string2number(String inString) {
        int outNumber = -1;
        if (inString.equals("0")) {
            outNumber = 0;
        }
        if (inString.equals("1")) {
            outNumber = 1;
        }
        if (inString.equals("2")) {
            outNumber = 2;
        }
        if (inString.equals("3")) {
            outNumber = 3;
        }
        if (inString.equals("4")) {
            outNumber = 4;
        }
        if (inString.equals("5")) {
            outNumber = 5;
        }
        if (inString.equals("6")) {
            outNumber = 6;
        }
        if (inString.equals("7")) {
            outNumber = 7;
        }
        if (inString.equals("8")) {
            outNumber = 8;
        }
        if (inString.equals("9")) {
            outNumber = 9;
        }
        return outNumber;
    }

    protected TestDatabaseSap additionalDatabase(TestDriverConfiguration pConfig, int traceLevel) throws TestDatabaseException, UnknownUserException {
        HashMap dbOptions = pConfig.getConfiguration();
        ArrayList dbDeviceList = null;
        HashMap dbParameter = null;
        TestDatabaseSap thisNewDatabase = null;
        if (dbOptions == null || dbOptions.size() == 0) {
            this.addMessage("additionalDatabase", 'W', "No valid db options is given in the properties!");
            throw new TestDatabaseException("No valid db options is given in the properties!");
        }
        dbDeviceList = pConfig.getDBDeviceList();
        dbParameter = pConfig.getDBParameterMap();
        if (dbOptions.get("DBType") != null) {
            this.addMessage("additionalDatabase", 'T', "DB type : " + dbOptions.get("DBType").toString(), traceLevel);
            if (!dbOptions.get("DBType").equals("SAP")) {
                throw new TestDatabaseException("Database type " + dbOptions.get("DBType") + " not supported! Only type: " + "SAP" + " allowed.");
            }
        } else {
            this.addMessage("additionalDatabase", 'W', "No DB type is given in the properties! \nUse key: TestDriverConstants.DB_TYPE ");
            throw new TestDatabaseException("No DB type is given in the properties!");
        }
        if (dbOptions.get("DBHost") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB host is given in the properties! \nUse key: TestDriverConstants.DB_HOST ");
            throw new TestDatabaseException("No DB host is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB host : " + dbOptions.get("DBHost").toString(), traceLevel);
        if (dbOptions.get("db-port") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB port is given in the properties! \nUse key: TestDriverConstants.DB_PORT ");
            throw new TestDatabaseException("No DB port is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB port : " + dbOptions.get("db-port").toString(), traceLevel);
        if (dbOptions.get("DBName") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB name is given in the properties! \nUse key: TestDriverConstants.DB_NAME ");
            throw new TestDatabaseException("No DB name is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB name : " + dbOptions.get("DBName").toString(), traceLevel);
        if (dbOptions.get("DBRoot") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB root is given in the properties! \nUse key: TestDriverConstants.DB_ROOT ");
            throw new TestDatabaseException("No DB root is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB root : " + dbOptions.get("DBRoot").toString(), traceLevel);
        if (dbOptions.get("DBMode") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB mode is given in the properties! \nUse key: TestDriverConstants.DB_MODE ");
            throw new TestDatabaseException("No DB mode is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB mode : " + dbOptions.get("DBMode").toString(), traceLevel);
        if (dbOptions.get("DBKind") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB kind is given in the properties! \nUse key: TestDriverConstants.DB_KIND ");
            throw new TestDatabaseException("No DB kind is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB kind : " + dbOptions.get("DBKind").toString(), traceLevel);
        if (dbOptions.get("DBSize") != null) {
            this.addMessage("additionalDatabase", 'T', "DB size : " + dbOptions.get("DBSize").toString(), traceLevel);
            if (dbDeviceList != null && dbDeviceList.size() != 0) {
                this.addMessage("additionalDatabase", 'T', "DB size : " + dbDeviceList.size() + " devices are defined", traceLevel);
            }
        } else if (dbDeviceList != null && dbDeviceList.size() != 0) {
            this.addMessage("additionalDatabase", 'T', "DB size : " + dbDeviceList.size() + " devices are defined", traceLevel);
        } else {
            this.addMessage("additionalDatabase", 'W', "Neither DB size nor entries in the device list are given in the properties! \nUse key: TestDriverConstants.DB_SIZE ");
            throw new TestDatabaseException("Neither DB size nor entries in the device list are given in the properties!");
        }
        if (dbOptions.get("DBForce") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB force is given in the properties! \nUse key: TestDriverConstants.DB_FORCE ");
            throw new TestDatabaseException("No DB force is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB force: " + dbOptions.get("DBForce").toString(), traceLevel);
        if (dbOptions.get("DBKeep") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB keep is given in the properties! \nUse key: TestDriverConstants.DB_KEEP ");
            throw new TestDatabaseException("No DB keep is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB keep : " + dbOptions.get("DBKeep").toString(), traceLevel);
        if (dbOptions.get("DBKeepState") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB keep state is given in the properties! \nUse key: TestDriverConstants.DB_KEEP_STATE ");
            throw new TestDatabaseException("No DB keep state is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "keep state : " + dbOptions.get("DBKeepState").toString(), traceLevel);
        if (dbOptions.get("DBDrop") == null) {
            this.addMessage("additionalDatabase", 'W', "No DB drop is given in the properties! \nUse key: TestDriverConstants.DB_DROP ");
            throw new TestDatabaseException("No DB drop is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DB drop : " + dbOptions.get("DBDrop").toString(), traceLevel);
        if (((Boolean)dbOptions.get("DBDrop")).booleanValue() && ((Boolean)dbOptions.get("DBKeep")).booleanValue()) {
            this.addMessage("additionalDatabase", 'W', "DB drop and db keep (property key: TestDriverConstants.DB_DROP and TestDriverConstants.DB_KEEP) are set to true.\nThat is not useful.");
            throw new TestDatabaseException("DB drop and db keep (property key: TestDriverConstants.DB_DROP and TestDriverConstants.DB_KEEP) are set to true.\nThat is not useful.");
        }
        if (dbOptions.get("DBMUser") == null) {
            this.addMessage("additionalDatabase", 'W', "No DBM user is given in the properties! \nUse key: TestDriverConstants.DB_DBM_USER ");
            throw new UnknownUserException("No DBM user is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DBM user: " + dbOptions.get("DBMUser").toString(), traceLevel);
        if (dbOptions.get("DBMPwd") == null) {
            this.addMessage("additionalDatabase", 'W', "No DBM password is given in the properties! \nUse key: TestDriverConstants.DB_DBM_PWD ");
            throw new UnknownUserException("No DBM password is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DBM pwd : " + dbOptions.get("DBMPwd").toString(), traceLevel);
        if (dbOptions.get("DBAUser") == null) {
            this.addMessage("additionalDatabase", 'T', "No DBA user is given in the properties! \nUse key: TestDriverConstants.DB_DBA_USER ");
            throw new UnknownUserException("No DBA user is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DBA user: " + dbOptions.get("DBAUser").toString(), traceLevel);
        if (dbOptions.get("DBAPwd") == null) {
            this.addMessage("additionalDatabase", 'T', "No DBA password is given in the properties! \nUse key: TestDriverConstants.DB_DBA_PWD ");
            throw new UnknownUserException("No DBA password is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "DBA pwd : " + dbOptions.get("DBAPwd").toString(), traceLevel);
        if (!dbOptions.get("DBHost").toString().equalsIgnoreCase("localhost")) {
            if (dbOptions.get("OSUser") == null) {
                this.addMessage("additionalDatabase", 'T', "No OS user is given in the properties! \nUse key: TestDriverConstants.OS_USER ");
                throw new UnknownUserException("No OS user is given in the properties!");
            }
            this.addMessage("additionalDatabase", 'T', "OS User : " + dbOptions.get("OSUser").toString(), traceLevel);
            if (dbOptions.get("OSPwd") != null) {
                this.addMessage("additionalDatabase", 'T', "OS pwd  : " + dbOptions.get("OSPwd").toString(), traceLevel);
            } else {
                this.addMessage("additionalDatabase", 'T', "No OS password is given in the properties! \nUse key: TestDriverConstants.OS_PWD ");
                throw new UnknownUserException("No OS user is given in the properties!");
            }
        }
        if (dbOptions.get("TestFrameTrace") == null) {
            this.addMessage("additionalDatabase", 'W', "No testframe trace is given in the properties! \nUse key: TestDriverConstants.MISC_TFRAME_TRACE ");
            throw new TestDatabaseException("No testframe trace is given in the properties!");
        }
        this.addMessage("additionalDatabase", 'T', "testframe trace : " + dbOptions.get("TestFrameTrace").toString(), traceLevel);
        if (TestCase.getDatabase().getName().equalsIgnoreCase(dbOptions.get("DBName").toString()) && TestCase.getDatabase().getHost().equalsIgnoreCase(dbOptions.get("DBHost").toString())) {
            this.addMessage("additionalDatabase", 'T', "Cannot use db_host: " + dbOptions.get("DBHost").toString() + " AND db_name: " + dbOptions.get("DBName").toString() + " for additional database, because it is the initial testframe database!", traceLevel);
            throw new UnknownUserException("Cannot create an additional database ( " + dbOptions.get("DBName") + " on " + dbOptions.get("DBHost") + " ), because it is the initial testframe database!");
        }
        try {
            thisNewDatabase = new TestDatabaseSap(dbOptions.get("DBHost").toString(), dbOptions.get("DBName").toString());
            thisNewDatabase.setPort(new Integer(dbOptions.get("db-port").toString()));
            thisNewDatabase.setDBMUser(dbOptions.get("DBMUser").toString());
            thisNewDatabase.setDBMPassword(dbOptions.get("DBMPwd").toString());
            thisNewDatabase.setDBAUser(dbOptions.get("DBAUser").toString());
            thisNewDatabase.setDBAPassword(dbOptions.get("DBAPwd").toString());
            thisNewDatabase.setKernelMode(dbOptions.get("DBMode").toString());
            boolean createANewInstance = true;
            if (thisNewDatabase.exists()) {
                if (!((Boolean)dbOptions.get("DBForce")).booleanValue()) {
                    createANewInstance = false;
                    if (!thisNewDatabase.existsUser(thisNewDatabase.getDBMUser(), thisNewDatabase.getDBMPassword())) {
                        throw new UnknownUserException(null, dbOptions.get("DBName").toString(), thisNewDatabase.getDBMUser() + "," + thisNewDatabase.getDBMPassword());
                    }
                    if (!thisNewDatabase.existsUser(thisNewDatabase.getDBAUser(), thisNewDatabase.getDBAPassword())) {
                        throw new UnknownUserException(null, dbOptions.get("DBName").toString(), thisNewDatabase.getDBAUser() + "," + thisNewDatabase.getDBAPassword());
                    }
                } else {
                    createANewInstance = true;
                }
            } else if (!((Boolean)dbOptions.get("DBForce")).booleanValue()) {
                this.addMessage("additionalDatabase", 'T', "Database doesn't exist, and auto generation is disabled.");
                throw new UnknownUserException("Database doesn't exist, and auto generation is disabled");
            }
            if (createANewInstance) {
                this.addMessage("additionalDatabase", 'T', "set protocol: " + sTDProtocol, traceLevel);
                thisNewDatabase.setProtocol(sTDProtocol);
                this.addMessage("additionalDatabase", 'T', "Creating database <" + thisNewDatabase.getName() + "> ...", 3);
                this.addMessage("additionalDatabase", 'T', "set Root: " + dbOptions.get("DBRoot").toString(), traceLevel);
                thisNewDatabase.setRoot(dbOptions.get("DBRoot").toString());
                this.addMessage("additionalDatabase", 'T', "set Kind: " + dbOptions.get("DBKind").toString(), traceLevel);
                thisNewDatabase.setInstanceType(dbOptions.get("DBKind").toString());
                this.addMessage("additionalDatabase", 'T', "set OS user: " + dbOptions.get("OSUser").toString(), traceLevel);
                thisNewDatabase.setOsUser(dbOptions.get("OSUser").toString());
                this.addMessage("additionalDatabase", 'T', "set OS pwd: " + dbOptions.get("OSPwd").toString(), traceLevel);
                thisNewDatabase.setOsPassword(dbOptions.get("OSPwd").toString());
                this.addMessage("additionalDatabase", 'T', "set trace: " + dbOptions.get("TestFrameTrace").toString(), traceLevel);
                thisNewDatabase.setIsActionTraced((Boolean)dbOptions.get("TestFrameTrace"));
                this.addMessage("additionalDatabase", 'T', "set size: " + dbOptions.get("DBSize").toString(), traceLevel);
                thisNewDatabase.setSize(dbOptions.get("DBSize").toString());
                this.addMessage("additionalDatabase", 'T', "keep SAP DB after tests finished: " + dbOptions.get("DBKeep").toString(), traceLevel);
                thisNewDatabase.setKeep((Boolean)dbOptions.get("DBKeep"));
                if (thisNewDatabase.isKeep()) {
                    this.addMessage("additionalDatabase", 'T', "keep state of SAP DB after tests finished: " + dbOptions.get("DBKeepState").toString(), traceLevel);
                }
                if (dbOptions.get("DBKeepState") != null) {
                    thisNewDatabase.setKeepState(dbOptions.get("DBKeepState").toString());
                }
                this.addMessage("additionalDatabase", 'T', "drop SAP DB after tests finished: " + dbOptions.get("DBDrop").toString(), traceLevel);
                thisNewDatabase.setDrop((Boolean)dbOptions.get("DBDrop"));
                if (!thisNewDatabase.isKeep() && !thisNewDatabase.isDrop()) {
                    this.addMessage("additionalDatabase", 'T', "drop additional SAP DB after tests finished if no error occurs", traceLevel);
                }
                this.addMessage("additionalDatabase", 'T', "force create SAPDB: " + dbOptions.get("DBForce").toString(), traceLevel);
                thisNewDatabase.setForceCreate((Boolean)dbOptions.get("DBForce"));
                if (dbDeviceList != null || dbParameter != null) {
                    this.addMessage("additionalDatabase", 'T', "set configuration and device list", traceLevel);
                    thisNewDatabase.setConfiguration(dbParameter);
                    thisNewDatabase.setDeviceList(dbDeviceList);
                }
                if (dbOptions.get("JDBC_Property") != null) {
                    thisNewDatabase.setJdbcProperty((Properties)dbOptions.get("JDBC_Property"));
                }
                if (dbOptions.get("DBJdbcTrace") != null && ((Boolean)dbOptions.get("DBJdbcTrace")).booleanValue()) {
                    thisNewDatabase.setJdbcTraceOutput(thisNewDatabase.getRunDir());
                    thisNewDatabase.enableJDBCTrace();
                }
                this.addMessage("additionalDatabase", 'T', "Creating SAP DB " + dbOptions.get("DBName").toString() + " on host " + dbOptions.get("DBHost").toString() + " ...", traceLevel);
                thisNewDatabase.setHostName(dbOptions.get("DBHost").toString());
                thisNewDatabase.createInstance(sTestDriver);
                this.addMessage("additionalDatabase", 'T', "successful!", traceLevel);
                thisNewDatabase.start();
            }
        }
        catch (Exception exp) {
            throw new TestDatabaseException(exp, "Error.");
        }
        if (this.mTestDatabaseSAP != null && this.mTestDatabaseSAP.size() != 0) {
            for (int i = 0; i < this.mTestDatabaseSAP.size(); ++i) {
                TestDatabaseSap addiDB = (TestDatabaseSap)this.mTestDatabaseSAP.get(i);
                if (!dbOptions.get("DBHost").toString().equals(addiDB.getHost()) || !dbOptions.get("DBName").toString().equals(addiDB.getName())) continue;
                this.mTestDatabaseSAP.remove(i);
                this.addMessage("additionalDatabase", 'T', "Remove old, duplicate \"TestDatabase\" object with id ( " + dbOptions.get("DBName").toString() + " on " + dbOptions.get("DBHost").toString() + " ) ", traceLevel);
                break;
            }
        }
        this.mTestDatabaseSAP.add(thisNewDatabase);
        this.addMessage("additionalDatabase", 'T', "Add a new \"TestDatabase\" object with id ( " + dbOptions.get("DBName").toString() + " on " + dbOptions.get("DBHost").toString() + " ) for test finalization.", traceLevel);
        return thisNewDatabase;
    }

    static {
        mTestDriverOptions = null;
        sTestDriver = null;
        mTestDriverConfiguration = null;
        STEP_FORMAT = new DecimalFormat("#####");
        STEP_FORMAT.setMinimumIntegerDigits(5);
        sResultDatabase = null;
        sTestClassId = null;
        sTestNameForProtocol = null;
        sTestNumber = null;
        sRunMode = (char)65;
        sErrorMessages = new ArrayList();
        sTestName = null;
        sTestClassName = null;
    }
}

