/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.DatabaseNotExistentException;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseIBM;
import com.sap.sapdb.testframe.driver.TestDatabaseInterbase;
import com.sap.sapdb.testframe.driver.TestDatabaseOracle;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.driver.TestDriverConstants;
import com.sap.sapdb.testframe.driver.TestDriverProtocol;
import com.sap.sapdb.testframe.driver.TestMessage;
import com.sap.sapdb.testframe.driver.TestMessageAttachement;
import com.sap.sapdb.testframe.driver.TestNotFoundException;
import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.driver.TestResultDatabase;
import com.sap.sapdb.testframe.driver.TestSequence;
import com.sap.sapdb.testframe.driver.TestStatistic;
import com.sap.sapdb.testframe.driver.UnknownUserException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestParameter;
import com.sap.sapdb.testframe.testcase.TestParameterException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import com.sap.sapdb.testframe.utilities.webdav.WebDAVClient;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class TestDriver
implements TestDriverConstants {
    private static final String sVersion = "7.0.2";
    private static boolean m_killed = false;
    private boolean mLastTestIsInterrupted = false;
    private static boolean m_hasRespondedToKill = false;
    private TestDriverProtocol mTestDriverProtocol = null;
    private TestProtocol mTestProtocol = null;
    private TestDatabase mTestDatabase = null;
    private Scheduler mTestScheduler = null;
    private TestResultDatabase mTestResultDatabase = null;
    private TestSequence mTestSet = null;
    private TestDriverConfiguration mConfiguration = null;
    private Properties mOptions = null;
    private TestMonitorUpdater mTestMonitorUpdater = null;
    private boolean mHasAsyncProtocol = false;
    private boolean mHasOutputFile = true;
    private String mHostName = null;
    private static Date mStartDate = null;
    private static boolean mWEBDavIsEnabled = true;
    protected static String mWEBDavDir = null;
    protected static URL mWEBDavBaseURL = null;
    private static final SimpleDateFormat mDateFormat = new SimpleDateFormat("dd.MM.yyyy 'at' HH:mm:ss");
    private static final SimpleDateFormat mDateFormatMilli = new SimpleDateFormat("dd.MM.yyyy 'at' HH:mm:ss.SSS");
    private Vector vecTraceFiles = new Vector(10);
    private Vector vecMails = new Vector(10);
    private static int mMaxEntriesInVector = 15;
    private static Vector mLastMessages = new Vector(mMaxEntriesInVector);
    private int mTestResponsibleSubstitutionFile = 0;
    private String mTestSetName = "";
    static /* synthetic */ Class class$com$sap$sapdb$testframe$testcase$TestParameter;

    private boolean tryToZipTheAttachment() {
        if (this.mOptions.get("ZipAttachment") == null) {
            return false;
        }
        if (new Integer(this.mOptions.getProperty("ZipAttachment")) == null) {
            return false;
        }
        return new Integer(this.mOptions.getProperty("ZipAttachment")) >= 0;
    }

    private void addDbInfoToProtocol(TestDatabase pDatabase, TestProtocol pProtocol) throws TestDatabaseException {
        TestDriver.addState(" TestDriver->addDbInfoToProtocol(..)");
        pProtocol.setTestDriverVersion(sVersion);
        pProtocol.setTestDriverStart(mStartDate);
        pProtocol.setOpSystem(TestDriver.getOpSystem());
        if (pDatabase.isSap()) {
            TestDatabaseSap sapdb = (TestDatabaseSap)pDatabase;
            pProtocol.setDbKernelMode(sapdb.getKernelMode());
            String setSpecialVersion = this.mOptions.getProperty("ExplicitVersion");
            if (setSpecialVersion != null && setSpecialVersion.length() > 1) {
                if (setSpecialVersion.length() > 64) {
                    setSpecialVersion = setSpecialVersion.substring(0, 63);
                }
                pProtocol.setDbVersion(setSpecialVersion);
            } else {
                pProtocol.setDbVersion(sapdb.getKernelVersion());
            }
            pProtocol.setDbBuildNumber(sapdb.getKernelBuild());
            pProtocol.setDbRunDirectory(sapdb.getRunDir());
            pProtocol.setDbBit(new Integer(sapdb.getBitVersion()));
            this.mOptions.setProperty("DBJdbcVersion", sapdb.getJdbcDriverVersion());
            this.mOptions.setProperty("DBCpCVersion", sapdb.getCPCVersion());
            pProtocol.setJDBCDriverVersion(this.mOptions.getProperty("DBJdbcVersion"));
            pProtocol.setPort(sapdb.getPort());
        }
    }

    private void addRefKeyToProtocol(TestProtocol pProtocol) throws TestDatabaseException {
        if (this.mOptions.get("SaveResult") != null && ((Boolean)this.mOptions.get("SaveResult")).booleanValue() && this.hasReferenceMode()) {
            pProtocol.addItem("", "", 'I', "Test results stored as references with key " + this.mTestDatabase.getId());
        }
    }

    protected void addTraceToProtocol(String pText) {
        if (this.hasTrace() && this.mTestDriverProtocol != null) {
            this.mTestDriverProtocol.addItem('T', pText);
        }
    }

    private void attachToDatabase() {
        if (!((Boolean)this.mOptions.get("DBAttach")).booleanValue()) {
            return;
        }
        TestDriver.addState(" TestDriver->attachToDatabase()");
        long TimeDiff = 0L;
        Date StartTime = null;
        int chara = 0;
        if (this.mTestDatabase == null || !this.mTestDatabase.isSap()) {
            this.mTestDriverProtocol.addItem('E', "No ATTACH to database possibly. Can't find SAPDB!");
            return;
        }
        try {
            StartTime = new Date();
            System.out.println("Database " + this.mOptions.getProperty("DBName") + " is online and can be attached with debugger.");
            System.out.println("Press <RETURN> to continue or wait 3 min.");
            while (TimeDiff < 180L && chara == 0) {
                TimeDiff = (new Date().getTime() - StartTime.getTime()) / 1000L;
                chara = System.in.available();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception dummy) {}
            }
        }
        catch (Exception e) {
            this.mTestDriverProtocol.addItem('E', "No ATTACH to database possibly!");
            this.mTestDriverProtocol.addItem('I', "Extra : " + e.getMessage());
        }
    }

    private String buildReport() {
        int TestErrorCount = 0;
        int TestWarnCount = 0;
        int ExecutionTime = 0;
        StringBuffer Line = new StringBuffer();
        StringBuffer Result = new StringBuffer();
        String dbKernelVers = "unknown";
        TestDatabaseSap sapdb = null;
        if (this.mTestDatabase != null && this.mTestDatabase.isSap()) {
            sapdb = (TestDatabaseSap)this.mTestDatabase;
            try {
                dbKernelVers = sapdb.getKernelVersion();
            }
            catch (TestDatabaseException e) {
                // empty catch block
            }
        }
        if (dbKernelVers == null) {
            dbKernelVers = "unknown";
        }
        if (this.mTestSet != null) {
            Iterator it = this.mTestSet.iterator();
            while (it.hasNext()) {
                TestSequence.TestSequenceItem TestItem = (TestSequence.TestSequenceItem)it.next();
                TestErrorCount += TestItem.getErrorCount();
                TestWarnCount += TestItem.getWarnCount();
            }
        } else {
            TestErrorCount = -1;
            TestWarnCount = -1;
        }
        ExecutionTime = (int)((new Date().getTime() - TestStatistic.getStartTime().getTime()) / 1000L);
        Result.append("\n");
        Result.append("|--------------------------------------------------------------------------|\n");
        Line.replace(0, Line.length(), "|       TestDriver       - Report                                          |\n");
        Line.replace(19, 19 + sVersion.length(), sVersion);
        Result.append(Line.toString());
        Result.append("|--------------------------------------------------------------------------|\n");
        Line.replace(0, Line.length(), "| Host                                                                     |\n");
        String Item = this.getHostName();
        Line.replace(39, 39 + Item.length(), Item);
        Result.append(Line.toString());
        if (!((Boolean)this.mOptions.get("DBNone")).booleanValue()) {
            Line.replace(0, Line.length(), "| Release                                                                  |\n");
            Item = dbKernelVers;
            if (!((String)this.mOptions.get("ChangeListNumber")).equals("n/a")) {
                Item = Item + "  (Changelist: " + (String)this.mOptions.get("ChangeListNumber") + ")";
            }
            Line.replace(39, 39 + Item.length(), Item);
            Result.append(Line.toString());
            Line.replace(0, Line.length(), "| Database                                                                 |\n");
            if (!this.mOptions.getProperty("db-port").equalsIgnoreCase("7210")) {
                Item = this.mOptions.getProperty("DBName");
                Item = Item + " (port: " + this.mOptions.getProperty("db-port") + ")";
            } else {
                Item = this.mOptions.getProperty("DBName");
            }
            Line.replace(39, 39 + Item.length(), Item);
            Result.append(Line.toString());
        }
        Line.replace(0, Line.length(), "| Operating System                                                         |\n");
        Item = TestDriver.getOpSystem();
        Line.replace(39, 39 + Item.length(), Item);
        Result.append(Line.toString());
        Result.append("|--------------------------------------------------------------------------|\n");
        Line.replace(0, Line.length(), "| Start time                                                               |\n");
        Item = mDateFormat.format(TestStatistic.getStartTime());
        Line.replace(39, 39 + Item.length(), Item);
        Result.append(Line.toString());
        Line.replace(0, Line.length(), "| Total run time                       00h 00m 00s                         |\n");
        Item = String.valueOf(ExecutionTime / 3600);
        Line.replace(41 - Item.length(), 41, Item);
        Item = String.valueOf(ExecutionTime % 3600 / 60);
        Line.replace(45 - Item.length(), 45, Item);
        Item = String.valueOf(ExecutionTime % 60);
        Line.replace(49 - Item.length(), 49, Item);
        Result.append(Line.toString());
        Result.append("|--------------------------------------------------------------------------|\n");
        Line.replace(0, Line.length(), "| Tests planned                                                            |\n");
        Item = String.valueOf(TestStatistic.getTestsPlanned());
        Line.replace(41 - Item.length(), 41, Item);
        Result.append(Line.toString());
        Line.replace(0, Line.length(), "| Tests started                                                            |\n");
        Item = String.valueOf(TestStatistic.getTestsStarted());
        Line.replace(41 - Item.length(), 41, Item);
        Result.append(Line.toString());
        Line.replace(0, Line.length(), "| Tests successful                                                         |\n");
        Item = String.valueOf(TestStatistic.getTestsSuccessful());
        Line.replace(41 - Item.length(), 41, Item);
        Result.append(Line.toString());
        Line.replace(0, Line.length(), "|                                                                          |\n");
        Result.append(Line.toString());
        if (TestStatistic.getTotalErrors() >= TestErrorCount && TestStatistic.getTotalErrors() - TestErrorCount != 0) {
            TestStatistic.setTotalTestDriverErrors(TestStatistic.getTotalErrors() - TestErrorCount);
            Line.replace(0, Line.length(), "| Total TestDriver errors                                                  |\n");
            Item = String.valueOf(TestStatistic.getTotalTestDriverErrors());
            Line.replace(41 - Item.length(), 41, Item);
            Result.append(Line.toString());
        }
        if (TestStatistic.getTotalWarnings() >= TestWarnCount && TestStatistic.getTotalWarnings() - TestWarnCount != 0) {
            Line.replace(0, Line.length(), "| Total TestDriver warnings                                                |\n");
            Item = String.valueOf(TestStatistic.getTotalWarnings() - TestWarnCount);
            Line.replace(41 - Item.length(), 41, Item);
            Result.append(Line.toString());
        }
        if (TestErrorCount > 0) {
            Line.replace(0, Line.length(), "| Total test errors                                                        |\n");
            Item = String.valueOf(TestErrorCount);
            Line.replace(41 - Item.length(), 41, Item);
            Result.append(Line.toString());
        }
        if (TestWarnCount > 0) {
            Line.replace(0, Line.length(), "| Total test warnings                                                      |\n");
            Item = String.valueOf(TestWarnCount);
            Line.replace(41 - Item.length(), 41, Item);
            Result.append(Line.toString());
        }
        Result.append("|--------------------------------------------------------------------------|\n");
        return Result.toString();
    }

    private String buildSummary() {
        int ErrorCount = 0;
        int ExecutionTime = 0;
        int TestCount = 0;
        int counter = 0;
        int WarnCount = 0;
        StringBuffer line = new StringBuffer();
        StringWriter stringW = new StringWriter();
        BufferedWriter Result = new BufferedWriter(stringW);
        if (this.mTestSet == null) {
            return "";
        }
        try {
            String item;
            if (((Boolean)this.mOptions.get("ProtocolFilterSummary")).booleanValue()) {
                Result.write("FILTER-SUMMARY active, only tests with errors or warnings are listed. ");
                Result.newLine();
                Result.newLine();
            }
            Result.newLine();
            Result.write("|--------------------------------------------------------------------------|");
            Result.newLine();
            line.replace(0, line.length(), "|     | TestDriver       - Summary               | Runtime | Error | Warn. |");
            line.replace(19, 19 + sVersion.length(), sVersion);
            Result.write(line.toString());
            Result.newLine();
            Result.write("| Nr. |                                          |(min:sec)| count | count |");
            Result.newLine();
            Result.write("|-----+------------------------------------------+---------+-------+-------|");
            Result.newLine();
            Iterator it = this.mTestSet.iterator();
            while (it.hasNext()) {
                int tnc;
                String dummy;
                int maxTestNameLength;
                String tempitem;
                TestSequence.TestSequenceItem TestItem = (TestSequence.TestSequenceItem)it.next();
                ++counter;
                if (((Boolean)this.mOptions.get("ProtocolFilterSummary")).booleanValue() && TestItem.getErrorCount() == 0 && TestItem.getWarnCount() == 0) {
                    if (TestItem.wasExecuted()) {
                        ++TestCount;
                        WarnCount += TestItem.getWarnCount();
                        ErrorCount += TestItem.getErrorCount();
                        ExecutionTime += TestItem.getExecutionTime();
                        continue;
                    }
                    line.replace(0, line.length(), "| 000 |                                          |  ??:??  |    ?? |    ?? |");
                    tempitem = new Integer(counter).toString();
                    line.replace(5 - tempitem.length(), 5, tempitem);
                    item = TestItem.getClassName();
                    maxTestNameLength = 40;
                    if (item.startsWith("com.sap.sapdb.")) {
                        item = tempitem = item.substring(14);
                    }
                    if (item.startsWith("com.sap.")) {
                        item = tempitem = item.substring(8);
                    }
                    if (item.length() > maxTestNameLength) {
                        dummy = "";
                        tempitem = "";
                        for (tnc = item.length() - 1; tnc >= 0; --tnc) {
                            if (item.charAt(tnc) != '.') {
                                dummy = item.charAt(tnc) + dummy;
                                continue;
                            }
                            if (dummy.length() > maxTestNameLength) break;
                            tempitem = dummy;
                            dummy = item.charAt(tnc) + dummy;
                        }
                        if (tempitem == "") {
                            tempitem = dummy.substring(0, maxTestNameLength - 3) + "...";
                        }
                        item = tempitem;
                    }
                    line.replace(8, 8 + item.length(), item);
                    Result.write(line.toString());
                    Result.newLine();
                    continue;
                }
                if (TestItem.wasExecuted()) {
                    line.replace(0, line.length(), "| 000 |                                          |    :00  |       |       |");
                } else {
                    line.replace(0, line.length(), "| 000 |                                          |  ??:??  |    ?? |    ?? |");
                }
                tempitem = new Integer(counter).toString();
                line.replace(5 - tempitem.length(), 5, tempitem);
                item = TestItem.getClassName();
                maxTestNameLength = 40;
                if (item.startsWith("com.sap.sapdb.")) {
                    item = tempitem = item.substring(14);
                }
                if (item.startsWith("com.sap.")) {
                    item = tempitem = item.substring(8);
                }
                if (item.length() > maxTestNameLength) {
                    dummy = "";
                    tempitem = "";
                    for (tnc = item.length() - 1; tnc >= 0; --tnc) {
                        if (item.charAt(tnc) != '.') {
                            dummy = item.charAt(tnc) + dummy;
                            continue;
                        }
                        if (dummy.length() > maxTestNameLength) break;
                        tempitem = dummy;
                        dummy = item.charAt(tnc) + dummy;
                    }
                    if (tempitem == "") {
                        tempitem = dummy.substring(0, maxTestNameLength - 3) + "...";
                    }
                    item = tempitem;
                }
                line.replace(8, 8 + item.length(), item);
                if (TestItem.wasExecuted()) {
                    ExecutionTime += TestItem.getExecutionTime();
                    item = String.valueOf(TestItem.getExecutionTime() / 60);
                    line.replace(54 - item.length(), 54, item);
                    item = String.valueOf(TestItem.getExecutionTime() % 60);
                    line.replace(57 - item.length(), 57, item);
                    ErrorCount += TestItem.getErrorCount();
                    item = String.valueOf(TestItem.getErrorCount());
                    line.replace(66 - item.length(), 66, item);
                    WarnCount += TestItem.getWarnCount();
                    item = String.valueOf(TestItem.getWarnCount());
                    line.replace(73 - item.length(), 73, item);
                    ++TestCount;
                }
                Result.write(line.toString());
                Result.newLine();
                if (!TestItem.getParameter().exists()) continue;
                item = TestItem.getParameter().getName();
                line.replace(0, line.length(), "|     |    using:                                |         |       |       |");
                line.replace(18, 18 + item.length(), item);
                Result.write(line.toString());
                Result.newLine();
            }
            Result.write("|------------------------------------------------+---------+-------+-------|");
            Result.newLine();
            line.replace(0, line.length(), "| Total:     of     tests executed               |    :00  |       |       |");
            item = String.valueOf(TestCount);
            line.replace(12 - item.length(), 12, item);
            item = String.valueOf(this.mTestSet.size());
            line.replace(19 - item.length(), 19, item);
            item = String.valueOf(ErrorCount);
            line.replace(66 - item.length(), 66, item);
            item = String.valueOf(WarnCount);
            line.replace(73 - item.length(), 73, item);
            item = String.valueOf(ExecutionTime / 60);
            line.replace(54 - item.length(), 54, item);
            item = String.valueOf(ExecutionTime % 60);
            line.replace(57 - item.length(), 57, item);
            Result.write(line.toString());
            Result.newLine();
            Result.write("|--------------------------------------------------------------------------|");
            Result.newLine();
            Result.flush();
        }
        catch (IOException e) {
            this.printException(e.getMessage());
        }
        return stringW.toString();
    }

    private void checkOptions() {
        TestDriver.addState(" TestDriver->checkOptions()");
        if (this.mOptions.get("DBGenerate") != null && ((Boolean)this.mOptions.get("DBGenerate")).booleanValue()) {
            if (!(this.mOptions.getProperty("DBSize") == null || this.mOptions.getProperty("DBSize").equalsIgnoreCase("SMALL") || this.mOptions.getProperty("DBSize").equalsIgnoreCase("MEDIUM") || this.mOptions.getProperty("DBSize").equalsIgnoreCase("LARGE") || this.mOptions.getProperty("DBSize").equalsIgnoreCase("HUGE"))) {
                System.out.println("Wrong option: -S <SMALL|MEDIUM|LARGE|HUGE>");
                System.exit(-1);
            }
            if (this.mOptions.getProperty("DBType") != null && this.mOptions.getProperty("DBType").compareTo("SAP") != 0) {
                System.out.println("Invalid option: -t " + this.mOptions.getProperty("DBType"));
                System.exit(-1);
            }
        } else if (!(this.mOptions.getProperty("DBMode") == null || this.mOptions.getProperty("DBMode").equalsIgnoreCase("FAST") || this.mOptions.getProperty("DBMode").equalsIgnoreCase("SLOW") || this.mOptions.getProperty("DBMode").equalsIgnoreCase("TEST"))) {
            System.out.println("Wrong option: -k <SLOW|FAST|TEST>");
            System.exit(-1);
        }
        if (this.hasReferenceMode() && this.hasSaveTestResult() && this.mOptions.getProperty("ResultDBName") == null && this.mOptions.getProperty("ResultDBPwd") == null) {
            System.out.println("-g <password> required for reference database T01");
            System.exit(-1);
        }
    }

    private boolean checkTestVersion(TestDatabase pDb, Class pClass) {
        boolean rval = true;
        try {
            if (pDb.isSap()) {
                TestDatabaseSap actDb = (TestDatabaseSap)pDb;
                int dbvrs = TestDriver.convertMinimumToInteger(actDb.getVersion());
                Method GetMin = pClass.getMethod("getMinimumRelease", new Class[0]);
                String stvrsb = (String)GetMin.invoke(null, new Object[0]);
                Method GetMax = pClass.getMethod("getMaximumRelease", new Class[0]);
                String stvrse = (String)GetMax.invoke(null, new Object[0]);
                int tvrsb = 0;
                int tvrse = Integer.MAX_VALUE;
                if (stvrsb != null && stvrsb.compareTo("*") != 0) {
                    tvrsb = TestDriver.convertMinimumToInteger(stvrsb);
                }
                if (stvrse != null && stvrse.compareTo("*") != 0) {
                    tvrse = TestDriver.convertMaximumToInteger(stvrse);
                }
                rval = dbvrs >= tvrsb && dbvrs <= tvrse;
                if (tvrsb == -1) {
                    this.mTestDriverProtocol.addItem(pClass.getName(), 'W', "getMinimumRelease() is wrong: " + stvrsb);
                    rval = false;
                }
                if (tvrse == -1) {
                    this.mTestDriverProtocol.addItem(pClass.getName(), 'W', "getMaximumRelease() is wrong: " + stvrse);
                    rval = false;
                }
                this.addTraceToProtocol("Database release = \"" + actDb.getVersion() + "\" -> " + dbvrs);
                this.addTraceToProtocol(pClass.getName() + "\n   getMinimumRelease() = \"" + stvrsb + "\" -> " + tvrsb + ";\n   getMaximumRelease() = \"" + stvrse + "\" -> " + tvrse);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return rval;
    }

    private Properties completeOptions() {
        Object key;
        Iterator<Object> it;
        Set<Object> keys;
        Properties modOptions = new Properties();
        modOptions.put("SingleParameterFile", "");
        modOptions.put("db-port", "7210");
        modOptions.put("DBHost", "localhost");
        modOptions.put("DBType", "SAP");
        modOptions.put("DBKind", "OLTP");
        modOptions.put("DBKeepState", "OFFLINE");
        modOptions.put("DBGenerate", Boolean.TRUE);
        modOptions.put("DBSize", "SMALL");
        modOptions.put("ResultDBHost", "localhost");
        modOptions.put("SaveResult", Boolean.FALSE);
        modOptions.put("Save-Result", Boolean.FALSE);
        modOptions.put("TestMode", "Test");
        modOptions.put("ExceptionTraceback", Boolean.FALSE);
        modOptions.put("ProtocolAsync", Boolean.TRUE);
        modOptions.put("DBJdbcTrace", Boolean.FALSE);
        modOptions.put("DBOltpTrace", Boolean.FALSE);
        modOptions.put("DBOmsTrace", Boolean.FALSE);
        modOptions.put("TestFrameTrace", Boolean.FALSE);
        modOptions.put("VerificationTrace", Boolean.FALSE);
        modOptions.put("RepetitionRate", new Integer(1));
        modOptions.put("ParallelRate", new Integer(1));
        modOptions.put("MailIndividual", Boolean.FALSE);
        modOptions.put("DBKeep", Boolean.FALSE);
        modOptions.put("DBForce", Boolean.FALSE);
        modOptions.put("DBDrop", Boolean.FALSE);
        modOptions.put("DBAttach", Boolean.FALSE);
        modOptions.put("VerificationTraceWithExplain", Boolean.FALSE);
        modOptions.put("VerificationTraceWithResult", Boolean.FALSE);
        modOptions.put("DBMode", "FAST");
        modOptions.put("Restart", "EMPTY");
        modOptions.put("DBShort", Boolean.FALSE);
        modOptions.put("NoMonitor", Boolean.FALSE);
        modOptions.put("Monitor", Boolean.FALSE);
        modOptions.put("NoWebdav", Boolean.FALSE);
        modOptions.put("SaveWebdav-host", "");
        modOptions.put("sql-service-url", "");
        modOptions.put("Monitor-Host", "");
        modOptions.put("NoKnldiag", Boolean.FALSE);
        modOptions.put("knldump", Boolean.FALSE);
        modOptions.put("NoVtrace", Boolean.FALSE);
        modOptions.put("ScheduledTest", Boolean.FALSE);
        modOptions.put("mailsubject", "");
        modOptions.put("jdbc-property", "");
        modOptions.put("ProtocolFilterSummary", Boolean.FALSE);
        modOptions.put("files-to-upload", "");
        modOptions.put("QALevel", "N");
        modOptions.put("LCPoolNumber", "n/a");
        modOptions.put("ChangeListNumber", "n/a");
        modOptions.put("MakeKey", "0");
        modOptions.put("MakeKey2", "0");
        modOptions.put("InstKey", "0");
        modOptions.put("DBNone", Boolean.FALSE);
        modOptions.put("ExplicitVersion", "");
        modOptions.put("ZipAttachment", "-1");
        if (System.getProperty("env.own") != null) {
            modOptions.put("DBRoot", System.getProperty("env.own") + File.separator + "usr");
        }
        HashMap tdConfig = null;
        if (this.mConfiguration != null && !(tdConfig = this.mConfiguration.getConfiguration()).isEmpty()) {
            keys = tdConfig.keySet();
            it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                modOptions.put(key, tdConfig.get(key));
            }
        }
        keys = this.mOptions.keySet();
        it = keys.iterator();
        while (it.hasNext()) {
            key = it.next();
            modOptions.put(key, this.mOptions.get(key));
        }
        Boolean monitor = (Boolean)this.mOptions.get("Monitor");
        if (monitor != null && monitor.booleanValue()) {
            modOptions.put("NoMonitor", Boolean.FALSE);
        }
        if (this.mOptions.get("DBDrop") != null && ((Boolean)this.mOptions.get("DBDrop")).booleanValue()) {
            modOptions.put("DBDrop", Boolean.TRUE);
            modOptions.put("DBKeep", Boolean.FALSE);
        } else if (this.mOptions.get("DBKeep") != null && ((Boolean)this.mOptions.get("DBKeep")).booleanValue()) {
            modOptions.put("DBDrop", Boolean.FALSE);
            modOptions.put("DBKeep", Boolean.TRUE);
        }
        if (modOptions.getProperty("DBName") == null) {
            modOptions.put("DBNone", Boolean.TRUE);
            modOptions.put("DBType", "NONE");
        }
        if (modOptions.get("DBNone") != null && ((Boolean)modOptions.get("DBNone")).booleanValue()) {
            modOptions.put("DBKind", "NONE");
            modOptions.put("DBType", "NONE");
        }
        if (modOptions.get("DBType") != null && modOptions.get("DBType").equals("NONE")) {
            modOptions.put("DBNone", Boolean.TRUE);
            modOptions.put("DBKind", "NONE");
        }
        if (modOptions.get("DBKind") != null && modOptions.get("DBKind").equals("NONE")) {
            modOptions.put("DBNone", Boolean.TRUE);
            modOptions.put("DBType", "NONE");
        }
        if (modOptions.getProperty("ProtocolOutput") == null) {
            modOptions.put("ProtocolOutputPath", System.getProperty("user.dir"));
            modOptions.put("ProtocolOutputFile", "TestOut");
            this.mHasOutputFile = true;
        } else if (!modOptions.getProperty("ProtocolOutput").equalsIgnoreCase("ProtocolConsole")) {
            this.mHasOutputFile = true;
            Properties fp = TestDriver.parseFile(modOptions.getProperty("ProtocolOutput"));
            if (fp.getProperty("PATH") == null) {
                modOptions.put("ProtocolOutputPath", System.getProperty("user.dir"));
            } else {
                modOptions.put("ProtocolOutputPath", fp.getProperty("PATH"));
            }
            if (fp.getProperty("FILE") == null) {
                modOptions.put("ProtocolOutputFile", "TestOut");
            } else {
                modOptions.put("ProtocolOutputFile", fp.getProperty("FILE"));
            }
        }
        if (modOptions.getProperty("DBHost") != null && modOptions.getProperty("DBHost").equalsIgnoreCase(this.getHostName())) {
            modOptions.put("DBHost", "localhost");
        }
        return modOptions;
    }

    static int convertMinimumToInteger(String pStr) {
        int version = 0;
        try {
            StringTokenizer st = new StringTokenizer(pStr, ".");
            String actToken = null;
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                version += 10000000 * Integer.valueOf(actToken);
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version += 100000 * Integer.valueOf(actToken);
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version += 1000 * Integer.valueOf(actToken);
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version += Integer.valueOf(actToken).intValue();
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return version;
    }

    static int convertMaximumToInteger(String pStr) {
        int version = 0;
        try {
            StringTokenizer st = new StringTokenizer(pStr, ".");
            String actToken = null;
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                version += 10000000 * Integer.valueOf(actToken);
                version += 9999999;
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version -= 9999999;
                    version += 100000 * Integer.valueOf(actToken);
                    version += 99999;
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version -= 99999;
                    version += 1000 * Integer.valueOf(actToken);
                    version += 999;
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
            if (st.hasMoreTokens()) {
                actToken = st.nextToken();
                if (actToken.compareTo("*") != 0) {
                    version -= 999;
                    version += Integer.valueOf(actToken).intValue();
                } else if (st.hasMoreTokens()) {
                    return -1;
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return version;
    }

    public static boolean compareRelease(String pRelease1, String pOperator, String pRelease2) {
        if (pOperator.trim().equalsIgnoreCase("<")) {
            return TestDriver.convertMinimumToInteger(pRelease1.trim()) < TestDriver.convertMinimumToInteger(pRelease2.trim());
        }
        if (pOperator.trim().equalsIgnoreCase("<=") || pOperator.trim().equalsIgnoreCase("=<")) {
            return TestDriver.convertMinimumToInteger(pRelease1.trim()) <= TestDriver.convertMinimumToInteger(pRelease2.trim());
        }
        if (pOperator.trim().equalsIgnoreCase(">")) {
            return TestDriver.convertMinimumToInteger(pRelease1.trim()) > TestDriver.convertMinimumToInteger(pRelease2.trim());
        }
        if (pOperator.trim().equalsIgnoreCase("=>") || pOperator.trim().equalsIgnoreCase(">=")) {
            return TestDriver.convertMinimumToInteger(pRelease1.trim()) >= TestDriver.convertMinimumToInteger(pRelease2.trim());
        }
        if (pOperator.trim().equalsIgnoreCase("=") || pOperator.trim().equalsIgnoreCase("==") || pOperator.trim().equalsIgnoreCase("= =") || pOperator.trim().equalsIgnoreCase("equals")) {
            return TestDriver.convertMinimumToInteger(pRelease1.trim()) == TestDriver.convertMinimumToInteger(pRelease2.trim());
        }
        return false;
    }

    private void enableAsyncProtocolWriter() {
        TestDriver.addState(" TestDriver->enableAsyncProtocolWriter()");
        if (this.mOptions.get("ProtocolAsync") != null && ((Boolean)this.mOptions.get("ProtocolAsync")).booleanValue()) {
            this.mHasAsyncProtocol = true;
            if (!this.mHasOutputFile) {
                this.mTestDriverProtocol.enableParallelPrintSaveMode(10, 'A');
                this.mTestProtocol.enableParallelPrintSaveMode(10, 'A');
            } else {
                this.mTestDriverProtocol.enableParallelPrintSaveMode(10, 'B');
                this.mTestProtocol.enableParallelPrintSaveMode(10, 'B');
            }
        }
    }

    private void enableExceptionTracebackInProtocol() {
        if (this.mOptions.get("ExceptionTraceback") != null) {
            this.mTestProtocol.setPrintExceptionTraceback((Boolean)this.mOptions.get("ExceptionTraceback"));
        }
    }

    private void generateInterruptReportFiles(String TestName) {
        this.addTraceToProtocol("Start of generateInterruptReportFiles(" + TestName + ")");
        this.generateVTrace(TestName, true);
    }

    private void generateVTrace(String TestName, boolean isInterrupted) {
        if (!this.isRemoteTest() && !((Boolean)this.mOptions.get("DBNone")).booleanValue()) {
            File knlmsgFile;
            File knldiagFile;
            String currentCmd;
            this.addTraceToProtocol("in generateVTrace(" + TestName + "," + isInterrupted + ")...");
            boolean noVtrace = false;
            Boolean oNoVtrace = (Boolean)this.mOptions.get("NoVtrace");
            if (oNoVtrace != null && oNoVtrace.booleanValue()) {
                noVtrace = true;
            }
            if (noVtrace) {
                this.addTraceToProtocol("no vtrace, rtedump, knldump and comseg.dump because option novtrace is set!");
                return;
            }
            TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
            File FileDir = null;
            try {
                FileDir = new File(sapdb.getRunDir());
            }
            catch (TestDatabaseException e) {
                // empty catch block
            }
            if (FileDir == null) {
                this.printMessage("No vtrace, rtedump, knldump and comseg.dump because: can't read RUNDIRECTORY; getting: null");
                return;
            }
            try {
                this.printMessage("Try to generate vtrace and rtedump named like the current testname (" + TestName + ") in " + FileDir + File.separator);
                if (sapdb.isFull()) {
                    this.printMessage("Database is full. No connect to database possible -> stop it.");
                    this.mTestDriverProtocol.addItem('T', "Database is full. No connect to database possible -> stop it.");
                    sapdb.executeDBMcmd("db_stop -dump");
                }
                if (sapdb.isWarm()) {
                    sapdb.flushTrace();
                }
            }
            catch (TestDatabaseException e) {
                this.printMessage("Can't flush the vtrace. Error: " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception ex) {
                this.printMessage("Can't flush the vtrace. Error : " + ex.getMessage());
                ex.printStackTrace();
            }
            StringBuffer ProcessOutput = new StringBuffer();
            Execute SystemProcess = null;
            ProcessOutput.setLength(0);
            if (FileDir.isDirectory()) {
                String[] FileList = FileDir.list();
                int filecounter = 0;
                for (int i = 0; i < FileList.length && filecounter < 10; ++i) {
                    File file = new File(FileDir, FileList[i]);
                    String fileName = null;
                    fileName = file.toString();
                    if (!isInterrupted && fileName.endsWith(TestName + ".vtrace")) {
                        this.addTraceToProtocol("delete old duplicate vtrace file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted && fileName.endsWith(TestName + ".rtedump")) {
                        this.addTraceToProtocol("delete old duplicate rtedump file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted && fileName.endsWith(TestName + ".dbmprt")) {
                        this.addTraceToProtocol("delete old duplicate dbmprt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted && fileName.endsWith(TestName + ".knldump")) {
                        this.addTraceToProtocol("delete old duplicate knldump file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted && fileName.endsWith(TestName + ".knldiag")) {
                        this.addTraceToProtocol("delete old duplicate knldiag file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted && fileName.endsWith(TestName + ".knlmsg")) {
                        this.addTraceToProtocol("delete old duplicate knlmsg file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".vtrace_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate vtrace_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".rtedump_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate rtedump_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".knldump_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate knldump_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".dbmprt_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate dbmprt_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".knldiag_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate knldiag_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (isInterrupted && fileName.endsWith(TestName + ".knlmsg_interrupt")) {
                        this.addTraceToProtocol("delete old duplicate knlmsg_interrupt file");
                        file.delete();
                        ++filecounter;
                    }
                    if (!isInterrupted || !fileName.endsWith(TestName + ".ps_interrupt")) continue;
                    this.addTraceToProtocol("delete old duplicate ps_interrupt file");
                    file.delete();
                    ++filecounter;
                }
            }
            try {
                File newVtrace;
                String[] cmdArr;
                currentCmd = this.mOptions.getProperty("DBRoot") + File.separator + "bin" + File.separator + "xkernprot -d " + this.mOptions.getProperty("DBName").toUpperCase() + " akbx";
                if (TestDriver.isDevelopmentInstallation()) {
                    if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
                        this.addTraceToProtocol("Try to execute: " + currentCmd + " in: " + FileDir);
                        SystemProcess = new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=yes"}, ProcessOutput);
                    } else {
                        cmdArr = new String[]{"sh", "-c", currentCmd};
                        this.addTraceToProtocol("Trying system call: " + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + " in: " + FileDir);
                        SystemProcess = new Execute(cmdArr, new String[]{"SAPDB_NO_INDEPPATH=yes"}, ProcessOutput);
                    }
                } else if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
                    this.addTraceToProtocol("Try to execute: " + currentCmd + " in: " + FileDir);
                    SystemProcess = new Execute(currentCmd, null, ProcessOutput);
                } else {
                    cmdArr = new String[]{"sh", "-c", currentCmd};
                    this.addTraceToProtocol("Trying system call: " + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + " in: " + FileDir);
                    SystemProcess = new Execute(cmdArr, null, ProcessOutput);
                }
                SystemProcess.exec(FileDir);
                this.addTraceToProtocol("" + ProcessOutput);
                File Vtrace = new File(FileDir + File.separator + this.mOptions.getProperty("DBName").toUpperCase() + ".prt");
                if (isInterrupted) {
                    this.addTraceToProtocol("Rename: " + Vtrace + " to " + TestName + ".vtrace_interrupt");
                    newVtrace = new File(FileDir + File.separator + TestName + ".vtrace_interrupt");
                    Vtrace.renameTo(newVtrace);
                } else {
                    this.addTraceToProtocol("Rename: " + Vtrace + " to " + TestName + ".vtrace");
                    newVtrace = new File(FileDir + File.separator + TestName + ".vtrace");
                    Vtrace.renameTo(newVtrace);
                }
            }
            catch (Exception e) {
                this.printMessage("Can't run xkernprot.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            catch (NoSuchMethodError nsme) {
                this.printMessage("Can't automatically generate the vtrace. Check if Java VM has version 1.3 or above.");
                this.addTraceToProtocol("Error: " + nsme.toString());
            }
            try {
                File newRtedump;
                File rtedump = new File(FileDir + File.separator + "rtedump");
                ProcessOutput = new StringBuffer();
                if (sapdb.isWarm()) {
                    currentCmd = TestDriver.isDevelopmentInstallation() ? this.mOptions.getProperty("DBRoot") + File.separator + "bin" + File.separator + "x_cons " + this.mOptions.getProperty("DBName").toUpperCase() + " show all" : "x_cons " + this.mOptions.getProperty("DBName").toUpperCase() + " show all";
                    this.addTraceToProtocol("Try to execute: " + currentCmd + " in: " + FileDir);
                    SystemProcess = TestDriver.isDevelopmentInstallation() ? new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=yes"}, ProcessOutput) : new Execute(currentCmd, null, ProcessOutput);
                    SystemProcess.ignoreBufferLimitForStdOut(true);
                    SystemProcess.exec(FileDir);
                    FileWriter fw = new FileWriter(rtedump);
                    fw.write(ProcessOutput.substring(0), 0, ProcessOutput.length());
                    fw.close();
                }
                if (isInterrupted) {
                    this.addTraceToProtocol("Rename: " + rtedump + " to " + TestName + ".rtedump_interrupt");
                    newRtedump = new File(FileDir + File.separator + TestName + ".rtedump_interrupt");
                    rtedump.renameTo(newRtedump);
                } else {
                    this.addTraceToProtocol("Rename: " + rtedump + " to " + TestName + ".rtedump");
                    newRtedump = new File(FileDir + File.separator + TestName + ".rtedump");
                    rtedump.renameTo(newRtedump);
                }
            }
            catch (Exception e) {
                this.printMessage("Can't create rtedump.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            catch (NoSuchMethodError nsme) {
                this.printMessage("Error: " + nsme.toString());
                nsme.printStackTrace();
            }
            try {
                if (sapdb != null) {
                    knldiagFile = null;
                    if (isInterrupted) {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knldiag_interrupt");
                        knldiagFile = new File(FileDir + File.separator + TestName + ".knldiag_interrupt");
                    } else {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knldiag");
                        knldiagFile = new File(FileDir + File.separator + TestName + ".knldiag");
                    }
                    FileWriter fwknl = new FileWriter(knldiagFile);
                    String knldiag = sapdb.getDatabaseProtocolViaDBMKey("KNLDIAG");
                    fwknl.write(knldiag.substring(0), 0, knldiag.length());
                    fwknl.close();
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy knldiag.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            try {
                if (sapdb != null) {
                    knldiagFile = null;
                    if (isInterrupted) {
                        this.addTraceToProtocol("Copy: dbmprt to " + TestName + ".dbmprt_interrupt");
                        knldiagFile = new File(FileDir + File.separator + TestName + ".dbmprt_interrupt");
                    } else {
                        this.addTraceToProtocol("Copy: dbmprt to " + TestName + ".dbmprt");
                        knldiagFile = new File(FileDir + File.separator + TestName + ".dbmprt");
                    }
                    FileWriter fwknl = new FileWriter(knldiagFile);
                    String knldiag = sapdb.getDatabaseProtocolViaDBMKey("DBMPRT");
                    fwknl.write(knldiag.substring(0), 0, knldiag.length());
                    fwknl.close();
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy dbmprt.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            try {
                if (sapdb != null && TestDriver.compareRelease(sapdb.getKernelVersion(), ">=", "7.7.00")) {
                    knlmsgFile = null;
                    if (isInterrupted) {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knlmsg_interrupt");
                        knlmsgFile = new File(FileDir + File.separator + TestName + ".knlmsg_interrupt");
                    } else {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knlmsg");
                        knlmsgFile = new File(FileDir + File.separator + TestName + ".knlmsg");
                    }
                    FileWriter fwknl = new FileWriter(knlmsgFile);
                    String knldiag = sapdb.getDatabaseProtocolViaDBMKey("KNLMSGX");
                    fwknl.write(knldiag.substring(0), 0, knldiag.length());
                    fwknl.close();
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy knlmsg.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            try {
                if (sapdb != null && TestDriver.compareRelease(sapdb.getKernelVersion(), ">=", "7.6.00") && TestDriver.compareRelease(sapdb.getKernelVersion(), "<", "7.7.00")) {
                    knlmsgFile = null;
                    if (isInterrupted) {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knlmsg_interrupt");
                        knlmsgFile = new File(FileDir + File.separator + TestName + ".knlmsg_interrupt");
                    } else {
                        this.addTraceToProtocol("Copy: knldiag to " + TestName + ".knlmsg");
                        knlmsgFile = new File(FileDir + File.separator + TestName + ".knlmsg");
                    }
                    FileWriter fwknl = new FileWriter(knlmsgFile);
                    String knldiag = sapdb.getDatabaseProtocolViaDBMKey("KNLMSG");
                    fwknl.write(knldiag.substring(0), 0, knldiag.length());
                    fwknl.close();
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy knlmsg.\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            Boolean oKnlDump = (Boolean)this.mOptions.get("knldump");
            if (oKnlDump != null && oKnlDump.booleanValue()) {
                currentCmd = "util_execute diagnose data to 'knldump'";
                try {
                    if (sapdb != null && sapdb.isWarm()) {
                        sapdb.executeDBMcmd(currentCmd);
                    }
                }
                catch (Exception e) {
                    this.printMessage("Can't create knldump with '" + currentCmd + "' . Message: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            try {
                if (sapdb != null) {
                    File knldump = new File(FileDir + File.separator + "knldump");
                    if (!knldump.exists()) {
                        this.printMessage("No knldump available!");
                    } else if (isInterrupted) {
                        this.addTraceToProtocol("Rename: " + knldump + " to " + TestName + ".knldump_interrupt");
                        File newknldump = new File(FileDir + File.separator + TestName + ".knldump_interrupt");
                        knldump.renameTo(newknldump);
                    } else {
                        this.addTraceToProtocol("Rename: " + knldump + " to " + TestName + ".knldump");
                        File newknldump = new File(FileDir + File.separator + TestName + ".knldump");
                        knldump.renameTo(newknldump);
                    }
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy knldump .\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            try {
                if (sapdb != null) {
                    File comsegdump = new File(FileDir + File.separator + "comseg.dump");
                    if (!comsegdump.exists()) {
                        this.printMessage("No comseg.dump available!");
                    } else if (isInterrupted) {
                        this.addTraceToProtocol("Rename: " + comsegdump + " to " + TestName + ".comseg.dump_interrupt");
                        File newcomsegdump = new File(FileDir + File.separator + TestName + ".comseg.dump_interrupt");
                        comsegdump.renameTo(newcomsegdump);
                    } else {
                        this.addTraceToProtocol("Rename: " + comsegdump + " to " + TestName + ".comseg.dump");
                        File newcomsegdump = new File(FileDir + File.separator + TestName + ".comseg.dump");
                        comsegdump.renameTo(newcomsegdump);
                    }
                }
            }
            catch (Exception e) {
                this.printMessage("Can't copy comseg.dump .\n" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            if (isInterrupted && System.getProperty("os.name").indexOf("Windows") == -1) {
                try {
                    ProcessOutput = new StringBuffer();
                    File psOutPut = new File(FileDir + File.separator + "psOutPut");
                    currentCmd = "ps -aef";
                    String[] cmdArr = new String[]{"sh", "-c", currentCmd};
                    this.addTraceToProtocol("Trying system call: " + cmdArr[0] + " " + cmdArr[1] + " " + cmdArr[2] + " in: " + FileDir);
                    SystemProcess = new Execute(cmdArr, null, ProcessOutput);
                    SystemProcess.ignoreBufferLimitForStdOut(true);
                    SystemProcess.exec(FileDir);
                    FileWriter fw = new FileWriter(psOutPut);
                    fw.write(ProcessOutput.substring(0), 0, ProcessOutput.length());
                    fw.close();
                    this.addTraceToProtocol("Rename: " + psOutPut + " to " + TestName + ".ps_interrupt");
                    File newPSOutput = new File(FileDir + File.separator + TestName + ".ps_interrupt");
                    psOutPut.renameTo(newPSOutput);
                }
                catch (Exception e) {
                    this.printMessage("Can't copy 'ps -aef' output .\n" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public String getHostName() {
        if (this.mHostName != null) {
            return this.mHostName;
        }
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        ProcessOutput.setLength(0);
        String currentCmd = "hostname";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName;
            this.mHostName = hostName = ProcessOutput.toString().trim().toLowerCase();
            return this.mHostName;
        }
        ProcessOutput.setLength(0);
        currentCmd = "uname -n";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName;
            this.mHostName = hostName = ProcessOutput.toString().trim().toLowerCase();
            return this.mHostName;
        }
        return "unknown";
    }

    public static String getOpSystem() {
        return System.getProperty("os.name");
    }

    public static final boolean isDevelopmentInstallation() {
        String itprop = System.getProperty("db.insttype");
        return itprop == null || itprop.equalsIgnoreCase("develop") || itprop.equalsIgnoreCase("developer") || itprop.equalsIgnoreCase("development");
    }

    public static final String getJTestRoot() {
        return System.getProperty("jtest.root");
    }

    public String getTestSetName() {
        return this.mTestSetName;
    }

    public static final Date getStartTime() {
        return mStartDate;
    }

    private static URLClassLoader getURLClassLoader(TestSequence pTestSequence) {
        URLClassLoader loader = null;
        Iterator it = pTestSequence.iterator();
        ArrayList<File> archiveList = new ArrayList<File>();
        while (it.hasNext()) {
            TestSequence.TestSequenceItem item = (TestSequence.TestSequenceItem)it.next();
            File archive = item.getArchive();
            if (archive == null || archiveList.contains(archive)) continue;
            archiveList.add(archive);
        }
        if (!archiveList.isEmpty()) {
            Object[] archiveArray = archiveList.toArray();
            URL[] urlList = new URL[archiveArray.length];
            for (int i = 0; i < archiveArray.length; ++i) {
                try {
                    urlList[i] = new URL("file", null, archiveArray[i].toString());
                    continue;
                }
                catch (MalformedURLException e) {
                    System.out.println(e.getMessage());
                }
            }
            loader = new URLClassLoader(urlList);
        }
        return loader;
    }

    private boolean hasReferenceMode() {
        String mode = this.mOptions.getProperty("TestMode");
        if (mode == null) {
            return false;
        }
        return mode.equalsIgnoreCase("Reference");
    }

    private boolean hasSaveTestResult() {
        if (this.mOptions.get("SaveResult") == null) {
            return false;
        }
        return (Boolean)this.mOptions.get("SaveResult");
    }

    private boolean hasTestMode() {
        String mode = this.mOptions.getProperty("TestMode");
        if (mode == null) {
            return false;
        }
        return mode.equalsIgnoreCase("Test");
    }

    private boolean hasTrace() {
        try {
            return (Boolean)this.mOptions.get("TestFrameTrace");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasVerificationMode() {
        String mode = this.mOptions.getProperty("TestMode");
        if (mode == null) {
            return false;
        }
        return mode.equalsIgnoreCase("Verification");
    }

    private void initTestDatabase() throws TestDatabaseException, IOException, FileNotFoundException, ClassNotFoundException {
        TestDriver.addState(" TestDriver->initTestDatabase()");
        boolean CreateDatabase = false;
        this.addTraceToProtocol("Initializing test database ...");
        this.addTraceToProtocol("db-kind: " + this.mOptions.getProperty("DBKind"));
        this.addTraceToProtocol("db-type: " + this.mOptions.getProperty("DBType"));
        this.addTraceToProtocol("db-host: " + this.mOptions.getProperty("DBHost"));
        this.addTraceToProtocol("db-name: " + this.mOptions.getProperty("DBName"));
        String db_type = this.mOptions.getProperty("DBType");
        if (db_type.equals("NONE")) {
            if (this.mOptions.getProperty("DBName") != null) {
                this.mTestDatabase = new TestDatabaseSap("NONE", this.mOptions.getProperty("DBName"));
                ((TestDatabaseSap)this.mTestDatabase).setPort(new Integer(this.mOptions.getProperty("db-port")));
            } else {
                this.mTestDatabase = new TestDatabaseSap("NONE", "NONE");
                ((TestDatabaseSap)this.mTestDatabase).setPort(new Integer(this.mOptions.getProperty("db-port")));
            }
        } else if (db_type.equals("SAP")) {
            this.mTestDatabase = new TestDatabaseSap(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBName"));
        } else if (db_type.equals("ORA")) {
            this.mTestDatabase = new TestDatabaseOracle(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBName"));
        } else if (db_type.equals("DB2")) {
            this.mTestDatabase = new TestDatabaseIBM(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBName"));
        } else if (db_type.equals("ITB")) {
            this.mTestDatabase = new TestDatabaseInterbase(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBName"));
        } else {
            throw new TestDatabaseException("Database type " + db_type + " not supported");
        }
        if (this.mOptions.getProperty("DBMUser") != null) {
            this.mTestDatabase.setDBMUser(this.mOptions.getProperty("DBMUser"));
        }
        if (this.mOptions.getProperty("DBMPwd") != null) {
            this.mTestDatabase.setDBMPassword(this.mOptions.getProperty("DBMPwd"));
        }
        if (this.mOptions.getProperty("DBAUser") != null) {
            this.mTestDatabase.setDBAUser(this.mOptions.getProperty("DBAUser"));
        }
        if (this.mOptions.getProperty("DBAPwd") != null) {
            this.mTestDatabase.setDBAPassword(this.mOptions.getProperty("DBAPwd"));
        }
        this.addTraceToProtocol("Define database user ...");
        this.addTraceToProtocol("dba-user: " + this.mTestDatabase.getDBAUser());
        this.addTraceToProtocol("dba-pwd:  " + this.mTestDatabase.getDBAPassword());
        this.addTraceToProtocol("dbm-user: " + this.mTestDatabase.getDBMUser());
        this.addTraceToProtocol("dbm-pwd:  " + this.mTestDatabase.getDBMPassword());
        if (this.mTestDatabase.isSap()) {
            TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
            sapdb.setPort(new Integer(this.mOptions.getProperty("db-port")));
            if (this.mTestDriverProtocol != null) {
                this.mTestDriverProtocol.setPort(new Integer(this.mOptions.getProperty("db-port")));
            }
            sapdb.setKernelMode(this.mOptions.getProperty("DBMode"));
            if (((Boolean)this.mOptions.get("DBShort")).booleanValue()) {
                sapdb.setIsShort((Boolean)this.mOptions.get("DBShort"));
            }
            if (((Boolean)this.mOptions.get("DBForce")).booleanValue()) {
                CreateDatabase = true;
            } else {
                this.printMessage("Checking database <" + this.mTestDatabase.getName() + "> for existence ...");
                if (!sapdb.exists()) {
                    if (!((Boolean)this.mOptions.get("DBGenerate")).booleanValue() && !((Boolean)this.mOptions.get("DBShort")).booleanValue()) {
                        throw new DatabaseNotExistentException("Database doesn't exist, and auto generation is disabled\nor maybe a wrong port; tried to use: " + this.mOptions.getProperty("db-port"), this.mOptions.getProperty("DBName"), this.mOptions.getProperty("DBHost"));
                    }
                    CreateDatabase = true;
                } else {
                    if (!sapdb.existsUser(this.mTestDatabase.getDBMUser(), this.mTestDatabase.getDBMPassword())) {
                        throw new UnknownUserException(null, this.mOptions.getProperty("DBName"), this.mTestDatabase.getDBMUser() + "," + this.mTestDatabase.getDBMPassword());
                    }
                    if (!sapdb.existsUser(this.mTestDatabase.getDBAUser(), this.mTestDatabase.getDBAPassword())) {
                        throw new UnknownUserException(null, this.mOptions.getProperty("DBName"), this.mTestDatabase.getDBAUser() + "," + this.mTestDatabase.getDBAPassword());
                    }
                }
            }
            if (this.mOptions.get("JDBC_Property") != null) {
                sapdb.setJdbcProperty((Properties)this.mOptions.get("JDBC_Property"));
            }
            this.addTraceToProtocol("set trace: " + this.mOptions.get("TestFrameTrace"));
            sapdb.setIsActionTraced((Boolean)this.mOptions.get("TestFrameTrace"));
            this.addTraceToProtocol("set protocol: " + this.mTestDriverProtocol);
            sapdb.setProtocol(this.mTestDriverProtocol);
            this.addTraceToProtocol("set Root: " + this.mOptions.getProperty("DBRoot"));
            sapdb.setRoot(this.mOptions.getProperty("DBRoot"));
            this.addTraceToProtocol("try to set host name");
            sapdb.setHostName(this.getHostName());
            if (CreateDatabase) {
                this.printMessage("Creating database <" + this.mTestDatabase.getName() + "> ...");
                this.addTraceToProtocol("set Kind: " + this.mOptions.getProperty("DBKind"));
                sapdb.setInstanceType(this.mOptions.getProperty("DBKind"));
                this.addTraceToProtocol("set OS user: " + this.mOptions.getProperty("OSUser"));
                sapdb.setOsUser(this.mOptions.getProperty("OSUser"));
                this.addTraceToProtocol("set OS pwd: " + this.mOptions.getProperty("OSPwd"));
                sapdb.setOsPassword(this.mOptions.getProperty("OSPwd"));
                this.addTraceToProtocol("set size: " + this.mOptions.getProperty("DBSize"));
                sapdb.setSize(this.mOptions.getProperty("DBSize"));
                this.addTraceToProtocol("keep SAP DB after tests finished: " + this.mOptions.get("DBKeep"));
                sapdb.setKeep((Boolean)this.mOptions.get("DBKeep"));
                if (sapdb.isKeep()) {
                    this.addTraceToProtocol("keep state of SAP DB after tests finished: " + this.mOptions.get("DBKeepState"));
                }
                if (this.mOptions.get("DBKeepState") != null) {
                    sapdb.setKeepState(this.mOptions.get("DBKeepState").toString());
                }
                this.addTraceToProtocol("drop SAP DB after tests finished: " + this.mOptions.get("DBDrop"));
                sapdb.setDrop((Boolean)this.mOptions.get("DBDrop"));
                if (!sapdb.isKeep() && !sapdb.isDrop()) {
                    this.addTraceToProtocol("drop SAP DB after tests finished if no error occurs");
                }
                this.addTraceToProtocol("force create SAPDB: " + this.mOptions.get("DBForce"));
                sapdb.setForceCreate((Boolean)this.mOptions.get("DBForce"));
                if (this.mConfiguration != null) {
                    this.addTraceToProtocol("set configuration and device list");
                    sapdb.setConfiguration(this.mConfiguration.getDBParameterMap());
                    sapdb.setDeviceList(this.mConfiguration.getDBDeviceList());
                }
                this.addTraceToProtocol("Creating SAP DB ...");
                sapdb.createInstance(this);
                this.printMessage("successful!");
            }
            if (this.mOptions.get("Restart").toString().compareToIgnoreCase("false") == 0) {
                sapdb.setDisableDatabaseRestart(true);
                this.addTraceToProtocol("disable the restart(s) of SAP DB ");
            }
            sapdb.setOLTPTraceEnabled((Boolean)this.mOptions.get("DBOltpTrace"));
            sapdb.setOMSTraceEnabled((Boolean)this.mOptions.get("DBOmsTrace"));
            if (this.mOptions.get("DBAdditionalTrace") != null) {
                sapdb.setAdditionalTrace(this.mOptions.get("DBAdditionalTrace").toString());
            }
            if (this.mOptions.get("Database_Command") != null) {
                sapdb.setDatabaseCommands((Vector)this.mOptions.get("Database_Command"));
            }
            if (this.mOptions.get("DBMsrv_Command") != null) {
                sapdb.setDbmServerCommands((Vector)this.mOptions.get("DBMsrv_Command"));
            }
            if (((Boolean)this.mOptions.get("DBJdbcTrace")).booleanValue()) {
                sapdb.enableJDBCTrace();
            }
            this.addTraceToProtocol("keep SAP DB after tests finished: " + this.mOptions.get("DBKeep"));
            sapdb.setKeep((Boolean)this.mOptions.get("DBKeep"));
            if (sapdb.isKeep()) {
                this.addTraceToProtocol("keep state of SAP DB after tests finished: " + this.mOptions.get("DBKeepState"));
                sapdb.setKeepState(this.mOptions.get("DBKeepState").toString());
            }
            this.addTraceToProtocol("drop SAP DB after tests finished: " + this.mOptions.get("DBDrop"));
            sapdb.setDrop((Boolean)this.mOptions.get("DBDrop"));
            this.addTraceToProtocol("force create SAPDB: " + this.mOptions.get("DBForce"));
            sapdb.setForceCreate((Boolean)this.mOptions.get("DBForce"));
            this.printMessage("Starting database <" + this.mTestDatabase.getName() + "> " + (this.mOptions.getProperty("DBMode") == null ? "FAST" : this.mOptions.getProperty("DBMode")) + " ...");
            if (sapdb.start()) {
                this.printMessage("successful!");
                try {
                    this.addTraceToProtocol("set rundir");
                    sapdb.setRunDir();
                    this.addTraceToProtocol("set kernel version");
                    sapdb.setKernelVersion();
                    this.addTraceToProtocol("set kernel build");
                    sapdb.setKernelBuild();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.addTraceToProtocol("db-kernel-version: " + sapdb.getKernelVersion());
                this.addTraceToProtocol("db-kernel-build:   " + sapdb.getKernelBuild());
                this.addTraceToProtocol("db-kernel-mode:    " + sapdb.getKernelMode());
                this.addTraceToProtocol("db-rundir:         " + sapdb.getRunDir());
                this.addTraceToProtocol("db-op-system:      " + TestDriver.getOpSystem());
                this.addTraceToProtocol("db-host-name:      " + this.getHostName());
                this.mTestDriverProtocol.addItem('I', "SAP DB kernel started in mode " + sapdb.getKernelMode().toUpperCase());
            }
        }
        if (!((Boolean)this.mOptions.get("DBNone")).booleanValue()) {
            this.printMessage("Testing database connection ...");
            this.mTestDatabase.testConnection();
            this.printMessage("successful!");
        }
    }

    public final boolean isRemoteTest() {
        return !((String)this.mOptions.get("DBHost")).equalsIgnoreCase("localhost") && !((String)this.mOptions.get("DBHost")).equalsIgnoreCase(this.getHostName());
    }

    private void buildWebDavURL() {
        mWEBDavIsEnabled = true;
        Boolean oNoWebdav = (Boolean)this.mOptions.get("NoWebdav");
        if (oNoWebdav != null && oNoWebdav.booleanValue()) {
            mWEBDavIsEnabled = false;
        }
        if (mWEBDavIsEnabled) {
            String ts = new SimpleDateFormat("yyyyMMddHH-mm-ss").format(mStartDate);
            mWEBDavDir = this.getHostName() + "/" + ts.substring(0, 4) + "/" + ts.substring(4, 6) + "/" + ts.substring(6, 8) + "/" + ts.substring(8) + "/";
            try {
                String webdavHost = this.mOptions.get("SaveWebdav-host").toString();
                if (webdavHost.equals("")) {
                    System.err.println("No hostname configured for WebDAV upload (XML element: webdav-host).");
                    mWEBDavDir = null;
                    mWEBDavBaseURL = null;
                    return;
                }
                mWEBDavBaseURL = new URL("http://" + webdavHost + "/webdav/tests/");
            }
            catch (MalformedURLException e) {
                System.err.println("Malformed URL for the WebDAV host: " + mWEBDavBaseURL.toString());
                mWEBDavDir = null;
                mWEBDavBaseURL = null;
            }
        } else {
            mWEBDavDir = null;
            mWEBDavBaseURL = null;
        }
    }

    private void initTestDriverProtocol() throws IOException {
        TestDriver.addState(" TestDriver->initTestDriverProtocol()");
        this.mTestDriverProtocol = this.mHasOutputFile ? new TestDriverProtocol(this.mOptions.getProperty("DBType"), this.mOptions.getProperty("DBName"), this.getHostName(), this.mOptions.getProperty("ProtocolOutputPath"), this.mOptions.getProperty("ProtocolOutputFile")) : new TestDriverProtocol(this.mOptions.getProperty("DBType"), this.mOptions.getProperty("DBName"), this.getHostName());
        this.mTestDriverProtocol.setInfoMessageFilter(false);
        this.mTestDriverProtocol.setRemote(this.isRemoteTest());
        if (this.mOptions.get("DBRoot") != null) {
            this.mTestDriverProtocol.setDbRoot(this.mOptions.get("DBRoot").toString());
        }
        this.mTestDriverProtocol.flushAsyncWriters();
        if (this.mOptions.get("DBType") != null && this.mOptions.getProperty("DBType").equals("NONE")) {
            this.mTestDriverProtocol.addItem('I', "The 'no database' option was set.");
        }
    }

    private void initTestProtocol() throws IOException {
        TestDriver.addState(" TestDriver->initTestProtocol()");
        this.mTestProtocol = this.mHasOutputFile ? new TestProtocol(this.mOptions.getProperty("DBName"), this.getHostName(), this.mOptions.getProperty("DBType"), this.mOptions.getProperty("ProtocolOutputPath"), this.mOptions.getProperty("ProtocolOutputFile"), "prt", this.mTestDriverProtocol.getSaveFileVersion()) : new TestProtocol(this.mOptions.getProperty("DBName"), this.getHostName(), this.mOptions.getProperty("DBType"));
        if (this.mOptions.get("ProtocolInfoFilter") != null) {
            this.mTestProtocol.setInfoMessageFilter((Boolean)this.mOptions.get("ProtocolInfoFilter"));
        }
        this.mTestProtocol.setRemote(this.isRemoteTest());
        if (this.mOptions.get("DBRoot") != null) {
            this.mTestProtocol.setDbRoot(this.mOptions.get("DBRoot").toString());
        }
        this.mTestProtocol.flushAsyncWriters();
    }

    private void initTestResultDatabase() throws TestDatabaseException {
        String rdbname;
        String rdbhost;
        if (!this.hasSaveTestResult()) {
            return;
        }
        TestDriver.addState(" TestDriver->initTestResultDatabase()");
        String rdbuser = null;
        String rdbpwd = null;
        boolean centralRefDb = false;
        if (this.mOptions.getProperty("ResultDBName") == null) {
            rdbhost = "P30882";
            rdbname = "T01";
            centralRefDb = true;
        } else {
            rdbhost = this.mOptions.getProperty("ResultDBHost");
            if (rdbhost == null) {
                rdbhost = "localhost";
            }
            rdbname = this.mOptions.getProperty("ResultDBName");
        }
        rdbuser = this.hasReferenceMode() || this.hasVerificationMode() ? "TESTALL" : "TEST";
        rdbpwd = centralRefDb ? this.mOptions.getProperty("ResultDBPwd") : "TEST";
        if (this.hasReferenceMode() || this.hasVerificationMode() || this.hasSaveTestResult()) {
            this.addTraceToProtocol("Initializing test result database ...");
            this.addTraceToProtocol("res-db-name: " + rdbname);
            this.addTraceToProtocol("res-db-host: " + rdbhost);
            this.addTraceToProtocol("res-db-user: " + rdbuser);
            this.addTraceToProtocol("res-db-pwd:  " + rdbpwd);
            this.mTestResultDatabase = new TestResultDatabase(rdbhost, rdbname, rdbuser, rdbpwd);
            this.mTestResultDatabase.testConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        TestDriver drv;
        block72: {
            drv = new TestDriver();
            mStartDate = new Date();
            Exception AbortException = null;
            drv.printMessage("Starting TestDriver 7.0.2 on " + mDateFormat.format(mStartDate));
            mLastMessages.add("Starting TestDriver 7.0.2 on " + mDateFormat.format(mStartDate));
            TestStatistic.setStartTime(mStartDate);
            drv.printMessage("Parsing command line");
            String[] tests = new String[args.length];
            drv.mOptions = TestDriver.parseOptions(args, tests);
            drv.checkOptions();
            drv.setTestSetName(tests[0]);
            try {
                if (drv.mOptions.getProperty("TEST_DRIVER_CONFIGURATION") != null) {
                    drv.printMessage("Searching config file ... " + drv.mOptions.getProperty("TEST_DRIVER_CONFIGURATION"));
                    drv.mConfiguration = TestDriver.readConfigurationFile(drv.mOptions.getProperty("TEST_DRIVER_CONFIGURATION"));
                } else {
                    drv.printMessage("Searching config file ... no explicit configuration file");
                    drv.mConfiguration = TestDriver.readConfigurationFile(drv.mOptions.getProperty("TEST_DRIVER_CONFIGURATION"));
                }
            }
            catch (IOException e) {
                drv.printMessage("Config file not found");
                drv.printMessage("Exception: " + e.getLocalizedMessage());
                drv.mConfiguration = null;
            }
            catch (SAXException e) {
                drv.printMessage(e.getMessage());
                System.exit(-1);
            }
            drv.mOptions = drv.completeOptions();
            drv.printOptions();
            drv.verifyOptions();
            try {
                drv.buildWebDavURL();
                drv.initTestDriverProtocol();
                StringBuffer sb = new StringBuffer();
                sb.append("TestDriver arguments: \n");
                for (int i = 0; i < args.length; ++i) {
                    sb.append(" " + args[i]);
                }
                if (!drv.hasTrace()) {
                    drv.mTestDriverProtocol.addItem('I', "For detailed information use the option -T in the call of jtrun.pl or \nactivate <test-frame-trace/> in the <misc> region in the cfg-file.");
                }
                drv.mTestDriverProtocol.addItem('I', sb.toString());
                if (drv.hasTrace()) {
                    drv.mTestDriverProtocol.addItem('T', TestDriver.buildClassPathForTrace());
                }
                drv.mTestDriverProtocol.setTestDriverVersion(sVersion);
            }
            catch (IOException e) {
                System.err.println("jtest--> Cannot create test driver protocol.");
                drv.printException(e);
                System.exit(-1);
            }
            drv.mTestSet = TestDriver.parseTests(tests, drv.mOptions, drv.mTestDriverProtocol);
            TestStatistic.setTestsPlanned(drv.mTestSet.size());
            drv.initTestMonitor();
            drv.initTestDatabase();
            drv.setTestMonitorDBValues();
            drv.initTestProtocol();
            drv.addDbInfoToProtocol(drv.mTestDatabase, drv.mTestDriverProtocol);
            drv.addDbInfoToProtocol(drv.mTestDatabase, drv.mTestProtocol);
            drv.enableAsyncProtocolWriter();
            drv.enableExceptionTracebackInProtocol();
            drv.initTestResultDatabase();
            drv.attachToDatabase();
            drv.runTest();
            if (m_killed) {
                m_hasRespondedToKill = true;
            }
            drv.addRefKeyToProtocol(drv.mTestDriverProtocol);
            Object var7_17 = null;
            try {
                drv.setTestMonitorStatus("Driver: Write protocol");
                drv.writeProtocol();
            }
            catch (IOException e2) {
                drv.printException(e2);
            }
            drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
            drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
            drv.runFinalizersOnDatabase();
            drv.setTestMonitorStatus("Driver: Finish protocol");
            if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
            } else {
                drv.printMessage("TestDriver protocol not generated");
            }
            if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
            } else {
                drv.printMessage("Test protocol not generated");
            }
            drv.printSummary();
            drv.printMessage("TestDriver finished!");
            drv.finalizeTestProtocol();
            {
                break block72;
                catch (DatabaseNotExistentException e) {
                    AbortException = e;
                    drv.printException(e);
                    if (drv.mTestDatabase != null && drv.mTestDatabase.isSap()) {
                        TestDatabaseSap sapdb;
                        if (drv.mTestMonitorUpdater != null && drv.mTestMonitorUpdater.dbVersion == null) {
                            drv.setTestMonitorDBValues();
                        }
                        if ((sapdb = (TestDatabaseSap)drv.mTestDatabase).isKernelBinaryMissing()) {
                            drv.setTestMonitorDriverEndStatus("NO KERNEL.");
                        } else {
                            drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                        }
                    } else {
                        drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                    }
                    Object var7_18 = null;
                    try {
                        drv.setTestMonitorStatus("Driver: Write protocol");
                        drv.writeProtocol();
                    }
                    catch (IOException e2) {
                        drv.printException(e2);
                    }
                    drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
                    drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
                    drv.runFinalizersOnDatabase();
                    drv.setTestMonitorStatus("Driver: Finish protocol");
                    if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                        drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
                    } else {
                        drv.printMessage("TestDriver protocol not generated");
                    }
                    if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                        drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
                    } else {
                        drv.printMessage("Test protocol not generated");
                    }
                    drv.printSummary();
                    drv.printMessage("TestDriver finished!");
                    drv.finalizeTestProtocol();
                    break block72;
                }
                catch (UnknownUserException e) {
                    AbortException = e;
                    drv.printException(e);
                    if (drv.mTestDatabase != null && drv.mTestDatabase.isSap()) {
                        TestDatabaseSap sapdb;
                        if (drv.mTestMonitorUpdater != null && drv.mTestMonitorUpdater.dbVersion == null) {
                            drv.setTestMonitorDBValues();
                        }
                        if ((sapdb = (TestDatabaseSap)drv.mTestDatabase).isKernelBinaryMissing()) {
                            drv.setTestMonitorDriverEndStatus("NO KERNEL.");
                        } else {
                            drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                        }
                    } else {
                        drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                    }
                    Object var7_19 = null;
                    try {
                        drv.setTestMonitorStatus("Driver: Write protocol");
                        drv.writeProtocol();
                    }
                    catch (IOException e2) {
                        drv.printException(e2);
                    }
                    drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
                    drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
                    drv.runFinalizersOnDatabase();
                    drv.setTestMonitorStatus("Driver: Finish protocol");
                    if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                        drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
                    } else {
                        drv.printMessage("TestDriver protocol not generated");
                    }
                    if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                        drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
                    } else {
                        drv.printMessage("Test protocol not generated");
                    }
                    drv.printSummary();
                    drv.printMessage("TestDriver finished!");
                    drv.finalizeTestProtocol();
                    break block72;
                }
                catch (TestDatabaseException e) {
                    AbortException = e;
                    drv.printException(e);
                    if (drv.mTestDatabase != null && drv.mTestDatabase.isSap()) {
                        TestDatabaseSap sapdb;
                        if (drv.mTestMonitorUpdater != null && drv.mTestMonitorUpdater.dbVersion == null) {
                            drv.setTestMonitorDBValues();
                        }
                        if ((sapdb = (TestDatabaseSap)drv.mTestDatabase).isKernelBinaryMissing()) {
                            drv.setTestMonitorDriverEndStatus("NO KERNEL.");
                        } else {
                            drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                        }
                    } else {
                        drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                    }
                    Object var7_20 = null;
                    try {
                        drv.setTestMonitorStatus("Driver: Write protocol");
                        drv.writeProtocol();
                    }
                    catch (IOException e2) {
                        drv.printException(e2);
                    }
                    drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
                    drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
                    drv.runFinalizersOnDatabase();
                    drv.setTestMonitorStatus("Driver: Finish protocol");
                    if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                        drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
                    } else {
                        drv.printMessage("TestDriver protocol not generated");
                    }
                    if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                        drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
                    } else {
                        drv.printMessage("Test protocol not generated");
                    }
                    drv.printSummary();
                    drv.printMessage("TestDriver finished!");
                    drv.finalizeTestProtocol();
                    break block72;
                }
                catch (Exception e) {
                    AbortException = e;
                    drv.printException(e);
                    if (drv.mTestDatabase != null && drv.mTestDatabase.isSap()) {
                        TestDatabaseSap sapdb;
                        if (drv.mTestMonitorUpdater != null && drv.mTestMonitorUpdater.dbVersion == null) {
                            drv.setTestMonitorDBValues();
                        }
                        if ((sapdb = (TestDatabaseSap)drv.mTestDatabase).isKernelBinaryMissing()) {
                            drv.setTestMonitorDriverEndStatus("NO KERNEL.");
                        } else {
                            drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                        }
                    } else {
                        drv.setTestMonitorDriverEndStatus("CRASHED while running tests");
                    }
                    Object var7_21 = null;
                    try {
                        drv.setTestMonitorStatus("Driver: Write protocol");
                        drv.writeProtocol();
                    }
                    catch (IOException e2) {
                        drv.printException(e2);
                    }
                    drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
                    drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
                    drv.runFinalizersOnDatabase();
                    drv.setTestMonitorStatus("Driver: Finish protocol");
                    if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                        drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
                    } else {
                        drv.printMessage("TestDriver protocol not generated");
                    }
                    if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                        drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
                    } else {
                        drv.printMessage("Test protocol not generated");
                    }
                    drv.printSummary();
                    drv.printMessage("TestDriver finished!");
                    drv.finalizeTestProtocol();
                }
            }
            catch (Throwable throwable) {
                Object var7_22 = null;
                try {
                    drv.setTestMonitorStatus("Driver: Write protocol");
                    drv.writeProtocol();
                }
                catch (IOException e2) {
                    drv.printException(e2);
                }
                drv.setTestMonitorTotalErrors(TestStatistic.getTotalErrors());
                drv.sendMessage(drv.mOptions.getProperty("Responsible"), AbortException);
                drv.runFinalizersOnDatabase();
                drv.setTestMonitorStatus("Driver: Finish protocol");
                if (drv.mTestDriverProtocol != null && drv.mTestDriverProtocol.getProtocolWasSaved()) {
                    drv.printMessage("TestDriver protocol: " + drv.mTestDriverProtocol.getSaveFile());
                } else {
                    drv.printMessage("TestDriver protocol not generated");
                }
                if (drv.mTestProtocol != null && drv.mTestProtocol.getProtocolWasSaved()) {
                    drv.printMessage("Test protocol: " + drv.mTestProtocol.getSaveFile());
                } else {
                    drv.printMessage("Test protocol not generated");
                }
                drv.printSummary();
                drv.printMessage("TestDriver finished!");
                drv.finalizeTestProtocol();
                throw throwable;
            }
        }
        drv.setTestMonitorStatus("Driver: Finish TestMonitor");
        if (!m_killed) {
            drv.setTestMonitorDriverEndStatus("OK");
        } else {
            drv.setTestMonitorDriverEndStatus("KILLED (soft)");
        }
        drv.finishTestMonitor();
        TestDriver.addState("System.exit(" + TestStatistic.getTotalErrors() + ");");
        System.exit(TestStatistic.getTotalErrors());
    }

    private void killTestDriver() {
        TestDriver.addState(" TestDriver->killTestDriver()");
        this.setTestMonitorStatus("Driver: Write protocol.");
        Killer TestDriverKiller = new Killer(30000L);
        try {
            this.writeProtocol();
        }
        catch (IOException ex) {
            this.printException(ex);
        }
        this.sendMessage(this.mOptions.getProperty("Responsible"), (Exception)null);
        this.runFinalizersOnDatabase();
        this.setTestMonitorDriverEndStatus("KILLED (hard)");
        this.finishTestMonitor();
        if (this.mTestDriverProtocol != null && this.mTestDriverProtocol.getProtocolWasSaved()) {
            this.printMessage("TestDriver protocol: " + this.mTestDriverProtocol.getSaveFile());
        } else {
            this.printMessage("TestDriver protocol not generated");
        }
        if (this.mTestProtocol != null && this.mTestProtocol.getProtocolWasSaved()) {
            this.printMessage("Test protocol: " + this.mTestProtocol.getSaveFile());
        } else {
            this.printMessage("Test protocol not generated");
        }
        this.printSummary();
        this.printMessage("TestDriver killed");
        this.finalizeTestProtocol();
        TestDriverKiller.pleaseStop();
        System.exit(-100);
    }

    public void finalizeTestProtocol() {
        if (this.mTestProtocol != null) {
            this.mTestProtocol.finalize();
        }
    }

    private static boolean parseDbGenerateOptions(Properties pProperties, String pArg) {
        boolean isEqual = false;
        if (pArg.equalsIgnoreCase("NONE")) {
            pProperties.put("DBNone", Boolean.TRUE);
            pProperties.put("DBForce", Boolean.FALSE);
            pProperties.put("DBShort", Boolean.FALSE);
            pProperties.put("DBKeep", Boolean.FALSE);
            pProperties.put("DBGenerate", Boolean.FALSE);
            pProperties.put("DBKind", "NONE");
            pProperties.put("DBType", "NONE");
            isEqual = true;
        } else if (pArg.startsWith("NONE(")) {
            String mySubString = pArg.substring(pArg.indexOf("(") + 1, pArg.indexOf(")"));
            pProperties.put("DBNone", Boolean.TRUE);
            pProperties.put("DBForce", Boolean.FALSE);
            pProperties.put("DBShort", Boolean.FALSE);
            pProperties.put("DBKeep", Boolean.FALSE);
            pProperties.put("DBGenerate", Boolean.FALSE);
            pProperties.put("DBKind", "NONE");
            pProperties.put("DBType", "NONE");
            pProperties.put("ExplicitVersion", mySubString);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("FORCE")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBForce", Boolean.TRUE);
            pProperties.put("DBShort", Boolean.FALSE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("KEEP")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBKeep", Boolean.TRUE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("DROP")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBDrop", Boolean.TRUE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("OFF")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBForce", Boolean.FALSE);
            pProperties.put("DBGenerate", Boolean.FALSE);
            pProperties.put("DBShort", Boolean.FALSE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("ATTACH")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBAttach", Boolean.TRUE);
            pProperties.put("Restart", Boolean.FALSE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("SHORT")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBShort", Boolean.TRUE);
            pProperties.put("Restart", Boolean.FALSE);
            pProperties.put("DBForce", Boolean.FALSE);
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("OFFLINE") || pArg.equalsIgnoreCase("COLD") || pArg.equalsIgnoreCase("ADMIN") || pArg.equalsIgnoreCase("WARM") || pArg.equalsIgnoreCase("ONLINE")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBKeep", Boolean.TRUE);
            pProperties.put("DBDrop", Boolean.FALSE);
            pProperties.put("DBKeepState", pArg.toUpperCase());
            isEqual = true;
        } else if (pArg.equalsIgnoreCase("DOS") || pArg.equalsIgnoreCase("DROP_ON_SUCCESS")) {
            pProperties.put("DBNone", Boolean.FALSE);
            pProperties.put("DBKeep", Boolean.FALSE);
            pProperties.put("DBDrop", Boolean.FALSE);
            isEqual = true;
        }
        return isEqual;
    }

    private static Properties parseFile(String pName) {
        Properties parseFile = new Properties();
        File file = new File(pName);
        if (file.isDirectory()) {
            parseFile.put("PATH", pName);
        } else {
            if (file.getParent() != null) {
                parseFile.put("PATH", file.getParent());
            }
            if (file.getName() != null) {
                parseFile.put("FILE", file.getName());
                int pos = file.getName().indexOf(46);
                if (pos != -1) {
                    parseFile.put("NAME", file.getName().substring(0, pos));
                    parseFile.put("EXT", file.getName().substring(pos + 1));
                }
            }
        }
        return parseFile;
    }

    private static Properties parseOptions(String[] args, String[] tests) {
        String currentArg;
        TestDriver.addState(" TestDriver->parseOptions(..)");
        Properties parseOptions = new Properties();
        int i = 0;
        int j = 0;
        block35: for (i = 0; i < args.length && (currentArg = args[i]).charAt(0) == '-'; ++i) {
            char currentOpt = currentArg.charAt(1);
            switch (currentOpt) {
                case 'b': {
                    if (!currentArg.equals("-bits")) continue block35;
                    try {
                        parseOptions.put("DBBits", new Integer(args[++i]));
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("expected number of bits (e.g. 32) after -bits, got <" + args[i] + ">");
                    }
                    continue block35;
                }
                case 'h': {
                    TestDriver.usageOptions(false);
                    continue block35;
                }
                case 'c': {
                    parseOptions.put("TEST_DRIVER_CONFIGURATION", args[++i]);
                    continue block35;
                }
                case 'n': {
                    if (currentArg.equals("-n")) {
                        parseOptions.put("DBHost", args[++i]);
                        continue block35;
                    }
                    if (currentArg.equals("-nomonitor")) {
                        parseOptions.put("NoMonitor", Boolean.TRUE);
                        continue block35;
                    }
                    if (currentArg.equals("-nowebdav")) {
                        parseOptions.put("NoWebdav", Boolean.TRUE);
                        continue block35;
                    }
                    if (currentArg.equals("-noknldiag")) {
                        parseOptions.put("NoKnldiag", Boolean.TRUE);
                        continue block35;
                    }
                    if (!currentArg.equals("-novtrace")) continue block35;
                    parseOptions.put("NoVtrace", Boolean.TRUE);
                    continue block35;
                }
                case 'd': {
                    parseOptions.put("DBName", args[++i].toUpperCase());
                    continue block35;
                }
                case 'u': {
                    currentArg = args[++i];
                    try {
                        if (args[i - 1].length() == 3) {
                            parseOptions.put("DBMUser", currentArg.substring(0, currentArg.indexOf(44)));
                            parseOptions.put("DBMPwd", currentArg.substring(currentArg.indexOf(44) + 1));
                            continue block35;
                        }
                        parseOptions.put("DBAUser", currentArg.substring(0, currentArg.indexOf(44)));
                        parseOptions.put("DBAPwd", currentArg.substring(currentArg.indexOf(44) + 1));
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Option -u user,password: Missing comma");
                        TestDriver.usageOptions(true);
                    }
                    continue block35;
                }
                case 't': {
                    parseOptions.put("DBType", args[++i]);
                    continue block35;
                }
                case 'k': {
                    if (currentArg.equals("-k")) {
                        parseOptions.put("DBMode", args[++i].toUpperCase());
                        continue block35;
                    }
                    if (!currentArg.equals("-knldump")) continue block35;
                    parseOptions.put("knldump", Boolean.TRUE);
                    continue block35;
                }
                case 'o': {
                    if (currentArg.length() == 3 && currentArg.charAt(2) == 's') {
                        parseOptions.put("ProtocolOutput", "ProtocolConsole");
                        continue block35;
                    }
                    parseOptions.put("ProtocolOutput", args[++i]);
                    continue block35;
                }
                case 'p': {
                    if (currentArg.equalsIgnoreCase("-port")) {
                        parseOptions.put("db-port", args[++i]);
                        continue block35;
                    }
                    if (currentArg.equalsIgnoreCase("-pf")) {
                        parseOptions.put("SingleParameterFile", args[++i]);
                        continue block35;
                    }
                    parseOptions.put("ParameterInputDir", args[++i]);
                    continue block35;
                }
                case 'r': {
                    if (!currentArg.equals("-restart")) continue block35;
                    parseOptions.put("Restart", args[++i]);
                    continue block35;
                }
                case 's': {
                    if (currentArg.equals("-scheduled")) {
                        parseOptions.put("ScheduledTest", Boolean.TRUE);
                        continue block35;
                    }
                    if (currentArg.equals("-sr")) {
                        parseOptions.put("Save-Result", Boolean.TRUE);
                        TestStatistic.setNightTest(true);
                        continue block35;
                    }
                    if (currentArg.equals("-snode")) {
                        parseOptions.put("DBSecondHost", args[++i]);
                        continue block35;
                    }
                    if (currentArg.equals("-sroot")) {
                        parseOptions.put("DBSecondRoot", args[++i]);
                        continue block35;
                    }
                    if (currentArg.equals("-sport")) {
                        parseOptions.put("DBSecondPort", args[++i]);
                        continue block35;
                    }
                    parseOptions.put("SaveResult", Boolean.TRUE);
                    continue block35;
                }
                case 'l': {
                    currentArg = args[++i];
                    int indx = currentArg.indexOf(44);
                    if (indx == -1) {
                        parseOptions.put("ResultDBName", currentArg);
                        continue block35;
                    }
                    parseOptions.put("ResultDBName", currentArg.substring(0, indx));
                    parseOptions.put("ResultDBHost", currentArg.substring(indx + 1));
                    continue block35;
                }
                case 'g': {
                    parseOptions.put("ResultDBPwd", args[++i]);
                    continue block35;
                }
                case 'm': {
                    int len;
                    if (currentArg.equals("-monitor")) {
                        parseOptions.put("Monitor", Boolean.TRUE);
                        continue block35;
                    }
                    if (currentArg.equals("-mailindividual")) {
                        parseOptions.put("MailIndividual", Boolean.TRUE);
                        continue block35;
                    }
                    if (currentArg.length() == 5 && currentArg.charAt(2) == 'a') {
                        if (args[i + 1].equalsIgnoreCase("OFF")) {
                            parseOptions.put("Responsible", "OFF");
                            ++i;
                            continue block35;
                        }
                        parseOptions.put("Responsible", args[++i]);
                        continue block35;
                    }
                    if ((len = (currentArg = args[++i]).length()) <= 2) continue block35;
                    String mode = currentArg.substring(0, 3);
                    if (mode.equalsIgnoreCase("Reference".substring(0, 3))) {
                        parseOptions.put("TestMode", "Reference");
                        continue block35;
                    }
                    if (mode.equalsIgnoreCase("Verification".substring(0, 3))) {
                        parseOptions.put("TestMode", "Verification");
                        parseOptions.put("TestLabel", currentArg.substring(3, len));
                        continue block35;
                    }
                    parseOptions.put("TestMode", "Test");
                    continue block35;
                }
                case 'G': {
                    parseOptions.put("DBGenerate", Boolean.TRUE);
                    String nextArg = args[i + 1];
                    int index = nextArg.indexOf(44);
                    if (index == -1) {
                        if (!TestDriver.parseDbGenerateOptions(parseOptions, nextArg)) continue block35;
                        ++i;
                        continue block35;
                    }
                    StringTokenizer st = new StringTokenizer(nextArg, ",");
                    boolean match = false;
                    while (st.hasMoreTokens()) {
                        if (!TestDriver.parseDbGenerateOptions(parseOptions, st.nextToken())) continue;
                        match = true;
                    }
                    if (!match) continue block35;
                    ++i;
                    continue block35;
                }
                case 'I': {
                    if (currentArg.equals("-INSTKEY")) {
                        currentArg = args[++i];
                        parseOptions.put("InstKey", currentArg);
                        continue block35;
                    }
                    parseOptions.put("DBKind", args[++i]);
                    continue block35;
                }
                case 'R': {
                    parseOptions.put("DBRoot", args[++i]);
                    continue block35;
                }
                case 'O': {
                    currentArg = args[++i];
                    try {
                        parseOptions.put("OSUser", currentArg.substring(0, currentArg.indexOf(44)));
                        parseOptions.put("OSPwd", currentArg.substring(currentArg.indexOf(44) + 1));
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Option -O user,password: Missing comma");
                        TestDriver.usageOptions(true);
                    }
                    continue block35;
                }
                case 'S': {
                    parseOptions.put("DBSize", args[++i]);
                    continue block35;
                }
                case 'P': {
                    parseOptions.put("ParallelRate", args[++i]);
                    continue block35;
                }
                case 'T': {
                    parseOptions.put("TestFrameTrace", Boolean.TRUE);
                    continue block35;
                }
                case 'Q': {
                    if (!currentArg.equals("-QA")) continue block35;
                    if ((currentArg = args[++i].toUpperCase()).length() > 1) {
                        System.out.println("Built substring of " + currentArg + " -> " + currentArg.substring(0, 1) + " for option -QA");
                        currentArg = currentArg.substring(0, 1);
                    }
                    if (currentArg.equalsIgnoreCase("R") || currentArg.equalsIgnoreCase("C") || currentArg.equalsIgnoreCase("D") || currentArg.equalsIgnoreCase("H")) {
                        parseOptions.put("QALevel", currentArg);
                        continue block35;
                    }
                    System.out.println("Wrong value for option -QA: '" + currentArg + "'. Set to default 'N' !");
                    parseOptions.put("QALevel", "N");
                    continue block35;
                }
                case 'L': {
                    if (!currentArg.equals("-LCP")) continue block35;
                    if ((currentArg = args[++i]).length() > 4) {
                        System.out.println("Built substring of " + currentArg + " -> " + currentArg.substring(0, 4) + " for option -LCP");
                        currentArg = currentArg.substring(0, 4);
                    }
                    parseOptions.put("LCPoolNumber", currentArg);
                    continue block35;
                }
                case 'C': {
                    if (!currentArg.equals("-CL")) continue block35;
                    if ((currentArg = args[++i]).length() > 6) {
                        System.out.println("Built substring of " + currentArg + " -> " + currentArg.substring(0, 6) + " for option -CL");
                        currentArg = currentArg.substring(0, 6);
                    }
                    parseOptions.put("ChangeListNumber", currentArg);
                    continue block35;
                }
                case 'M': {
                    if (currentArg.equals("-MAKEKEY")) {
                        currentArg = args[++i];
                        parseOptions.put("MakeKey", currentArg);
                    }
                    if (!currentArg.equals("-MAKEKEY2")) continue block35;
                    currentArg = args[++i];
                    parseOptions.put("MakeKey2", currentArg);
                    continue block35;
                }
                case 'z': {
                    if (currentArg.equals("-za")) {
                        currentArg = args[++i];
                        parseOptions.put("ZipAttachment", currentArg);
                    }
                    if (!currentArg.equals("-zipattachment")) continue block35;
                    currentArg = args[++i];
                    parseOptions.put("ZipAttachment", currentArg);
                    continue block35;
                }
                default: {
                    System.err.println("Invalid option " + currentOpt);
                    TestDriver.usageOptions(true);
                }
            }
        }
        while (i < args.length) {
            tests[j++] = args[i++];
        }
        return parseOptions;
    }

    private static TestSequence parseTests(String[] args, Properties pOptions, TestDriverProtocol pProtocol) throws FileNotFoundException, IOException, TestNotFoundException {
        TestDriver.addState(" TestDriver->parseTests(..)");
        String TestParameterPath = pOptions.getProperty("ParameterInputDir");
        TestSequence TestSet = new TestSequence(TestParameterPath);
        String currArg = null;
        for (int i = 0; i < args.length && args[i] != null; ++i) {
            currArg = args[i];
            try {
                if (currArg.indexOf(".jar") != -1) {
                    TestSet.addArchive(currArg.trim());
                    continue;
                }
                if (currArg.indexOf(".seq") != -1) {
                    TestSet.addSequence(currArg.trim());
                    continue;
                }
                if (pOptions.getProperty("SingleParameterFile").length() != 0) {
                    TestSet.addTest(currArg.trim(), null, null, pOptions.getProperty("SingleParameterFile"));
                    continue;
                }
                TestSet.addTest(currArg.trim(), null);
                continue;
            }
            catch (Exception e) {
                pProtocol.addItem('E', e.getMessage());
            }
        }
        if (TestSet.isEmpty()) {
            throw new TestNotFoundException("There are no tests declared");
        }
        return TestSet;
    }

    public void printException(DatabaseNotExistentException pException) {
        if (pException == null) {
            return;
        }
        TestDriver.addState(" TestDriver->printException(" + pException.getClass() + ")");
        System.err.println("jtest--> **********************************************************************");
        System.err.println("jtest--> ERROR: Database <" + pException.getName() + "> on host <" + pException.getHost() + "> not found");
        System.err.println("jtest-->        " + pException.getMessage().substring(0, pException.getMessage().indexOf("\n")));
        System.err.println("jtest-->        " + pException.getMessage().substring(pException.getMessage().indexOf("\n") + 1));
        System.err.println("jtest--> **********************************************************************");
        this.mTestDriverProtocol.addItem('E', pException.getMessage());
        if (this.hasTrace()) {
            pException.printStackTrace();
        }
    }

    public void printException(UnknownUserException pException) {
        if (pException == null) {
            return;
        }
        TestDriver.addState(" TestDriver->printException(" + pException.getClass() + ")");
        System.err.println("jtest--> **********************************************************************");
        System.err.println("jtest--> ERROR: User <" + pException.getUser() + "> cannot connect to database <" + pException.getName() + ">");
        System.err.println("jtest--> Check if:");
        System.err.println("jtest-->  - the user exists");
        System.err.println("jtest-->  - <" + pException.getUser() + "> is the DBM (colduser)");
        System.err.println("jtest--> **********************************************************************");
        this.mTestDriverProtocol.addItem('E', pException.getMessage());
        if (this.hasTrace()) {
            pException.printStackTrace();
        }
    }

    public void printException(Exception pException) {
        if (pException == null) {
            return;
        }
        TestDriver.addState(" TestDriver->printException(" + pException.getClass() + ")");
        System.err.println("jtest--> **********************************************************************");
        System.err.println("jtest--> ERROR class   : " + pException.getClass());
        System.err.println("jtest--> ERROR message : " + pException.getMessage());
        StringWriter sw = new StringWriter();
        pException.printStackTrace(new PrintWriter(sw));
        if (pException.getLocalizedMessage() != null && pException.getLocalizedMessage().indexOf("INFO_STATE") != -1) {
            System.err.println("\nPerhaps no system tables are loaded.\n");
            if (this.mTestDatabase != null) {
                this.mTestDriverProtocol.addItem('W', "Perhaps no system tables are loaded.");
            }
        }
        System.err.println("jtest--> trace:\n" + sw.toString());
        if (this.mTestDriverProtocol != null && this.mTestDriverProtocol.getSaveFile() != null) {
            System.err.println("jtest--> ");
            System.err.println("jtest--> For detailed information see the testDriver protocol: " + this.mTestDriverProtocol.getSaveFile().getName());
            this.mTestDriverProtocol.addItem('E', pException.getMessage());
            this.mTestDriverProtocol.addItem('T', "\n" + sw.toString());
            if (this.mTestDatabase != null && this.mTestDatabase.isSap()) {
                try {
                    this.mTestDriverProtocol.addItem('I', "Current db state: " + this.mTestDatabase.executeDBMcmd("db_state"));
                }
                catch (TestDatabaseException tbe) {
                    this.mTestDriverProtocol.addItem('I', "Can't read current db state.");
                }
            }
        }
        System.err.println("jtest--> **********************************************************************");
    }

    public void printException(String pExceptionText) {
        TestDriver.addState(" TestDriver->printException(" + pExceptionText + ")");
        System.err.println("jtest--> **********************************************************************");
        System.err.println("jtest--> ERROR: " + pExceptionText);
        System.err.println("jtest--> **********************************************************************");
        this.mTestDriverProtocol.addItem('E', pExceptionText);
    }

    public void printMessage(String pMessage) {
        System.out.println("jtest--> " + pMessage);
        this.addTraceToProtocol(pMessage);
    }

    private void printOptions() {
        TestDriver.addState(" TestDriver->printOptions()");
        this.printMessage("----------------------------------------------------------------------");
        if (!((Boolean)this.mOptions.get("DBNone")).booleanValue()) {
            this.printMessage("Test database : " + this.mOptions.getProperty("DBName") + " on " + this.mOptions.getProperty("DBHost") + ":" + this.mOptions.getProperty("db-port"));
            if (this.mOptions.getProperty("DBMUser") != null && this.mOptions.getProperty("DBMPwd") != null) {
                this.printMessage("DBM (colduser): " + this.mOptions.getProperty("DBMUser") + "," + this.mOptions.getProperty("DBMPwd"));
            } else {
                this.printMessage("DBM (colduser): no explicit known, use default ( DBM )");
            }
            if (this.mOptions.getProperty("DBAUser") != null && this.mOptions.getProperty("DBAPwd") != null) {
                this.printMessage("DBA           : " + this.mOptions.getProperty("DBAUser") + "," + this.mOptions.getProperty("DBAPwd"));
            } else {
                this.printMessage("DBA           : no explicit known, use default ( DBA )");
            }
            this.printMessage("----------------------------------------------------------------------");
        }
        if (this.hasTrace()) {
            StringTokenizer st = new StringTokenizer(this.mOptions.toString(), ",");
            int numberOfOptions = st.countTokens();
            int counterOfOptions = 0;
            String currentOpt = null;
            this.printMessage("TestDriver configuration:");
            while (st.hasMoreTokens()) {
                ++counterOfOptions;
                currentOpt = st.nextToken().trim();
                if (currentOpt.indexOf("OSPwd") != -1) continue;
                if (counterOfOptions == 1) {
                    this.printMessage(currentOpt.substring(1, currentOpt.length()));
                    continue;
                }
                if (counterOfOptions == numberOfOptions) {
                    this.printMessage(currentOpt.substring(0, currentOpt.length() - 1));
                    continue;
                }
                this.printMessage(currentOpt);
            }
        }
    }

    private void printSummary() {
        this.printMessage(this.buildSummary());
    }

    private static TestDriverConfiguration readConfigurationFile(String pFileName) throws IOException, SAXException {
        TestDriver.addState(" TestDriver->readConfigurationFile(" + pFileName + ")");
        String filePath = System.getProperty("user.dir");
        String fileName = "TestDriverConfig";
        String fileExt = "xml";
        if (pFileName != null) {
            Properties fp = TestDriver.parseFile(pFileName);
            if (fp.getProperty("PATH") != null) {
                filePath = fp.getProperty("PATH");
            }
            if (fp.getProperty("NAME") != null) {
                fileName = fp.getProperty("NAME");
            }
            if (fp.getProperty("EXT") != null) {
                fileExt = fp.getProperty("EXT");
            }
        }
        TestDriverConfiguration tdConfig = new TestDriverConfiguration();
        tdConfig.parse(new File(filePath + File.separator + fileName + "." + fileExt));
        return tdConfig;
    }

    private StringBuffer readFileIntoStringBuffer(File pFile) {
        return this.readFileIntoStringBuffer(pFile, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readFileIntoStringBuffer(File pFile, int pMaxCharacter) {
        StringBuffer sb = null;
        FileReader fr = null;
        if (pMaxCharacter == -1) {
            pMaxCharacter = Integer.MAX_VALUE;
        }
        try {
            String line;
            fr = new FileReader(pFile);
            BufferedReader br = new BufferedReader(fr);
            sb = new StringBuffer();
            while ((line = br.readLine()) != null && sb.toString().length() < pMaxCharacter) {
                sb.append(line);
                sb.append("\n");
            }
            if (sb.capacity() >= pMaxCharacter) {
                sb.append("\n");
                sb.append("Mailsize limit of " + pMaxCharacter + " bytes reached; protocol is truncated!");
                sb.append("\n");
                sb.append("\n");
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                fr.close();
            }
            catch (Exception e) {}
        }
        return sb;
    }

    private void runFinalizersOnDatabase() {
        if (this.mTestDatabase == null) {
            return;
        }
        if (!this.mTestDatabase.isSap()) {
            return;
        }
        TestDriver.addState(" TestDriver->runFinalizersOnDatabase()");
        this.setTestMonitorStatus("Driver: runFinalizersOnDatabase");
        TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
        sapdb.releaseDBMConnection();
        if (!sapdb.isCreated() && sapdb.getInitialState() != null) {
            try {
                this.printMessage("Switching SAP DB " + sapdb.getName() + " to " + sapdb.getInitialState().toUpperCase() + " ....");
                sapdb.switchState(sapdb.getInitialState());
                this.printMessage("successful!");
                return;
            }
            catch (Exception e) {
                this.printException(e);
            }
        } else {
            if (sapdb.isKeep()) {
                try {
                    this.printMessage("Keeping SAP DB " + sapdb.getName() + " in " + sapdb.getKeepState() + " mode ...");
                    sapdb.switchState(sapdb.getKeepState());
                    this.printMessage("successful!");
                }
                catch (Exception e) {
                    this.printException(e);
                }
                return;
            }
            if (sapdb.isDrop()) {
                try {
                    this.printMessage("Dropping SAP DB " + sapdb.getName() + " ...");
                    sapdb.dropInstance();
                    this.printMessage("successful!");
                }
                catch (Exception e) {
                    this.printException(e);
                }
                return;
            }
            if (!sapdb.isKeep() && TestStatistic.getTotalErrors() == 0) {
                try {
                    this.printMessage("Dropping SAP DB " + sapdb.getName() + " ...");
                    sapdb.dropInstance();
                    this.printMessage("successful!");
                }
                catch (Exception e) {
                    this.printException(e);
                }
                return;
            }
            try {
                this.printMessage("Switching SAP DB " + sapdb.getName() + " to " + sapdb.getKeepState() + " mode ...");
                sapdb.switchState(sapdb.getKeepState());
                this.printMessage("successful!");
            }
            catch (Exception e) {
                this.printException(e);
            }
        }
    }

    private void initTestMonitor() {
        Boolean nomonitor = (Boolean)this.mOptions.get("NoMonitor");
        if (nomonitor == null || !nomonitor.booleanValue()) {
            Boolean monitor;
            TestDriver.addState(" TestDriver->initTestMonitor()");
            this.mTestMonitorUpdater = (Boolean)this.mOptions.get("DBNone") != false ? new TestMonitorUpdater(sVersion, "localhost", "NONE", (String)this.mOptions.get("sql-service-url")) : new TestMonitorUpdater(sVersion, (String)this.mOptions.get("DBHost"), (String)this.mOptions.get("DBName"), (String)this.mOptions.get("sql-service-url"));
            this.mTestMonitorUpdater.setTestStatus("Driver: DB init");
            this.mTestMonitorUpdater.setDriverEndStatus("Failed before DB-Init");
            this.mTestMonitorUpdater.setTestUser(System.getProperty("user.name"));
            this.mTestMonitorUpdater.setTestSequence(this.getTestSetName());
            Integer bits = (Integer)this.mOptions.get("DBBits");
            if (bits != null) {
                this.mTestMonitorUpdater.setDbBits(bits);
            }
            if ((monitor = (Boolean)this.mOptions.get("Monitor")) == null || !monitor.booleanValue()) {
                this.mTestMonitorUpdater.setHidden(true);
            } else {
                this.mTestMonitorUpdater.setHidden(false);
            }
            Boolean scheduled = (Boolean)this.mOptions.get("ScheduledTest");
            if (scheduled != null && scheduled.booleanValue()) {
                this.mTestMonitorUpdater.setTestType("scheduled");
            }
            this.mTestMonitorUpdater.start();
        }
    }

    private void setTestMonitorDBValues() {
        if (this.mTestMonitorUpdater != null) {
            String setSpecialVersion;
            TestDriver.addState(" TestDriver->setTestMonitorDBValues()");
            this.addTraceToProtocol("TestDriver->setTestMonitorDBValues()");
            if (this.mTestDatabase.isNone()) {
                if (this.mOptions.get("DBRoot") != null) {
                    this.mTestMonitorUpdater.setDbRoot(this.mOptions.getProperty("DBRoot").trim());
                    this.mTestMonitorUpdater.setDbVersion(((TestDatabaseSap)this.mTestDatabase).getDBVersionWithHostAndDBRoot(this.mOptions.getProperty("DBHost").trim(), this.mOptions.getProperty("DBRoot").trim()));
                } else {
                    this.mTestMonitorUpdater.setDbRoot("NONE");
                    this.mTestMonitorUpdater.setDbVersion("NONE");
                }
            }
            SAPDBInstallation sInst = null;
            try {
                this.mTestMonitorUpdater.setDbOS(this.getSAPDBOS());
                sInst = this.getCurrentSAPDBInstallation();
            }
            catch (Exception ex) {
                sInst = null;
            }
            if (this.mTestDatabase.isSap() && !this.mTestDatabase.isNone()) {
                TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
                try {
                    this.mTestMonitorUpdater.setDbType(sapdb.getInstanceType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sInst != null) {
                this.mTestMonitorUpdater.setDbRoot(sInst.dbRoot);
                this.mTestMonitorUpdater.setDbVersion(sInst.version);
            }
            if ((setSpecialVersion = this.mOptions.getProperty("ExplicitVersion")) != null && setSpecialVersion.length() > 1) {
                if (setSpecialVersion.length() > 64) {
                    this.addTraceToProtocol("Truncate given special version '" + setSpecialVersion + "' to ' " + setSpecialVersion.substring(0, 63) + "' and set them for the test monitor.");
                    setSpecialVersion = setSpecialVersion.substring(0, 63);
                } else {
                    this.addTraceToProtocol("Set given special version '" + setSpecialVersion + "' for test monitor.");
                }
                this.mTestMonitorUpdater.setDbVersion(setSpecialVersion);
            }
            this.mTestMonitorUpdater.setDriverEndStatus("Failed after DB-Init");
        }
    }

    public final void setTestMonitorStatus(String status) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setTestStatus(status);
        }
    }

    private void setTestMonitorDriverEndStatus(String status) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setDriverEndStatus(status);
        }
    }

    private void setTestMonitorTotalErrors(int n) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setDriverErrors(n);
        }
    }

    private void setTestMonitorTestsPlanned(int n) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setDriverTestsPlanned(n);
        }
    }

    private void setTestMonitorTestName(String testName) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setTestName(testName);
        }
    }

    private void setTestMonitorFinishedTests(int n) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setDriverTests(n);
        }
    }

    private void setTestMonitorMailReport(String mailReport) {
        if (this.mTestMonitorUpdater != null) {
            this.mTestMonitorUpdater.setDriverMailReport(mailReport);
        }
    }

    private void finishTestMonitor() {
        if (this.mTestMonitorUpdater != null) {
            TestDriver.addState(" TestDriver->finishTestMonitor()");
            try {
                this.mTestMonitorUpdater.processTaskQueue();
            }
            catch (Exception ex) {
                System.err.println("Got Exception while finishing the TestMonitorUpdater's task queue");
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
            }
            this.mTestMonitorUpdater.setStop(true);
            this.mTestMonitorUpdater = null;
        }
    }

    private void runTest() throws TestDatabaseException {
        TestDriver.addState(" TestDriver->runTest()");
        long StartTime = 0L;
        int TestExecutionTime = 0;
        char mode = 'A';
        if (this.hasTestMode()) {
            mode = 'A';
        } else if (this.hasVerificationMode()) {
            mode = 'B';
        } else if (this.hasReferenceMode()) {
            mode = 'C';
        }
        if (this.hasTrace()) {
            this.addTraceToProtocol("test-mode: " + mode);
            switch (mode) {
                case 'A': {
                    this.mTestDriverProtocol.addItem('I', "Test sequence runing without verification");
                    break;
                }
                case 'B': {
                    this.mTestDriverProtocol.addItem('I', "Test sequence runing with verification");
                    break;
                }
                case 'C': {
                    this.mTestDriverProtocol.addItem('I', "Test sequence creating verification objects");
                }
            }
        }
        TestCase.setRunMode(mode);
        TestCase.setDatabase(this.mTestDatabase);
        TestCase.setProtocol(this.mTestProtocol);
        TestCase.setTestDriverProtocol(this.mTestDriverProtocol);
        TestCase.setUser(this.mTestDatabase.getDBAUser());
        TestCase.setPassword(this.mTestDatabase.getDBAPassword());
        TestCase.setSave(this.hasSaveTestResult());
        TestCase.setResultDatabase(this.mTestResultDatabase);
        TestCase.resetCounters();
        TestCase.setTestDriverOptions(this.mOptions);
        TestCase.setTestDriverConfiguration(this.mConfiguration);
        TestCase.setTestDriver(this);
        URLClassLoader loader = TestDriver.getURLClassLoader(this.mTestSet);
        Iterator it = this.mTestSet.iterator();
        int numberOfTestItems = this.mTestSet.size();
        TestStatistic.setTestsPlanned(numberOfTestItems);
        int counterOfTests = 0;
        String dbRoot = this.mOptions.getProperty("DBRoot");
        this.setTestMonitorTestsPlanned(TestStatistic.getTestsPlanned());
        boolean mRestartInstanceAfterTheLastTest = false;
        String mRestartOrResetOfTheLastTest = "";
        while (!m_killed && it.hasNext()) {
            File actParameter;
            File actArchive;
            Properties actTestAdditionalParameter;
            String actTestDBRestart;
            String actResponsible;
            String actClassName;
            TestSequence.TestSequenceItem TestItem;
            block121: {
                TestItem = (TestSequence.TestSequenceItem)it.next();
                actClassName = TestItem.getClassName();
                actResponsible = TestItem.getResponsible();
                actTestDBRestart = TestItem.getTestDBRestart();
                if (TestItem.getRestartAfterTest().equalsIgnoreCase("TRUE")) {
                    mRestartOrResetOfTheLastTest = new String(actTestDBRestart);
                    actTestDBRestart = "FALSE";
                }
                actTestAdditionalParameter = TestItem.getAdditionalTestParameter();
                actArchive = TestItem.getArchive();
                actParameter = TestItem.getParameter();
                if (!(actTestDBRestart.equalsIgnoreCase("TRUE") || actTestDBRestart.equalsIgnoreCase("RESET") || this.mOptions.get("Restart").toString().equalsIgnoreCase("TRUE") || mRestartInstanceAfterTheLastTest || this.mLastTestIsInterrupted)) {
                    try {
                        if (((Boolean)this.mOptions.get("DBNone")).booleanValue()) break block121;
                        this.mTestDatabase.testConnection();
                    }
                    catch (Exception e) {
                        this.mTestDriverProtocol.addItem('W', "Database not online. Try to restart...");
                        try {
                            TestDatabaseSap sapdb = null;
                            if (this.mTestDatabase != null && this.mTestDatabase.isSap()) {
                                sapdb = (TestDatabaseSap)this.mTestDatabase;
                                sapdb.offline();
                            }
                            this.mTestDatabase.disconnect();
                            this.mTestDatabase.restart();
                            this.mTestDatabase.testConnection();
                            this.mTestDriverProtocol.addItem('I', "Restart successful. Database online.");
                        }
                        catch (Exception exc) {
                            this.mTestDriverProtocol.addItem('E', "Database restart failed. \n" + exc.getLocalizedMessage());
                            break;
                        }
                    }
                }
            }
            String actName = null;
            StringTokenizer st = new StringTokenizer(actClassName, ".");
            while (st.hasMoreTokens()) {
                actName = st.nextToken();
            }
            Class<?> actClass = null;
            String actTestId = null;
            String actTestNameForProtocol = null;
            String MethodName = null;
            Method Prepare = null;
            Method CleanUp = null;
            long actTestTimeout = 0L;
            try {
                TestDatabaseSap sapdb;
                this.addTraceToProtocol("Loading class " + actClassName);
                actClass = actArchive != null ? Class.forName(actClassName, true, loader) : Class.forName(actClassName);
                if (actClass.isInterface()) continue;
                boolean skip = false;
                Class<?> superClass = actClass.getSuperclass();
                while (true) {
                    if (superClass == null) {
                        skip = true;
                        break;
                    }
                    if (superClass.toString().endsWith("com.sap.sapdb.testframe.testcase.TestCase")) break;
                    superClass = superClass.getSuperclass();
                }
                if (skip) continue;
                this.setTestMonitorStatus("Driver: prepare test");
                TestCase.resetTestClassId();
                String testNumber = ++counterOfTests < 10 ? "00" + counterOfTests : (counterOfTests < 100 ? "0" + counterOfTests : "" + counterOfTests);
                TestCase.setTestNumber(testNumber);
                MethodName = "getTestClassId";
                try {
                    Method GetTestId = actClass.getMethod(MethodName, new Class[0]);
                    if (GetTestId != null) {
                        actTestId = (String)GetTestId.invoke(null, new Object[0]);
                        if (actTestId == null) {
                            actTestId = actName;
                        }
                    } else {
                        actTestId = actName;
                    }
                }
                catch (NoSuchMethodException e) {
                    actTestId = actName;
                }
                this.addTraceToProtocol("Getting test id ... " + actTestId);
                TestCase.setTestClassId(actTestId);
                MethodName = "getTestNameForProtocol";
                try {
                    Method GetTestNameForProtocol = actClass.getMethod(MethodName, new Class[0]);
                    if (GetTestNameForProtocol != null) {
                        actTestNameForProtocol = (String)GetTestNameForProtocol.invoke(null, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    actTestNameForProtocol = null;
                }
                this.addTraceToProtocol("Getting test name for protocol ... " + actTestNameForProtocol);
                if (actTestNameForProtocol != null) {
                    TestCase.setTestNameForProtocol(actTestNameForProtocol);
                }
                this.printMessage("Running test " + counterOfTests + "(" + numberOfTestItems + ") " + actClassName + " ...");
                try {
                    MethodName = "isReferenceEnabled";
                    Method IsReferenceEnabled = actClass.getMethod(MethodName, new Class[0]);
                    boolean isRefEnabled = (Boolean)IsReferenceEnabled.invoke(null, new Object[0]);
                    if (this.hasReferenceMode() && !isRefEnabled) {
                        this.mTestDriverProtocol.addItem(actTestId, 'I', "Test is not reference enabled -> skip test");
                        continue;
                    }
                }
                catch (Error ero) {
                    this.mTestDriverProtocol.addItem(actTestId, 'E', "Testframe catched an error. " + ero.getMessage());
                    System.out.println("Error: " + ero.getMessage());
                    ero.printStackTrace();
                    break;
                }
                if (this.mTestDatabase.isSap() && !actTestDBRestart.equalsIgnoreCase("TRUE") && !actTestDBRestart.equalsIgnoreCase("RESET") && !this.mOptions.get("Restart").toString().equalsIgnoreCase("TRUE") && !(sapdb = (TestDatabaseSap)this.mTestDatabase).isShort() && sapdb.isWarm() && sapdb.isFull()) {
                    this.mTestDriverProtocol.addItem(actTestId, 'W', "Database is full!");
                    System.out.println("Database is full!");
                    break;
                }
                MethodName = "isSAPOnly";
                Method IsSAPOnly = actClass.getMethod(MethodName, new Class[0]);
                boolean isSAPOnly = (Boolean)IsSAPOnly.invoke(null, new Object[0]);
                if (!this.mTestDatabase.isNone() && !this.mTestDatabase.isSap() && isSAPOnly) {
                    this.mTestDriverProtocol.addItem(actTestId, 'I', "Test is SAP DB only -> skip test");
                    continue;
                }
                if (this.mTestDatabase.isSap() && !this.checkTestVersion(this.mTestDatabase, actClass)) {
                    this.mTestDriverProtocol.addItem(actTestId, 'W', "Test is not valid for current database release");
                    continue;
                }
                try {
                    Prepare = actClass.getDeclaredMethod("prepare", new Class[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    CleanUp = actClass.getDeclaredMethod("cleanUp", new Class[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestParameter TestPar = null;
                TestPar = actParameter == null ? new TestParameter() : new TestParameter(actParameter.getParent(), actParameter.getName());
                if (actTestAdditionalParameter != null) {
                    Enumeration<?> e = actTestAdditionalParameter.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = e.nextElement().toString();
                        TestPar.setParameter(key, actTestAdditionalParameter.getProperty(key));
                    }
                }
                if (actParameter.exists()) {
                    this.addTraceToProtocol("used parameter file: " + actParameter.getName());
                }
                MethodName = "setParameterObject";
                Method SetParameterObject = actClass.getMethod(MethodName, class$com$sap$sapdb$testframe$testcase$TestParameter == null ? TestDriver.class$("com.sap.sapdb.testframe.testcase.TestParameter") : class$com$sap$sapdb$testframe$testcase$TestParameter);
                SetParameterObject.invoke(null, TestPar);
            }
            catch (ClassNotFoundException e) {
                this.printException(actClassName + " not found");
                continue;
            }
            catch (NoSuchMethodException e) {
                this.printException("Method " + MethodName + " for class " + actClassName + " not defined");
                continue;
            }
            catch (IllegalAccessException e) {
                this.printException("No access to " + actClassName);
                System.out.println("IllegalAccessException: " + e.getMessage());
                e.printStackTrace();
                continue;
            }
            catch (SecurityException e) {
                this.printException("Security Exception " + e.getMessage() + " for class " + actClassName);
                continue;
            }
            catch (InvocationTargetException e) {
                this.printException(e.getTargetException().getMessage());
                continue;
            }
            catch (TestParameterException e) {
                this.printException(e);
                continue;
            }
            String myFullName = TestItem.getClassName();
            String testName = null;
            if (myFullName.lastIndexOf(46) != -1) {
                String myClassName = myFullName.substring(myFullName.lastIndexOf(46) + 1);
                String myLastPackageName = myFullName.substring(0, myFullName.length() - (myClassName.length() + 1));
                myLastPackageName = myLastPackageName.substring(myLastPackageName.lastIndexOf(46) + 1);
                testName = myLastPackageName + "." + myClassName;
            } else {
                testName = myFullName;
            }
            this.setTestMonitorTestName(testName);
            int repetitionRate = 1;
            if (this.mOptions.getProperty("RepetitionRate") != null) {
                repetitionRate = Integer.parseInt(this.mOptions.getProperty("RepetitionRate"));
            }
            int repCounter = 0;
            while (!m_killed) {
                TestCase[] actTestSet;
                block123: {
                    int i;
                    block122: {
                        this.setTestMonitorStatus("restore / reset");
                        ++repCounter;
                        if (mRestartInstanceAfterTheLastTest) {
                            actTestDBRestart = mRestartOrResetOfTheLastTest.equalsIgnoreCase("RESET") ? "RESET" : "TRUE";
                            if (actTestDBRestart.equalsIgnoreCase("RESET")) {
                                this.addTraceToProtocol("The last test requested a reset of the database instance before the next test starts.");
                            } else {
                                this.addTraceToProtocol("The last test requested a restore of the database instance before the next test starts.");
                            }
                            mRestartInstanceAfterTheLastTest = false;
                        }
                        if (this.mTestDatabase.isSap()) {
                            TestDatabaseSap sapdb;
                            if (this.mLastTestIsInterrupted) {
                                this.mLastTestIsInterrupted = false;
                                actTestDBRestart = "RESET";
                            }
                            if ((sapdb = (TestDatabaseSap)this.mTestDatabase).isCreated()) {
                                if (actTestDBRestart.equalsIgnoreCase("RESET") && counterOfTests != 1) {
                                    sapdb.resetInstance();
                                } else if (this.mOptions.get("Restart").toString().equalsIgnoreCase("TRUE") && counterOfTests != 1) {
                                    sapdb.restoreInstance();
                                }
                                if (!this.mOptions.get("Restart").toString().equalsIgnoreCase("TRUE") && actTestDBRestart.equalsIgnoreCase("TRUE") && counterOfTests != 1) {
                                    sapdb.restoreInstance();
                                }
                            } else if (actTestDBRestart.equalsIgnoreCase("RESET") && counterOfTests != 1) {
                                sapdb.resetInstance();
                            } else {
                                if (this.mOptions.get("Restart").toString().equalsIgnoreCase("TRUE") && counterOfTests != 1) {
                                    sapdb.restoreInstance();
                                }
                                if (this.mOptions.get("Restart").toString().equalsIgnoreCase("EMPTY") && actTestDBRestart.equalsIgnoreCase("TRUE") && counterOfTests != 1) {
                                    sapdb.restoreInstance();
                                }
                            }
                        }
                        try {
                            if (!this.mTestDatabase.isNone()) {
                                this.mTestDatabase.testConnection();
                            }
                            if (!this.mTestDatabase.isSap()) break block122;
                            ((TestDatabaseSap)this.mTestDatabase).releaseDBMConnection();
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    StartTime = new Date().getTime();
                    if (Prepare != null) {
                        StringWriter sw;
                        try {
                            this.setTestMonitorStatus("prepare()");
                            Prepare.invoke(null, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            this.mTestDriverProtocol.addItem(actTestId, 'E', e.getTargetException().getMessage());
                            sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            this.mTestDriverProtocol.addItem(actTestId, 'T', "\n" + sw.toString());
                            try {
                                this.getLogFileAfterTest((TestCase)actClass.newInstance(), "prepare");
                            }
                            catch (Exception exp) {
                                this.addTraceToProtocol("Exception during getLogFile() for '" + actClass.getName() + "'-> " + exp.getMessage());
                            }
                            break;
                        }
                        catch (IllegalAccessException e) {
                            this.mTestDriverProtocol.addItem(actTestId, 'E', e.getMessage());
                            sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            this.mTestDriverProtocol.addItem(actTestId, 'T', "\n" + sw.toString());
                            try {
                                this.getLogFileAfterTest((TestCase)actClass.newInstance(), "prepare");
                            }
                            catch (Exception exp) {
                                this.addTraceToProtocol("Exception during getLogFile() for '" + actClass.getName() + "' -> " + exp.getMessage());
                            }
                            break;
                        }
                    }
                    try {
                        MethodName = "getTimeout";
                        Method GetTimeout = actClass.getMethod(MethodName, new Class[0]);
                        actTestTimeout = (Long)GetTimeout.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        this.printException("Method " + MethodName + " for class " + actClassName + " not defined");
                    }
                    catch (IllegalAccessException e) {
                        this.printException("No access to " + actClassName);
                    }
                    catch (InvocationTargetException e) {
                        this.printException(e.getTargetException().getMessage());
                    }
                    int parallelExecution = 1;
                    if (this.mOptions.getProperty("ParallelRate") != null) {
                        parallelExecution = Integer.parseInt(this.mOptions.getProperty("ParallelRate"));
                    }
                    if (parallelExecution > 1) {
                        this.setTestMonitorStatus("Not available. Test is running in parallel (" + parallelExecution + ") mode.");
                    }
                    actTestSet = new TestCase[parallelExecution];
                    try {
                        for (i = 0; i < parallelExecution; ++i) {
                            actTestSet[i] = (TestCase)actClass.newInstance();
                            if (parallelExecution == 1) {
                                actTestSet[i].setTestId(actTestId);
                            } else {
                                actTestSet[i].setTestId(actTestId + "_" + i);
                            }
                            actTestSet[i].setTestName(actName);
                            actTestSet[i].setTestClassName(actClassName);
                            if (parallelExecution == 1 && this.mTestMonitorUpdater != null) {
                                actTestSet[i].addPropertyChangeListener("status", this.mTestMonitorUpdater);
                            }
                            actTestSet[i].setDBRoot(dbRoot);
                        }
                    }
                    catch (InstantiationException e) {
                        this.mTestDriverProtocol.addItem('E', "Instantiation of class " + actClassName + " failed");
                        break;
                    }
                    catch (IllegalAccessException e) {
                        this.mTestDriverProtocol.addItem('E', "No access to " + actClassName);
                        break;
                    }
                    catch (NoClassDefFoundError ncde) {
                        this.mTestDriverProtocol.addItem('E', "No class found exception in " + actClassName + "\n" + ncde.getMessage());
                        break;
                    }
                    if (((Boolean)this.mOptions.get("VerificationTrace")).booleanValue()) {
                        for (i = 0; i < actTestSet.length; ++i) {
                            actTestSet[i].enableTrace(false, (Boolean)this.mOptions.get("VerificationTraceWithResult"), (Boolean)this.mOptions.get("VerificationTraceWithExplain"));
                        }
                    }
                    if (this.mOptions.getProperty("DBSecondRoot") != null) {
                        for (i = 0; i < actTestSet.length; ++i) {
                            actTestSet[i].setSecondDBRoot(this.mOptions.getProperty("DBSecondRoot"));
                        }
                    }
                    if (this.mOptions.getProperty("DBSecondHost") != null) {
                        for (i = 0; i < actTestSet.length; ++i) {
                            actTestSet[i].setSecondDBHost(this.mOptions.getProperty("DBSecondHost"));
                            actTestSet[i].setSecondDBPort(new Integer(this.mOptions.getProperty("DBSecondPort")));
                        }
                    }
                    try {
                        if (actTestSet.length == 0) break block123;
                        if (this.mTestScheduler == null) {
                            this.mTestScheduler = new Scheduler();
                        }
                        this.setTestMonitorStatus("run()");
                        this.mTestScheduler.run(actTestSet, actTestTimeout);
                    }
                    catch (InterruptedException e) {
                        this.mTestDriverProtocol.addItem(actTestId, 'W', "Test interrupted");
                        this.getLogFileAfterTest(actTestSet[0], "interrupt");
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        this.mTestDriverProtocol.addItem(actTestId, 'E', e.getMessage());
                        break;
                    }
                }
                if (this.mTestDatabase.isSap()) {
                    TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
                    try {
                        if (!sapdb.isShort() && sapdb.isFull()) {
                            this.mTestDriverProtocol.addItem(actTestId, 'W', "Database is full! Don't processing cleanUp() method.");
                            System.out.println("Database is full! Don't processing cleanUp() method");
                            CleanUp = null;
                            break;
                        }
                    }
                    catch (Exception exp) {
                        // empty catch block
                    }
                }
                if (CleanUp != null) {
                    StringWriter sw;
                    try {
                        this.setTestMonitorStatus("cleanup()");
                        CleanUp.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        this.mTestDriverProtocol.addItem(actTestId, 'E', e.getTargetException().getMessage());
                        sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        this.mTestDriverProtocol.addItem(actTestId, 'T', "\n" + sw.toString());
                        this.getLogFileAfterTest(actTestSet[0], "cleanUp");
                        break;
                    }
                    catch (IllegalAccessException e) {
                        this.mTestDriverProtocol.addItem(actTestId, 'E', e.getMessage());
                        sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        this.mTestDriverProtocol.addItem(actTestId, 'T', "\n" + sw.toString());
                        this.getLogFileAfterTest(actTestSet[0], "cleanUp");
                        break;
                    }
                }
                try {
                    this.getLogFileAfterTest(actTestSet[0], "finalize");
                    for (int i = 0; i < actTestSet.length; ++i) {
                        actTestSet[i].finalize();
                    }
                }
                catch (Throwable ex) {
                    this.mTestDriverProtocol.addItem("TestCase.finalize() failed", 'E', ex.getMessage());
                }
                if (repCounter < repetitionRate) continue;
            }
            TestExecutionTime = (int)((new Date().getTime() - StartTime) / 1000L);
            TestStatistic.incTestsStarted();
            if (((Boolean)this.mOptions.get("MailIndividual")).booleanValue() && TestCase.getErrorCounter() != 0 && TestStatistic.isNightTest()) {
                this.sendMessage(actResponsible, TestItem);
            }
            if (TestCase.getErrorCounter() == 0) {
                this.printMessage(actClassName + " finished successfully!");
                TestStatistic.incTestsSuccessful();
            } else {
                this.printMessage(actClassName + " finished with " + TestCase.getErrorCounter() + " errors!");
                if (((Boolean)this.mOptions.get("DBOltpTrace")).booleanValue() || ((Boolean)this.mOptions.get("DBOmsTrace")).booleanValue()) {
                    this.generateVTrace(actClassName, false);
                }
            }
            TestItem.setErrorCount(TestCase.getErrorCounter());
            TestItem.setWarnCount(TestCase.getWarningCounter());
            TestItem.setExecutionTime(TestExecutionTime);
            if (TestCase.getTestNameForProtocol() != null) {
                TestItem.setClass(TestCase.getTestNameForProtocol());
            }
            TestCase.resetCounters();
            this.setTestMonitorFinishedTests(counterOfTests);
            this.setTestMonitorStatus("Driver: DB Setup");
            if (!TestItem.getRestartAfterTest().equalsIgnoreCase("TRUE")) continue;
            mRestartInstanceAfterTheLastTest = true;
        }
        TestDriver.removeLastState();
    }

    private void getLogFileAfterTest(TestCase actCase, String testPhase) {
        String f = null;
        try {
            f = actCase.getLogFile();
        }
        catch (Exception e) {
            f = null;
            System.out.println("Exception for " + actCase.getTestId() + " in phase: " + testPhase + ":" + e.getMessage());
            e.printStackTrace();
            this.addTraceToProtocol("Exception during 'getLogFile()' for " + actCase.getTestId() + ". -> " + e.getMessage());
        }
        if (f != null) {
            boolean objectAlreadyInVector = false;
            for (int ve = 0; ve < this.vecTraceFiles.size(); ++ve) {
                if (!((AdditionalTraceFile)this.vecTraceFiles.get((int)ve)).fileName.equalsIgnoreCase(f)) continue;
                objectAlreadyInVector = true;
            }
            if (!objectAlreadyInVector) {
                String fileId = "" + actCase.getTestId();
                if (testPhase.equalsIgnoreCase("finalize")) {
                    fileId = fileId + " after finished test";
                    this.addTraceToProtocol("Add the file '" + f + "' to the attachment vector after the test finished normally.");
                }
                if (testPhase.equalsIgnoreCase("prepare")) {
                    fileId = fileId + " after error in prepare";
                    this.addTraceToProtocol("Add the file '" + f + "' to the attachment vector after the test finished bad in prepare.");
                }
                if (testPhase.equalsIgnoreCase("cleanUp")) {
                    fileId = fileId + " after error in cleanUp";
                    this.addTraceToProtocol("Add the file '" + f + "' to the attachment vector after the test finished bad in cleanUp.");
                }
                if (testPhase.equalsIgnoreCase("interrupt")) {
                    fileId = fileId + " after interrupt";
                    this.addTraceToProtocol("Add the file '" + f + "' to the attachment vector after the test was interrupted.");
                }
                this.vecTraceFiles.add(new AdditionalTraceFile(f, fileId));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String getValidRecipientFromQADB(String pRecipient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendMessage(String pRecipient, TestSequence.TestSequenceItem pItem) {
        String pk;
        TestDriver.addState(" TestDriver->sendMessage(String, TestSequenceItem)");
        if (pRecipient == null || pRecipient == "OFF" || pRecipient.toUpperCase().startsWith("OFF")) {
            return;
        }
        this.setTestMonitorStatus("Driver: Send Mail");
        TestDatabaseSap sapdb = null;
        if (this.mTestDatabase.isSap()) {
            sapdb = (TestDatabaseSap)this.mTestDatabase;
        }
        String dbHost = this.getHostName();
        String dbPort = "";
        String dbKernelVers = "unknown";
        String dbQALevel = this.mOptions.getProperty("QALevel");
        if (sapdb != null) {
            try {
                dbPort = "" + sapdb.getPort();
                dbKernelVers = sapdb.getDBVersionWithHostAndDBRoot(sapdb.getHost(), sapdb.getDBRoot());
            }
            catch (TestDatabaseException e) {
                // empty catch block
            }
            if (dbQALevel.equalsIgnoreCase("D")) {
                dbQALevel = "DEV";
            }
            if (dbQALevel.equalsIgnoreCase("C")) {
                dbQALevel = "COR";
            }
            if (dbQALevel.equalsIgnoreCase("R")) {
                dbQALevel = "RAMP";
            }
            if (dbQALevel.equalsIgnoreCase("H")) {
                dbQALevel = "HOT";
            }
            if (dbQALevel.equalsIgnoreCase("A")) {
                dbQALevel = "ANA";
            }
        }
        if (((Boolean)this.mOptions.get("DBNone")).booleanValue() && this.mOptions.get("DBRoot") != null && this.mOptions.get("DBHost") != null && dbKernelVers.length() == 0) {
            dbKernelVers = ((TestDatabaseSap)this.mTestDatabase).getDBVersionWithHostAndDBRoot(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBRoot"));
        }
        TestMessage msg = new TestMessage();
        msg.addRecipient(this.getValidRecipientFromQADB(pRecipient));
        StringBuffer subject = new StringBuffer();
        subject.append(dbKernelVers);
        if (dbQALevel.length() != 0) {
            subject.append(" (" + dbQALevel + ")");
        }
        subject.append(" Test Error ");
        subject.append(dbHost);
        subject.append(" - ");
        if (TestCase.getErrorCounter() == 1) {
            subject.append(" 1 error in '");
        } else {
            subject.append(TestCase.getErrorCounter() + " errors in '");
        }
        subject.append(pItem.getClassName().substring(pItem.getClassName().lastIndexOf(".") + 1));
        subject.append("' (SAPDBJavaTest)");
        msg.setSubject(subject.toString());
        StringBuffer sb = new StringBuffer();
        sb.append("This mail is sent automatically to inform you about errors in a test your are responsible for (declared within the corresponding test sequence file):\n\n");
        sb.append(mDateFormat.format(new Date(System.currentTimeMillis())));
        sb.append("\n");
        sb.append("Release          : " + dbKernelVers);
        if (dbQALevel.length() != 0) {
            sb.append(" ( " + dbQALevel + " )");
        }
        sb.append(" with Changelist: " + this.mOptions.getProperty("ChangeListNumber") + "\n");
        sb.append("Host             : " + dbHost);
        if (!dbPort.equalsIgnoreCase("7210")) {
            sb.append(" on port: " + dbPort);
        }
        sb.append("\nTest");
        int plannedTests = TestStatistic.getTestsPlanned();
        int startedTests = TestStatistic.getTestsStarted();
        if (startedTests < 10) {
            sb.append("   ");
        }
        if (startedTests > 9 && startedTests < 100) {
            sb.append("  ");
        }
        if (startedTests > 99) {
            sb.append(" ");
        }
        sb.append(startedTests + " of " + plannedTests);
        if (plannedTests < 10) {
            sb.append("   ");
        }
        if (plannedTests > 9 && plannedTests < 100) {
            sb.append("  ");
        }
        if (plannedTests > 99) {
            sb.append(" ");
        }
        sb.append(" : ");
        sb.append(pItem.getClassName());
        sb.append("\nParameter file   : ");
        sb.append(pItem.getParameter().getName());
        try {
            if (new File(this.mOptions.getProperty("ParameterInputDir"), pItem.getParameter().getName()).exists()) {
                sb.append(" (file found and used)");
            } else {
                sb.append(" (file not found)");
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (pItem.getAdditionalTestParameter() != null && pItem.getAdditionalTestParameter().size() > 0) {
            sb.append("\nSingle parameter :\n");
            Enumeration<?> e = pItem.getAdditionalTestParameter().propertyNames();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                sb.append("\t" + key + " = " + pItem.getAdditionalTestParameter().getProperty(key) + "\n");
            }
        }
        if (this.mOptions.getProperty("TEST_DRIVER_CONFIGURATION") != null) {
            sb.append("\ncfg-file         : ");
            sb.append(this.mOptions.getProperty("TEST_DRIVER_CONFIGURATION"));
        }
        if (this.getTestSetName() != null && this.getTestSetName().length() != 0) {
            sb.append("\nseq-file         : ");
            sb.append(this.getTestSetName());
        }
        sb.append("\n\n");
        if (this.mTestMonitorUpdater != null && (pk = this.mTestMonitorUpdater.getPrimaryKey()) != null) {
            String monitorHost = this.mOptions.get("Monitor-Host").toString();
            if (monitorHost != "") {
                try {
                    sb.append("TestDetails      : http://" + monitorHost + "/TestMonitor/index.jsp?cmd=showcomments&report=1&testid=" + URLEncoder.encode(pk, "UTF-8") + "\n\n");
                }
                catch (UnsupportedEncodingException uee) {
                    System.out.println("UnsupportedEncodingException for '" + pk + "': " + uee.getMessage());
                }
            } else {
                sb.append("\nFor a direct link to the TestMonitor a monitor hostname is required.\n\n");
            }
        }
        sb.append(TestCase.getErrorCounter());
        sb.append(" ERROR(s) found: \n\n");
        ArrayList errorMessageList = TestCase.getErrorMessages();
        ListIterator it = errorMessageList.listIterator();
        int simpleErrorCounter = 0;
        while (it.hasNext()) {
            sb.append(++simpleErrorCounter + ". error:\n");
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append("\n----\n");
        }
        msg.addLine(sb.toString());
        msg.addLine("\n");
        this.printMessage("Mail will be sent to " + this.getValidRecipientFromQADB(pRecipient));
        this.vecMails.add(msg);
    }

    private File zipTheContent(File pFile, String pString, String pInternalFileNameForString, int pSize) {
        File theZipFile;
        block22: {
            theZipFile = null;
            try {
                String internalPath;
                File fileInternalPath;
                if (pFile != null && pString != null) {
                    this.printMessage("The parameter pFile as well as the parameter pString are not null. I do not know which content should be zipped.");
                    return null;
                }
                if (pFile == null && pString == null) {
                    this.printMessage("The parameter pFile as well as pString are null.");
                    return null;
                }
                if (pSize < 0) {
                    this.printMessage("The parameter pSize (" + pSize + ") is lower than 0.");
                    return null;
                }
                if (pFile != null) {
                    if (!pFile.exists()) {
                        this.printMessage("The file '" + pFile.getName() + "' does not exist.");
                        return null;
                    }
                    if (!pFile.canRead()) {
                        this.printMessage("The file '" + pFile.getName() + "' can not be read.");
                        return null;
                    }
                    if (pFile.getName().toLowerCase().endsWith(".zip") || pFile.getName().toLowerCase().endsWith(".sck") || pFile.getName().toLowerCase().endsWith(".upg")) {
                        this.printMessage("The given file '" + pFile.getName() + "' seems to be a zip file already.");
                        return pFile;
                    }
                    if (pFile.length() < (long)pSize) {
                        if (this.tryToZipTheAttachment()) {
                            this.printMessage("The length of the file '" + pFile.getName() + "' (" + pFile.length() + ") is lower than the minimum size (" + pSize + "). No zip file creation.");
                        }
                        return null;
                    }
                    theZipFile = new File(pFile.getAbsolutePath() + ".zip");
                    if (theZipFile.exists() && !theZipFile.delete()) {
                        this.printMessage("The existing file '" + theZipFile.getName() + "' can not be dropped.");
                        return null;
                    }
                    Zipper myZipper = new Zipper(theZipFile);
                    myZipper.addFile(pFile);
                    try {
                        myZipper.zip();
                        break block22;
                    }
                    catch (IOException e) {
                        this.printMessage("Something went wrong during the zip of the file '" + pFile.getName() + "'\n" + e.getLocalizedMessage());
                        return null;
                    }
                }
                if (pString.length() < pSize) {
                    if (this.tryToZipTheAttachment()) {
                        this.printMessage("The length of the given string (" + pString.length() + ") is lower than the minimum size (" + pSize + "). No zip file creation.");
                    }
                    return null;
                }
                if (pInternalFileNameForString == null) {
                    this.printMessage("The parameter pInternalFileNameForString for the internal file name is null. Trying to build an unique name.");
                    pInternalFileNameForString = "" + System.currentTimeMillis();
                }
                if (pInternalFileNameForString.endsWith(".zip")) {
                    pInternalFileNameForString = pInternalFileNameForString.substring(0, pInternalFileNameForString.length() - 4);
                }
                if (!(fileInternalPath = new File(internalPath = TestDriver.getJTestRoot() + File.separator + "tests" + File.separator + "output" + File.separator + "frame")).exists() && !fileInternalPath.mkdirs()) {
                    this.printMessage("Can not create directory '" + fileInternalPath + "' to store the new zip file with the name '" + pInternalFileNameForString + "'.");
                    return null;
                }
                FileWriter fwIFNFS = new FileWriter(internalPath + File.separator + pInternalFileNameForString);
                fwIFNFS.write(pString.substring(0), 0, pString.length());
                fwIFNFS.close();
                theZipFile = new File(internalPath + File.separator + pInternalFileNameForString + ".zip");
                if (theZipFile.exists() && !theZipFile.delete()) {
                    this.printMessage("The existing file '" + theZipFile.getName() + "' can not be dropped.");
                    return null;
                }
                Zipper myZipper = new Zipper(theZipFile);
                myZipper.addFile(new File(internalPath + File.separator + pInternalFileNameForString));
                try {
                    myZipper.zip();
                }
                catch (IOException e) {
                    this.printMessage("Something went wrong during the zip of the file '" + pFile.getName() + "'\n" + e.getLocalizedMessage());
                    return null;
                }
            }
            catch (Exception exc) {
                this.printMessage("ERROR: something went wrong in zipTheContent: " + exc.getLocalizedMessage());
                exc.printStackTrace();
                theZipFile = null;
            }
        }
        return theZipFile;
    }

    private String uploadToWebdav(File pToUpload, String pWebdavDir) {
        return this.uploadToWebdav(null, pToUpload, pWebdavDir, null);
    }

    private String uploadToWebdav(String pToUpload, String pWebdavDir, String pFilename) {
        return this.uploadToWebdav(pToUpload, null, pWebdavDir, pFilename);
    }

    private String uploadToWebdav(String pToUpload, File pFileToUpload, String pWebdavDir, String pFilename) {
        if (pFilename == null) {
            if (pFileToUpload == null) {
                System.out.println("File to upload was null. Upload failed.");
                return null;
            }
            pFilename = pFileToUpload.getName();
        }
        String newUrl = null;
        this.printMessage("Uploading " + pWebdavDir + pFilename + " to WebDAV server " + this.mOptions.get("SaveWebdav-host").toString() + " ...");
        if (mWEBDavDir == null) {
            System.err.println("No correct webdav directory defined.");
        } else {
            try {
                WebDAVClient client = new WebDAVClient(mWEBDavBaseURL);
                if (pFileToUpload != null && pFileToUpload.getName() != null && pFileToUpload.getName().indexOf("zip") != -1) {
                    client.setStandardTimeout(300);
                }
                if (pFileToUpload == null && pToUpload != null) {
                    if (client.upload(pToUpload, pWebdavDir + pFilename)) {
                        this.printMessage("Upload successful.");
                        newUrl = mWEBDavBaseURL.toString() + pWebdavDir + pFilename;
                    } else {
                        this.printMessage("Upload failed.");
                    }
                } else if (client.upload(pFileToUpload, pWebdavDir + pFilename)) {
                    this.printMessage("Upload successful.");
                    newUrl = mWEBDavBaseURL.toString() + pWebdavDir + pFilename;
                } else {
                    this.printMessage("Upload failed.");
                }
            }
            catch (WebDAVException we) {
                if (we.getStatusCode() == 900) {
                    System.out.println(we.getMessage() + " on " + mDateFormat.format(new Date()) + " with \ncurrent url: '" + mWEBDavBaseURL.toString() + pWebdavDir + pFilename + "'");
                    System.out.println();
                }
                System.out.println("Upload failed on " + mDateFormat.format(new Date()) + " with \ncurrent url: '" + mWEBDavBaseURL.toString() + pWebdavDir + pFilename + "' " + we.toString() + " :");
                we.printStackTrace();
                System.out.println();
            }
        }
        return newUrl;
    }

    private void sendMessage(String pRecipient, Exception pException) {
        ArrayList<TestMessageAttachement> attachements;
        int maximumSizeOfAnUnzippedAttachment;
        StringBuffer mailBodyForMonitor;
        boolean somethingWrongDuringUploadToWEBDav;
        String newUrl;
        int msgAttachSize;
        StringBuffer mailBody;
        TestMessage msg;
        boolean noTestMail;
        block143: {
            String pk;
            String specialSubject;
            TestDriver.addState(" TestDriver->sendMessage(String, Exception)");
            String UpLoadLimit = "";
            noTestMail = false;
            if (pRecipient == null || pRecipient == "OFF" || pRecipient.toUpperCase().startsWith("OFF")) {
                this.printMessage("No mail was sent.");
                noTestMail = true;
            }
            boolean noKnldiag = false;
            Boolean oNoKnldiag = (Boolean)this.mOptions.get("NoKnldiag");
            if (oNoKnldiag != null && oNoKnldiag.booleanValue()) {
                noKnldiag = true;
            }
            if (!noTestMail) {
                this.setTestMonitorStatus("Driver: Send Mail");
            } else {
                this.setTestMonitorStatus("Driver: Generate Report");
            }
            TestDatabaseSap sapdb = null;
            if (this.mTestDatabase != null && this.mTestDatabase.isSap()) {
                sapdb = (TestDatabaseSap)this.mTestDatabase;
            }
            String dbHost = this.getHostName();
            String dbQALevel = this.mOptions.getProperty("QALevel");
            String dbKernelVers = "unknown release";
            if (sapdb != null) {
                try {
                    dbKernelVers = sapdb.getDBVersionWithHostAndDBRoot(sapdb.getHost(), sapdb.getDBRoot());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (dbQALevel.equalsIgnoreCase("D")) {
                dbQALevel = "DEV";
            }
            if (dbQALevel.equalsIgnoreCase("C")) {
                dbQALevel = "COR";
            }
            if (dbQALevel.equalsIgnoreCase("R")) {
                dbQALevel = "RAMP";
            }
            if (dbQALevel.equalsIgnoreCase("H")) {
                dbQALevel = "HOT";
            }
            if (dbQALevel.equalsIgnoreCase("A")) {
                dbQALevel = "ANA";
            }
            if (this.mTestDatabase != null && ((Boolean)this.mOptions.get("DBNone")).booleanValue() && this.mOptions.get("DBRoot") != null && this.mOptions.get("DBHost") != null && dbKernelVers.length() == 0) {
                dbKernelVers = ((TestDatabaseSap)this.mTestDatabase).getDBVersionWithHostAndDBRoot(this.mOptions.getProperty("DBHost"), this.mOptions.getProperty("DBRoot"));
            }
            if (this.mOptions.getProperty("ExplicitVersion").length() > 0) {
                dbKernelVers = this.mOptions.getProperty("ExplicitVersion");
            }
            msg = new TestMessage();
            if (!noTestMail) {
                msg.addRecipient(this.getValidRecipientFromQADB(pRecipient));
            }
            if (pException != null) {
                TestStatistic.incTotalErrors();
            }
            if ((specialSubject = this.mOptions.getProperty("MailSubject")) != null && !specialSubject.equals("")) {
                msg.setSubject(specialSubject + " (SAPDBJavaTest)");
            } else {
                StringBuffer subject = new StringBuffer();
                subject.append(dbKernelVers);
                if (dbQALevel.length() != 0) {
                    subject.append(" (" + dbQALevel + ")");
                }
                subject.append(" Test");
                if (TestStatistic.getTotalErrors() == 0 && TestStatistic.getTestsPlanned() - TestStatistic.getTestsSuccessful() == 0) {
                    subject.append(" Info");
                } else if (TestStatistic.getTotalErrors() > 0) {
                    subject.append(" Error");
                } else if (TestStatistic.getTotalErrors() == 0 && TestStatistic.getTestsPlanned() - TestStatistic.getTestsSuccessful() != 0) {
                    subject.append(" Warning");
                } else {
                    subject.append(" Error");
                }
                subject.append(" " + dbHost + " - ");
                if (this.getTestSetName().length() != 0) {
                    if (TestStatistic.getTotalErrors() == 1) {
                        subject.append("1 error in ");
                    }
                    if (TestStatistic.getTotalErrors() > 1) {
                        subject.append(TestStatistic.getTotalErrors() + " errors in ");
                    }
                    if (this.getTestSetName().length() > 0) {
                        if (this.getTestSetName().indexOf(File.separator) != -1) {
                            subject.append(this.getTestSetName().substring(this.getTestSetName().lastIndexOf(File.separator) + 1));
                        } else {
                            subject.append(this.getTestSetName().substring(this.getTestSetName().lastIndexOf(".") + 1));
                        }
                    }
                }
                subject.append(" (SAPDBJavaTest)");
                msg.setSubject(subject.toString());
            }
            mailBody = new StringBuffer();
            mailBody.append(this.buildReport() + "\n\n");
            mailBody.append(this.buildSummary() + "\n\n");
            msgAttachSize = 0;
            newUrl = null;
            String monitorHost = "";
            somethingWrongDuringUploadToWEBDav = false;
            mailBodyForMonitor = new StringBuffer(mailBody.toString());
            if (!mWEBDavIsEnabled) {
                mailBodyForMonitor.append("Upload of protocols disabled.\n");
            }
            if (this.mTestMonitorUpdater != null && (pk = this.mTestMonitorUpdater.getPrimaryKey()) != null) {
                monitorHost = this.mOptions.get("Monitor-Host").toString();
                if (monitorHost != "") {
                    try {
                        mailBody.append("This test's page in the TestMonitor:\nhttp://" + monitorHost + "/TestMonitor/index.jsp?cmd=showcomments&report=1&testid=" + URLEncoder.encode(pk, "UTF-8") + "\n\n");
                    }
                    catch (UnsupportedEncodingException uee) {
                        System.out.println("UnsupportedEncodingException for '" + pk + "': " + uee.getMessage());
                    }
                    catch (NoSuchMethodError nsme) {
                        System.err.println("UnsupportedEncodingException for URLEncoder.encode(pk, \"UTF-8\") -> old java vm!");
                        mailBody.append("This test's page in the TestMonitor:\nhttp://" + monitorHost + "/TestMonitor/index.jsp?cmd=showcomments&report=1&testid=" + URLEncoder.encode(pk) + "\n\n");
                    }
                } else {
                    mailBody.append("\nFor a direct link to the TestMonitor a monitor hostname is required.\n\n");
                }
            }
            if (mWEBDavIsEnabled) {
                mailBody.append("\nAttachments\n-----------\n");
            }
            maximumSizeOfAnUnzippedAttachment = 0;
            maximumSizeOfAnUnzippedAttachment = this.tryToZipTheAttachment() ? new Integer(this.mOptions.getProperty("ZipAttachment")) : 45678;
            boolean uploadFileIsZipped = false;
            attachements = new ArrayList<TestMessageAttachement>();
            if (this.mTestProtocol != null) {
                File testProtocolFile = null;
                TestDriver.addState(" TestDriver->sendMessage(..)->upload/send test protocol file");
                if (this.tryToZipTheAttachment()) {
                    testProtocolFile = this.zipTheContent(this.mTestProtocol.getSaveFile(), null, null, maximumSizeOfAnUnzippedAttachment);
                    if (testProtocolFile == null) {
                        uploadFileIsZipped = false;
                        testProtocolFile = this.mTestProtocol.getSaveFile();
                        if (testProtocolFile.length() > 5000000L) {
                            msgAttachSize += 5000000;
                        }
                    } else {
                        uploadFileIsZipped = true;
                    }
                } else {
                    testProtocolFile = this.mTestProtocol.getSaveFile();
                }
                if (uploadFileIsZipped) {
                    if (mWEBDavIsEnabled) {
                        newUrl = this.uploadToWebdav(testProtocolFile, mWEBDavDir);
                    }
                    if (newUrl != null) {
                        mailBody.append("Test protocol  : \t" + newUrl + "\n");
                        mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Test protocol</A>\n");
                    } else {
                        attachements.add(new TestMessageAttachement("Test protocol", testProtocolFile));
                        somethingWrongDuringUploadToWEBDav = true;
                    }
                } else {
                    StringBuffer testProtocol = this.readFileIntoStringBuffer(testProtocolFile, 5000000);
                    if (testProtocol != null) {
                        if (mWEBDavIsEnabled) {
                            newUrl = this.uploadToWebdav(testProtocol.toString(), mWEBDavDir, testProtocolFile.getName());
                        }
                        if (newUrl != null) {
                            mailBody.append("Test protocol  : \t" + newUrl + "\n");
                            mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Test protocol</A>\n");
                        } else {
                            attachements.add(new TestMessageAttachement("Test protocol", testProtocol.toString()));
                            somethingWrongDuringUploadToWEBDav = true;
                        }
                    }
                    if (TestStatistic.getTotalErrors() > 0 && this.mTestProtocol.getErrorProtocolExists()) {
                        newUrl = null;
                        DecimalFormat df = new DecimalFormat("####");
                        df.setMinimumIntegerDigits(4);
                        String errorprotocolname = "TestErr" + df.format(this.mTestProtocol.getSaveFileVersion()) + ".html";
                        if (mWEBDavIsEnabled) {
                            newUrl = this.uploadToWebdav(this.mTestProtocol.getErrorProtocol(), mWEBDavDir, errorprotocolname);
                        }
                        if (newUrl != null) {
                            mailBody.append("Error protocol : \t" + newUrl + "\n");
                            mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Error protocol</A>\n");
                        }
                    }
                }
                uploadFileIsZipped = false;
                TestDriver.removeLastState();
            }
            if (this.mTestDriverProtocol != null) {
                TestDriver.addState(" TestDriver->sendMessage(..)->upload/send test driver protocol file");
                File driverProtocolFile = null;
                if (this.tryToZipTheAttachment()) {
                    driverProtocolFile = this.zipTheContent(this.mTestDriverProtocol.getSaveFile(), null, null, maximumSizeOfAnUnzippedAttachment);
                    if (driverProtocolFile == null) {
                        uploadFileIsZipped = false;
                        driverProtocolFile = this.mTestDriverProtocol.getSaveFile();
                        if (driverProtocolFile.length() > 5000000L) {
                            msgAttachSize += 5000000;
                        }
                    } else {
                        uploadFileIsZipped = true;
                    }
                } else {
                    driverProtocolFile = this.mTestDriverProtocol.getSaveFile();
                }
                if (uploadFileIsZipped) {
                    if (mWEBDavIsEnabled) {
                        newUrl = this.uploadToWebdav(driverProtocolFile, mWEBDavDir);
                    }
                    if (newUrl != null) {
                        mailBody.append("Driver protocol: \t" + newUrl + "\n");
                        mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Driver protocol</A>\n");
                    } else {
                        attachements.add(new TestMessageAttachement("Driver protocol", driverProtocolFile.toString()));
                        somethingWrongDuringUploadToWEBDav = true;
                    }
                } else {
                    StringBuffer driverProtocol = this.readFileIntoStringBuffer(driverProtocolFile, 5000000);
                    if (driverProtocol != null) {
                        if (mWEBDavIsEnabled) {
                            newUrl = this.uploadToWebdav(driverProtocol.toString(), mWEBDavDir, driverProtocolFile.getName());
                        }
                        if (newUrl != null) {
                            mailBody.append("Driver protocol: \t" + newUrl + "\n");
                            mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Driver protocol</A>\n");
                        } else {
                            attachements.add(new TestMessageAttachement("Driver protocol", driverProtocol.toString()));
                            somethingWrongDuringUploadToWEBDav = true;
                        }
                    }
                }
                uploadFileIsZipped = false;
                TestDriver.removeLastState();
            }
            if (sapdb != null) {
                try {
                    String filesFromCfgFiletoUploadToWebDav;
                    TestDriver.addState(" TestDriver->sendMessage(..)->database parameter file");
                    File stringFileAsZip = null;
                    String paramString = null;
                    newUrl = null;
                    boolean upLoadOfParamterOK = false;
                    if (this.tryToZipTheAttachment() && (stringFileAsZip = this.zipTheContent(null, sapdb.getAllParameter(), "params.txt", maximumSizeOfAnUnzippedAttachment)) != null && mWEBDavIsEnabled) {
                        newUrl = this.uploadToWebdav(stringFileAsZip, mWEBDavDir);
                        upLoadOfParamterOK = true;
                    }
                    if (!upLoadOfParamterOK) {
                        paramString = sapdb.getAllParameter();
                        if (mWEBDavIsEnabled) {
                            newUrl = this.uploadToWebdav(paramString, mWEBDavDir, "params.txt");
                        }
                    }
                    if (newUrl != null) {
                        mailBody.append("DB parameters: \t" + newUrl + "\n");
                        mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">DB parameters</A>\n");
                    } else if (stringFileAsZip != null) {
                        attachements.add(new TestMessageAttachement("Parameters", stringFileAsZip));
                        msgAttachSize = (int)((long)msgAttachSize + stringFileAsZip.length());
                    } else {
                        attachements.add(new TestMessageAttachement("Parameters", paramString));
                        msgAttachSize += paramString.length();
                    }
                    String keyForStringToUpload = null;
                    String stringToUpload = null;
                    Vector<String> filesToUploadToWebDav = new Vector<String>(7);
                    Vector<String> uploadedFilesToWebDav = new Vector<String>(7);
                    boolean upLoadAsZipFileOK = false;
                    TestDriver.removeLastState();
                    if (TestStatistic.getTotalErrors() > 0 && !noKnldiag) {
                        String ts;
                        mailBody.append("\nDBM Key\tProtocol\n\n");
                        filesToUploadToWebDav.add("KNLDIAG");
                        filesToUploadToWebDav.add("KNLDIAGERR");
                        filesToUploadToWebDav.add("DBMPRT");
                        while (!filesToUploadToWebDav.isEmpty()) {
                            upLoadAsZipFileOK = false;
                            try {
                                keyForStringToUpload = (String)filesToUploadToWebDav.firstElement();
                                TestDriver.addState(" TestDriver->sendMessage(..)->upload/send DBM file: " + keyForStringToUpload);
                                stringToUpload = sapdb.getDatabaseProtocolViaDBMKey(keyForStringToUpload);
                            }
                            catch (Exception ex) {
                                UpLoadLimit = ex.getMessage();
                            }
                            newUrl = null;
                            if (mWEBDavIsEnabled && UpLoadLimit.length() == 0) {
                                stringFileAsZip = this.zipTheContent(null, stringToUpload, keyForStringToUpload, maximumSizeOfAnUnzippedAttachment);
                                if (stringFileAsZip != null) {
                                    newUrl = this.uploadToWebdav(stringFileAsZip, mWEBDavDir);
                                    upLoadAsZipFileOK = true;
                                }
                                if (!upLoadAsZipFileOK) {
                                    newUrl = this.uploadToWebdav(stringToUpload.toString(), mWEBDavDir, keyForStringToUpload);
                                }
                            }
                            if (newUrl != null) {
                                ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                mailBody.append(keyForStringToUpload + "\t" + newUrl + "\n");
                                mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">" + keyForStringToUpload + " " + ts + "</A>\n");
                            } else if (UpLoadLimit.length() == 0) {
                                somethingWrongDuringUploadToWEBDav = true;
                                attachements.add(new TestMessageAttachement(keyForStringToUpload, stringToUpload));
                                msgAttachSize += stringToUpload.length();
                            } else {
                                mailBody.append("Can't upload or send " + keyForStringToUpload + "; " + UpLoadLimit + "\n");
                                UpLoadLimit = "";
                            }
                            uploadedFilesToWebDav.add(keyForStringToUpload);
                            filesToUploadToWebDav.remove(keyForStringToUpload);
                            TestDriver.removeLastState();
                        }
                        if (TestStatistic.getTotalTestDriverErrors() > 0) {
                            filesToUploadToWebDav.add("LOADER");
                            filesToUploadToWebDav.add("XSRVPRT");
                            while (!filesToUploadToWebDav.isEmpty()) {
                                upLoadAsZipFileOK = false;
                                try {
                                    keyForStringToUpload = (String)filesToUploadToWebDav.firstElement();
                                    TestDriver.addState(" TestDriver->sendMessage(..)->upload/send DBM file: " + keyForStringToUpload);
                                    stringToUpload = sapdb.getDatabaseProtocolViaDBMKey(keyForStringToUpload);
                                }
                                catch (Exception ex) {
                                    UpLoadLimit = ex.getMessage();
                                }
                                newUrl = null;
                                if (mWEBDavIsEnabled && UpLoadLimit.length() == 0) {
                                    stringFileAsZip = this.zipTheContent(null, stringToUpload, keyForStringToUpload, 0);
                                    if (stringFileAsZip != null) {
                                        newUrl = this.uploadToWebdav(stringFileAsZip, mWEBDavDir);
                                        upLoadAsZipFileOK = true;
                                    }
                                    if (!upLoadAsZipFileOK) {
                                        newUrl = this.uploadToWebdav(stringToUpload.toString(), mWEBDavDir, keyForStringToUpload);
                                    }
                                }
                                if (newUrl != null) {
                                    ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                    mailBody.append(keyForStringToUpload + "\t" + newUrl + "\n");
                                    mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">" + keyForStringToUpload + " " + ts + "</A>\n");
                                } else if (UpLoadLimit.length() == 0) {
                                    somethingWrongDuringUploadToWEBDav = true;
                                    attachements.add(new TestMessageAttachement(keyForStringToUpload, stringToUpload));
                                    msgAttachSize += stringToUpload.length();
                                } else {
                                    mailBody.append("Can't upload or send " + keyForStringToUpload + "; " + UpLoadLimit + "\n");
                                    UpLoadLimit = "";
                                }
                                uploadedFilesToWebDav.add(keyForStringToUpload);
                                filesToUploadToWebDav.remove(keyForStringToUpload);
                                TestDriver.removeLastState();
                            }
                        }
                    }
                    if ((filesFromCfgFiletoUploadToWebDav = (String)this.mOptions.get("files-to-upload")).length() <= 0) break block143;
                    StringTokenizer stz = new StringTokenizer(filesFromCfgFiletoUploadToWebDav, ",;");
                    String curFile = null;
                    while (stz.hasMoreTokens()) {
                        curFile = stz.nextToken().trim();
                        if (uploadedFilesToWebDav.contains(curFile) || filesToUploadToWebDav.contains(curFile)) continue;
                        filesToUploadToWebDav.add(curFile);
                    }
                    if (!filesToUploadToWebDav.isEmpty() && mailBody.toString().indexOf("DBM Key") == -1) {
                        mailBody.append("\nDBM Key\tProtocol\n\n");
                    }
                    while (!filesToUploadToWebDav.isEmpty()) {
                        try {
                            keyForStringToUpload = (String)filesToUploadToWebDav.firstElement();
                            TestDriver.addState(" TestDriver->sendMessage(..)->upload/send file from cfg file: " + keyForStringToUpload);
                            stringToUpload = sapdb.getDatabaseProtocolViaDBMKey(keyForStringToUpload);
                        }
                        catch (Exception ex) {
                            UpLoadLimit = ex.getMessage();
                        }
                        newUrl = null;
                        upLoadAsZipFileOK = false;
                        if (mWEBDavIsEnabled && UpLoadLimit.length() == 0) {
                            stringFileAsZip = this.zipTheContent(null, stringToUpload, keyForStringToUpload, maximumSizeOfAnUnzippedAttachment);
                            if (stringFileAsZip != null) {
                                newUrl = this.uploadToWebdav(stringFileAsZip, mWEBDavDir);
                                upLoadAsZipFileOK = true;
                            }
                            if (!upLoadAsZipFileOK) {
                                newUrl = this.uploadToWebdav(stringToUpload.toString(), mWEBDavDir, keyForStringToUpload);
                            }
                        }
                        if (newUrl != null) {
                            String ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                            mailBody.append(keyForStringToUpload + "\t" + newUrl + "\n");
                            mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">" + keyForStringToUpload + " " + ts + "</A>\n");
                        } else if (UpLoadLimit.length() == 0) {
                            somethingWrongDuringUploadToWEBDav = true;
                            attachements.add(new TestMessageAttachement(keyForStringToUpload, stringToUpload));
                            msgAttachSize += stringToUpload.length();
                        } else {
                            mailBody.append("Can't upload or send " + keyForStringToUpload + "; " + UpLoadLimit + "\n");
                            UpLoadLimit = "";
                        }
                        uploadedFilesToWebDav.add(keyForStringToUpload);
                        filesToUploadToWebDav.remove(keyForStringToUpload);
                        TestDriver.removeLastState();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.isRemoteTest()) {
            TestDriver.addState(" TestDriver->sendMessage(..)-> is remote test; -> upload/send getRemoteDBSysInfo()");
            String sysInfo = this.getRemoteDBSysInfo();
            if (mWEBDavIsEnabled) {
                newUrl = this.uploadToWebdav(sysInfo, mWEBDavDir, "sysinfo.txt");
            }
            if (newUrl != null) {
                mailBody.append("Remote system info:   " + newUrl + "\n");
                mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">Remote system info</A>\n");
            } else {
                somethingWrongDuringUploadToWEBDav = true;
                attachements.add(new TestMessageAttachement("Remote system info", sysInfo));
                msgAttachSize += sysInfo.length();
            }
            TestDriver.removeLastState();
        }
        if (this.vecTraceFiles.size() > 0) {
            int mailsizelimit;
            block144: {
                msgAttachSize /= 1024;
                if (mWEBDavIsEnabled) {
                    mailBody.append("\n\nlog file(s):\n\n");
                }
                mailsizelimit = 2048;
                try {
                    mailsizelimit = Integer.parseInt(this.mOptions.getProperty("MailSizeLimit"));
                }
                catch (Exception ex) {
                    String strMailSizeLimit = this.mOptions.getProperty("MailSizeLimit");
                    if (strMailSizeLimit == null) break block144;
                    msg.addLine("Malformed mailsizelimit option: <" + strMailSizeLimit + ">.");
                }
            }
            TestDriver.addState(" TestDriver->sendMessage(..)->upload/send " + this.vecTraceFiles.size() + " log file(s)");
            for (int i = 0; i < this.vecTraceFiles.size(); ++i) {
                newUrl = null;
                AdditionalTraceFile curTraceFile = (AdditionalTraceFile)this.vecTraceFiles.elementAt(i);
                File file = new File(curTraceFile.fileName);
                File fileAsZipFile = null;
                if (file == null) continue;
                if (!file.isFile()) {
                    System.err.println(" Can not open additional logfile <" + curTraceFile.fileName + "> because it is not a file object.");
                    continue;
                }
                if (!file.canRead()) {
                    mailBody.append("\tCan't open additional logfile <" + curTraceFile.fileName + ">\n");
                    System.err.println(" Can't open additional logfile <" + curTraceFile.fileName + ">");
                    continue;
                }
                if (file.length() > 0xA00000L) {
                    StringBuffer canNotUploadDecisionBuffer = new StringBuffer();
                    canNotUploadDecisionBuffer.append("The file " + file.getName() + " could not be uploaded to the WebDAV server because it is too large.\n\n");
                    canNotUploadDecisionBuffer.append("File Size: " + file.length() + " bytes \n");
                    canNotUploadDecisionBuffer.append("Limit    : 10485760 bytes \n\n");
                    canNotUploadDecisionBuffer.append("The file might still exist on the test host " + this.getHostName() + " at \n" + file.getAbsolutePath() + " !");
                    if (mWEBDavIsEnabled) {
                        newUrl = this.uploadToWebdav(canNotUploadDecisionBuffer.toString(), mWEBDavDir, file.getName());
                    }
                    if (newUrl != null) {
                        String ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                        mailBody.append("( " + file.getName() + " ): \t" + newUrl + "\n");
                        mailBodyForMonitor.append("(<A HREF=\"" + newUrl + "\">" + file.getName() + ") " + ts + "</A>\n");
                    } else {
                        canNotUploadDecisionBuffer = new StringBuffer();
                        canNotUploadDecisionBuffer.append("The file " + file.getName() + " could not be sent as attachment because it is too large.\n\n");
                        canNotUploadDecisionBuffer.append("File Size       : " + file.length() + " bytes \n");
                        canNotUploadDecisionBuffer.append("WebDav Limit    : 10485760 bytes \n");
                        canNotUploadDecisionBuffer.append("Mail Limit      : " + mailsizelimit * 1024 + " bytes \n");
                        canNotUploadDecisionBuffer.append("The file might still exist on the test host " + this.getHostName() + " at \n" + file.getAbsolutePath() + " !");
                        attachements.add(new TestMessageAttachement("(" + file.getName() + ")", canNotUploadDecisionBuffer.toString()));
                    }
                    System.out.println(canNotUploadDecisionBuffer.toString());
                    continue;
                }
                msgAttachSize = (int)((long)msgAttachSize + file.length() / 1024L);
                if (mWEBDavIsEnabled) {
                    fileAsZipFile = this.zipTheContent(file, null, null, maximumSizeOfAnUnzippedAttachment);
                    newUrl = fileAsZipFile != null ? this.uploadToWebdav(fileAsZipFile, mWEBDavDir) : this.uploadToWebdav(file, mWEBDavDir);
                }
                if (newUrl != null) {
                    String ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                    mailBody.append(file.getName() + ": \t" + this.convertToHtml(newUrl) + "\n");
                    mailBodyForMonitor.append("<A HREF=\"" + newUrl + "\">" + file.getName() + " " + ts + "</A>\n");
                    continue;
                }
                if (msgAttachSize > mailsizelimit) {
                    msg.addLine("Message size limit (" + mailsizelimit + " kb) exceeded. " + (this.vecTraceFiles.size() - i) + " logfile(s) are not attached.");
                    System.out.println("Message size limit (" + mailsizelimit + " kb) exceeded. " + (this.vecTraceFiles.size() - i) + " logfile(s) are not attached.");
                    if (!mWEBDavIsEnabled) break;
                }
                if (file.getName().toLowerCase().endsWith(".zip") || file.getName().toLowerCase().endsWith(".sck")) {
                    String fileName = file.getName();
                    fileName = fileName.substring(0, fileName.length() - 4);
                    attachements.add(new TestMessageAttachement(fileName, file));
                    continue;
                }
                attachements.add(new TestMessageAttachement(curTraceFile.fileId, this.readFileIntoStringBuffer(file).toString()));
            }
            TestDriver.removeLastState();
        }
        TestDriver.addState(" TestDriver->sendMessage(..)->complete mail body and send email");
        msg.addLine(mailBody.toString());
        if (somethingWrongDuringUploadToWEBDav && mWEBDavIsEnabled) {
            mailBodyForMonitor.append("At least one protocol was not uploaded to the WEBDav server.");
        }
        this.setTestMonitorMailReport(mailBodyForMonitor.toString());
        if (pException != null) {
            msg.addLine("****** Exception occured ******");
            msg.addLine("more info: " + pException.getLocalizedMessage());
        }
        if (!noTestMail) {
            if (attachements.isEmpty()) {
                msg.send();
            } else {
                msg.send(attachements);
            }
        }
        if (this.vecMails.size() > 0) {
            for (int i = 0; i < this.vecMails.size(); ++i) {
                TestMessage dummy = null;
                dummy = (TestMessage)this.vecMails.get(i);
                dummy.send();
            }
        }
        TestDriver.removeLastState();
    }

    private String convertToHtml(String notAHtmlString) {
        int index = notAHtmlString.indexOf(" ");
        while (index != -1) {
            notAHtmlString = notAHtmlString.substring(0, index) + "%20" + notAHtmlString.substring(index + 1);
            index = notAHtmlString.indexOf(" ");
        }
        return notAHtmlString;
    }

    protected final String getRemoteDBSysInfo() {
        TestDriver.addState(" TestDriver->getRemoteDBSysInfo()");
        String runDirectory = "unknown";
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)this.mTestDatabase;
            runDirectory = sapdb.executeDBMcmd("param_getvalue RUNDIRECTORY");
            runDirectory = runDirectory.substring(0, runDirectory.indexOf(10));
        }
        catch (Exception ex) {
            this.mTestDriverProtocol.addItem('I', "Can't retrieve working directory: " + ex.getMessage());
        }
        StringBuffer sysInfo = new StringBuffer();
        sysInfo.append("******************************************************************************\n");
        sysInfo.append("*****                   Remote DB System Information                     *****\n");
        sysInfo.append("******************************************************************************\n");
        sysInfo.append(this.mkReportLine("***** Remote Host      : " + this.mOptions.get("DBHost")));
        sysInfo.append(this.mkReportLine("***** Remote DB        : " + this.mOptions.get("DBName")));
        String remoteOS = "(can't retrieve)";
        try {
            remoteOS = this.getSAPDBOS();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (remoteOS == null) {
            remoteOS = "(can't retrieve)";
        }
        try {
            SAPDBInstallation si = this.getCurrentSAPDBInstallation();
            sysInfo.append(this.mkReportLine("***** Release          : " + si.version));
            sysInfo.append(this.mkReportLine("***** Remote DB_ROOT   : " + si.dbRoot));
            sysInfo.append(this.mkReportLine("***** Working Dir:     : " + runDirectory));
        }
        catch (Exception ex) {
            sysInfo.append(this.mkReportLine("***** Release          : (can't retrieve)"));
            sysInfo.append(this.mkReportLine("***** Remote DB_ROOT   : (can't retrieve)"));
            sysInfo.append(this.mkReportLine("***** Working Dir:     : (can't retrieve)"));
        }
        sysInfo.append(this.mkReportLine("***** Remote OS        : " + remoteOS));
        sysInfo.append(this.mkReportLine("***** Kernel Mode      : " + this.mOptions.get("DBMode")));
        try {
            sysInfo.append(this.mkReportLine("***** Kernel Build     : " + this.getSAPDBBuild()));
        }
        catch (Exception ex) {
            sysInfo.append(this.mkReportLine("***** Kernel Build     : (can't retrieve)"));
        }
        sysInfo.append("******************************************************************************\n");
        return sysInfo.toString();
    }

    private String mkReportLine(String start) {
        String r = new String(start);
        for (int i = 0; i < 73 - start.length(); ++i) {
            r = r + " ";
        }
        r = r + "*****\n";
        return r;
    }

    public void setTestSetName(String newTestSetName) {
        this.mTestSetName = newTestSetName;
    }

    private static void usageOptions(boolean pError) {
        System.out.println("Usage: java TestDriver [options] test.class [test.class]");
        System.out.println("    <options>:");
        System.out.println("         -h             this help menue                               ");
        System.out.println("         -c             <test driver configuration file>              ");
        System.out.println("         -d             <db name>                                     ");
        System.out.println("         -n             <db host>                                     ");
        System.out.println("         -u             <user,password> of the DBA user               ");
        System.out.println("         -uc            <user,password> of the DBM user (=colduser)   ");
        System.out.println("         -t             <SAP|ORA|DB2|MSS> (default: SAP)              ");
        System.out.println("         -k             <SLOW|FAST> (SAP DB only, default: FAST)");
        System.out.println("------------------------------------------------------------------");
        System.out.println("*** create SAP DB options ***                                     ");
        System.out.println("------------------------------------------------------------------");
        System.out.println("         -G             [NONE |[OFF|FORCE [,KEEP|DROP] [,ATTACH]]]    ");
        System.out.println("                        [,OFFLINE, COLD, ADMIN, WARM, ONLINE]         ");
        System.out.println("                        (generate test db; define the db-endstate)    ");
        System.out.println("         -R             <db root>                                     ");
        System.out.println("         -jdbcport      <db port> for jdbc communication              ");
        System.out.println("         -O             <os user,os password>                         ");
        System.out.println("         -S             <SMALL|MEDIUM|LARGE|HUGE> (default: SMALL)    ");
        System.out.println("         -bits          <32|64|n> architecture of DB host OS          ");
        System.out.println("         -snode         a second <db host>                            ");
        System.out.println("         -sroot         a second <db root>                            ");
        System.out.println("         -sport         a second <db port>                            ");
        System.out.println("------------------------------------------------------------------");
        System.out.println("*** test control options ***                                      ");
        System.out.println("------------------------------------------------------------------");
        System.out.println("         -T             print detailed TestDriver Trace messages      ");
        System.out.println("         -p             <test parameter path>                         ");
        System.out.println("         -pf            <test parameter file>                         ");
        System.out.println("         -m             <TEST|REF|VER><label> (default: TEST)         ");
        System.out.println("         -s             save test results                             ");
        System.out.println("         -l   \t         <resdb name>[,<res dbhost>]                   ");
        System.out.println("         -P             Number of parallel test threads               ");
        System.out.println("         -restart [TRUE|FALSE] specify whether the database should    ");
        System.out.println("                               be restarted between each test         ");
        System.out.println("------------------------------------------------------------------");
        System.out.println("*** test evaluation options ***                                   ");
        System.out.println("------------------------------------------------------------------");
        System.out.println("         -o             <protocol path>                               ");
        System.out.println("         -os            protocol is written to stdout                 ");
        System.out.println("         -sr            store the test results in external database   ");
        System.out.println("         -mail          <responsible> | OFF                           ");
        System.out.println("         -nowebdav      disable upload of files to WebDAV server      ");
        System.out.println("         -noknldiag     disable uploading/attaching of knldiag* files ");
        System.out.println("         -novtrace      disable generating of vtrace file             ");
        System.out.println("         -monitor       make this test visible in the TestMonitor     ");
        System.out.println("         -nomonitor     don't send any information to the TestMonitor ");
        System.out.println("         -QA [D,R,C,A,H] QA level; DEV, RAMP, COR, HOT, ANA           ");
        System.out.println("         -LCP <no>      lcpool number; which package was used         ");
        System.out.println("         -CL <no>       last changelist number                        ");
        System.out.println("         -MAKEKEY <no>  make run identifier                           ");
        System.out.println("         -MAKEKEY2 <no> 2. make run identifier                        ");
        if (pError) {
            System.exit(2);
        } else {
            System.exit(0);
        }
    }

    private void verifyOptions() {
        String DBRoot;
        TestDriver.addState(" TestDriver->verifyOptions()");
        if (this.mOptions.get("DBGenerate") != null && ((Boolean)this.mOptions.get("DBGenerate")).booleanValue() && !((Boolean)this.mOptions.get("DBNone")).booleanValue()) {
            String DBRoot2 = (String)this.mOptions.get("DBRoot");
            if (DBRoot2 == null) {
                System.out.println("Testing on machine (" + this.mOptions.get("DBHost") + "), but DB-ROOT not specified. \nUse -R on the command line or <db-root> in the cfg-file!");
            }
            SAPDBInstallation myInst = null;
            try {
                myInst = this.getCurrentSAPDBInstallation();
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex.getLocalizedMessage() + " + " + ex.getClass());
                System.out.println("Can't retrieve current SAPDB Installation: " + ex.getMessage());
                ex.printStackTrace();
                System.exit(3);
            }
            if (myInst == null) {
                if (DBRoot2 != null) {
                    System.out.println("Can't find DB-ROOT <" + DBRoot2 + ">. ");
                }
                System.out.println("The following DB-ROOTs were found on <" + this.mOptions.get("DBHost") + ">:");
                SAPDBInstallation[] dbInstallations = null;
                try {
                    dbInstallations = this.getSAPDBInstallations();
                }
                catch (Exception ex) {
                    System.out.println("Exception: " + ex.getLocalizedMessage() + " + " + ex.getClass());
                    System.out.println("Can't retrieve list of available installations: " + ex.getMessage());
                    ex.printStackTrace();
                    System.exit(3);
                }
                if (dbInstallations == null) {
                    System.out.println("No SAPDB Installations on machine " + this.mOptions.get("DBHost") + ".");
                    System.exit(3);
                }
                for (int i = 0; i < dbInstallations.length; ++i) {
                    System.out.println(dbInstallations[i].dbRoot);
                }
                System.exit(3);
            }
        } else if (!((Boolean)this.mOptions.get("DBNone")).booleanValue() && (DBRoot = (String)this.mOptions.get("DBRoot")) == null) {
            System.out.println("Testing on machine (" + this.mOptions.get("DBHost") + "), but DB-ROOT not specified. \nUse -R on the command line or <db-root> in the cfg-file!");
            System.exit(3);
        }
        if (((Boolean)this.mOptions.get("Save-Result")).booleanValue() && (this.mOptions.get("SaveDBName") == null || this.mOptions.get("SaveDBHost") == null || this.mOptions.get("SaveDBUser") == null || this.mOptions.get("SaveDBUser-password") == null)) {
            System.out.println("\nWARNING: Missing parameter in xml-config-file for saving the testdriver results in external database!\n");
            this.mOptions.put("Save-Result", Boolean.FALSE);
        }
        if (!((Boolean)this.mOptions.get("DBNone")).booleanValue() && this.mOptions.get("DBName") == null) {
            System.out.println("\nError: Missing database name; use option -d <name> or <db-name> in cfg-file");
            System.exit(3);
        }
    }

    private SAPDBInstallation getCurrentSAPDBInstallation() throws Exception {
        SAPDBInstallation[] dbInstallations = this.getSAPDBInstallations();
        SAPDBInstallation myInst = null;
        String dbRoot = this.mOptions.getProperty("DBRoot");
        if (dbRoot == null) {
            dbRoot = "unknown root";
        }
        File fDbRoot = new File(dbRoot);
        for (int i = 0; i < dbInstallations.length; ++i) {
            if (!new File(dbInstallations[i].dbRoot).equals(fDbRoot)) continue;
            myInst = dbInstallations[i];
            break;
        }
        return myInst;
    }

    private String getSAPDBOS() throws Exception {
        String dbType = this.mOptions.getProperty("DBType");
        if (dbType == null || !dbType.equals("SAP")) {
            throw new Exception("TestDriver.getSAPDBOS(): only possible if DB_TYPE == SAP");
        }
        TestDatabaseSap testDB = null;
        try {
            testDB = new TestDatabaseSap(this.mOptions.getProperty("DBHost"), null);
            testDB.setPort(Integer.parseInt(this.mOptions.getProperty("db-port")));
        }
        catch (Exception ex) {
            throw new Exception("TestDriver.getSAPDBOS(): can't connect to SAPDB on " + this.mOptions.getProperty("DBHost") + ": " + ex.getMessage());
        }
        if (testDB == null) {
            throw new Exception("TestDriver.getSAPDBOS(): can't connect to SAPDB on " + this.mOptions.getProperty("DBHost") + ".");
        }
        String cmdResult = null;
        try {
            cmdResult = testDB.executeDBMcmdWithoutLogin("dbm_version sysname").trim();
        }
        catch (Exception ex) {
            throw new Exception("TestDriver.getSAPDBOS(): Can't execute DBM command 'dbm_version' on " + this.mOptions.get("DBHost") + ". Exception: " + ex.getMessage());
        }
        if (cmdResult == null) {
            throw new Exception("TestDriver.getSAPDBOS(): Null result from DBM command 'dbm_version' on " + this.mOptions.get("DBHost") + ".");
        }
        return cmdResult;
    }

    private String getSAPDBBuild() throws Exception {
        TestDatabaseSap testDB = null;
        try {
            testDB = (TestDatabaseSap)this.mTestDatabase;
        }
        catch (Exception ex) {
            throw new Exception("getSAPDBBuild(): DB is not a SAPDB, can't retrieve Build-Info.");
        }
        return testDB.getKernelBuild();
    }

    private SAPDBInstallation[] getSAPDBInstallations() throws Exception {
        String dbType = this.mOptions.getProperty("DBType");
        if (dbType == null || !dbType.equals("SAP")) {
            throw new Exception("TestDriver.getSAPDBInstallations(): only possible if DB_TYPE == SAP; (found DB_TYPE = " + dbType + ")");
        }
        TestDatabaseSap testDB = null;
        try {
            testDB = new TestDatabaseSap(this.mOptions.getProperty("DBHost"), null);
            testDB.setPort(new Integer(this.mOptions.getProperty("db-port")));
        }
        catch (Exception ex) {
            throw new Exception("TestDriver.getSAPDBInstallations(): can't connect to SAPDB on " + this.mOptions.getProperty("DBHost") + ": " + ex.getMessage());
        }
        if (testDB == null) {
            throw new Exception("TestDriver.getSAPDBInstallations(): can't connect to SAPDB on " + this.mOptions.getProperty("DBHost") + ".");
        }
        String cmdResult = null;
        try {
            cmdResult = testDB.executeDBMcmdWithoutLogin("inst_enum");
        }
        catch (Exception ex) {
            System.out.println("\nApparently the XSERVER is not running. \nStart it with 'x_server start' if required,\nor check if the correct port is used.\n\n");
            throw ex;
        }
        if (cmdResult == null) {
            throw new Exception("TestDriver.getSAPDBInstallations(): Null result from DBM command 'inst_enum' on " + this.mOptions.get("DBHost") + ".");
        }
        Vector<SAPDBInstallation> v = new Vector<SAPDBInstallation>(10);
        if (this.hasTrace()) {
            System.out.println("inst_enum -> \n" + cmdResult);
        }
        BufferedReader br = new BufferedReader(new StringReader(cmdResult));
        String line = null;
        String instVersion = null;
        while ((line = br.readLine()) != null) {
            int firstPositionOfSpace = line.indexOf(" ");
            instVersion = line.substring(0, firstPositionOfSpace).trim();
            if (this.hasTrace()) {
                System.out.println(" Version: '" + instVersion + "'\n Path   : '" + line.substring(firstPositionOfSpace).trim() + "'");
            }
            try {
                String patchedVersion = "";
                String tempString = null;
                StringTokenizer versST = new StringTokenizer(instVersion, ".");
                patchedVersion = patchedVersion + versST.nextToken();
                patchedVersion = patchedVersion + ".";
                patchedVersion = patchedVersion + versST.nextToken();
                while (versST.hasMoreTokens()) {
                    patchedVersion = patchedVersion + ".";
                    tempString = versST.nextToken();
                    if (tempString.length() == 1) {
                        patchedVersion = patchedVersion + "0";
                        patchedVersion = patchedVersion + tempString;
                        continue;
                    }
                    patchedVersion = patchedVersion + tempString;
                }
                instVersion = patchedVersion;
                if (this.hasTrace()) {
                    System.out.println(" patched Version: '" + instVersion + "'");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            v.add(new SAPDBInstallation(instVersion, line.substring(firstPositionOfSpace).trim()));
        }
        Object[] va = v.toArray();
        SAPDBInstallation[] installations = new SAPDBInstallation[va.length];
        for (int i = 0; i < va.length; ++i) {
            installations[i] = (SAPDBInstallation)va[i];
        }
        return installations;
    }

    private void writeProtocol() throws IOException {
        TestDriver.addState(" TestDriver->writeProtocol()");
        if (this.mHasAsyncProtocol) {
            if (this.mTestDriverProtocol != null) {
                this.mTestDriverProtocol.flushAsyncWriters();
            }
            if (this.mTestProtocol != null) {
                this.mTestProtocol.flushAsyncWriters();
            }
        }
        if (!this.mHasAsyncProtocol) {
            if (!this.mHasOutputFile) {
                if (this.mTestDriverProtocol != null) {
                    this.mTestDriverProtocol.print();
                }
                if (this.mTestProtocol != null) {
                    this.mTestProtocol.print();
                }
            } else {
                if (this.mTestDriverProtocol != null) {
                    this.mTestDriverProtocol.save();
                }
                if (this.mTestProtocol != null) {
                    this.mTestProtocol.save();
                }
            }
        }
        if (this.mTestDriverProtocol != null) {
            this.mTestDriverProtocol.close();
            this.copyProtocol(this.mTestDriverProtocol);
        }
        if (this.mTestProtocol != null) {
            this.mTestProtocol.close();
            this.copyProtocol(this.mTestProtocol);
        }
    }

    private void copyProtocol(TestProtocol tp) {
        TestDriver.addState(" TestDriver->copyProtocol(..)");
        String currentCmd = null;
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        String Ext = null;
        Ext = tp.getSaveFile().toString().endsWith("rte") ? "rte" : "prt";
        currentCmd = "cp " + tp.getSaveFile() + " " + tp.getFilePath() + File.separator + tp.getFileNamePrefix() + "." + Ext;
        this.addTraceToProtocol("Try to execute: " + currentCmd);
        SystemProcess = TestDriver.isDevelopmentInstallation() ? new Execute(currentCmd, new String[]{"SAPDB_NO_INDEPPATH=yes"}, ProcessOutput) : new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
    }

    public static void addState(String pMessage) {
        if (mLastMessages.size() > mMaxEntriesInVector) {
            mLastMessages.remove(1);
        }
        pMessage = pMessage + " on " + mDateFormatMilli.format(new Date());
        mLastMessages.addElement(pMessage);
    }

    public static void removeLastState() {
        if (mLastMessages.size() > 1) {
            mLastMessages.remove(mLastMessages.size() - 1);
        }
    }

    public static void removeLastStateAndAddNewState(String pMessage) {
        TestDriver.removeLastState();
        TestDriver.addState(pMessage);
    }

    public static String buildClassPathForTrace() {
        StringBuffer sb = new StringBuffer();
        String tmpString = null;
        StringTokenizer str = null;
        str = System.getProperty("os.name").indexOf("Windows") != -1 ? new StringTokenizer(System.getProperty("java.class.path"), ";") : new StringTokenizer(System.getProperty("java.class.path"), ":");
        int i = 1;
        int longestEntry = 0;
        while (str.hasMoreTokens()) {
            tmpString = str.nextToken();
            if (longestEntry >= tmpString.length()) continue;
            longestEntry = tmpString.length();
        }
        str = System.getProperty("os.name").indexOf("Windows") != -1 ? new StringTokenizer(System.getProperty("java.class.path"), ";") : new StringTokenizer(System.getProperty("java.class.path"), ":");
        sb.append("Classpath:\n");
        while (str.hasMoreTokens()) {
            if (i < 10) {
                sb.append("  ");
            }
            if (i > 9 && i < 100) {
                sb.append(" ");
            }
            tmpString = str.nextToken();
            sb.append(i + ". -> ");
            sb.append(tmpString);
            if (tmpString.length() < longestEntry) {
                char[] ca = new char[longestEntry - tmpString.length()];
                Arrays.fill(ca, ' ');
                sb.append(ca);
            }
            File tmpFile = new File(tmpString);
            try {
                if (tmpFile.exists()) {
                    sb.append("\tlast modified: " + mDateFormat.format(new Date(tmpFile.lastModified())));
                    tmpString = TestDriver.searchForClassFiles(tmpFile);
                    if (tmpString.length() > 1) {
                        sb.append("\n\tSingle class files in this directory:" + tmpString);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private static String searchForClassFiles(File startFile) {
        String result = "";
        if (startFile.isDirectory()) {
            File[] allFiles = startFile.listFiles();
            for (int i = 0; i < allFiles.length; ++i) {
                result = result + TestDriver.searchForClassFiles(allFiles[i]);
            }
        } else if (startFile.toString().endsWith("class")) {
            result = result + "\n\t\t" + startFile.toString() + "";
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SAPDBInstallation {
        public String version = null;
        public String dbRoot = null;

        public SAPDBInstallation(String v, String dbr) {
            this.version = new String(v);
            this.dbRoot = new String(dbr);
        }
    }

    private class AdditionalTraceFile {
        public String fileName = null;
        public String fileId = null;

        public AdditionalTraceFile(String fname, String id) {
            this.fileName = new String(fname);
            this.fileId = new String(id);
        }
    }

    private final class TestMonitorUpdater
    extends Thread
    implements PropertyChangeListener {
        private String driverVersion = null;
        private String driverIP = null;
        private String driverFQHN = null;
        private String dbIP = null;
        private String dbFQHN = null;
        private String dbName = null;
        private String dbVersion = null;
        private String driverID = null;
        private String primaryKey = null;
        private String driverStarted = null;
        private String lastPing = null;
        private ServerSocket driverSocket = null;
        public int driverPort = -1;
        private Connection dbConn = null;
        private boolean stopped = false;
        private Vector taskQueue = new Vector(10);
        private RemoteWatchdog remoteWatchdog = null;
        private URL mUrl = null;
        private boolean mUseHTTP = false;

        private final String getPrimaryKey() {
            return this.driverStarted;
        }

        private String handleRemoteCommand(String cmd) {
            if (cmd.equalsIgnoreCase("kill")) {
                TestDriver.this.printMessage("Received kill...");
                TestDriver.this.mTestDriverProtocol.addItem('E', "Received kill command (ping of death)");
                m_killed = true;
                if (TestDriver.this.mTestScheduler != null) {
                    TestDriver.this.mTestScheduler.interruptAllTests();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!m_hasRespondedToKill) {
                    TestDriver.this.mTestDriverProtocol.addItem('E', "Interrupting test failed, killing the hard way");
                    TestDriver.this.mTestDriverProtocol.addItem('E', "It is very likely, that child processes are still alive");
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < mLastMessages.size(); ++i) {
                        sb.append((String)mLastMessages.get(i));
                        sb.append("\n");
                    }
                    TestDriver.this.mTestDriverProtocol.addItem('T', "Last States: \n" + sb.toString());
                    TestDriver.this.killTestDriver();
                } else {
                    TestDriver.this.mTestDriverProtocol.addItem('E', "Test interrupted. Killing me softly.");
                }
            } else {
                if (cmd.equalsIgnoreCase("state")) {
                    StringBuffer sb = new StringBuffer();
                    TestDriver.this.printMessage("Received state...");
                    sb.append("current TestDriver state:\n");
                    for (int i = 0; i < mLastMessages.size(); ++i) {
                        sb.append((String)mLastMessages.get(i));
                        sb.append("\n");
                    }
                    sb.append("\n");
                    if (TestDriver.this.mTestProtocol != null && TestDriver.this.mTestProtocol.getItems() != null && TestDriver.this.mTestProtocol.getItems().size() != 0) {
                        ArrayList myTempTestEntries = new ArrayList(TestDriver.this.mTestProtocol.getItems());
                        sb.append("current, last 10 entries in test protocol:");
                        for (int j = myTempTestEntries.size(); j > myTempTestEntries.size() - 10 && j > 0; --j) {
                            sb.append("\n " + ((TestProtocol)myTempTestEntries.get(j)).toString());
                        }
                    }
                    System.out.println("\n" + sb.toString());
                    return sb.toString();
                }
                TestDriver.this.mTestDriverProtocol.addItem('E', "TestMonitorUpdater received unknown command via ping connection: '" + cmd + "'");
                return "Unkown command '" + cmd + "'";
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTask(String cmd, String[] args, String[] argvalues) {
            Vector vector = this.taskQueue;
            synchronized (vector) {
                this.taskQueue.add(new TestMonitorUpdaterTask(cmd, args, argvalues));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TestMonitorUpdaterTask getNextTask() {
            Vector vector = this.taskQueue;
            synchronized (vector) {
                for (int i = 0; i < this.taskQueue.size(); ++i) {
                    TestMonitorUpdaterTask t = (TestMonitorUpdaterTask)this.taskQueue.elementAt(i);
                    if (t.done) continue;
                    return t;
                }
            }
            return null;
        }

        public TestMonitorUpdater(String newDriverVersion, String newDbFQHN, String newDbName, String newUrl) {
            this.driverVersion = new String(newDriverVersion);
            this.dbFQHN = new String(newDbFQHN);
            this.dbName = new String(newDbName);
            if (newUrl.length() != 0) {
                try {
                    this.mUrl = new URL("http://" + newUrl);
                }
                catch (MalformedURLException malformurl) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "TestMonitorUpdater! MalformedURLException: " + malformurl.getLocalizedMessage());
                    this.mUrl = null;
                }
            }
        }

        private boolean allocatePort() {
            try {
                this.driverSocket = new ServerSocket(0);
            }
            catch (Exception ex) {
                this.driverSocket = null;
                return false;
            }
            this.driverPort = this.driverSocket.getLocalPort();
            TestDriver.this.printMessage("Ready for TestMonitor pings on port " + this.driverPort);
            return true;
        }

        private void startRemoteWatchdog() {
            this.remoteWatchdog = new RemoteWatchdog();
            this.remoteWatchdog.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.initConfig()) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "Can't initialize configuration");
                }
                return;
            }
            try {
                this.initDBConnection();
            }
            catch (Exception ex) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "TestMonitorUpdater failed to open DB. Exception: {" + ex.getMessage() + "}");
                }
                return;
            }
            if (!this.allocatePort()) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "Can't open port to answer pings");
                }
                return;
            }
            this.initID();
            try {
                this.addStartEntry();
            }
            catch (Exception ex) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "TestMonitorUpdater can't access DB Table: {" + ex.getMessage() + "}");
                }
                return;
            }
            this.startRemoteWatchdog();
            try {
                this.setPriority(1);
            }
            catch (Exception ex) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "TestMonitorUpdater failed to diminish priority. Exception: {" + ex.getMessage() + "}");
                }
                return;
            }
            try {
                this.eventDispatcher();
            }
            catch (Exception ex) {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', "TestMonitorUpdater crashed. Exception: {" + ex.getMessage() + "}");
                }
                System.out.println("TestMonitorUpdater crashed. " + ex.getClass() + "  " + ex.getLocalizedMessage());
            }
            finally {
                this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTestType(String type) {
            this.addTask("setTestType", new String[]{"testType"}, new String[]{type});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDbType(String type) {
            this.addTask("setDbType", new String[]{"dbType"}, new String[]{type});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDbBits(int n) {
            this.addTask("setDbBits", new String[]{"dbBits"}, new String[]{"" + n});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDriverErrors(int n) {
            this.addTask("setDriverErrors", new String[]{"driverErrors"}, new String[]{"" + n});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTestUser(String user) {
            if (user != null) {
                this.addTask("setTestUser", new String[]{"testUser"}, new String[]{user});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDbRoot(String s) {
            if (s != null) {
                this.addTask("setDbRoot", new String[]{"dbRoot"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDbOS(String s) {
            if (s != null) {
                this.addTask("setDbOS", new String[]{"dbOS"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDriverTests(int n) {
            this.addTask("setDriverTests", new String[]{"driverTests"}, new String[]{"" + n});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDbVersion(String s) {
            if (s != null) {
                this.addTask("setDbVersion", new String[]{"dbVersion"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDriverMailReport(String s) {
            if (s != null) {
                try {
                    if (s.length() > 6750) {
                        System.out.print("Mail report is cut out. Original length: " + s.length());
                        String dummy = s.substring(0, 3000) + "\nSnipp...\n\n   Left out due to oversized summary; \n   Use entry FILTER_SUMMERY in the cfg-file to show only the tests \n   with errors and warnings.\n\n";
                        int PositionOfTotal = s.indexOf("| Total:");
                        boolean tooManyFiles = false;
                        if (PositionOfTotal != -1 && s.length() - PositionOfTotal + 152 > 3600) {
                            dummy = dummy + s.substring(PositionOfTotal - 156, PositionOfTotal - 156 + 3500);
                            tooManyFiles = true;
                        } else {
                            dummy = dummy + s.substring(PositionOfTotal - 156);
                        }
                        if (tooManyFiles) {
                            int startOfEnd = dummy.length() - 1;
                            while (dummy.charAt(startOfEnd) != '\n') {
                                --startOfEnd;
                            }
                            dummy = dummy.substring(0, startOfEnd);
                            dummy = dummy + "\nSnipp...\n too many files!\n";
                        }
                        s = dummy;
                        System.out.println("; new length: " + s.length());
                    }
                }
                catch (Exception e) {
                    s = "Something wrong during setDriverMailReport(..) with the truncation of the report with a size of " + s.length() + " bytes.\n" + e.getLocalizedMessage() + "\n";
                    System.err.println(s);
                    e.printStackTrace();
                }
                this.addTask("setDriverMailReport", new String[]{"driverMailReport"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTestName(String s) {
            if (s != null) {
                this.addTask("setTestName", new String[]{"testName", "testStarted"}, new String[]{s, new Timestamp(System.currentTimeMillis()).toString()});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTestStatus(String s) {
            if (s != null) {
                this.addTask("setTestStatus", new String[]{"testStatus"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTestSequence(String s) {
            if (s != null) {
                this.addTask("setTestSequence", new String[]{"testSequence"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDriverTestsPlanned(int n) {
            this.addTask("setDriverTestsPlanned", new String[]{"driverTestsPlanned"}, new String[]{"" + n});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDriverEndStatus(String s) {
            if (s != null) {
                this.addTask("setDriverEndStatus", new String[]{"driverEndStatus"}, new String[]{s});
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHidden(boolean isHidden) {
            this.addTask("setHidden", new String[]{"hidden"}, new String[]{isHidden ? "TRUE" : "FALSE"});
            TestMonitorUpdater testMonitorUpdater = this;
            synchronized (testMonitorUpdater) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eventDispatcher() throws Exception {
            while (!this.stopped) {
                try {
                    TestMonitorUpdater testMonitorUpdater = this;
                    synchronized (testMonitorUpdater) {
                        this.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.processTaskQueue();
                if (this.taskQueue.size() <= 10) continue;
                this.cleanTaskQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanTaskQueue() {
            Vector vector = this.taskQueue;
            synchronized (vector) {
                TestMonitorUpdaterTask t;
                while (this.taskQueue.size() > 0 && (t = (TestMonitorUpdaterTask)this.taskQueue.elementAt(0)).done) {
                    this.taskQueue.remove(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTaskQueue() throws Exception {
            if (this.dbConn != null && !this.dbConn.isClosed() || this.mUseHTTP) {
                TestMonitorUpdaterTask t = this.getNextTask();
                while (t != null) {
                    TestMonitorUpdaterTask testMonitorUpdaterTask = t;
                    synchronized (testMonitorUpdaterTask) {
                        if (!t.done) {
                            if (t.cmd.equals("setDbRoot")) {
                                this.process_setDbRoot(t.getArg("dbRoot"));
                            } else if (t.cmd.equals("setDbOS")) {
                                this.process_setDbOS(t.getArg("dbOS"));
                            } else if (t.cmd.equals("setDbVersion")) {
                                this.process_setDbVersion(t.getArg("dbVersion"));
                            } else if (t.cmd.equals("setTestName")) {
                                this.process_setTestName(t.getArg("testName"), t.getArg("testStarted"));
                            } else if (t.cmd.equals("setTestStatus")) {
                                this.process_setTestStatus(t.getArg("testStatus"));
                            } else if (t.cmd.equals("setTestSequence")) {
                                this.process_setTestSequence(t.getArg("testSequence"));
                            } else if (t.cmd.equals("setDriverEndStatus")) {
                                this.process_setDriverEndStatus(t.getArg("driverEndStatus"));
                            } else if (t.cmd.equals("setTestUser")) {
                                this.process_setTestUser(t.getArg("testUser"));
                            } else if (t.cmd.equals("setDriverMailReport")) {
                                this.process_setDriverMailReport(t.getArg("driverMailReport"));
                            } else if (t.cmd.equals("setDriverTests")) {
                                this.process_setDriverTests(t.getArg("driverTests"));
                            } else if (t.cmd.equals("setDriverErrors")) {
                                this.process_setDriverErrors(t.getArg("driverErrors"));
                            } else if (t.cmd.equals("setDriverTestsPlanned")) {
                                this.process_setDriverTestsPlanned(t.getArg("driverTestsPlanned"));
                            } else if (t.cmd.equals("setTestType")) {
                                this.process_setTestType(t.getArg("testType"));
                            } else if (t.cmd.equals("setHidden")) {
                                this.process_setHidden(t.getArg("hidden"));
                            } else if (t.cmd.equals("setDbType")) {
                                this.process_setDbType(t.getArg("dbType"));
                            } else if (t.cmd.equals("setDbBits")) {
                                this.process_setDbBits(t.getArg("dbBits"));
                            } else {
                                throw new Exception("invalid task in queue. cmd=<" + t.cmd + ">");
                            }
                            t.done = true;
                        }
                    }
                    t = this.getNextTask();
                }
            }
        }

        private String executeQuery(String qry) throws Exception {
            if (this.mUseHTTP) {
                String result = this.executeQueryHTTP(qry);
                if (result.startsWith("OK")) {
                    return result;
                }
                if (result.indexOf("ConnectException") != -1 || result.indexOf("FileNotFoundException") != -1) {
                    System.out.println("TestMonitorUpdater has a wrong result!\nFor statement: " + qry + "\nreceived: " + result);
                    return result;
                }
                throw new SQLException("\nGot no \"ok\" for:\n" + qry + "\nbut:\n" + result + " on " + mDateFormat.format(new Date()));
            }
            Statement stmt = this.dbConn.createStatement();
            stmt.execute(qry);
            return "OK";
        }

        private String executeQueryHTTP(String sqlStmt) {
            try {
                String line;
                URLConnection connection = this.mUrl.openConnection();
                connection.setDoOutput(true);
                PrintWriter out = new PrintWriter(connection.getOutputStream());
                out.write(sqlStmt);
                out.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    response.append(line + "\n");
                }
                in.close();
                return response.toString();
            }
            catch (IOException e) {
                return "HTTP Error:\n" + e.toString();
            }
        }

        private void process_setDbBits(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET dbBits=" + s + " WHERE " + this.primaryKey);
        }

        private void process_setDbType(String type) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET dbType=" + this.embrace(type) + " WHERE " + this.primaryKey);
        }

        private void process_setTestType(String type) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET testType=" + this.embrace(type) + " WHERE " + this.primaryKey);
        }

        private void process_setHidden(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET hidden=" + s + " WHERE " + this.primaryKey);
        }

        private void process_setDriverTestsPlanned(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET driverTestsPlanned=" + s + " WHERE " + this.primaryKey);
        }

        private void process_setDriverErrors(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET driverErrors=" + s + " WHERE " + this.primaryKey);
        }

        private void process_setDriverTests(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET driverTests=" + this.embrace(s) + " WHERE " + this.primaryKey);
        }

        private void process_setDriverMailReport(String rep) throws Exception {
            this.executeQuery("INSERT INTO javatestreport (driverstarted, drivermailreport) VALUES ( " + this.embrace(this.driverStarted) + ", " + this.embrace(rep) + " ) ");
        }

        private void process_setTestUser(String user) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET testUser=" + this.embrace(user) + " WHERE " + this.primaryKey);
        }

        private void process_setTestSequence(String seq) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET testSequence=" + this.embrace(this.mangleSeqName(seq)) + " WHERE " + this.primaryKey);
        }

        private void process_setDriverEndStatus(String status) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET driverEndStatus=" + this.embrace(status) + " WHERE " + this.primaryKey);
        }

        private void process_setTestName(String test, String start) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET testName=" + this.embrace(test) + ", testStarted=" + this.embrace(start) + " WHERE " + this.primaryKey);
        }

        private void process_setTestStatus(String status) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET testStatus=" + this.embrace(status) + " WHERE " + this.primaryKey);
        }

        private void process_setDbRoot(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET dbRoot=" + this.embrace(s) + " WHERE " + this.primaryKey);
        }

        private void process_setDbOS(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET dbOS=" + this.embrace(s) + " WHERE " + this.primaryKey);
        }

        private void process_setDbVersion(String s) throws Exception {
            this.executeQuery("UPDATE javatestinfo SET dbVersion=" + this.embrace(s) + " WHERE " + this.primaryKey);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getNewValue().equals(evt.getOldValue())) {
                this.setTestStatus((String)evt.getNewValue());
            }
        }

        private void finish() {
            this.stopped = true;
            this.closeEntry();
            this.remoteWatchdog.setStopped(true);
            try {
                if (this.driverSocket != null) {
                    this.driverSocket.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.dbConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void addStartEntry() throws Exception {
            SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            this.driverStarted = mDateFormat.format(mStartDate);
            this.lastPing = new String(this.driverStarted);
            String qry = "INSERT INTO javatestinfo (driverIP, driverPort, driverFQHN, driverID, driverStarted, driverVersion, dbIP, dbFQHN, dbName, isRunning, lastUpdated) VALUES (" + this.embrace(this.driverIP) + "," + this.driverPort + "," + this.embrace(this.driverFQHN) + "," + this.embrace(this.driverID) + "," + this.embrace(this.driverStarted) + "," + this.embrace(this.driverVersion) + "," + this.embrace(this.dbIP) + "," + this.embrace(this.dbFQHN) + "," + this.embrace(this.dbName) + "," + "TRUE" + "," + this.embrace(this.lastPing) + ")";
            if (!this.executeQuery(qry).startsWith("OK")) {
                this.mUrl = null;
                this.mUseHTTP = false;
                this.initDBConnection();
                this.executeQuery(qry);
            }
            this.primaryKey = "driverStarted=" + this.embrace(this.driverStarted);
            if (!TestDriver.this.mOptions.getProperty("QALevel").equalsIgnoreCase("N")) {
                qry = "UPDATE javatestinfo SET QALEVEL=" + this.embrace(TestDriver.this.mOptions.getProperty("QALevel")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (!TestDriver.this.mOptions.getProperty("LCPoolNumber").equalsIgnoreCase("n/a")) {
                qry = "UPDATE javatestinfo SET LCPOOL_NO=" + this.embrace(TestDriver.this.mOptions.getProperty("LCPoolNumber")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (!TestDriver.this.mOptions.getProperty("ChangeListNumber").equalsIgnoreCase("n/a")) {
                qry = "UPDATE javatestinfo SET CHANGELIST=" + this.embrace(TestDriver.this.mOptions.getProperty("ChangeListNumber")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (Integer.parseInt(TestDriver.this.mOptions.getProperty("MakeKey")) != 0) {
                qry = "UPDATE javatestinfo SET MAKEKEY=" + Integer.parseInt(TestDriver.this.mOptions.getProperty("MakeKey")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (Integer.parseInt(TestDriver.this.mOptions.getProperty("MakeKey2")) != 0) {
                qry = "UPDATE javatestinfo SET MAKEKEY2=" + Integer.parseInt(TestDriver.this.mOptions.getProperty("MakeKey2")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (Integer.parseInt(TestDriver.this.mOptions.getProperty("InstKey")) != 0) {
                qry = "UPDATE javatestinfo SET INSTKEY=" + Integer.parseInt(TestDriver.this.mOptions.getProperty("InstKey")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
            if (Integer.parseInt(TestDriver.this.mOptions.getProperty("db-port")) != 7210) {
                qry = "UPDATE javatestinfo SET XSERVERPORT=" + Integer.parseInt(TestDriver.this.mOptions.getProperty("db-port")) + " WHERE " + this.primaryKey;
                this.executeQuery(qry);
            }
        }

        private synchronized void closeEntry() {
            if (this.primaryKey != null) {
                String qry = null;
                try {
                    qry = "UPDATE javatestinfo SET isRunning=FALSE, driverFinished=NOW() WHERE " + this.primaryKey;
                    this.executeQuery(qry);
                    if (TestDriver.this.mOptions.getProperty("DBJdbcVersion") != null) {
                        String jdbcVersion = TestDriver.this.mOptions.getProperty("DBJdbcVersion").substring(TestDriver.this.mOptions.getProperty("DBJdbcVersion").lastIndexOf(",") + 1).trim();
                        qry = "UPDATE javatestinfo SET JDBCDRIVERVERSION=" + this.embrace(jdbcVersion) + " WHERE " + this.primaryKey;
                        this.executeQuery(qry);
                    }
                    if (TestDriver.this.mOptions.getProperty("DBCpCVersion") != null) {
                        String cpcVersion = null;
                        String cpcVersionHelper = null;
                        cpcVersion = TestDriver.this.mOptions.getProperty("DBCpCVersion").trim().length() > 64 ? TestDriver.this.mOptions.getProperty("DBCpCVersion").trim().substring(0, 63) : TestDriver.this.mOptions.getProperty("DBCpCVersion").trim();
                        if (cpcVersion.indexOf("Build") != -1) {
                            cpcVersion = cpcVersionHelper = cpcVersion.substring(0, cpcVersion.indexOf("Build")) + "\n" + cpcVersion.substring(cpcVersion.indexOf("Build"));
                        }
                        qry = "UPDATE javatestinfo SET CPCVERSION=" + this.embrace(cpcVersion) + " WHERE " + this.primaryKey;
                        this.executeQuery(qry);
                    }
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Can not execute: " + qry + "\nget: " + ex.getLocalizedMessage());
                }
            }
        }

        private String embrace(String s) {
            return "'" + s + "'";
        }

        private final String mangleSeqName(String s) {
            if (!s.equals("n/a")) {
                if (s.indexOf(47) == -1 && s.indexOf(92) == -1) {
                    int lastP = s.lastIndexOf(46);
                    if (lastP != -1) {
                        char[] ca = s.toCharArray();
                        for (int i = lastP - 1; i >= 0; --i) {
                            if (ca[i] != '.') continue;
                            return new String(ca, i + 1, ca.length - (i + 1));
                        }
                        return s;
                    }
                    return s;
                }
                File f = new File(s);
                return f.getName();
            }
            return s;
        }

        private boolean initConfig() {
            try {
                if (!this.dbFQHN.equalsIgnoreCase("localhost")) {
                    this.dbIP = InetAddress.getByName(this.dbFQHN).getHostAddress();
                } else {
                    this.dbIP = InetAddress.getLocalHost().getHostAddress();
                    this.dbFQHN = InetAddress.getLocalHost().getHostName().toLowerCase();
                }
                this.driverIP = InetAddress.getLocalHost().getHostAddress();
                this.driverFQHN = InetAddress.getLocalHost().getHostName().toLowerCase();
                if (this.dbFQHN != null && this.dbFQHN.indexOf(".wdf.sap") != -1) {
                    this.dbFQHN = this.dbFQHN.substring(0, this.dbFQHN.indexOf(".wdf.sap"));
                }
                if (this.driverFQHN != null && this.driverFQHN.indexOf(".wdf.sap") != -1) {
                    this.driverFQHN = this.driverFQHN.substring(0, this.driverFQHN.indexOf(".wdf.sap"));
                }
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        private void initDBConnection() throws Exception {
            String dbName = (String)TestDriver.this.mOptions.get("SaveDBName");
            String dbHost = (String)TestDriver.this.mOptions.get("SaveDBHost");
            String dbUser = (String)TestDriver.this.mOptions.get("SaveDBUser");
            String dbUserPwd = (String)TestDriver.this.mOptions.get("SaveDBUser-password");
            if (this.mUrl != null) {
                if (TestDriver.this.mTestDriverProtocol != null && TestDriver.this.hasTrace()) {
                    TestDriver.this.mTestDriverProtocol.addItem("TestMonitorUpdater", 'T', "Try to use sqlservice via http [ " + this.mUrl + " ]");
                }
                this.mUseHTTP = true;
            } else {
                if (dbName == null || dbHost == null || dbUser == null || dbUserPwd == null) {
                    throw new Exception("TestUserMonitorUpdater.initDBConnection(): dbName=<" + dbName + "> dbHost=<" + dbHost + "> dbUser=<" + dbUser + "> dbUserPwd=<" + dbUserPwd + "> ");
                }
                if (TestDriver.this.mTestDriverProtocol != null && TestDriver.this.hasTrace()) {
                    TestDriver.this.mTestDriverProtocol.addItem("TestMonitorUpdater", 'T', "Try to use jdbc...");
                }
                Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
                this.dbConn = DriverManager.getConnection("jdbc:sapdb://" + dbHost + "/" + dbName, dbUser, dbUserPwd);
            }
        }

        private void initID() {
            this.driverID = "TestDriver 7.0.2 on " + this.driverIP + ":" + this.driverPort + " since " + System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStop(boolean b) {
            this.stopped = b;
            if (this.stopped) {
                TestMonitorUpdater testMonitorUpdater = this;
                synchronized (testMonitorUpdater) {
                    this.notifyAll();
                }
                while (this.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        static /* synthetic */ String access$800(TestMonitorUpdater x0) {
            return x0.driverID;
        }

        static /* synthetic */ String access$900(TestMonitorUpdater x0, String x1) {
            return x0.handleRemoteCommand(x1);
        }

        private final class TestMonitorUpdaterTask {
            private String cmd = null;
            private Hashtable args = new Hashtable();
            private boolean done = false;

            public TestMonitorUpdaterTask(String cmd, String[] args, String[] argvalues) {
                this.cmd = new String(cmd);
                if (args != null && argvalues != null && args.length == argvalues.length) {
                    for (int i = 0; i < args.length; ++i) {
                        this.args.put(args[i], argvalues[i]);
                    }
                }
            }

            public String getArg(String key) {
                if (key != null && this.args != null) {
                    return (String)this.args.get(key);
                }
                return null;
            }
        }

        private final class RemoteWatchdog
        extends Thread {
            private boolean stopped = false;

            private RemoteWatchdog() {
            }

            public void run() {
                try {
                    this.setPriority(1);
                }
                catch (Exception ex) {
                    if (TestDriver.this.mTestDriverProtocol != null) {
                        TestDriver.this.mTestDriverProtocol.addItem('W', "RemoteWatchdog failed to diminish priority. Exception: {" + ex.getMessage() + "}");
                    }
                    return;
                }
                try {
                    TestMonitorUpdater.this.driverSocket.setSoTimeout(5000);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                while (!this.stopped) {
                    Socket tmp = null;
                    try {
                        tmp = TestMonitorUpdater.this.driverSocket.accept();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    Socket watchdog = tmp;
                    if (watchdog == null) continue;
                    new Thread(this, watchdog){
                        private final /* synthetic */ Socket val$watchdog;
                        private final /* synthetic */ RemoteWatchdog this$2;
                        {
                            this.this$2 = this$2;
                            this.val$watchdog = val$watchdog;
                        }

                        public void run() {
                            try {
                                try {
                                    this.setPriority(1);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                OutputStreamWriter ow = new OutputStreamWriter(this.val$watchdog.getOutputStream());
                                String IDnl = new String(TestMonitorUpdater.access$800(RemoteWatchdog.access$700(this.this$2)) + "\n");
                                ow.write(IDnl, 0, IDnl.length());
                                ow.flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }.start();
                    new Thread(this, watchdog){
                        private final /* synthetic */ Socket val$watchdog;
                        private final /* synthetic */ RemoteWatchdog this$2;
                        {
                            this.this$2 = this$2;
                            this.val$watchdog = val$watchdog;
                        }

                        public void run() {
                            try {
                                String cmd;
                                try {
                                    this.setPriority(1);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                InputStreamReader ir = new InputStreamReader(this.val$watchdog.getInputStream());
                                BufferedReader br = new BufferedReader(ir);
                                while ((cmd = br.readLine()) != null) {
                                    String response = TestMonitorUpdater.access$900(RemoteWatchdog.access$700(this.this$2), cmd);
                                    if (response == null) continue;
                                    OutputStreamWriter writer = new OutputStreamWriter(this.val$watchdog.getOutputStream());
                                    writer.write(response + "\n");
                                    writer.flush();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }

            public void setStopped(boolean b) {
                this.stopped = b;
            }

            public boolean isStopped() {
                return this.stopped;
            }

            static /* synthetic */ TestMonitorUpdater access$700(RemoteWatchdog x0) {
                return x0.TestMonitorUpdater.this;
            }
        }
    }

    class Killer
    extends Thread {
        boolean keepRunning;
        long timeToKill = 0L;

        Killer(long time) {
            this.timeToKill = time;
            this.keepRunning = true;
            this.start();
        }

        public void run() {
            try {
                if (TestDriver.this.mTestDriverProtocol != null) {
                    TestDriver.this.mTestDriverProtocol.addItem('W', this.timeToKill / 1000L + " sec. for TestDriver shutdown left");
                }
                System.err.println(this.timeToKill / 1000L + " sec. for TestDriver shutdown left");
                Killer.sleep(this.timeToKill);
                if (this.keepRunning) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < mLastMessages.size(); ++i) {
                        sb.append((String)mLastMessages.get(i));
                        sb.append("\n");
                    }
                    if (this.keepRunning) {
                        System.err.println("Last states:\n" + sb.toString());
                        System.err.println("System.exit(-101)");
                        System.exit(-101);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void pleaseStop() {
            this.keepRunning = false;
        }
    }

    class SchedulerTable
    extends HashMap {
        private static final long serialVersionUID = 24L;
        private int mEntryCounter = 0;

        SchedulerTable() {
        }

        public void addItem(String key, long time) {
            this.put(new String(key), new Long(time));
            ++this.mEntryCounter;
        }

        public boolean containsItem(String key) {
            return this.containsKey(new String(key));
        }

        public int getEntryCounter() {
            return this.mEntryCounter;
        }

        public long getItem(String key) {
            return (Long)this.get(new String(key));
        }

        public void removeItem(String key) {
            this.remove(new String(key));
            --this.mEntryCounter;
        }
    }

    class Scheduler
    extends Thread {
        private SchedulerTable mSchedulerTable;
        private int mTestTotal = 0;
        private int mAbortTotal = 0;
        private int mInterruptTotal = 0;
        private Thread[] actThreadSet = null;

        public void interruptAllTests() {
            if (this.actThreadSet != null) {
                for (int i = 0; i < this.actThreadSet.length; ++i) {
                    try {
                        this.actThreadSet[i].interrupt();
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("Exception while interrupting running test: " + ex.getMessage());
                    }
                }
            }
        }

        Scheduler() {
            this.mSchedulerTable = new SchedulerTable();
        }

        public void run(TestCase[] pTestSet, long pTimeout) throws InterruptedException, NoSuchMethodException {
            int i;
            TestDriver.addState("  TestDriver.Scheduler->run(" + TestCase.getTestClassId() + ", " + pTimeout + ")");
            this.actThreadSet = new Thread[pTestSet.length];
            long start = System.currentTimeMillis();
            for (i = 0; i < pTestSet.length; ++i) {
                this.actThreadSet[i] = new Thread(pTestSet[i]);
                this.actThreadSet[i].start();
                if (pTimeout != 0L) {
                    if (pTimeout == -1L) {
                        pTimeout = 3600000L;
                        TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), "Started with default timeout (" + String.valueOf(pTimeout / 1000L / 60L) + " min.)\n getTestId()     : " + pTestSet[i].getTestId() + "\n original name   : " + pTestSet[i].getTestName() + "\n package and name: " + pTestSet[i].getTestClassName());
                    } else {
                        TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), "Started with timeout of this test: " + pTimeout + " milliseconds [" + String.valueOf(pTimeout / 1000L / 60L) + " min.]\n getTestId()     : " + pTestSet[i].getTestId() + "\n original name   : " + pTestSet[i].getTestName() + "\n package and name: " + pTestSet[i].getTestClassName());
                    }
                } else {
                    TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), "Started without timeout \n getTestId()     : " + pTestSet[i].getTestId() + "\n original name   : " + pTestSet[i].getTestName() + "\n package and name: " + pTestSet[i].getTestClassName());
                }
                this.mSchedulerTable.addItem(pTestSet[i].getTestId(), System.currentTimeMillis());
                ++this.mTestTotal;
            }
            while (this.mSchedulerTable.getEntryCounter() != 0) {
                Thread.sleep(2000L);
                for (i = 0; i < this.actThreadSet.length; ++i) {
                    if (!this.actThreadSet[i].isAlive()) {
                        if (!this.mSchedulerTable.containsItem(pTestSet[i].getTestId())) continue;
                        this.mSchedulerTable.removeItem(pTestSet[i].getTestId());
                        continue;
                    }
                    long deltaTime = System.currentTimeMillis() - this.mSchedulerTable.getItem(pTestSet[i].getTestId());
                    if (pTimeout == 0L || deltaTime <= pTimeout) continue;
                    try {
                        this.actThreadSet[i].interrupt();
                        pTestSet[i].interrupt();
                        this.mSchedulerTable.removeItem(pTestSet[i].getTestId());
                        TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), 'E', "Timeout threshold " + String.valueOf(pTimeout / 1000L) + " sec exceeded!");
                        for (int loopcounter = 0; this.actThreadSet[i].isAlive() && loopcounter < 30; ++loopcounter) {
                            Thread.sleep(1000L);
                        }
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (pTestSet[0].isInterrupted()) {
                TestDriver.this.mLastTestIsInterrupted = true;
                TestDriver.this.generateInterruptReportFiles(pTestSet[0].getTestId());
            }
            for (i = 0; i < pTestSet.length; ++i) {
                if (pTestSet[i].isInterrupted()) {
                    if (i == 0) {
                        Thread.sleep(4000L);
                    }
                    ++this.mInterruptTotal;
                    TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), 'A', "Test interrupted!");
                    continue;
                }
                if (pTestSet[i].isAborted()) {
                    ++this.mAbortTotal;
                    TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), 'A', "Test aborted!");
                    continue;
                }
                TestDriver.this.mTestDriverProtocol.addItem(pTestSet[i].getTestId(), "Test finished");
            }
            long stop = System.currentTimeMillis();
            TestDriver.this.mTestDriverProtocol.addItem(TestCase.getTestClassId(), "Elapsed total time: " + (stop - start) / 1000L + " sec");
        }

        public int getAbortTotal() {
            return this.mAbortTotal;
        }

        public int getInterruptTotal() {
            return this.mInterruptTotal;
        }

        public int getTestTotal() {
            return this.mTestTotal;
        }
    }
}

