/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.xlog;

import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.SubFailure;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FailureGroup {
    private String name;
    private int errorCount;
    private Vector failures;

    public FailureGroup(String string) {
        this.name = string;
        this.errorCount = -1;
        this.failures = new Vector();
    }

    public boolean hasErrors() {
        return this.getErrorCount() > 0;
    }

    public int getErrorCount() {
        if (this.errorCount == -1) {
            this.calculateErrorCount();
        }
        return this.errorCount;
    }

    protected void calculateErrorCount() {
        this.errorCount = 0;
        Enumeration enumeration = this.failures.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Failure) {
                ++this.errorCount;
                continue;
            }
            if (!(e instanceof FailureGroup)) continue;
            FailureGroup failureGroup = (FailureGroup)e;
            this.errorCount += failureGroup.getErrorCount();
        }
    }

    public void dumpPlain(PrintWriter printWriter, String string) {
        if (this.hasErrors()) {
            printWriter.println(string + this.name);
            String string2 = string + "    ";
            Enumeration enumeration = this.failures.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e = enumeration.nextElement();
                if (e instanceof Failure) {
                    object = string2 + e;
                    if (((String)object).length() > 79) {
                        object = ((String)object).substring(0, 76) + "...";
                    }
                    printWriter.println((String)object);
                    continue;
                }
                if (!(e instanceof FailureGroup)) continue;
                object = (FailureGroup)e;
                ((FailureGroup)object).dumpPlain(printWriter, string2);
            }
        }
        printWriter.flush();
    }

    public void dumpPlain(PrintWriter printWriter) {
        this.dumpPlain(printWriter, "");
    }

    void addFailure(Failure failure) {
        if (!(failure instanceof SubFailure)) {
            this.failures.add(failure);
        }
    }

    void addGroup(FailureGroup failureGroup) {
        this.failures.add(failureGroup);
    }
}

