/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.testdriver;

import com.sap.dbtechtest.util.testdriver.TestEnvironment;
import com.sap.dbtechtest.xlog.ExceptionOccurred;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;

public class TestCase {
    protected TestEnvironment requirements = null;

    public TestCase require(String string) {
        if (this.requirements == null) {
            this.requirements = new TestEnvironment();
        }
        this.requirements.addFeature(string);
        return this;
    }

    public TestCase requireMinKernelVersion(String string) {
        if (this.requirements == null) {
            this.requirements = new TestEnvironment();
        }
        this.requirements.actualKernelVersion = string;
        return this;
    }

    public TestCase require(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.require(stringArray[i]);
        }
        return this;
    }

    public TestCase disable(String string) {
        this.require("picky");
        return this;
    }

    public TestCase knownBug(String string) {
        this.require("picky");
        return this;
    }

    public TestCase bugFixed(String string) {
        return this;
    }

    public TestEnvironment getRequirements() {
        return this.requirements;
    }

    protected boolean testForException(String string, Class clazz, Exception exception, LogWriter logWriter) {
        boolean bl;
        Class<?> clazz2 = exception == null ? null : exception.getClass();
        if (clazz2 == null && clazz == null) {
            bl = true;
        } else if (clazz == null) {
            logWriter.addFailure(new ExceptionOccurred(string, exception));
            bl = false;
        } else if (clazz2 == null) {
            logWriter.addFailure(new Failure(string, "expecting Exception " + clazz.getName()));
            bl = false;
        } else if (clazz.isAssignableFrom(clazz2)) {
            logWriter.addInfo(string, "expected Exception " + exception);
            bl = true;
        } else {
            logWriter.addFailure(new ExceptionOccurred(string, exception));
            bl = false;
        }
        return bl;
    }
}

