/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.options;

import com.sap.dbtechtest.util.options.Options;
import java.io.PrintStream;

public abstract class OptionDesc {
    protected String name;
    protected String[] aliases;
    protected String helpString;
    protected Object defaultValue;

    public OptionDesc(String string, String string2, Object object, String[] stringArray) {
        this.name = string;
        this.helpString = string2;
        this.defaultValue = object;
        this.aliases = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setOptionValue(Options var1, String var2);

    public boolean hasMatchingOption(String string) {
        if (string.equals("--" + this.name)) {
            return true;
        }
        if (this.aliases != null) {
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public void help(PrintStream printStream) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t--" + this.name);
        if (this.aliases != null) {
            for (int i = 0; i < this.aliases.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.aliases[i]);
            }
        }
        if (this.helpString != null) {
            stringBuffer.append('\t');
            stringBuffer.append(this.helpString);
        }
        printStream.println(stringBuffer.toString());
    }

    public void dump(Options options) {
        Object object = options.get(this.name);
        System.out.println(this.name + ": " + object);
    }

    public static OptionDesc[] concatArrays(OptionDesc[] optionDescArray, OptionDesc[] optionDescArray2) {
        OptionDesc[] optionDescArray3 = new OptionDesc[optionDescArray.length + optionDescArray2.length];
        System.arraycopy(optionDescArray, 0, optionDescArray3, 0, optionDescArray.length);
        System.arraycopy(optionDescArray2, 0, optionDescArray3, optionDescArray.length, optionDescArray2.length);
        return optionDescArray3;
    }
}

