/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class YetAnotherTimestampTest
extends Test {
    private static final String help = "help for YetAnotherTimestampTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private static final TimeZone utcTimeZone = TimeZone.getTimeZone("GMT");
    private static final Calendar utcCalendar = Calendar.getInstance(utcTimeZone);
    private String context = "YetAnotherTimestampTest";
    private String tableName = "";

    public YetAnotherTimestampTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public YetAnotherTimestampTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        this.tableName = this.getUnicodeIdentifier(this.context);
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + " (b timestamp, c time, d date, e varchar(30))");
        Timestamp[] timestampArray = new Timestamp[]{new Timestamp(113, 1, 24, 9, 37, 55, 123456789), new Timestamp(113, 1, 24, 9, 37, 55, 18), new Timestamp(113, 1, 24, 23, 59, 59, 999999999), new Timestamp(113, 1, 23, 15, 17, 41, 0), new Timestamp(113, 1, 2, 11, 46, 48, 752000000), new Timestamp(70, 0, 1, 0, 0, 0, 0), new Timestamp(69, 11, 31, 23, 59, 59, 999999999), new Timestamp(100, 1, 29, 12, 59, 59, 999999999)};
        for (int i = 0; i < timestampArray.length; ++i) {
            this.testcase1(timestampArray[i]);
        }
    }

    void testcase1(Timestamp timestamp) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.tableName + " values (?,?,?,?)");
        preparedStatement.setTimestamp(1, timestamp, utcCalendar);
        preparedStatement.setTimestamp(2, timestamp, utcCalendar);
        preparedStatement.setTimestamp(3, timestamp, utcCalendar);
        preparedStatement.setTimestamp(4, timestamp, utcCalendar);
        preparedStatement.execute();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName);
        resultSet.next();
        this.log.addDifference(this.context, "check getTimestamp ", timestamp, resultSet.getTimestamp(1, utcCalendar));
        this.log.addDifference(this.context, "check getTimestamp from Date", new Date(timestamp.getTime()), new Date(resultSet.getTimestamp(3, utcCalendar).getTime()));
        this.log.addDifference(this.context, "check getTimestamp from String", timestamp, resultSet.getTimestamp(4, utcCalendar));
        this.log.addDifference(this.context, "check getTimestamp ColPerString", timestamp, resultSet.getTimestamp("B", utcCalendar));
        this.log.addDifference(this.context, "check getTimestamp from Date ColPerString", new Date(timestamp.getTime()), new Date(resultSet.getTimestamp("D", utcCalendar).getTime()));
        this.log.addDifference(this.context, "check getTimestamp from String ColPerString", timestamp, resultSet.getTimestamp("E", utcCalendar));
        this.log.addDifference(this.context, "check getTime ", new Time(timestamp.getTime()), resultSet.getTime(1, utcCalendar));
        this.log.addDifference(this.context, "check getTime ColPerString", new Time(timestamp.getTime()), resultSet.getTime("B", utcCalendar));
        this.log.addDifference(this.context, "check getDate ", new Date(timestamp.getTime()), resultSet.getDate(1, utcCalendar));
        this.log.addDifference(this.context, "check getDate from Date", new Date(timestamp.getTime()), resultSet.getDate(3, utcCalendar));
        this.log.addDifference(this.context, "check getDate from String", new Date(timestamp.getTime()), resultSet.getDate(4, utcCalendar));
        resultSet.close();
        this.stmt.executeUpdate("DELETE FROM " + this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        YetAnotherTimestampTest yetAnotherTimestampTest = new YetAnotherTimestampTest(stringArray);
        try {
            yetAnotherTimestampTest.runInner();
        }
        finally {
            yetAnotherTimestampTest.connection.close();
        }
        if (yetAnotherTimestampTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

