/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class UCS2JavaString
extends Test {
    private static final String help = "help for UCS2JavaString";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    final String u_StringC = "\u5386\u53f2\u56de\u987e\uff1a\u82cf\u963f";

    public UCS2JavaString(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UCS2JavaString(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UCS2JavaString";
        String string2 = this.getUnicodeIdentifier(string);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (COL1 Varchar(20) UNICODE, COL2 TIMESTAMP)");
        this.log.addInfo(string, "Inserting realy unicode strings");
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?)");
        preparedStatement.setString(1, "\u5386\u53f2\u56de\u987e\uff1a\u82cf\u963f");
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.execute();
        this.log.addInfo(string, "Querying realy unicode strings");
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("select * from " + string2 + " where col1 = ?");
        preparedStatement2.setString(1, "\u5386\u53f2\u56de\u987e\uff1a\u82cf\u963f");
        ResultSet resultSet = preparedStatement2.executeQuery();
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            this.log.addDifference(string, "getString(1)", "\u5386\u53f2\u56de\u987e\uff1a\u82cf\u963f", string3);
            Timestamp timestamp2 = resultSet.getTimestamp(2);
            this.log.addDifference(string, "getTimestamp(2)", timestamp, timestamp2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UCS2JavaString uCS2JavaString = new UCS2JavaString(stringArray);
        try {
            uCS2JavaString.runInner();
        }
        finally {
            uCS2JavaString.connection.close();
        }
        if (uCS2JavaString.log.hasErrors()) {
            System.exit(5);
        }
    }
}

