/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.SQLException;

public class FloatTest
extends ConversionTest {
    private static final String help = "help for FloatTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "SQL column definition", "FLOAT(14)", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("Float", new Float(0.0)), new EqualityTestCase("Float", new Float("1E-15")), new EqualityTestCase("Float", new Float("1E-16")), new EqualityTestCase("Float", new Float(Float.MIN_VALUE))};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), new EqualityTestCase("Float", new Float(0.0)), new EqualityTestCase("Float", new Float("1E-15")), new EqualityTestCase("Float", new Float("1E-16")), new EqualityTestCase("Float", new Float(Float.MIN_VALUE))};

    public FloatTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public FloatTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        FloatTest floatTest = new FloatTest(stringArray);
        try {
            floatTest.runInner();
        }
        finally {
            floatTest.connection.close();
        }
        if (floatTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

