/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.savepoint;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SavepointById
extends Test {
    private static final String help = "help for SavepointById";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SavepointById(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SavepointById(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "SavepointById";
        this.dropTable("SavepointById");
        this.stmt.execute("CREATE TABLE SavepointById (a int key)");
        String string2 = new String("Savepoint_MP");
        string = "INSERT";
        PreparedStatement preparedStatement = this.prepare("insert into SavepointById (a) values (?)");
        this.log.addInfo(string, "adding row through insert 1");
        preparedStatement.setInt(1, 1);
        preparedStatement.execute();
        this.connection.commit();
        string = "SET SAVEPOINT";
        Savepoint savepoint = this.connection.setSavepoint();
        string = "INSERT";
        preparedStatement.setInt(1, 2);
        preparedStatement.execute();
        string = "FETCH";
        ResultSet resultSet = this.select("select a from SavepointById order by a");
        int n = 0;
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            this.log.addDifference(string, "column a", new Integer(n + 1), new Integer(n2));
            ++n;
        }
        this.log.addDifference(string, "row count", new Integer(2), new Integer(n));
        this.log.addInfo("GET SAVEPOINTID", Integer.toString(savepoint.getSavepointId()));
        try {
            savepoint.getSavepointName();
            this.log.addFailure(new Failure("GET SAVEPOINTNAME", "expected SQLExeception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection.rollback(savepoint);
        string = "FETCH";
        ResultSet resultSet2 = this.select("select a from SavepointById order by a");
        int n3 = 0;
        while (resultSet2.next()) {
            int n4 = resultSet2.getInt(1);
            this.log.addDifference(string, "column a", new Integer(n3 + 1), new Integer(n4));
            ++n3;
        }
        this.log.addDifference(string, "row count", new Integer(1), new Integer(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SavepointById savepointById = new SavepointById(stringArray);
        try {
            savepointById.runInner();
        }
        finally {
            savepointById.connection.close();
        }
        if (savepointById.log.hasErrors()) {
            System.exit(5);
        }
    }
}

