/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ScrollablefResultSetTest
extends Test {
    private static final String help = "help for ScrollablefResultSetTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private static final String TEST_TABLE = "ScrollablefResultSetTest";
    private static final String TEST_COLUMN = "FINT";
    private static final String INSERT_STMT = "insert into ScrollablefResultSetTest(K1VC4, K2INT, FINT) VALUES ('1', ?, ?)";
    private static final String UPDATE_STMT = "update ScrollablefResultSetTest set FINT = ? where K1VC4 = '1' and K2INT = ?";
    private static final String DELETE_STMT = "delete from ScrollablefResultSetTest where K1VC4 = '1' and K2INT = ?";
    private static final String QUERY1 = "select FINT from ScrollablefResultSetTest order by FINT";
    private static final String QUERY2 = "select FINT from ScrollablefResultSetTest where K1VC4 <> '1'";
    private static final int ROW_CNT = 10;
    private Statement stmt1;
    private ResultSet rs;
    private int rowCnt;
    private int pos;
    private ArrayList resultValues;
    private static final int TOLERANT = 1;

    public ScrollablefResultSetTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ScrollablefResultSetTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = TEST_TABLE;
        this.dropTable(TEST_TABLE);
        this.stmt.execute("CREATE TABLE ScrollablefResultSetTest ( \"K1VC4\"               Varchar (4)     NOT NULL, \"K2INT\"               Integer    NOT NULL, \"FVC8\"               Varchar (8) , \"FVB16\"               Char (16) BYTE,\"FSHORT\"               Smallint,\"FINT\"               Integer,\"FBIGINT\"               Fixed (19,0),\"FDEC5_2\"               Fixed (5,2),\"FDOUBLE\"               Float (38),\"FDATE\"               Date,\"FTIME\"               Time,\"FTSTAMP\"               Timestamp,\"FCLOB\"               Long ,\"FBLOB\"               Long BYTE,PRIMARY KEY (\"K1VC4\", \"K2INT\"))");
        String string2 = this.getUnicodeIdentifier(string + "1");
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (" + "TIMESTMP  Fixed (19,0)    NOT NULL," + "VMID      Integer    NOT NULL," + "NOTEBOOK  Long BYTE," + "PRIMARY KEY (TIMESTMP, VMID))");
        this.setupTest();
        this.testResultSetTypeMetaData();
        this.testNonEmptyResultSet();
        this.testEmptyResultSet();
        this.testModifiedResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ScrollablefResultSetTest scrollablefResultSetTest = new ScrollablefResultSetTest(stringArray);
        try {
            scrollablefResultSetTest.runInner();
        }
        finally {
            scrollablefResultSetTest.connection.close();
        }
        if (scrollablefResultSetTest.log.hasErrors()) {
            System.exit(5);
        }
    }

    public void testResultSetTypeMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.verify(databaseMetaData.supportsResultSetType(1003), "ResultSet.TYPE_FORWARD_ONLY not supported", 1);
        this.verify(databaseMetaData.supportsResultSetType(1004), "ResultSet.TYPE_SCROLL_INSENSITIVE not supported", 1);
        this.verify(databaseMetaData.supportsResultSetType(1005), "ResultSet.TYPE_SCROLL_SENSITIVE not supported", 1);
    }

    public void testNonEmptyResultSet() throws SQLException {
        this.setupTest();
        this.checkNonEmptyResultSet(1004, 1);
        this.checkNonEmptyResultSet(1004, 2);
        this.checkNonEmptyResultSet(1005, 1);
        this.checkNonEmptyResultSet(1005, 2);
    }

    public void testEmptyResultSet() throws SQLException {
        this.checkEmptyResultSet(1004);
        this.checkEmptyResultSet(1005);
    }

    public void testModifiedResultSet() throws SQLException {
        this.checkInsertVisibility(1004);
        this.checkUpdateVisibility(1004);
        this.checkDeleteVisibility(1004);
    }

    private void checkNonEmptyResultSet(int n, int n2) throws SQLException {
        this.connection.setTransactionIsolation(n2);
        this.executeQuery(QUERY1, n);
        this.checkAbsolute(6);
        this.checkAbsolute(3);
        this.checkAbsolute(-2);
        this.checkAbsolute(12);
        this.checkAbsolute(-100);
        this.checkNext();
        this.checkRelative(3);
        this.checkRelative(this.rowCnt);
        this.checkPrevious();
        this.checkRelative(-5);
        this.checkRelative(0);
        this.checkRelative(-this.rowCnt);
        this.checkRelative(1);
        this.checkBeforeFirst();
        this.checkPrevious();
        this.checkNext();
        try {
            this.rs.close();
            this.stmt1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void executeQuery(String string, int n) {
        try {
            this.stmt1 = this.connection.createStatement(n, 1007);
            this.rs = this.stmt1.executeQuery(string);
            this.resultValues = new ArrayList(10);
            while (this.rs.next()) {
                this.resultValues.add(new Integer(this.rs.getInt(1)));
            }
            this.rowCnt = this.resultValues.size();
            this.pos = 0;
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on query execution: " + sQLException.getMessage());
        }
    }

    private void checkEmptyResultSet(int n) {
        this.executeQuery(QUERY2, n);
        this.checkAbsolute(5);
        this.checkAbsolute(-100);
        this.checkRelative(1);
        this.checkNext();
        this.checkPrevious();
        this.checkBeforeFirst();
        this.checkFirst();
        this.checkLast();
        this.checkAfterLast();
        this.checkIsBeforeFirst();
        this.checkFirst();
        this.checkIsLast();
        this.checkIsAfterLast();
        try {
            this.rs.close();
            this.stmt1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkInsertVisibility(int n) {
        this.setupTest();
        this.executeQuery(QUERY1, n);
        this.insertRow(11, 110);
        if (n == 1005) {
            this.resultValues.add(new Integer(110));
        }
        this.checkResultSet(n);
        try {
            this.rs.close();
            this.stmt1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkDeleteVisibility(int n) {
        this.setupTest();
        this.executeQuery(QUERY1, n);
        this.deleteRow(7);
        if (n == 1005) {
            this.resultValues.remove(6);
        }
        this.checkResultSet(n);
        try {
            this.rs.close();
            this.stmt1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkUpdateVisibility(int n) {
        this.setupTest();
        this.executeQuery(QUERY1, n);
        this.updateRow(5, 55);
        if (n == 1005) {
            this.resultValues.set(4, new Integer(55));
        }
        this.checkResultSet(n);
        try {
            this.rs.close();
            this.stmt1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkResultSet(int n) {
        String string = n == 1005 ? "sensitive" : "insensitiv";
        try {
            this.rs.beforeFirst();
            this.pos = 0;
            while (this.rs.next() && this.pos < this.resultValues.size()) {
                int n2;
                int n3 = this.rs.getInt(1);
                if (n3 == (n2 = ((Integer)this.resultValues.get(this.pos++)).intValue())) continue;
                this.flop("Unexpected value in " + string + " result set at row " + this.pos + " : fint = " + n3 + " , expected was " + n2);
                return;
            }
            this.verify(this.pos == this.resultValues.size(), "Unexpected number of rows in " + string + " result set: " + this.pos + " , expected was " + this.resultValues.size());
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occured when scrolling through " + string + " result set: " + sQLException.getMessage());
        }
    }

    private void checkIsBeforeFirst() {
        try {
            boolean bl = this.rs.isBeforeFirst();
            if (this.rowCnt == 0) {
                this.verify(!bl, "isBeforeFirst() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos <= 0;
                this.verify(bl == bl2, "isBeforeFirst() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isBeforeFirst() call: " + exception.getMessage());
        }
    }

    private void checkIsAfterLast() {
        try {
            boolean bl = this.rs.isAfterLast();
            if (this.rowCnt == 0) {
                this.verify(!bl, "isAfterLast() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos > this.rowCnt;
                this.verify(bl == bl2, "isAfterLast() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isAfterLast() call: " + exception.getMessage());
        }
    }

    private void checkIsFirst() {
        try {
            boolean bl = this.rs.isFirst();
            if (this.rowCnt == 0) {
                this.verify(!bl, "isFirst() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos == 1;
                this.verify(bl == bl2, "isFirst() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isFirst() call: " + exception.getMessage());
        }
    }

    private void checkIsLast() {
        try {
            boolean bl = this.rs.isLast();
            if (this.rowCnt == 0) {
                this.verify(!bl, "isLast() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos == this.rowCnt;
                this.verify(bl == bl2, "isLast() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isLast() call: " + exception.getMessage());
        }
    }

    private void checkGetRow() {
        try {
            int n = this.rs.getRow();
            int n2 = this.rowCnt == 0 || this.pos < 1 || this.pos > this.rowCnt ? 0 : this.pos;
            this.verify(n == n2, "getRow() returned wrong result: " + n + " , expected was " + n2, 1);
            if (n > 0) {
                this.checkRow(n);
            }
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on getRow() call: " + sQLException.getMessage());
        }
    }

    private void checkBeforeFirst() {
        this.pos = 0;
        try {
            this.rs.beforeFirst();
            this.checkCursorPosition();
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on beforeFirst() call: " + sQLException.getMessage());
        }
    }

    private void checkAfterLast() {
        this.pos = this.rowCnt + 1;
        try {
            this.rs.afterLast();
            this.checkCursorPosition();
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on beforeFirst() call: " + sQLException.getMessage());
        }
    }

    private void checkFirst() {
        this.pos = 1;
        try {
            boolean bl = this.rs.first();
            if (this.rowCnt == 0) {
                this.verify(!bl, "first() returned true on empty result set", 1);
            } else {
                this.verify(bl, "first() returned false on non-empty result set", 1);
                this.checkCursorPosition();
            }
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on first() call: " + sQLException.getMessage());
        }
    }

    private void checkLast() {
        this.pos = this.rowCnt;
        try {
            boolean bl = this.rs.last();
            if (this.rowCnt == 0) {
                this.verify(!bl, "last() returned true on empty result set", 1);
            } else {
                this.verify(bl, "last() returned false on non-empty result set", 1);
                this.checkCursorPosition();
            }
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred on first() call: " + sQLException.getMessage());
        }
    }

    private void checkNext() {
        try {
            boolean bl = this.rs.next();
            if (this.rowCnt == 0) {
                this.verify(!bl, "next() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos < this.rowCnt;
                this.verify(bl == bl2, "next() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
                if (this.pos <= this.rowCnt) {
                    ++this.pos;
                }
                this.checkCursorPosition();
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isBeforeFirst() call: " + exception.getMessage());
        }
    }

    private void checkPrevious() {
        try {
            boolean bl = this.rs.previous();
            if (this.rowCnt == 0) {
                this.verify(!bl, "previous() returned true on empty result set", 1);
            } else {
                boolean bl2 = this.pos > 1;
                this.verify(bl == bl2, "previous() returned wrong result: " + bl + " , cursor position is " + this.pos, 1);
                if (this.pos > 0) {
                    --this.pos;
                }
                this.checkCursorPosition();
            }
        }
        catch (Exception exception) {
            this.flop("SQLException occurred on isBeforeFirst() call: " + exception.getMessage());
        }
    }

    private void checkAbsolute(int n) {
        block3: {
            try {
                boolean bl = this.rs.absolute(n);
                if (n == 0) {
                    this.flop("absolute(0) does not throw an SQLException as expected");
                    return;
                }
                boolean bl2 = Math.abs(n) <= this.rowCnt;
                this.verify(bl == bl2, "absolute() returned wrong result: " + bl + " , expected was " + bl2, 1);
                this.pos = n > 0 ? Math.min(n, this.rowCnt + 1) : Math.max(0, this.rowCnt + n + 1);
                this.checkCursorPosition();
            }
            catch (SQLException sQLException) {
                if (n == 0) break block3;
                this.flop("SQLException occurred on absolute(" + n + ") call: " + sQLException.getMessage());
            }
        }
    }

    private void checkRelative(int n) {
        block3: {
            boolean bl = this.rowCnt == 0 || this.pos <= 0 || this.pos > this.rowCnt;
            try {
                boolean bl2 = this.rs.relative(n);
                if (bl) {
                    this.flop("relative() does not throw an SQLException as expected");
                    return;
                }
                this.pos = n >= 0 ? Math.min(this.pos + n, this.rowCnt + 1) : Math.max(0, this.pos + n);
                boolean bl3 = this.pos > 0 && this.pos <= this.rowCnt;
                this.verify(bl2 == bl3, "relative() returned wrong result: " + bl2 + " , expected was " + bl3, 1);
                this.checkCursorPosition();
            }
            catch (SQLException sQLException) {
                if (bl) break block3;
                this.flop("SQLException occurred on relative(" + n + ") call: " + sQLException.getMessage());
            }
        }
    }

    private void checkRow(int n) {
        int n2 = (Integer)this.resultValues.get(n - 1);
        try {
            int n3 = this.rs.getInt(1);
            this.verify(n3 == n2, "getInt(1)=" + n3 + " , expected was " + n2, 1);
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred when getting column 1 from result set: " + sQLException.getMessage());
        }
    }

    private void checkCursorPosition() {
        this.checkIsBeforeFirst();
        this.checkIsFirst();
        this.checkIsLast();
        this.checkIsAfterLast();
        this.checkGetRow();
    }

    private void insertRow(int n, int n2) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(INSERT_STMT);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred when inserting a row into ScrollablefResultSetTest: " + sQLException.getMessage());
        }
    }

    private void updateRow(int n, int n2) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(UPDATE_STMT);
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred when updating a row into ScrollablefResultSetTest: " + sQLException.getMessage());
        }
    }

    private void deleteRow(int n) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(DELETE_STMT);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.flop("SQLException occurred when deleting a row into ScrollablefResultSetTest: " + sQLException.getMessage());
        }
    }

    private void setupTest() {
        PreparedStatement preparedStatement = null;
        try {
            Connection connection = this.connection;
            preparedStatement = connection.prepareStatement("delete from ScrollablefResultSetTest");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(INSERT_STMT);
            for (int i = 1; i <= 10; ++i) {
                int n = i * 10;
                preparedStatement.setInt(1, i);
                preparedStatement.setInt(2, n);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.flop("Couldn't create test data in table ScrollablefResultSetTest: " + sQLException);
        }
    }

    private void flop(String string) {
        this.log.addFailure(new Failure(string));
    }

    private void flop(String string, String string2, int n) {
        this.flop(string);
    }

    protected final void verify(boolean bl, String string) {
        this.verify(bl, string, null, 2);
    }

    protected final void verify(boolean bl, String string, String string2) {
        this.verify(bl, string, string2, 2);
    }

    protected final void verify(boolean bl, String string, int n) {
        this.verify(bl, string, null, n);
    }

    protected final void verify(boolean bl, String string, String string2, int n) {
        if (!bl) {
            this.flop(string, string2, n);
        }
    }
}

