/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongMix
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LongMix(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongMix(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("XI_AF_CPA_MAPPING");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + "   (            \"OBJECT_ID\"               Varchar (32)     NOT NULL    DEFAULT ' ',             \"NAME\"               Varchar (127)     NOT NULL    DEFAULT ' ',             \"SOURCE_XML\"               Long ,             \"TARGET_XML\"               Long ,             \"METADATA_XML\"               Long ,             \"ADD_MD_XML\"               Long ,             \"INSTANCE_XML\"               Long ,             \"SOURCECODE\"               Long ,             \"BYTECODE\"               Long BYTE,             PRIMARY KEY (\"OBJECT_ID\")             )");
        this.stmt.execute("INSERT INTO " + string + " (OBJECT_ID, NAME) VALUES('testId', 'testid')");
        this.connection.commit();
        this.connection.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepare("UPDATE " + string + " SET \"ADD_MD_XML\" = ?,\"BYTECODE\" = ?,\"TARGET_XML\" = ?,\"INSTANCE_XML\" = ?,\"METADATA_XML\" = ?,\"SOURCE_XML\" = ?,\"NAME\" = ?,\"SOURCECODE\" = ? WHERE \"OBJECT_ID\" = ?");
        this.connection.setAutoCommit(true);
        String string2 = "additionalMetadataXML";
        StringReader stringReader = new StringReader(string2);
        byte[] byArray = new byte[205256];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string3 = "targetXML";
        StringReader stringReader2 = new StringReader(string3);
        String string4 = "instanceXML";
        StringReader stringReader3 = new StringReader(string4);
        String string5 = "metadataXML";
        StringReader stringReader4 = new StringReader(string5);
        String string6 = "sourceXML";
        StringReader stringReader5 = new StringReader(string6);
        String string7 = "testid";
        String string8 = "sourcecode";
        StringReader stringReader6 = new StringReader(string8);
        String string9 = "testId";
        preparedStatement.setCharacterStream(1, (Reader)stringReader, string2.length());
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, byArray.length);
        preparedStatement.setCharacterStream(3, (Reader)stringReader2, string3.length());
        preparedStatement.setCharacterStream(4, (Reader)stringReader3, string4.length());
        preparedStatement.setCharacterStream(5, (Reader)stringReader4, string5.length());
        preparedStatement.setCharacterStream(6, (Reader)stringReader5, string6.length());
        preparedStatement.setString(7, string7);
        preparedStatement.setCharacterStream(8, (Reader)stringReader6, string8.length());
        preparedStatement.setString(9, string9);
        preparedStatement.execute();
        ResultSet resultSet = this.stmt.executeQuery("SELECT ADD_MD_XML, BYTECODE FROM " + string + " WHERE OBJECT_ID='testId'");
        resultSet.next();
        if (!resultSet.getString(1).equals(string2)) {
            this.log.addFailure(new Failure("FIRST LONG CONTENT IS DIFFERENT"));
        }
        if (resultSet.getBytes(2).length != 205256) {
            this.log.addFailure(new Failure("LONG LENGTH IS DIFFERENT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongMix longMix = new LongMix(stringArray);
        try {
            longMix.runInner();
        }
        finally {
            longMix.connection.close();
        }
        if (longMix.log.hasErrors()) {
            System.exit(5);
        }
    }
}

