/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.connection;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class CancelBlockingThread
extends Test {
    private static final String help = "help for CancelBlockingThread";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CancelBlockingThread(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CancelBlockingThread(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "CancelBlockingThread";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a varchar(100))");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES ('Weltjugendtag')");
        this.connection.commit();
        Connection connection = DriverManager.getConnection(this.options.getConnectURL(), this.getUsername(), this.getPasswd());
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        InsertThread insertThread = new InsertThread(statement, this.log, string2);
        Connection connection2 = DriverManager.getConnection(this.options.getConnectURL(), this.getUsername(), this.getPasswd());
        connection2.setAutoCommit(false);
        Statement statement2 = connection2.createStatement();
        InsertThread insertThread2 = new InsertThread(statement2, this.log, string2);
        insertThread.start();
        while (!insertThread.habeFertig) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        insertThread2.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        insertThread2.cancel();
        try {
            insertThread2.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        System.out.println("hallo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CancelBlockingThread cancelBlockingThread = new CancelBlockingThread(stringArray);
        try {
            cancelBlockingThread.runInner();
        }
        finally {
            cancelBlockingThread.connection.close();
        }
        if (cancelBlockingThread.log.hasErrors()) {
            System.exit(5);
        }
    }

    public class InsertThread
    extends Thread {
        private Statement stmt = null;
        private LogWriter log = null;
        public boolean habeFertig = false;
        private String tabname;

        public InsertThread(Statement statement, LogWriter logWriter, String string) {
            this.stmt = statement;
            this.log = logWriter;
            this.tabname = string;
        }

        public void run() {
            try {
                this.log.addInfo("before insert");
                this.stmt.execute("UPDATE " + this.tabname + " SET A = 'Weltjugendtag' WHERE A='Weltjugendtag'");
                this.log.addInfo("after insert");
                this.habeFertig = true;
            }
            catch (SQLException sQLException) {
                this.log.addFailure(new Failure(sQLException.toString()));
            }
        }

        public void cancel() throws SQLException {
            this.stmt.cancel();
        }

        public void commit() throws SQLException {
            this.stmt.getConnection().commit();
        }
    }
}

