/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.xlog.LogWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OriginalTp2Init {
    private static final int BRANCH_FILLER_SIZE = 90;
    private static final int TELLER_FILLER_SIZE = 89;
    private static final int ACCOUNT_FILLER_SIZE = 83;
    public static final int HISTORY_FILLER_SIZE = 26;
    public static final int BRANCH_ENTRIES = 1000;
    public static final int TELLER_ENTRIES = 10000;
    public static final int NO_OF_ACCOUNTS = 100000;
    public static final int HISTORY_ENTRIES = 10000;
    private static final int BATCH_SIZE = 50;
    private static final int MAX_SCALE_FACTOR = 8;
    private static long branchKeySize;
    private static long tellerKeySize;
    private static long accountKeySize;
    private int sizeFactor = 1;
    private LogWriter log;
    static final boolean debug_insert = false;
    private FileWriter fos;

    public OriginalTp2Init(LogWriter logWriter) {
        this.log = logWriter;
    }

    protected void fillTables(Connection connection, int n) throws SQLException {
        this.createTestTables(connection);
        this.fillTableBranch(connection, n);
        this.fillTableTeller(connection, n);
        this.fillTableAccount(connection, n);
        this.fillTableHistory(connection, n);
    }

    private void createTestTables(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("DROP TABLE branch");
        }
        catch (SQLException sQLException) {
            this.log.addInfo("Drop table failed: " + sQLException.toString());
        }
        try {
            statement.executeUpdate("DROP TABLE teller");
        }
        catch (SQLException sQLException) {
            this.log.addInfo("Drop table failed: " + sQLException.toString());
        }
        try {
            statement.executeUpdate("DROP TABLE account");
        }
        catch (SQLException sQLException) {
            this.log.addInfo("Drop table failed: " + sQLException.toString());
        }
        try {
            statement.executeUpdate("DROP TABLE history");
        }
        catch (SQLException sQLException) {
            this.log.addInfo("Drop table failed: " + sQLException.toString());
        }
        branchKeySize = Math.round(Math.log(1000 * this.sizeFactor) / Math.log(10.0) + 1.0);
        this.log.addInfo("BRANCH key: CHAR(" + branchKeySize + ")");
        tellerKeySize = Math.round(Math.log(10000 * this.sizeFactor) / Math.log(10.0) + 1.0);
        this.log.addInfo("TELLER key: CHAR(" + tellerKeySize + ")");
        accountKeySize = Math.round(Math.log(100000 * this.sizeFactor) / Math.log(10.0) + 5.0);
        this.log.addInfo("ACCOUNT/HISTORY key: CHAR(" + accountKeySize + ")");
        statement.executeUpdate("CREATE TABLE branch ( BRANCH_KEY\tCHAR(" + branchKeySize + ")," + " BRANCH_VALUE\tNUMERIC(12)," + " BRANCH_FILLER\tCHAR(" + 90 + "), primary key (BRANCH_KEY))");
        statement.executeUpdate("CREATE TABLE teller ( TELLER_KEY\tCHAR(" + tellerKeySize + ")," + " TELLER_VALUE\tNUMERIC(12)," + " TELLER_FILLER\tCHAR(" + 89 + "), primary key (TELLER_KEY))");
        statement.executeUpdate("CREATE TABLE account ( ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_VALUE\t\tNUMERIC(12)," + " ACCOUNT_FILLER\tCHAR(" + 83 + "), primary key (ACCOUNT_KEY))");
        statement.executeUpdate("CREATE TABLE history ( ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_ADD\t\tNUMERIC(12)," + " BRANCH_KEY\t\tCHAR(3)," + " TELLER_KEY\t\tCHAR(4)," + " HISTORY_FILLER\tCHAR(" + 26 + "))");
        for (int i = 0; i < 8; ++i) {
            statement = connection.createStatement();
            try {
                statement.executeUpdate("DROP TABLE branch_" + i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE teller_" + i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE account_" + i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.executeUpdate("DROP TABLE history_" + i);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            branchKeySize = Math.round(Math.log(1000 * this.sizeFactor) / Math.log(10.0) + 1.0);
            this.log.addInfo("BRANCH_" + i + " key: CHAR(" + branchKeySize + ")");
            tellerKeySize = Math.round(Math.log(10000 * this.sizeFactor) / Math.log(10.0) + 1.0);
            this.log.addInfo("TELLER_" + i + " key: CHAR(" + tellerKeySize + ")");
            accountKeySize = Math.round(Math.log(100000 * this.sizeFactor) / Math.log(10.0) + 5.0);
            this.log.addInfo("ACCOUNT/HISTORY_" + i + " key: CHAR(" + accountKeySize + ")");
            statement.executeUpdate("CREATE TABLE branch_" + i + "(" + " BRANCH_KEY\tCHAR(" + branchKeySize + ")," + " BRANCH_VALUE\tNUMERIC(12)," + " BRANCH_FILLER\tCHAR(" + 90 + "), primary key (BRANCH_KEY))");
            statement.executeUpdate("CREATE TABLE teller_" + i + "(" + " TELLER_KEY\tCHAR(" + tellerKeySize + ")," + " TELLER_VALUE\tNUMERIC(12)," + " TELLER_FILLER\tCHAR(" + 89 + "), primary key (TELLER_KEY))");
            statement.executeUpdate("CREATE TABLE account_" + i + "(" + " ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_VALUE\t\tNUMERIC(12)," + " ACCOUNT_FILLER\tCHAR(" + 83 + "), primary key (ACCOUNT_KEY))");
            statement.executeUpdate("CREATE TABLE history_" + i + "(" + " ACCOUNT_KEY\t\tCHAR(" + accountKeySize + ")," + " ACCOUNT_ADD\t\tNUMERIC(12)," + " BRANCH_KEY\t\tCHAR(3)," + " TELLER_KEY\t\tCHAR(4)," + " HISTORY_FILLER\tCHAR(" + 26 + "))");
        }
        statement.close();
    }

    private void fillTableBranch(Connection connection, int n) throws SQLException {
        int n2;
        this.log.addInfo("Filling table BRANCH with " + 1000 * this.sizeFactor + " entries ...");
        String string = this.getFiller(90);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO branch VALUES (?,0,?)");
        for (n2 = 0; n2 < 1000 * this.sizeFactor; ++n2) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, string);
            preparedStatement.addBatch();
            if (n2 % 50 != 0) continue;
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        }
        preparedStatement.executeBatch();
        if (n != -1) {
            for (n2 = 0; n2 < 8; ++n2) {
                this.log.addInfo("Filling table BRANCH_" + n2 + " with " + 1000 * this.sizeFactor + " entries ...");
                preparedStatement = connection.prepareStatement("INSERT INTO branch_" + n2 + " VALUES (?,0,?)");
                for (int i = 0; i < 1000 * this.sizeFactor; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.setString(2, string);
                    preparedStatement.addBatch();
                    if (i % 50 != 0) continue;
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                }
                preparedStatement.executeBatch();
            }
        }
        preparedStatement.close();
    }

    private void fillTableTeller(Connection connection, int n) throws SQLException {
        int n2;
        this.log.addInfo("Filling table TELLER with " + 10000 * this.sizeFactor + " entries ...");
        String string = this.getFiller(89);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO teller VALUES (?,0,?)");
        for (n2 = 0; n2 < 10000 * this.sizeFactor; ++n2) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, string);
            preparedStatement.addBatch();
            if (n2 % 50 != 0) continue;
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        }
        preparedStatement.executeBatch();
        if (n != -1) {
            for (n2 = 0; n2 < 8; ++n2) {
                this.log.addInfo("Filling table TELLER_" + n2 + " with " + 10000 * this.sizeFactor + " entries ...");
                string = this.getFiller(89);
                preparedStatement = connection.prepareStatement("INSERT INTO teller_" + n2 + " VALUES (?,0,?)");
                for (int i = 0; i < 10000 * this.sizeFactor; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.setString(2, string);
                    preparedStatement.addBatch();
                    if (i % 50 != 0) continue;
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                }
                preparedStatement.executeBatch();
            }
        }
        preparedStatement.close();
    }

    private void fillTableAccount(Connection connection, int n) throws SQLException {
        int n2;
        int n3;
        this.log.addInfo("Filling table ACCOUNT with " + 100000 * this.sizeFactor + " entries ...");
        String string = this.getFiller(83);
        int n4 = 100;
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO account VALUES (?,0,?)");
        for (n3 = 0; n3 < 1000 * this.sizeFactor; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                long l = (long)(n3 * n4) * 10000L + (long)n2;
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, string);
                preparedStatement.addBatch();
                if ((n3 * 1000 * this.sizeFactor + n2) % 50 != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        preparedStatement.executeBatch();
        if (n != -1) {
            for (n3 = 0; n3 < 8; ++n3) {
                this.log.addInfo("Filling table ACCOUNT_" + n3 + " with " + 100000 * this.sizeFactor + " entries ...");
                string = this.getFiller(83);
                n4 = 100;
                preparedStatement = connection.prepareStatement("INSERT INTO account_" + n3 + " VALUES (?,0,?)");
                for (n2 = 0; n2 < 1000 * this.sizeFactor; ++n2) {
                    for (int i = 0; i < n4; ++i) {
                        long l = (long)(n2 * n4) * 10000L + (long)i;
                        preparedStatement.setLong(1, l);
                        preparedStatement.setString(2, string);
                        preparedStatement.addBatch();
                        if ((n2 * 1000 * this.sizeFactor + i) % 50 != 0) continue;
                        preparedStatement.executeBatch();
                        preparedStatement.clearBatch();
                    }
                }
                preparedStatement.executeBatch();
            }
        }
        preparedStatement.close();
    }

    private void fillTableHistory(Connection connection, int n) throws SQLException {
        int n2;
        this.log.addInfo("Filling table HISTORY with " + 10000 * this.sizeFactor + " entries ...");
        String string = this.getFiller(26);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO history VALUES ('9999999999',0,'999','9999',?)");
        for (n2 = 0; n2 < 10000 * this.sizeFactor; ++n2) {
            preparedStatement.setString(1, string);
            preparedStatement.addBatch();
            if (n2 % 50 != 0) continue;
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        }
        preparedStatement.executeBatch();
        if (n != -1) {
            for (n2 = 0; n2 < 8; ++n2) {
                this.log.addInfo("Filling table HISTORY_" + n2 + " with " + 10000 * this.sizeFactor + " entries ...");
                preparedStatement = connection.prepareStatement("INSERT INTO history_" + n2 + " VALUES ('9999999999',0,'999','9999',?)");
                for (int i = 0; i < 10000 * this.sizeFactor; ++i) {
                    preparedStatement.setString(1, string);
                    preparedStatement.addBatch();
                    if (i % 50 != 0) continue;
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                }
                preparedStatement.executeBatch();
            }
        }
        preparedStatement.close();
    }

    private String getFiller(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('x');
        }
        return stringBuffer.toString();
    }

    public void putTestTablesInCache(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM account");
        while (resultSet.next()) {
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM branch");
        while (resultSet.next()) {
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM teller");
        while (resultSet.next()) {
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM history");
        while (resultSet.next()) {
        }
        resultSet.close();
        for (int i = 0; i < 8; ++i) {
            resultSet = statement.executeQuery("SELECT * FROM account_" + i);
            while (resultSet.next()) {
            }
            resultSet.close();
            resultSet = statement.executeQuery("SELECT * FROM branch_" + i);
            while (resultSet.next()) {
            }
            resultSet.close();
            resultSet = statement.executeQuery("SELECT * FROM teller_" + i);
            while (resultSet.next()) {
            }
            resultSet.close();
            resultSet = statement.executeQuery("SELECT * FROM history_" + i);
            while (resultSet.next()) {
            }
            resultSet.close();
        }
        statement.close();
        connection.commit();
    }

    public static long getAccountKeySize() {
        return accountKeySize;
    }

    public static long getBranchKeySize() {
        return branchKeySize;
    }

    public static long getTellerKeySize() {
        return tellerKeySize;
    }
}

