/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class Logger {
    public static short CURRDEBUG = (short)100;
    public static short QUIET = (short)40;
    public static short STANDARD = (short)30;
    public static short VERBOSE = (short)20;
    public static short DEBUG = (short)10;
    public static final String DEBUGLEVEL = "DEBUG";
    public static final String VERBOSELEVEL = "VERBOSE";
    public static final String STANDARDLEVEL = "STANDARD";
    public static final String QUIETLEVEL = "QUIET";
    public static final String[] levels = new String[]{"DEBUG", "VERBOSE", "STANDARD", "QUIET"};
    private static short level = STANDARD;
    private static boolean printStackTraces = false;
    private static boolean ECHOON = false;
    static volatile boolean USE_STDOUT = true;
    private static File m_StdOutFile = null;
    private static File m_StdErrFile = null;
    private static Vector listeners = new Vector();

    public static void setEcho(boolean isecho) {
        ECHOON = isecho;
    }

    public static boolean isEchoOn() {
        return ECHOON;
    }

    public static synchronized void setStdOutToFile(File stdOutFile) throws FileNotFoundException {
        if (stdOutFile == null || stdOutFile.isDirectory() || stdOutFile.exists() && !stdOutFile.canWrite()) {
            throw new FileNotFoundException("stdOutFile of Logger not okay");
        }
        m_StdOutFile = stdOutFile;
    }

    public static synchronized void setStdOutToSystemOut() {
        if (m_StdOutFile != null) {
            m_StdOutFile = null;
        }
    }

    public static synchronized boolean loggingToSystemOut() {
        return m_StdOutFile == null;
    }

    public static void setStdErrToFile(File stdErrFile) throws FileNotFoundException {
        if (stdErrFile == null || stdErrFile.isDirectory() || stdErrFile.exists() && !stdErrFile.canWrite()) {
            throw new FileNotFoundException("stdErrFile of Logger not okay");
        }
        m_StdErrFile = stdErrFile;
    }

    public static synchronized void setStdErrToSystemErr() {
        if (m_StdErrFile != null) {
            m_StdErrFile = null;
        }
    }

    public static synchronized boolean loggingToSystemErr() {
        return m_StdErrFile == null;
    }

    public static synchronized void error(String msg) {
        Logger.output(Logger.log_prefix() + "*** ERROR *** " + msg, null, m_StdErrFile, System.err);
    }

    public static synchronized void warning(String msg) {
        Logger.output(Logger.log_prefix() + "*** WARNING *** " + msg, null, m_StdErrFile, System.err);
    }

    public static void setLevel(short newlevel) {
        level = newlevel;
    }

    public static short getLevel() {
        return level;
    }

    public static void log(String msg) {
        Logger.log(STANDARD, msg);
    }

    public static void log(int level, String msg) {
        if (level < DEBUG || level > CURRDEBUG) {
            Logger.warning("Log level out of range, must be in range of DEBUG and QUIET");
        }
        if (level >= Logger.level) {
            Logger.output(Logger.log_prefix() + msg, null, m_StdOutFile, USE_STDOUT ? System.out : null);
        }
    }

    private static synchronized void output(String msg, Exception ex, File file, PrintStream stream) {
        try {
            if (file != null) {
                PrintStream out = new PrintStream(new FileOutputStream(file, true));
                Logger.output(msg, ex, out);
                if (ECHOON) {
                    Logger.output(msg, ex, stream);
                }
            } else {
                Logger.output(msg, ex, stream);
            }
        }
        catch (FileNotFoundException ignored) {
            // empty catch block
        }
    }

    private static void output(String msg, Exception ex, PrintStream stream) {
        if (stream == null) {
            return;
        }
        if (msg != null) {
            stream.println(msg);
            Logger.fireLogEvent(msg);
        }
        if (ex != null) {
            ex.printStackTrace(stream);
            Logger.fireLogEvent(ex);
        }
    }

    static void addLogListener(PropertyChangeListener al) {
        listeners.add(al);
    }

    static void removeLogListener(PropertyChangeListener al) {
        listeners.remove(al);
    }

    static void fireLogEvent(Exception ex) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            PropertyChangeListener al = (PropertyChangeListener)iter.next();
            al.propertyChange(new PropertyChangeEvent(ex, ex.getMessage(), null, ex));
        }
    }

    static void fireLogEvent(String s) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            PropertyChangeListener al = (PropertyChangeListener)iter.next();
            al.propertyChange(new PropertyChangeEvent(s, s, null, null));
        }
    }

    public static boolean setLevel(String newLevel) {
        if (DEBUGLEVEL.equalsIgnoreCase(newLevel)) {
            level = DEBUG;
            printStackTraces = true;
            return true;
        }
        if (VERBOSELEVEL.equalsIgnoreCase(newLevel)) {
            level = VERBOSE;
            return true;
        }
        if (STANDARDLEVEL.equalsIgnoreCase(newLevel)) {
            level = STANDARD;
            return true;
        }
        if (QUIETLEVEL.equalsIgnoreCase(newLevel)) {
            level = QUIET;
            return true;
        }
        level = STANDARD;
        return false;
    }

    private static String log_prefix() {
        DateFormat df = DateFormat.getTimeInstance(3);
        String time = df.format(new Date());
        return "[" + time + "] ";
    }

    public static void stackTrace(Exception e) {
        Logger.output(null, e, m_StdErrFile, System.err);
    }

    public static void errorMessage(String prefix, Exception e) {
        Logger.output(Logger.log_prefix() + prefix + " " + e.getMessage(), null, m_StdErrFile, System.err);
    }

    public static boolean isPrintStackTraces() {
        return printStackTraces;
    }

    public static void setPrintStackTraces(boolean pST) {
        printStackTraces = pST;
    }
}

