/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListener;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import com.sap.sapdb.upgradetest.ExecutorListenerDelegator;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.Iterator;
import java.util.Vector;

public class ExecutorDelegator
extends RemoteObject
implements RemoteExecutor {
    private volatile RemoteExecutor executor;
    private volatile RemoteExecutor currentDelegate = null;
    private volatile RemoteExecutor[] delegates = null;
    private String executorClass;
    private final Vector executorListeners = new Vector();
    private volatile transient Thread runThread;
    private final ExecutorListener exceptionListener = new ExecutorListenerDelegator(new ExecutorListenerAdapter(){

        public void exceptionOccurred(ExecutorEvent e) throws RemoteException {
            super.exceptionOccurred(e);
            ExecutorDelegator.this.hasExceptions = true;
            boolean goOn = false;
            try {
                goOn = ExecutorDelegator.this.currentDelegate.isForce();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!goOn) {
                ExecutorDelegator.this.interrupted = true;
            }
        }
    });
    private volatile boolean hasStarted = false;
    private volatile boolean hasFinished = false;
    private volatile boolean interrupted = false;
    private volatile boolean hasExceptions = false;
    private volatile boolean isSubProcess = false;
    private boolean isDone = false;

    public boolean isStarted() throws RemoteException {
        return this.hasStarted;
    }

    public boolean isForce() throws RemoteException {
        return false;
    }

    public Executor getExecutor() throws RemoteException {
        return this.executor.getExecutor();
    }

    public ExecutorDelegator(RemoteExecutor exe) throws RemoteException {
        this.executor = exe;
        Executor anexec = exe.getExecutor();
        this.executorClass = anexec != null ? anexec.getExecutorClass() : null;
        this.init(this.executor);
    }

    public ExecutorDelegator(Executor exe) throws RemoteException {
        this.executor = exe;
        this.executorClass = exe.getExecutorClass();
        this.init(this.executor);
    }

    private void init(RemoteExecutor exe) throws RemoteException {
        RemoteExecutor[] allDels = exe.getDelegates();
        this.delegates = new RemoteExecutor[allDels.length];
        for (int i = 0; i < allDels.length; ++i) {
            RemoteExecutor aDel = allDels[i];
            this.delegates[i] = aDel.getDelegates() != null ? new ExecutorDelegator(aDel) : aDel;
        }
    }

    void setIsSubProcess(boolean b) {
        this.isSubProcess = b;
    }

    private void setHasFinished(String finishedStatus) throws RemoteException {
        if (!this.hasFinished) {
            this.hasFinished = true;
            String terminated = this.interrupted ? "Finished" : (this.hasExceptions ? "Finished with Exceptions" : "Finished");
            this.fireRemoteStatusEvent(this.isSubProcess ? "subprocess finished" : "finished", terminated + " " + this.executor.getExecutor().shortName, finishedStatus);
        }
    }

    public void start() throws RemoteException {
        this.runThread = new Thread(){

            public void run() {
                try {
                    ExecutorDelegator.this.run();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        };
        this.runThread.start();
    }

    public void execute() throws RemoteException {
        this.run();
    }

    public void run() throws RemoteException {
        this.hasExceptions = false;
        this.hasFinished = false;
        this.hasStarted = true;
        this.interrupted = false;
        if (this.isDone) {
            return;
        }
        this.fireRemoteStatusEvent(this.isSubProcess ? "subprocess started" : "started", "Started " + this.executor.getExecutor().shortName, null);
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.interrupted) {
                this.currentDelegate = null;
                break;
            }
            this.currentDelegate = this.delegates[i];
            this.addExecutorListeners(this.currentDelegate);
            try {
                this.currentDelegate.execute();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.removeExecutorListeners(this.currentDelegate);
            if (!this.interrupted) continue;
            this.currentDelegate = null;
            break;
        }
        this.currentDelegate = null;
        String finishedStatus = "finished normally";
        if (this.interrupted && this.hasExceptions) {
            finishedStatus = "finished by exception";
        } else if (this.interrupted) {
            finishedStatus = "killed";
        }
        this.setHasFinished(finishedStatus);
        boolean forceExecutor = this.executor.isForce();
        if (!forceExecutor) {
            this.isDone = true;
        }
    }

    public boolean isRunning() throws RemoteException {
        return this.hasStarted && !this.hasFinished;
    }

    public boolean wasInterrupted() throws RemoteException {
        return this.interrupted;
    }

    public boolean isDone() throws RemoteException {
        if (this.isDone) {
            return true;
        }
        boolean retVal = this.hasStarted && !this.isRunning();
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i].isDone()) continue;
            retVal = false;
        }
        return retVal;
    }

    public void addExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners.add(l);
        if (this.currentDelegate != null) {
            this.currentDelegate.addExecutorListener(l);
        }
    }

    public void removeExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners.remove(l);
        if (this.currentDelegate != null) {
            this.currentDelegate.removeExecutorListener(l);
        }
    }

    void fireRemoteStatusEvent(String status, String msg, String finishedStatus) {
        Iterator iter = this.executorListeners.iterator();
        ExecutorEvent event = new ExecutorEvent("status event", msg, status, this.executorClass);
        event.setFinishedStatus(finishedStatus);
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.executorStatus(event);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }

    void addExecutorListeners(RemoteExecutor exe) throws RemoteException {
        Iterator iter = this.executorListeners.iterator();
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            exe.addExecutorListener(l);
        }
        exe.addExecutorListener(this.exceptionListener);
    }

    void removeExecutorListeners(RemoteExecutor exe) throws RemoteException {
        Iterator iter = this.executorListeners.iterator();
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            exe.removeExecutorListener(l);
        }
        exe.removeExecutorListener(this.exceptionListener);
    }

    public boolean destroy() throws RemoteException {
        boolean retVal = true;
        Exception anex = null;
        this.interrupted = true;
        try {
            if (this.currentDelegate != null) {
                retVal = this.currentDelegate.destroy();
            }
        }
        catch (Exception ex) {
            anex = ex;
        }
        try {
            if (this.runThread != null) {
                this.runThread.join();
            }
        }
        catch (InterruptedException ex) {
            anex = ex;
        }
        if (anex != null) {
            throw new RemoteException(anex.getMessage(), anex);
        }
        return retVal;
    }

    public RemoteExecutor[] getDelegates() throws RemoteException {
        return null;
    }

    public RemoteExecutor[] getDelegatesInternal() throws RemoteException {
        return this.delegates;
    }

    public void setDelegates(RemoteExecutor[] dels) throws RemoteException {
    }
}

