/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.ExceptionDialog;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterGUI;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterTreeModel;
import java.io.File;
import java.util.StringTokenizer;

class StarterEnv {
    public static final String LAST_LOADED_SEQFILES = "lastLoadedSeqFiles.properties";
    public static final String LAST_LOADED_FILES = "lastLoadedFiles.properties";
    public static final String HOSTS = "hosts.xml";
    private static File baseDir = null;
    private static File confDir = null;
    private static File seqFilesDir = null;
    private static File filesDir = null;
    private static StarterGUI starterGUI = null;

    StarterEnv() {
    }

    public static File getBaseDir() {
        return baseDir;
    }

    public static File getConfDir() {
        return confDir;
    }

    public static File getConfFile(String fileName) {
        return new File(confDir.getPath() + File.separator + fileName);
    }

    public static File getBaseSubDir(String subDirName) {
        File subDir = new File(StarterEnv.getBaseDir().getPath() + File.separator + subDirName);
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    public static File getSeqFilesDir() {
        return seqFilesDir;
    }

    public static File getFilesDir() {
        return filesDir;
    }

    public static void registerStarterGUI(StarterGUI starterGUI) {
        StarterEnv.starterGUI = starterGUI;
    }

    public static void throwException(Exception e) {
        if (starterGUI != null) {
            new ExceptionDialog(starterGUI, e).show();
        }
    }

    public static StarterGUI getStarterGUI() {
        return starterGUI;
    }

    public static StarterTreeModel getStarterTreeModel() {
        return starterGUI.getStarterTreeModel();
    }

    public static String extractExt(File file) {
        StringTokenizer ST = new StringTokenizer(file.getName(), ".");
        String ext = "";
        while (ST.hasMoreTokens()) {
            ext = ST.nextToken();
        }
        return ext;
    }

    static {
        baseDir = new File(System.getProperty("user.home") + File.separator + "tp2Starter");
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        confDir = StarterEnv.getBaseSubDir("conf");
        seqFilesDir = StarterEnv.getBaseSubDir("seqFiles");
        filesDir = StarterEnv.getBaseSubDir("files");
    }
}

