/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.starter.EditorApplet;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FileEditor
extends EditorApplet
implements DocumentListener {
    private JTextArea text = null;

    public FileEditor(File relatedFile) throws StarterException {
        super(relatedFile);
        this.initGUI();
        try {
            BufferedReader in = new BufferedReader(new FileReader(relatedFile));
            String line = null;
            while ((line = in.readLine()) != null) {
                this.text.append(line);
                this.text.append("\n");
            }
            in.close();
        }
        catch (IOException e) {
            throw new StarterException("Cannot read file " + relatedFile, e);
        }
        this.text.getDocument().addDocumentListener(this);
    }

    private void initGUI() {
        this.text = new JTextArea();
        this.text.setTabSize(2);
        this.add("Center", new JScrollPane(this.text));
    }

    protected String getContentAsString() throws StarterException {
        return this.text.getText();
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyChange();
    }
}

