/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.cases;

import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CompareAccessTypes
extends Tp2TestCase {
    public void runCase() throws Tp2Exception {
        TreeSet<AccessType> accessTypeProgram = new TreeSet<AccessType>();
        if (this.getCaseEnv().isPropSet("tp2.ext.accessTypeProgram")) {
            StringTokenizer ST = new StringTokenizer(this.getCaseEnv().getProp("tp2.ext.accessTypeProgram"), ";");
            while (ST.hasMoreTokens()) {
                accessTypeProgram.add(new AccessType(ST.nextToken()));
            }
        } else {
            accessTypeProgram.add(new AccessType("CPC_DIRECT-PL_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("CPC_DIRECT-STATEMENT-SYSTEM"));
            accessTypeProgram.add(new AccessType("CPC_DIRECT-CPP_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("CPC_VSERVER-PL_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("CPC_VSERVER-STATEMENT-SYSTEM"));
            accessTypeProgram.add(new AccessType("CPC_VSERVER-CPP_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("JDBC_SOCKET-PL_DBPROC-JAVA"));
            accessTypeProgram.add(new AccessType("JDBC_SOCKET-STATEMENT-JAVA"));
            accessTypeProgram.add(new AccessType("JDBC_SOCKET-CPP_DBPROC-JAVA"));
            accessTypeProgram.add(new AccessType("JDBC_NATIVE-PL_DBPROC-JAVA"));
            accessTypeProgram.add(new AccessType("JDBC_NATIVE-STATEMENT-JAVA"));
            accessTypeProgram.add(new AccessType("JDBC_NATIVE-CPP_DBPROC-JAVA"));
            accessTypeProgram.add(new AccessType("ODBC-STATEMENT-SYSTEM"));
            accessTypeProgram.add(new AccessType("ODBC-PL_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("ODBC-CPP_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("SQLDBC-STATEMENT-SYSTEM"));
            accessTypeProgram.add(new AccessType("SQLDBC-PL_DBPROC-SYSTEM"));
            accessTypeProgram.add(new AccessType("SQLDBC-CPP_DBPROC-SYSTEM"));
        }
        int[] userCountProgram = this.createUserCountProgramFromProperties();
        for (int i = 0; i < this.getTryCount(); ++i) {
            for (int k = 0; k < userCountProgram.length; ++k) {
                this.runAllUserTypes(userCountProgram[k], accessTypeProgram);
            }
        }
    }

    private void runAllUserTypes(int userCount, SortedSet accessTypeProgram) throws Tp2Exception {
        Iterator ats = accessTypeProgram.iterator();
        while (ats.hasNext()) {
            this.runOneAccessType(userCount, (AccessType)ats.next());
        }
    }

    private void runOneAccessType(int userCount, AccessType accessType) throws Tp2Exception {
        block2: {
            try {
                this.changeCurrentAccessType(accessType);
                this.stdOut("### Testing access type " + this.getCaseEnv().getCurrentAccessType().getCodeStr());
                this.runTestSafe(userCount);
            }
            catch (Tp2Exception e) {
                e.printStackTrace();
                this.getCaseEnv().logError("TestAll.runOneAccessType", "Unexpected exception", e);
                if (e.getAbortType() <= 3) break block2;
                throw e;
            }
        }
    }
}

