/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.lcbenchmarks;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class LcTransactionsMecki
extends PrimaryTest {
    public static final String VERSION = "1.0";
    private static final int MAXNOSTATEMENTS = 500;
    private static final int MAXSTMT_GROUPS = 120;
    public static int mTraceLevel;
    private static String mUserType;
    private static boolean mTraceOn;
    private static String mHostName;
    private static int mTestNumber;
    private TestStatementMonitor mMonitor = null;
    private Connection mExclusiveConnection = null;
    private TestStatement mExclusiveStatement = null;
    private int mStatementTaskId = 0;
    private Connection mPrepExclusiveConnection = null;
    private TestPreparedStatement mPrepExclusiveStatement = null;
    private int mPrepStatementTaskId = 0;
    private Connection mMeasureConnection = null;
    private TestStatement mMeasureStatement = null;
    private Connection mMainConnection = null;
    private TestStatement mMainStatement = null;
    private Random mRandomGenerator = new Random();
    private static final String mExUser = "LCTRANS";
    private static final String mExPassword = "LCTRANS";
    private DBM mDBMan = null;
    private Properties mDefResult;
    private Properties mOneResultRecord;
    private Properties[] mResults = new Properties[500];
    private int mTestRunId = 0;
    private int mStatementCounter = 0;
    private String mStmtDescription = "";
    private static TestDatabaseSap mTestDB;
    private static DBDescription mDbdescription;
    private static ServerNode mServernode;
    private static String mKernelVersion;
    protected int containerNo = 1;
    protected int objLength1 = 1000;
    protected int objLength2 = 2000;

    public static long getTimeout() {
        return 0L;
    }

    public static void prepare() throws TestCaseException {
        PrimaryTest.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block14: {
            mTraceLevel = LcTransactionsMecki.getParameterInt((String)"TraceLevel", (int)2);
            mTraceOn = LcTransactionsMecki.getParameterBoolean((String)"TraceOn", (boolean)false);
            mUserType = LcTransactionsMecki.getParameterString((String)"benchmark.case.user", (String)System.getProperty("user.name"));
            LcTransactionsMecki.printInfo(1, "LcTransactions", "*************************************************");
            LcTransactionsMecki.printInfo(1, "LcTransactions", "Starting LcTransactions - Version: 1.0");
            LcTransactionsMecki.printInfo(1, "LcTransactions", "*************************************************");
            LcTransactionsMecki.printInfo(2, "LcTransactions", "TraceLevel    = " + mTraceLevel);
            LcTransactionsMecki.printInfo(2, "LcTransactions", "TraceOn       = " + mTraceOn);
            LcTransactionsMecki.printInfo(2, "LcTransactions", "TestUser      = " + mUserType + "\n");
            this.setStatus("Creating DB users and connections");
            this.startUp();
            this.createTables();
            this.mDefResult = new Properties();
            this.setStatus("Executing transaction 1");
            this.executeTrans1();
            this.executeTrans2();
            this.executeTrans3();
            this.executeTrans4();
            this.writeResultsToProtocol();
            LcTransactionsMecki.addGlobalMessage((String)"run()", (char)'I', (String)"End of measurements! ");
            Object var3_1 = null;
            try {
                this.mMainStatement.close();
                this.mExclusiveStatement.close();
                this.mMeasureStatement.close();
                this.mPrepExclusiveStatement.close();
                StorableObject.closeConnection();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.mMainConnection.commit();
                this.mMainConnection.close();
                this.mExclusiveConnection.commit();
                this.mExclusiveConnection.close();
                this.mMeasureConnection.commit();
                this.mMeasureConnection.close();
                this.mPrepExclusiveConnection.commit();
                this.mPrepExclusiveConnection.close();
                StorableObject.closeConnection();
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (Exception e) {
                    LcTransactionsMecki.addGlobalMessage((String)"Method run", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
                    System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
                    Object var3_2 = null;
                    try {
                        this.mMainStatement.close();
                        this.mExclusiveStatement.close();
                        this.mMeasureStatement.close();
                        this.mPrepExclusiveStatement.close();
                        StorableObject.closeConnection();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        this.mMainConnection.commit();
                        this.mMainConnection.close();
                        this.mExclusiveConnection.commit();
                        this.mExclusiveConnection.close();
                        this.mMeasureConnection.commit();
                        this.mMeasureConnection.close();
                        this.mPrepExclusiveConnection.commit();
                        this.mPrepExclusiveConnection.close();
                        StorableObject.closeConnection();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.mMainStatement.close();
                    this.mExclusiveStatement.close();
                    this.mMeasureStatement.close();
                    this.mPrepExclusiveStatement.close();
                    StorableObject.closeConnection();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.mMainConnection.commit();
                    this.mMainConnection.close();
                    this.mExclusiveConnection.commit();
                    this.mExclusiveConnection.close();
                    this.mMeasureConnection.commit();
                    this.mMeasureConnection.close();
                    this.mPrepExclusiveConnection.commit();
                    this.mPrepExclusiveConnection.close();
                    StorableObject.closeConnection();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
        System.out.println("End of " + LcTransactionsMecki.getTestClassId());
    }

    public static String getTestClassId() {
        return "LcTransactions";
    }

    public void executeTrans1() {
        String lSqlString = "";
        boolean lCPUTime = false;
        boolean lResCount = false;
        Object rs = null;
        try {
            long lStart = System.currentTimeMillis();
            System.out.println("lStart = " + lStart);
            this.prCreateContainer(1, 1, "testteam", this.containerNo, 0);
            for (int i = 0; i < 10; ++i) {
                Oid oid = this.prCreateMyvarobj(1, "testteam", this.containerNo, this.objLength1, 0);
                this.prReadMyvarobj(1, "testteam", this.containerNo, oid, 0);
                this.prUpdateMyvarobj(1, "testteam", this.containerNo, oid, this.objLength2, 0);
                this.prReadMyvarobj(1, "testteam", this.containerNo, oid, 0);
                this.prRelease(1, oid, 0);
            }
            long lEnd = System.currentTimeMillis();
            System.out.println("lEnd = " + lEnd);
            long lRuntime = lEnd - lStart;
            System.out.println("lRuntime = " + lRuntime);
            this.storeResultsInJava(1, lRuntime, "first Transaction - var Objects");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void executeTrans2() {
        String lSqlString = "";
        boolean lCPUTime = false;
        boolean lResCount = false;
        Object rs = null;
        try {
            long lStart = System.currentTimeMillis();
            System.out.println("lStart = " + lStart);
            this.prCreateContainer(1, 3, "testteam", this.containerNo, 0);
            Oid oid = this.prCreateMyobj(1, "testteam", this.containerNo, 1000, 0);
            Oid oid2 = this.prCreateMyobj(1, "testteam", this.containerNo, 1001, 0);
            this.prCommit(1);
            if (this.prIsLocked(1, oid, 0)) {
                throw new TestCaseException("USER1 should not have a lock on object (OID: " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ").");
            }
            this.prLock(1, oid, 0);
            if (!this.prIsLocked(1, oid, 0)) {
                throw new TestCaseException("USER1 should have a lock on object (OID: " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ").");
            }
            this.prLock(2, oid, -51);
            if (this.prIsLocked(2, oid, 0)) {
                throw new TestCaseException("USER2 should not have a lock on object (OID: " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ").");
            }
            this.prRelease2(1, oid, 0);
            this.prDelete(1, oid2, -28006);
            this.prLock(1, oid2, 0);
            this.prDelete(1, oid2, 0);
            this.prCommit(1);
            this.prLock(2, oid2, -28819);
            this.prCommit(2);
            this.prLock(2, oid2, -28814);
            long lEnd = System.currentTimeMillis();
            System.out.println("lEnd = " + lEnd);
            long lRuntime = lEnd - lStart;
            System.out.println("lRuntime = " + lRuntime);
            this.storeResultsInJava(2, lRuntime, "second Transaction - objects");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void executeTrans3() {
        String lSqlString = "";
        boolean lCPUTime = false;
        boolean lResCount = false;
        Object rs = null;
        int MYOBJ_SMALL = 3;
        int MYOBJ_MEDIUM = 4;
        int MYOBJ_LARGE = 5;
        int MYOBJ_HUGE = 6;
        try {
            long lStart = System.currentTimeMillis();
            System.out.println("lStart = " + lStart);
            this.prCreateContainer(1, MYOBJ_LARGE, "testteam", this.containerNo, 0);
            for (int i = 0; i < 10; ++i) {
                Oid oid = this.prCreateMyObj(1, MYOBJ_LARGE, "testteam", this.containerNo, 0);
                this.prReadMyObj(1, MYOBJ_LARGE, oid, 0);
                this.prUpdateMyObj(1, MYOBJ_LARGE, oid, 0);
                this.prReadMyObj(1, MYOBJ_LARGE, oid, 0);
                this.prDropMyObj(1, MYOBJ_LARGE, oid, 0);
            }
            long lEnd = System.currentTimeMillis();
            System.out.println("lEnd = " + lEnd);
            long lRuntime = lEnd - lStart;
            System.out.println("lRuntime = " + lRuntime);
            this.storeResultsInJava(1, lRuntime, "3rd Transaction - normal Objects");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void executeTrans4() {
        String lSqlString = "";
        boolean lCPUTime = false;
        boolean lResCount = false;
        Object rs = null;
        int MYOBJ_SMALL = 3;
        int MYOBJ_MEDIUM = 4;
        int MYOBJ_LARGE = 5;
        int MYOBJ_HUGE = 6;
        int NO_OF_OPERATIONS = 10;
        try {
            System.out.println("trans4: NO_OF_OPERATIONS = " + NO_OF_OPERATIONS);
            long lStart = System.currentTimeMillis();
            System.out.println("trans4: lStart = " + lStart);
            this.prCreateContainer(1, MYOBJ_LARGE, "testteam", this.containerNo, 0);
            Oid oid = this.prCreateMyObj(1, MYOBJ_LARGE, "testteam", this.containerNo, 0);
            this.prReleaseMyObjMultiple(1, MYOBJ_LARGE, NO_OF_OPERATIONS, oid, 0);
            long lEnd = System.currentTimeMillis();
            System.out.println("trans4: lEnd = " + lEnd);
            long lRuntime = lEnd - lStart;
            System.out.println("trans4: lRuntime = " + lRuntime);
            this.storeResultsInJava(1, lRuntime, "4rd Transaction - normal Objects released multiple");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return str + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    private void writeResultsToMyQADB() {
        String lColumn = "";
        String lValue = "";
        long lTransCnt = 0L;
        long lRuntime = 0L;
        String lTransDesc = "";
        String lSql = "";
        Object lContentsOneRecord = null;
        Statement lStmt = null;
        try {
            lStmt = StorableObject.getConnection().createStatement();
            ResultSet rs = this.mMainStatement.executeQuery("SELECT * FROM RESULTS");
            while (rs.next()) {
                lTransCnt = rs.getInt("TRANS_CNT");
                lTransDesc = rs.getString("TRANS_DESCRIPTION");
                lRuntime = rs.getLong("RUN_TIME");
                Timestamp lTimestamp = rs.getTimestamp("DATE_TIME");
                lSql = "INSERT lcbench_results set TRANS_CNT = " + lTransCnt + ", trans_description = '" + lTransDesc + "', run_time = " + lRuntime + ", DATE_TIME = '" + lTimestamp + "'";
                System.out.println("lSql: " + lSql);
                lStmt.executeUpdate(lSql);
            }
            StorableObject.getConnection().commit();
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"writeResultsToMyQADB()", (char)'E', (String)("ERROR while storing results: " + e.getClass() + e.getMessage()));
            System.out.println("writeResultsToMyQADB() -- ERROR while storing results: " + e.getClass() + e.getMessage());
        }
    }

    private void writeResultsToProtocol() {
        long lTransCnt = 0L;
        long lResultCnt = 0L;
        long lRuntime = 0L;
        String lStmtDesc = "";
        boolean lExecutionCount = false;
        StringBuffer lOutString = new StringBuffer();
        try {
            lOutString.append("MACHINE INFO: CPUs       : " + this.mDefResult.getProperty("cpu_count".toString()) + "\n");
            lOutString.append("                 Main Memory: " + this.mDefResult.getProperty("main_memory".toString()) + " KB \n");
            lOutString.append("----------------------------------------------------------- \n");
            lOutString.append("RESULT SUMMAY: \n");
            lOutString.append("----------------------------------------------------------------- \n");
            lOutString.append("query    transaction description                     runtime (ms) \n");
            lOutString.append("----------------------------------------------------------------- \n");
            ResultSet rs = this.mMainStatement.executeQuery("SELECT * FROM RESULTS");
            while (rs.next()) {
                lTransCnt = rs.getInt("TRANS_CNT");
                lStmtDesc = rs.getString("TRANS_DESCRIPTION");
                lRuntime = rs.getLong("RUN_TIME");
                StringBuffer stringBuffer = new StringBuffer();
                ((Object)((Object)this)).toString();
                StringBuffer stringBuffer2 = stringBuffer.append(this.paddToRightJustified(String.valueOf(lTransCnt), 3)).append("   ").append(this.paddTo(lStmtDesc, 45));
                ((Object)((Object)this)).toString();
                lOutString.append(stringBuffer2.append(this.paddToRightJustified(String.valueOf(lRuntime), 12)).append("\n").toString());
            }
            LcTransactionsMecki.printInfo(2, "RESULT SUMMARY: ", lOutString.toString());
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"writeResultsToProtocol()", (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
            System.out.println("writeResultsToProtocol() -- ERROR: " + e.getClass() + e.getMessage());
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = LcTransactionsMecki.getDatabase().getHost();
            mName = LcTransactionsMecki.getDatabase().getName();
            int mPort = LcTransactionsMecki.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"executeDBMCmd()", (char)'W', (String)("Problem with command '" + pCmd + "' --> Exception: " + e.getMessage() + "\n" + e.getClass()));
            return "error";
        }
    }

    private void startUp() {
        try {
            this.mMainConnection = LcTransactionsMecki.getDatabase().connect(LcTransactionsMecki.getUser(), LcTransactionsMecki.getPassword());
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mMainStatement.enableExceptions(false);
            this.mMainStatement.executeUpdate("Drop user LCTRANS");
            this.mMainStatement.enableExceptions(true);
            this.mMainStatement.executeUpdate("Create user LCTRANS password LCTRANS dba not exclusive");
            this.mMainStatement.close();
            this.mMainConnection.close();
            this.mMainConnection = LcTransactionsMecki.getDatabase().connect("LCTRANS", "LCTRANS");
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mExclusiveConnection = LcTransactionsMecki.getDatabase().connect("LCTRANS", "LCTRANS");
            this.mExclusiveConnection.setAutoCommit(false);
            this.mExclusiveStatement = new TestStatement(null, this.mExclusiveConnection);
            this.mPrepExclusiveConnection = LcTransactionsMecki.getDatabase().connect("LCTRANS", "LCTRANS");
            this.mPrepExclusiveConnection.setAutoCommit(false);
            this.mPrepExclusiveStatement = new TestPreparedStatement(null, this.mPrepExclusiveConnection, "select process from dba.transactions, connectparameters where transactions.session = connectparameters.session");
            ResultSet rs = this.mPrepExclusiveStatement.executeQuery();
            if (rs.next()) {
                this.mPrepStatementTaskId = rs.getInt(1);
                LcTransactionsMecki.printInfo(2, "LcTransactionsMecki", "startUp() : Prepared statements to be measured use task ID: " + this.mPrepStatementTaskId);
            } else {
                LcTransactionsMecki.addGlobalMessage((String)"startUp()", (char)'E', (String)"Cannot determine TASK ID for prepared statements!");
            }
            this.mPrepExclusiveStatement.close();
            this.mMeasureConnection = LcTransactionsMecki.getDatabase().connect("LCTRANS", "LCTRANS");
            this.mMeasureStatement = new TestStatement(null, this.mMeasureConnection);
            this.mMonitor = new TestStatementMonitor(this.mMeasureConnection, LcTransactionsMecki.getDatabase().getHost(), LcTransactionsMecki.getDatabase().getName(), LcTransactionsMecki.getDatabase().getPort());
            rs = this.mExclusiveStatement.executeQuery("select process from transactions, connectparameters where transactions.session = connectparameters.session");
            if (rs.next()) {
                this.mStatementTaskId = rs.getInt(1);
            }
            LcTransactionsMecki.printInfo(2, "LcTransactions", "startUp() : Statements to be measured use task ID         : " + this.mStatementTaskId);
            this.mOneResultRecord = new Properties();
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        }
        catch (TestDatabaseException tde) {
            LcTransactionsMecki.addGlobalMessage((String)"LcTransactions", (char)'E', (String)("startUp() method failed with TestDatabaseException: " + ((Object)((Object)tde)).getClass() + tde.getMessage()));
        }
        catch (SQLException se) {
            LcTransactionsMecki.addGlobalMessage((String)"LcTransactions", (char)'E', (String)("startUp() method failed with SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            LcTransactionsMecki.addGlobalMessage((String)"LcTransactions", (char)'E', (String)("startUp() method failed with TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"LcTransactions", (char)'E', (String)("startUp() method failed with Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public void getMachineInfo() {
        int CPU = 0;
        long MEMORY = 0L;
        String sDevTool = System.getProperty("env.tool");
        if (sDevTool == null) {
            LcTransactionsMecki.printInfo(2, "getMachineInfo()", "Environment variable TOOL not defined.");
        }
        String sFileSep = System.getProperty("file.separator");
        String sCommand = sDevTool + sFileSep + "bin" + sFileSep + "machineInfo";
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        SystemProcess = new Execute(sCommand, null, ProcessOutput);
        SystemProcess.exec();
        StringTokenizer st = new StringTokenizer(ProcessOutput.toString());
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase("PROCESSORS:")) continue;
            CPU = new Integer(st.nextToken().toString());
            break;
        }
        if (CPU == 0) {
            LcTransactionsMecki.printInfo(2, "getMachineInfo()", "WARNING: Could not get number of CPUs!");
            CPU = -1;
            ((Object)((Object)this)).toString();
            this.mDefResult.setProperty("cpu_count", String.valueOf(CPU));
        } else {
            LcTransactionsMecki.printInfo(2, "getMachineInfo()", "CPU's for this System: " + CPU);
            ((Object)((Object)this)).toString();
            this.mDefResult.setProperty("cpu_count", String.valueOf(CPU));
        }
        sCommand = "";
        sCommand = sDevTool + sFileSep + "bin" + sFileSep + "machineInfo -T";
        SystemProcess = new Execute(sCommand, null, ProcessOutput);
        SystemProcess.exec();
        st = new StringTokenizer(ProcessOutput.toString());
        if (st.hasMoreTokens() && st.nextToken().equalsIgnoreCase("TOTAL_MEMORY(KBytes):")) {
            String nextOne = st.nextToken();
            MEMORY = nextOne.equalsIgnoreCase("?") ? -1L : (long)new Integer(nextOne.toString()).intValue();
        }
        if (MEMORY == 0L) {
            LcTransactionsMecki.printInfo(2, "getMachineInfo()", "WARNING: Could not get size of MAIN MEMORY!");
            MEMORY = -1L;
            ((Object)((Object)this)).toString();
            this.mDefResult.setProperty("main_memory", String.valueOf(MEMORY));
        } else {
            LcTransactionsMecki.printInfo(2, "getMachineInfo()", "MAIN MEMORY on this System: " + MEMORY + " KB");
            ((Object)((Object)this)).toString();
            this.mDefResult.setProperty("main_memory", String.valueOf(MEMORY));
        }
    }

    private void createTables() {
        try {
            this.mMainStatement.executeUpdate("CREATE TABLE RESULTS (TRANS_CNT FIXED(4), TRANS_DESCRIPTION VARCHAR(100),  DATE_TIME TIMESTAMP DEFAULT TIMESTAMP, RUN_TIME FIXED (20))");
            LcTransactionsMecki.printInfo(2, "createTables()", "Creating results table");
        }
        catch (SQLException se) {
            LcTransactionsMecki.addGlobalMessage((String)"createTables()", (char)'E', (String)("SQLException: " + se.getClass() + se.getMessage()));
        }
    }

    private void storeResultsInJava(int pTestNumber, long pRuntime, String pStmtDesc) {
        try {
            ++this.mStatementCounter;
            ((Object)((Object)this)).toString();
            this.mOneResultRecord.setProperty("trans_cnt", String.valueOf(pTestNumber));
            this.mOneResultRecord.setProperty("trans_description", "'" + pStmtDesc + "'");
            ((Object)((Object)this)).toString();
            this.mOneResultRecord.setProperty("run_time", String.valueOf(pRuntime));
            this.mResults[this.mStatementCounter] = (Properties)this.mOneResultRecord.clone();
            String lSqlString = "insert RESULTS set  trans_cnt = " + this.mStatementCounter + ", trans_description = '" + pStmtDesc + "', RUN_TIME = " + pRuntime;
            TestPreparedStatement myPrepStatement = new TestPreparedStatement(null, this.mMeasureConnection, lSqlString);
            myPrepStatement.execute();
        }
        catch (Exception e) {
            System.out.println("storeResultsInJava(): " + e.getClass() + e.getMessage());
            LcTransactionsMecki.addGlobalMessage((String)"storeResultsInJava()", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public String getPropertyWithDefault(String key, String defaultVal) {
        return LcTransactionsMecki.getParameterString((String)key, (String)defaultVal);
    }

    private void storeDefInMyQADB() {
        String sqlCommand = "";
        String svalue = "";
        Object sess = null;
        Object myUser = null;
        Statement lStmt = null;
        try {
            svalue = ((TestDatabaseSap)LcTransactionsMecki.getDatabase()).getKernelVersion();
            this.mDefResult.setProperty("version", svalue);
            svalue = ((TestDatabaseSap)LcTransactionsMecki.getDatabase()).getKernelBuild();
            this.mDefResult.setProperty("long_build", svalue);
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"storeDefInPTS()", (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
        }
        try {
            lStmt = StorableObject.getConnection().createStatement();
        }
        catch (Exception e) {
            LcTransactionsMecki.addGlobalMessage((String)"storeDefInPTS()", (char)'W', (String)("WARNING: Can't save WISCONSIN definitions in PTS database !!!\nException: " + e));
        }
        LcTransactionsMecki.printInfo(2, "\nLcTransactionsMecki", "WisconsinBenchmark measurements follow!\n");
    }

    public static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            LcTransactionsMecki.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            LcTransactionsMecki.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private String paddToRightJustified(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return new String(ca) + str;
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    static {
        mUserType = null;
        mTestNumber = 0;
        mTestDB = null;
        mDbdescription = null;
        mServernode = null;
    }
}

