/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common.where;

import com.sap.sapdb.benchmark.common.where.WhereException;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class AtomicFilter {
    private SortedSet whereProducers = null;
    private Class filterClass = null;
    private String tableName = null;
    private String staticWherePart = null;

    public AtomicFilter(Class filterClass, String tableName, SortedSet whereProducers) {
        this.filterClass = filterClass;
        this.whereProducers = new TreeSet(whereProducers);
        this.tableName = tableName;
    }

    public AtomicFilter(Class filterClass, String tableName) {
        this.filterClass = filterClass;
        this.whereProducers = new TreeSet();
        this.tableName = tableName;
    }

    public void add(WhereProducer wp) throws WhereException {
        if (!this.filterClass.isAssignableFrom(wp.getClass())) {
            throw new WhereException(wp.getClass() + " is not assignable from " + this.filterClass);
        }
        this.whereProducers.add(wp);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class getFilterClass() {
        return this.filterClass;
    }

    public SortedSet getWhereProducers() {
        return this.whereProducers;
    }

    public void setComparator(Comparator comparator) {
        TreeSet newOrder = new TreeSet(comparator);
        newOrder.addAll(this.whereProducers);
        this.whereProducers = newOrder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AtomicFilter) {
            AtomicFilter otherAF = (AtomicFilter)obj;
            if (this.filterClass.equals(otherAF.getFilterClass())) {
                Iterator otherIt = otherAF.getWhereProducers().iterator();
                Iterator it = this.getWhereProducers().iterator();
                while (it.hasNext()) {
                    if (!otherIt.hasNext()) {
                        return false;
                    }
                    if (it.next().equals(otherIt.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

