/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.MutableDBDescProperties;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.StorableObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class ServerNode
extends StorableObject {
    private static ServerNode currentServerNode = null;
    private String hostName = null;
    private String osName = "[UNKNOWN]";
    private String osVersion = "[UNKNOWN]";
    private int processorCount = -1;
    private String processorMHz = "[UNKNOWN]";
    private int memoryMB = -1;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$common$ServerNode;

    public static ServerNode getServerNode(String testDBHostName) throws SQLException, UnknownHostException {
        if (currentServerNode != null) {
            return currentServerNode;
        }
        String jTestHostName = new StringTokenizer(InetAddress.getLocalHost().getHostName(), ".").nextToken();
        String osName = null;
        String osVersion = null;
        if (testDBHostName.equals("localhost")) {
            testDBHostName = jTestHostName;
        }
        if (!testDBHostName.startsWith("127")) {
            testDBHostName = new StringTokenizer(testDBHostName, ".").nextToken();
        }
        if (jTestHostName.equals(testDBHostName)) {
            osName = System.getProperty("os.name");
            osVersion = System.getProperty("os.version");
        } else {
            osName = "[UNKNOWN]";
            osVersion = "[UNKNOWN]";
        }
        if (!ServerNode.isNonPersistent()) {
            Statement stmt = ServerNode.getConnection().createStatement();
            ResultSet RS = null;
            if (jTestHostName.equals(testDBHostName)) {
                MutableDBDescProperties.getCommonMutableDBDescProperties().setBooleanProperty("remote", false);
                RS = stmt.executeQuery("SELECT id,host_name, os_name, os_version, memory_mb, processor_count, processor_mhz FROM servernodes WHERE host_name='" + testDBHostName + "' AND " + "os_name='" + osName + "' AND " + "os_version='" + osVersion + "'");
            } else {
                MutableDBDescProperties.getCommonMutableDBDescProperties().setBooleanProperty("remote", true);
                RS = stmt.executeQuery("SELECT id,host_name, os_name, os_version, memory_mb, processor_count, processor_mhz FROM servernodes WHERE  host_name='" + testDBHostName + "' " + " ORDER BY id DESC");
            }
            if (!RS.next()) {
                stmt.executeUpdate("INSERT INTO servernodes SET id=0,host_name='" + testDBHostName + "'," + "os_name='" + osName + "'," + "os_version='" + osVersion + "'");
                RS = stmt.executeQuery("SELECT id,host_name, os_name, os_version, memory_mb, processor_count, processor_mhz FROM servernodes WHERE host_name='" + testDBHostName + "' AND " + "os_name='" + osName + "' AND " + "os_version='" + osVersion + "'");
                RS.next();
            }
            int id = RS.getInt("id");
            int memoryMB = RS.getInt("memory_mb");
            int processorCount = RS.getInt("processor_count");
            String processorMHz = RS.getString("processor_mhz");
            RS.close();
            stmt.close();
            ServerNode.getConnection().commit();
            currentServerNode = new ServerNode(id, testDBHostName, osName, osVersion, memoryMB, processorCount, processorMHz);
            return currentServerNode;
        }
        currentServerNode = new ServerNode(NonPersistent.getNextId(class$com$sap$sapdb$benchmark$common$ServerNode == null ? (class$com$sap$sapdb$benchmark$common$ServerNode = ServerNode.class$("com.sap.sapdb.benchmark.common.ServerNode")) : class$com$sap$sapdb$benchmark$common$ServerNode), testDBHostName, osName, osVersion, 0, 0, "[UNKNOWN]");
        NonPersistent.setServerNode(currentServerNode);
        return currentServerNode;
    }

    public static ServerNode loadServerNode(int id) throws SQLException {
        if (!ServerNode.isNonPersistent()) {
            Statement stmt = ServerNode.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT id,host_name, os_name, os_version, memory_mb, processor_count, processor_mhz FROM servernodes WHERE id=" + id);
            if (RS.next()) {
                String hostName = RS.getString("host_name");
                String osName = RS.getString("os_name");
                String osVersion = RS.getString("os_version");
                int memoryMB = RS.getInt("memory_mb");
                int processorCount = RS.getInt("processor_count");
                String processorMHz = RS.getString("processor_mhz");
                RS.close();
                stmt.close();
                ServerNode.getConnection().commit();
                return new ServerNode(id, hostName, osName, osVersion, memoryMB, processorCount, processorMHz);
            }
            RS.close();
            stmt.close();
            ServerNode.getConnection().commit();
            return null;
        }
        return (ServerNode)NonPersistent.select(class$com$sap$sapdb$benchmark$common$ServerNode == null ? (class$com$sap$sapdb$benchmark$common$ServerNode = ServerNode.class$("com.sap.sapdb.benchmark.common.ServerNode")) : class$com$sap$sapdb$benchmark$common$ServerNode, id);
    }

    public ServerNode(int id, String hostName, String osName, String osVersion, int memoryMB, int processorCount, String processorMHz) {
        super(id);
        this.hostName = hostName;
        this.osName = osName;
        this.osVersion = osVersion;
        this.memoryMB = memoryMB;
        this.processorCount = processorCount;
        this.processorMHz = processorMHz;
    }

    public String toString() {
        return this.getShortHostName();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getShortHostName() {
        return new StringTokenizer(this.hostName, ".").nextToken();
    }

    public int getMemoryMB() {
        return this.memoryMB;
    }

    public void setMemoryMB(int memoryMB) throws SQLException {
        Statement stmt = ServerNode.getConnection().createStatement();
        stmt.executeUpdate("UPDATE servernodes SET memory_mb=" + memoryMB + " WHERE id=" + this.getId());
        stmt.close();
        ServerNode.getConnection().commit();
        this.memoryMB = memoryMB;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public void setProcessorCount(int processorCount) throws SQLException {
        Statement stmt = ServerNode.getConnection().createStatement();
        stmt.executeUpdate("UPDATE servernodes SET processor_count=" + processorCount + " WHERE id=" + this.getId());
        stmt.close();
        ServerNode.getConnection().commit();
        this.processorCount = processorCount;
    }

    public String getProcessorMHz() {
        return this.processorMHz;
    }

    public void setProcessorMHz(String processorMHz) throws SQLException {
        Statement stmt = ServerNode.getConnection().createStatement();
        stmt.executeUpdate("UPDATE servernodes SET processor_mhz='" + processorMHz + "' WHERE id=" + this.getId());
        stmt.close();
        ServerNode.getConnection().commit();
        this.processorMHz = processorMHz;
    }

    public int compareTo(Object obj) {
        if (obj instanceof ServerNode) {
            return this.hostName.compareTo(((ServerNode)obj).getHostName());
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

