/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class SimulatorBasic
extends TestCase {
    private static String sTestCaller;
    private static String sFileSep;
    private static boolean sTrace;
    private static int sTimeout;
    private static ArrayList sTableSizeList;
    private static String outPutFile;

    public static void prepare() throws TestCaseException {
        File outPutFileFile;
        String jtestRoot = TestDriver.getJTestRoot();
        String trace = SimulatorBasic.getParameterString((String)"TRACE", (String)"OFF");
        sTrace = trace.equalsIgnoreCase("ON") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        String specialFlag = SimulatorBasic.getParameterString((String)"DEBUGALLOCATOR", (String)"AUTOMATIC");
        outPutFile = SimulatorBasic.getParameterString((String)"OUTPUTFILE", (String)"SimulatorBasic.txt");
        sTimeout = SimulatorBasic.getParameterInt((String)"TIMEOUT", (int)300);
        sFileSep = System.getProperty("file.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(jtestRoot);
        sb.append(sFileSep);
        sb.append("tests");
        sb.append(sFileSep);
        sb.append("testsimul_small");
        if (outPutFile.length() > 0) {
            sb.append(" -o " + outPutFile + " ");
        }
        if (sTrace) {
            sb.append(" -t ");
        }
        if (specialFlag.equalsIgnoreCase("automatic") && System.getProperty("os.name").equalsIgnoreCase("hp-ux")) {
            sb.append(" -x ");
        }
        if (specialFlag.equalsIgnoreCase("false")) {
            sb.append(" -x ");
        }
        sTestCaller = sb.toString();
        File memtraceFile = new File(jtestRoot + File.separator + "mem_trace.txt");
        if (memtraceFile.exists()) {
            memtraceFile.delete();
        }
        if ((outPutFileFile = new File(jtestRoot + File.separator + outPutFile)).exists()) {
            outPutFileFile.delete();
        }
    }

    public void run() {
        int rc;
        String cmd = sTestCaller;
        String line = null;
        String toProtocol = "";
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(sTrace);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(sTimeout);
        exc.exec();
        if (exc.isDestroyed()) {
            this.addMessage("", 'W', "Subprocess: " + cmd + " has been destroyed after timeout");
            System.out.println(" Subprocess: has been destroyed after timeout");
        }
        if ((rc = exc.getExitValue()) == 0) {
            this.addMessage("", 'I', cmd + " successful!");
        } else {
            this.addMessage("", 'E', cmd + " => RC = " + rc);
            System.out.println(" => RC = " + rc);
            if (outPutFile.length() > 0) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(new File(TestDriver.getJTestRoot() + File.separator + outPutFile)));
                    line = reader.readLine();
                    while (line != null) {
                        toProtocol = toProtocol + line + "\n";
                        line = reader.readLine();
                    }
                    if (toProtocol.length() > 0) {
                        this.addMessage("Screen", 'T', "\n" + toProtocol);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("FileNotFoundException during reading of " + outPutFile + " -> " + fnfe.getLocalizedMessage());
                }
                catch (IOException ioe) {
                    System.out.println("IOException during \"line = reader.readLine();\" -> " + ioe.getLocalizedMessage());
                }
            }
        }
        if (sb != null && sb.length() > 0) {
            this.addMessage("", 'I', sb.toString());
        }
    }

    public String getLogFile() {
        File memtraceFile = new File(TestDriver.getJTestRoot() + File.separator + "mem_trace.txt");
        if (memtraceFile.exists()) {
            return "" + TestDriver.getJTestRoot() + File.separator + "mem_trace.txt";
        }
        return null;
    }

    static {
        sTrace = false;
        sTimeout = 0;
        sTableSizeList = null;
        outPutFile = null;
    }
}

