/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public abstract class IteratorTest
extends TestCase
implements LiveCacheConstants {
    protected static final String sUser = "UITERATOR";
    protected static final String sPassword = "UITERATOR";
    protected static final int mNumberOfConnections = 3;
    protected static final int USER1 = 1;
    protected static final int USER2 = 2;
    protected static final int USER3 = 3;
    protected static final int NO_ERROR = 0;
    protected static final int DEFAULT_TIMEOUT = 10;
    protected static final int IGNORE_ALL_ERRORS = -999;
    protected boolean[] mObject;
    protected int[] mCheckSum;
    private int mStatementCounter = 0;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private DBM mDBM;
    private DBM mDBMan = null;
    private static Random mRandomGenerator;

    public static void cleanUp() throws TestCaseException {
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            if (mStatements[0] != null) {
                mConnections[0].commit();
                mStatements[0].execute("CALL DROP_CURRENT_SCHEMA('testteam')");
                mConnections[0].commit();
            }
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error while dropping schema: " + e.getMessage()));
            e.printStackTrace();
            throw new TestCaseException("Error while dropping schema: " + e.getMessage());
        }
        try {
            for (int i = 0; i < 3; ++i) {
                if (mStatements[i] != null) {
                    mStatements[i].close();
                }
                if (mConnections[i] != null) {
                    mConnections[i].commit();
                }
                mConnections[i].close();
            }
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[3];
            mStatements = new TestStatement[3];
            for (int i = 0; i < 3; ++i) {
                IteratorTest.mConnections[i] = IteratorTest.getDatabase().connect("UITERATOR", "UITERATOR");
                mConnections[i].setAutoCommit(false);
                IteratorTest.mStatements[i] = new TestStatement(null, mConnections[i]);
                mStatements[i].execute("CALL SET_CURRENT_SCHEMA('testteam')");
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = IteratorTest.getDatabase().connect("UITERATOR", "UITERATOR");
            stmt = new TestStatement(null, con);
            int ExecMode = 1;
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "iterator", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "iterator", "liveCache.consistent.TEST");
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'iterator'");
            }
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "iterator", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "iterator", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "iterator", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "iterator", ExecMode);
            DBProcedure.create(stmt, "DELETE_OBJECT_KR", "iterator", ExecMode);
            DBProcedure.create(stmt, "UPDATE_OBJECT_KR", "iterator", ExecMode);
            DBProcedure.create(stmt, "CREATE_OBJECT_KR", "iterator", ExecMode);
            DBProcedure.create(stmt, "CNT_OBJ_IN_RANGE_KR", "iterator", ExecMode);
            DBProcedure.create(stmt, "INIT", "iterator", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            stmt.enableExceptions(false);
            stmt.execute("CALL DELETE_ALL_OBJECTS(0)");
            stmt.enableExceptions(true);
            con.commit();
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("IteratorTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = IteratorTest.getDatabase().getHost();
            mName = IteratorTest.getDatabase().getName();
            int mPort = IteratorTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            return "error";
        }
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mConnections[UserId - 1];
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mStatements[UserId - 1];
    }

    private String getInfoString(String pMethodName, int pCounter, int pUser) {
        return "<" + pMethodName + "(), Statement " + pCounter + ", User " + pUser + ">";
    }

    protected void itCommit(int iUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("itCommit", this.mStatementCounter, iUserId);
        try {
            Connection con = this.getConnection(iUserId);
            con.commit();
            IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Commit --> OK");
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Could not commit: " + e.getMessage()));
            throw new TestCaseException("Error in Iterator test");
        }
    }

    protected int itSumOfCheckSum(int iStartKey, int iStopKey) {
        int dummy = 0;
        for (int i = iStartKey; i <= iStopKey; ++i) {
            dummy += this.mCheckSum[i];
        }
        return dummy;
    }

    protected void itUpdateObjectWithCommit(int iUserId, int iKey, int iValue) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itUpdateObjectWithCommit", this.mStatementCounter, iUserId);
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of UPDATE_OBJECT_KR ( Key = " + iKey + ", Value = " + iValue + " )";
            CallableStatement stmt = con.prepareCall("CALL UPDATE_OBJECT_KR ( " + iKey + ", " + iValue + " )");
            stmt.execute();
            con.commit();
            this.mCheckSum[iKey] = iValue;
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itUpdateObjectWithoutCommit(int iUserId, int iKey, int iValue) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itUpdateObjectWithoutCommit", this.mStatementCounter, iUserId);
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of UPDATE_OBJECT_KR ( Key = " + iKey + ", Value = " + iValue + " )";
            CallableStatement stmt = con.prepareCall("CALL UPDATE_OBJECT_KR ( " + iKey + ", " + iValue + " )");
            stmt.execute();
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itCountObjectsInRangeWithCommit(int iUserId, int iStartKey, int iStopKey, int iExpectedSum) throws TestCaseException {
        this.itCountObjectsInRangeWithCommit(iUserId, iStartKey, iStopKey, -1, iExpectedSum);
    }

    protected void itCountObjectsInRangeWithCommit(int iUserId, int iStartKey, int iStopKey, int iExpectedObj, int iExpectedSum) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itCountObjectsInRangeWithCommit", this.mStatementCounter, iUserId);
        int ObjCnt = 0;
        int Checksum = 0;
        int ExpectedCntOfObject = 0;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CNT_OBJ_IN_RANGE_KR ( StartKey = " + iStartKey + ", StopKey = " + iStopKey + ", ?, ?  )";
            CallableStatement stmt = con.prepareCall("CALL CNT_OBJ_IN_RANGE_KR ( " + iStartKey + ", " + iStopKey + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ObjCnt = stmt.getInt(1);
            Checksum = stmt.getInt(2);
            con.commit();
            ResultString = CallString + " returned: ( NumberOfObjects = " + ObjCnt + ", CheckSum = " + Checksum + " )";
            if (iExpectedObj == -1) {
                for (int i = iStartKey; i <= iStopKey; ++i) {
                    if (!this.mObject[i]) continue;
                    ++ExpectedCntOfObject;
                }
            } else {
                ExpectedCntOfObject = iExpectedObj;
            }
            if (ObjCnt != ExpectedCntOfObject) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting NumberOfObjects: " + ExpectedCntOfObject));
                throw new TestCaseException(ResultString + " --> expecting NumberOfObjects: " + ExpectedCntOfObject);
            }
            if (Checksum != iExpectedSum) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting CheckSum: " + iExpectedSum));
                throw new TestCaseException(ResultString + " --> expecting CheckSum: " + iExpectedSum);
            }
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void itCountObjectsInRangeWithoutCommit(int iUserId, int iStartKey, int iStopKey, int iExpectedSum) throws TestCaseException {
        this.itCountObjectsInRangeWithoutCommit(iUserId, iStartKey, iStopKey, -1, iExpectedSum);
    }

    protected void itCountObjectsInRangeWithoutCommit(int iUserId, int iStartKey, int iStopKey, int iExpectedObj, int iExpectedSum) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itCountObjectsInRangeWithoutCommit", this.mStatementCounter, iUserId);
        int ObjCnt = 0;
        int Checksum = 0;
        int ExpectedCntOfObject = 0;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CNT_OBJ_IN_RANGE_KR ( StartKey = " + iStartKey + ", StopKey = " + iStopKey + ", ?, ?  )";
            CallableStatement stmt = con.prepareCall("CALL CNT_OBJ_IN_RANGE_KR ( " + iStartKey + ", " + iStopKey + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ObjCnt = stmt.getInt(1);
            Checksum = stmt.getInt(2);
            ResultString = CallString + " returned: ( NumberOfObjects = " + ObjCnt + ", CheckSum = " + Checksum + " )";
            if (iExpectedObj == -1) {
                for (int i = iStartKey; i <= iStopKey; ++i) {
                    if (!this.mObject[i]) continue;
                    ++ExpectedCntOfObject;
                }
            } else {
                ExpectedCntOfObject = iExpectedObj;
            }
            if (ObjCnt != ExpectedCntOfObject) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting NumberOfObjects: " + ExpectedCntOfObject));
                throw new TestCaseException(ResultString + " --> expecting NumberOfObjects: " + ExpectedCntOfObject);
            }
            if (Checksum != iExpectedSum) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting CheckSum: " + iExpectedSum));
                throw new TestCaseException(ResultString + " --> expecting CheckSum: " + iExpectedSum);
            }
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void itCreateObjectWithCommit(int iUserId, int iKey, int iValue) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itCreateObjectWithCommit", this.mStatementCounter, iUserId);
        boolean ObjCnt = false;
        boolean Checksum = false;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CREATE_OBJECT_KR ( Key = " + iKey + " , Value = " + iValue + " )";
            CallableStatement stmt = con.prepareCall("CALL CREATE_OBJECT_KR ( " + iKey + ", " + iValue + " )");
            stmt.execute();
            con.commit();
            this.mCheckSum[iKey] = iValue;
            this.mObject[iKey] = true;
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itCreateObjectWithoutCommit(int iUserId, int iKey, int iValue) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itCreateObjectWithoutCommit", this.mStatementCounter, iUserId);
        boolean ObjCnt = false;
        boolean Checksum = false;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CREATE_OBJECT_KR ( Key = " + iKey + " , Value = " + iValue + " )";
            CallableStatement stmt = con.prepareCall("CALL CREATE_OBJECT_KR ( " + iKey + ", " + iValue + " )");
            stmt.execute();
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itDeleteObjectWithCommit(int iUserId, int iKey) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itDeleteObjectWithCommit", this.mStatementCounter, iUserId);
        boolean ObjCnt = false;
        boolean Checksum = false;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of DELETE_OBJECT_KR ( Key = " + iKey + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_OBJECT_KR ( " + iKey + " )");
            stmt.execute();
            con.commit();
            this.mCheckSum[iKey] = 0;
            this.mObject[iKey] = false;
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itDeleteObjectWithoutCommit(int iUserId, int iKey) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itDeleteObjectWithoutCommit", this.mStatementCounter, iUserId);
        boolean ObjCnt = false;
        boolean Checksum = false;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of DELETE_OBJECT_KR ( Key = " + iKey + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_OBJECT_KR ( " + iKey + " )");
            stmt.execute();
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected int itGetCheckSumWithoutCommit(int iUserId, int iKey) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itGetCheckSumWithoutCommit", this.mStatementCounter, iUserId);
        int ObjCnt = 0;
        int Checksum = 0;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CNT_OBJ_IN_RANGE_KR ( StartKey = " + iKey + ", StopKey = " + iKey + ", ?, ?  )";
            CallableStatement stmt = con.prepareCall("CALL CNT_OBJ_IN_RANGE_KR ( " + iKey + ", " + iKey + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ObjCnt = stmt.getInt(1);
            Checksum = stmt.getInt(2);
            ResultString = CallString + " returned: ( NumberOfObjects = " + ObjCnt + ", CheckSum = " + Checksum + " )";
            if (ObjCnt != 1) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting NumberOfObjects: 1 "));
                throw new TestCaseException(ResultString + " --> expecting NumberOfObjects: 1");
            }
            if (Checksum != this.mCheckSum[iKey]) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> CheckSum: " + Checksum));
                throw new TestCaseException(ResultString + " --> expecting CheckSum: " + this.mCheckSum[iKey]);
            }
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return 0;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return Checksum;
    }

    protected int itGetCheckSumWithCommit(int iUserId, int iKey) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itGetCheckSumWithCommit", this.mStatementCounter, iUserId);
        int ObjCnt = 0;
        int Checksum = 0;
        try {
            Connection con = this.getConnection(iUserId);
            CallString = "Call of CNT_OBJ_IN_RANGE_KR ( StartKey = " + iKey + ", StopKey = " + iKey + ", ?, ?  )";
            CallableStatement stmt = con.prepareCall("CALL CNT_OBJ_IN_RANGE_KR ( " + iKey + ", " + iKey + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ObjCnt = stmt.getInt(1);
            Checksum = stmt.getInt(2);
            con.commit();
            ResultString = CallString + " returned: ( NumberOfObjects = " + ObjCnt + ", CheckSum = " + Checksum + " )";
            if (ObjCnt != 1) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> expecting NumberOfObjects: 1 "));
                throw new TestCaseException(ResultString + " --> expecting NumberOfObjects: 1");
            }
            if (Checksum != this.mCheckSum[iKey]) {
                IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("*** ERROR *** " + ResultString + " --> CheckSum: " + Checksum));
                throw new TestCaseException(ResultString + " --> expecting CheckSum: " + this.mCheckSum[iKey]);
            }
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return 0;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return Checksum;
    }

    /*
     * Loose catch block
     */
    public static void prepare() throws TestCaseException {
        block15: {
            TestStatement lDefTstmt;
            Connection lDefConnection;
            block14: {
                lDefConnection = null;
                lDefTstmt = null;
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lDefConnection = IteratorTest.getDatabase().connect(IteratorTest.getDatabase().getDBAUser(), IteratorTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    IteratorTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + IteratorTest.getDatabase().getDBAUser() + ", Password: " + IteratorTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                try {
                    if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                        lDefTstmt.executeUpdate("enable write transaction");
                    }
                }
                catch (TestDatabaseException e) {
                    throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
                }
                lDefTstmt.executeUpdate("drop user UITERATOR");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user UITERATOR password UITERATOR dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block14;
                    IteratorTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : UITERATOR not possible");
                    throw e;
                }
            }
            IteratorTest.readParameters();
            IteratorTest.createDBProcedures();
            IteratorTest.createConnections();
            Object var4_6 = null;
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break block15;
            {
                catch (Exception e) {
                    throw (TestCaseException)e;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    lDefTstmt.close();
                    lDefConnection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    protected void itInitKR(int iUserId, int iInitialNumOfObj, int iInitialIncrement, int iPartitionedKeys) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("itInitKR", this.mStatementCounter, iUserId);
        try {
            TestStatement stmt = this.getStatement(iUserId);
            CallString = "Call of INIT ( InitialNumOfObj = " + iInitialNumOfObj + ", InitialIncrement = " + iInitialIncrement + ", PartitionedKeys = " + iPartitionedKeys + ")";
            stmt.execute("CALL INIT (" + iInitialNumOfObj + ", " + iInitialIncrement + ", " + iPartitionedKeys + ")");
        }
        catch (SQLException e) {
            IteratorTest.addGlobalMessage((String)"SQLExeception", (char)'E', (String)(CallString + " --> " + e.getMessage()));
            return;
        }
        IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void itReconnect(int iUserId) throws TestCaseException {
        String InfoString = this.getInfoString("prReconnect", this.mStatementCounter++, iUserId);
        try {
            if (iUserId < 1 || iUserId > 3) {
                throw new TestCaseException("Illegal user number: " + iUserId);
            }
            mConnections[--iUserId].close();
            mStatements[iUserId].close();
            IteratorTest.mConnections[iUserId] = IteratorTest.getDatabase().connect("UITERATOR", "UITERATOR");
            mConnections[iUserId].setAutoCommit(false);
            IteratorTest.mStatements[iUserId] = new TestStatement(null, mConnections[iUserId]);
            mStatements[iUserId].execute("CALL SET_CURRENT_SCHEMA('testteam')");
            mConnections[iUserId].commit();
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Reconnect for user " + iUserId + " failed: " + e.getMessage()));
            throw new TestCaseException("Error in Iterator test");
        }
    }

    protected void itRollback(int iUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prRollback", this.mStatementCounter, iUserId);
        try {
            Connection con = this.getConnection(iUserId);
            con.rollback();
            IteratorTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Rollback --> OK");
        }
        catch (Exception e) {
            IteratorTest.addGlobalMessage((String)InfoString, (char)'E', (String)("Could not rollback: " + e.getMessage()));
            throw new TestCaseException("Error in Itertor test");
        }
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    private static void readParameters() throws TestCaseException {
    }

    public void run() {
    }

    static {
        mRandomGenerator = new Random();
    }
}

