/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;

public class BackupRestoreLog2
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.6";
    private Connection mConnection = null;
    private TestStatement stmt = null;
    private static int mTraceLevel;
    private DBM mDBMan = null;
    private static int mWorkOnDatabase;
    private String sString = null;
    private int i = 0;
    private int j = 0;
    private boolean indexExists = false;
    private Random r = new Random();
    private int rand = 0;
    private int expectedLogSaves = 0;
    private boolean dataInDatabase = false;
    private String[] LogSaves;
    private String checkValues = null;
    private String mKernelMode = "FAST";

    public static String getTestClassId() {
        return "BackupRestoreLog2";
    }

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static void prepare() throws TestCaseException {
        BackupRestoreLog2.readAndPrintParameters();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            BackupRestoreLog2.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            BackupRestoreLog2.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        int defaultValue = 10;
        mTraceLevel = BackupRestoreLog2.getParameterInt((String)"TraceLevel", (int)2);
        mWorkOnDatabase = BackupRestoreLog2.getParameterInt((String)"WorkOnDatabase", (int)5);
        BackupRestoreLog2.printInfo(1, "\n" + BackupRestoreLog2.getTestClassId(), "Starting " + BackupRestoreLog2.getTestClassId() + " Test - Version: " + sVersion + "\n");
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Parameter: TraceLevel        = " + mTraceLevel);
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Parameter: WorkOnDatabase    = " + mWorkOnDatabase);
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = BackupRestoreLog2.getDatabase().getHost();
            mName = BackupRestoreLog2.getDatabase().getName();
            int mPort = BackupRestoreLog2.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private void recoverData() throws TestCaseException, SQLException, TestDatabaseException {
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Recover from data backup");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("recover_start lcrecover04dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void recoverLog() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        String firstLogSaveNumber = this.LogSaves[0].substring(this.LogSaves[0].indexOf(".") + 1, this.LogSaves[0].length());
        String resultString = "";
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Recover from log; beginning from tape, followed by log volume ...");
        resultString = this.executeDBMCmd("recover_start lcrecover04log LOG " + firstLogSaveNumber);
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), resultString);
        for (int lo = 1; lo < this.LogSaves.length && this.LogSaves[lo] != null; ++lo) {
            resultString = this.executeDBMCmd("recover_replace lcrecover04log " + this.LogSaves[lo]);
            BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), resultString);
        }
        this.executeDBMCmd("util_release");
    }

    private void restartDatabaseCold() throws TestCaseException, SQLException, TestDatabaseException {
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Restart database ( data volume: " + this.getDataFillingPTC() + "%; log volume: " + this.getLogFillingPTC() + "%; current pagecount: " + this.getSumPageCountOfHistory() + ")");
        this.executeDBMCmd("db_offline");
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        if (TestDriver.compareRelease((String)((TestDatabaseSap)BackupRestoreLog2.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute SET PARAMETER TRACE_LOGTRANS=5");
        } else {
            this.executeDBMCmd("util_execute diagnose vtrace topic 'log 5' on");
        }
        this.executeDBMCmd("util_connect");
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.executeDBMCmd("db_restartinfo"));
        this.executeDBMCmd("util_release");
    }

    private void startUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.mConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        TestDatabaseSap sapdb = (TestDatabaseSap)BackupRestoreLog2.getDatabase();
        this.mKernelMode = sapdb.getKernelMode();
        this.executeDBMCmd("autosave_off");
        this.executeDBMCmd("util_connect");
        if (TestDriver.compareRelease((String)((TestDatabaseSap)BackupRestoreLog2.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute SET PARAMETER TRACE_LOGTRANS=5");
        } else {
            this.executeDBMCmd("util_execute diagnose vtrace topic 'log 5' on");
        }
        this.executeDBMCmd("util_release");
    }

    private void checkBackUpState() throws SQLException, TestDatabaseException {
        String[] szLines = new String[200];
        int nCurrent = 0;
        String[] tempArray = new String[100];
        int tempArrayInt = 0;
        String szBuffer = this.executeDBMCmd("backup_history_list -c KEY -m -r LAST");
        String dummy = "";
        StringTokenizer stBuffer = new StringTokenizer(szBuffer);
        while (stBuffer.hasMoreTokens()) {
            dummy = stBuffer.nextToken("\n");
            if (!dummy.startsWith("M:") || dummy.indexOf("YES") == -1) continue;
            StringTokenizer singleLine = new StringTokenizer(dummy);
            int lastElementOfSingleLine = singleLine.countTokens();
            while (singleLine.hasMoreTokens()) {
                tempArray[tempArrayInt++] = singleLine.nextToken("|");
            }
            szLines[nCurrent++] = tempArray[lastElementOfSingleLine].trim();
            tempArray = new String[100];
            tempArrayInt = 0;
        }
        this.LogSaves = szLines;
        for (int z = 0; z < 200; ++z) {
            if (this.LogSaves[z] == null) continue;
            BackupRestoreLog2.printInfo(4, BackupRestoreLog2.getTestClassId(), "LogSaves[" + z + "] = " + this.LogSaves[z]);
        }
    }

    private void checkState() throws SQLException, TestDatabaseException {
        ResultSet rs = null;
        Connection mCheckStateConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
        this.stmt = new TestStatement((TestCase)this, mCheckStateConnection);
        if (this.checkValues == null) {
            this.checkValues = "";
            this.sString = "Select count(*) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\" -> ";
            this.checkValues = this.checkValues + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_LOG WHERE PRIMKEY > 1995";
            rs = this.stmt.executeQuery(this.sString);
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\"\n";
            this.checkValues = this.checkValues + "PrimKey \t Name \t\t PersNr\t Adresse\n";
            while (rs.next()) {
                this.checkValues = this.checkValues + " " + rs.getInt(1) + " ";
                this.checkValues = this.checkValues + "\t\t " + rs.getString(2) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getInt(3) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getString(4) + "\n";
            }
            this.sString = "Select SUM(PRIMKEY) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\" -> ";
            this.checkValues = this.checkValues + rs.getInt(1) + "\n";
        } else {
            String dummy = "";
            this.sString = "Select count(*) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            dummy = dummy + "Result of \"" + this.sString + "\" -> ";
            dummy = dummy + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_LOG WHERE PRIMKEY > 1995";
            rs = this.stmt.executeQuery(this.sString);
            dummy = dummy + "Result of \"" + this.sString + "\"\n";
            dummy = dummy + "PrimKey \t Name \t\t PersNr\t Adresse\n";
            while (rs.next()) {
                dummy = dummy + " " + rs.getInt(1) + " ";
                dummy = dummy + "\t\t " + rs.getString(2) + " ";
                dummy = dummy + "\t  " + rs.getInt(3) + " ";
                dummy = dummy + "\t  " + rs.getString(4) + "\n";
            }
            this.sString = "Select SUM(PRIMKEY) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            dummy = dummy + "Result of \"" + this.sString + "\" -> ";
            dummy = dummy + rs.getInt(1) + "\n";
            if (this.checkValues.compareTo(dummy) != 0) {
                BackupRestoreLog2.addGlobalMessage((String)BackupRestoreLog2.getTestClassId(), (char)'E', (String)("***** ERROR ****** \nwrong table content --> expecting:\n" + this.checkValues + "\ngetting:\n" + dummy));
            }
            BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Check database content ( data volume: " + this.getDataFillingPTC() + "%; log volume: " + this.getLogFillingPTC() + "%; SUM(Pagecount) of HISTORYINFO: " + this.getSumPageCountOfHistory() + " ) ... ok!");
        }
        this.stmt.close();
        mCheckStateConnection.close();
    }

    private void createTable() throws TestCaseException, SQLException {
        this.sString = "DROP INDEX TT_LOG_IND1";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP TABLE TT_LOG";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP DBPROC FILL_TT_LOG";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP DBPROC UPDATE_TT_LOG";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "CREATE TABLE TT_LOG(PRIMKEY INTEGER PRIMARY KEY, NAME CHAR(2000), PERSNR INTEGER, ADDRESS VARCHAR(6000) )";
        BackupRestoreLog2.printInfo(5, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.sString = "CREATE DBPROC FILL_TT_LOG AS  VAR x INT;  SET x=1;  WHILE x < 2001 DO BEGIN   INSERT INTO " + BackupRestoreLog2.getDatabase().getDBAUser() + ".TT_LOG VALUES (:x, rfill('4711','..0815',2000), :x, rfill('bla','blu',6000) );      " + "  IF $RC <> 0 THEN \t" + "   STOP ($RC, $ERRMSG); " + "  x = x + 1; " + " END; ";
        BackupRestoreLog2.printInfo(6, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.sString = "CREATE DBPROC UPDATE_TT_LOG AS  VAR x INT;  y INT;  sz INT;  tempchar char(100);  newaddress char(6000);  SET x = 1;  SET y = 0;  WHILE y < 5000 DO BEGIN     WHILE x < 2001 DO BEGIN        SET newaddress = 'No.:';        SET sz = 0;        SET tempchar = chr(sin(microsecond(now())/1000 + x));        WHILE sz < 60 DO BEGIN           SET newaddress = newaddress & tempchar;           SET sz = sz + 1;        END;        UPDATE " + BackupRestoreLog2.getDatabase().getDBAUser() + ".TT_LOG SET ADDRESS = :tempchar & :tempchar & :tempchar, NAME = 'Homer, Bart, Mr. Burns, Lenny, Barni, Willy, Skinner, Mo,...'  where PRIMKEY = :x; " + "       UPDATE " + BackupRestoreLog2.getDatabase().getDBAUser() + ".TT_LOG SET ADDRESS = :newaddress, NAME = :tempchar & :tempchar & :tempchar where PRIMKEY = :x; " + "        SET x = x + 1; " + "    END; " + "    SET y = y + 1; " + " END; ";
        BackupRestoreLog2.printInfo(6, BackupRestoreLog2.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.mConnection.commit();
    }

    private void createBackUpMedium() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_media_put lcrecover04log lcrecover04log FILE LOG");
        this.executeDBMCmd("backup_media_put lcrecover04dat lcrecover04dat FILE DATA 0 8 YES NO ");
        this.executeDBMCmd("util_release");
    }

    private void backUpData() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Backup data");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover04dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void backUpLogWarm() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Backup log");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover04log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private void backUpLogCold() throws TestCaseException, SQLException, TestDatabaseException {
        int filldegree = this.getLogFillingPTC();
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.setStatus("createBackup");
        BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Backup log ( log volume: " + filldegree + "% full )");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover04log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private int getLogFillingPTC() {
        int logPtc = -1;
        ResultSet rs = null;
        try {
            Connection mGetLogConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
            this.stmt = new TestStatement((TestCase)this, mGetLogConnection);
            this.sString = "Select PCTUSEDLOG from SERVERDBSTATISTICS";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            logPtc = rs.getInt(1);
            mGetLogConnection.close();
        }
        catch (SQLException sqle) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't excute: " + this.sString + "; get: " + sqle.getClass() + sqle.getErrorCode() + sqle.getMessage());
            logPtc = -1;
        }
        catch (TestDatabaseException tdbe) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't connect to Database. " + tdbe.getMessage());
            logPtc = -1;
        }
        return logPtc;
    }

    private int getSumPageCountOfHistory() {
        int pagecnt = -1;
        ResultSet rs = null;
        try {
            Connection mGetLogConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
            this.stmt = new TestStatement((TestCase)this, mGetLogConnection);
            this.sString = "Select SUM(PAGECOUNT) from HISTORYINFO";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            pagecnt = rs.getInt(1);
            mGetLogConnection.close();
        }
        catch (SQLException sqle) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't excute: " + this.sString + "; get: " + sqle.getClass() + sqle.getErrorCode() + sqle.getMessage());
            pagecnt = -1;
        }
        catch (TestDatabaseException tdbe) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't connect to Database. " + tdbe.getMessage());
            pagecnt = -1;
        }
        return pagecnt;
    }

    private int getDataFillingPTC() {
        int dataPtc = -1;
        ResultSet rs = null;
        try {
            Connection mGetLogConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
            this.stmt = new TestStatement((TestCase)this, mGetLogConnection);
            this.sString = "Select PCTUSEDPERM from SERVERDBSTATISTICS";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            dataPtc = rs.getInt(1);
            mGetLogConnection.close();
        }
        catch (SQLException sqle) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't excute: " + this.sString + "; get: " + sqle.getClass() + sqle.getErrorCode() + sqle.getMessage());
            dataPtc = -1;
        }
        catch (TestDatabaseException tdbe) {
            this.addMessage(BackupRestoreLog2.getTestClassId(), 'W', "Can't connect to Database. " + tdbe.getMessage());
            dataPtc = -1;
        }
        return dataPtc;
    }

    private void workOnTheDatabase() throws TestCaseException, SQLException, TestDatabaseException {
        this.workOnTheDatabase(-1);
    }

    private void workOnTheDatabase(int loopCounter) throws TestCaseException, SQLException, TestDatabaseException {
        Connection mWorkConnection = BackupRestoreLog2.getDatabase().connect(BackupRestoreLog2.getUser(), BackupRestoreLog2.getPassword());
        TestStatement workstmt = new TestStatement((TestCase)this, mWorkConnection);
        if (mWorkOnDatabase <= 0) {
            return;
        }
        if (!this.dataInDatabase) {
            BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "( a%; b%; c) -> a = filling degree of data volume; b = log volume; c = SUM(PAGECOUNT) of HISTORYINFO");
        }
        if (loopCounter != -1) {
            BackupRestoreLog2.printInfo(4, BackupRestoreLog2.getTestClassId(), "Working with data in the database ( " + loopCounter + " )...");
        } else {
            int datafill = this.getDataFillingPTC();
            int logfill = this.getLogFillingPTC();
            BackupRestoreLog2.printInfo(2, BackupRestoreLog2.getTestClassId(), "Working with data ( " + (datafill < 10 ? " " : "") + datafill + "%; " + (logfill < 10 ? " " : "") + logfill + "%; " + this.getSumPageCountOfHistory() + ")");
        }
        if (!this.dataInDatabase) {
            this.sString = "CALL FILL_TT_LOG";
            workstmt.execute(this.sString);
            mWorkConnection.commit();
            this.dataInDatabase = true;
        }
        this.i = 1;
        while (this.i <= mWorkOnDatabase) {
            this.rand = Math.abs(this.r.nextInt() % 100) + 1;
            if (this.rand < 90) {
                this.sString = "CALL UPDATE_TT_LOG";
                workstmt.execute(this.sString);
                mWorkConnection.commit();
            }
            if (this.rand >= 90) {
                if (this.indexExists) {
                    this.sString = "DROP INDEX TT_LOG_IND1";
                    workstmt.execute(this.sString);
                    mWorkConnection.commit();
                    this.indexExists = false;
                }
                this.sString = "CREATE INDEX TT_LOG_IND1 ON TT_LOG (PERSNR)";
                workstmt.execute(this.sString);
                mWorkConnection.commit();
                this.indexExists = true;
            }
            ++this.i;
        }
        mWorkConnection.commit();
        mWorkConnection.close();
    }

    public void run() {
        try {
            this.setStatus("startUp");
            this.startUp();
            this.setStatus("createBackUpMedium");
            this.createBackUpMedium();
            this.setStatus("createTable");
            this.createTable();
            this.setStatus("BackUp DATA");
            this.backUpData();
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase();
                Thread.sleep(12000L);
            } while (this.getLogFillingPTC() < 50);
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase();
                Thread.sleep(12000L);
            } while (this.getLogFillingPTC() < 60);
            this.setStatus("Check State");
            this.checkState();
            Thread.sleep(20000L);
            this.setStatus("Restart Database");
            this.restartDatabaseCold();
            this.checkBackUpState();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverLog();
            this.setStatus("Check State");
            this.checkState();
            this.executeDBMCmd("db_cold -" + this.mKernelMode);
            this.executeDBMCmd("util_connect");
            System.out.println("verify: " + this.executeDBMCmd("util_execute verify"));
            this.executeDBMCmd("util_release");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage() + " " + e.getClass() + " " + e.getLocalizedMessage());
            e.printStackTrace();
            BackupRestoreLog2.addGlobalMessage((String)BackupRestoreLog2.getTestClassId(), (char)'E', (String)("Exception: " + e.getClass() + " " + e.getMessage()));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    static {
        mWorkOnDatabase = 0;
    }
}

