
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
"""
A SAX driver for xmlproc with validation and DTD information.

$Id: drv_xmlproc_val.py,v 1.9 2001/12/30 12:13:45 loewis Exp $
"""

version="0.92"

from xml.sax import saxlib,saxutils
from xml.parsers.xmlproc import xmlval
from xml.sax.drivers.drv_xmlproc import *

import types

# --- SAX_XPValParser

class SAX_XPValParser(SAX_XPParser):

    def __init__(self):
        SAX_XPParser.__init__(self)

    def _create_parser(self):
        return xmlval.XMLValidator()

    def handle_start_tag(self, name, attrs):
        try:
            self.doc_handler.startElement(name,
                                          XPAttributes(attrs,\
                                                       self.parser.dtd.get_elem(name)))
        except KeyError,e:
            self.doc_handler.startElement(name,XPAttributes(attrs,None))

    # --- EXPERIMENTAL PYTHON SAX EXTENSIONS:

    def get_parser_name(self):
        return "xmlproc_val"

    def get_driver_version(self):
        return version

    def is_validating(self):
        return 1

# --- XPAttributes

class XPAttributes(saxutils.AttributeMap):

    def __init__(self,map,elemdecl):
        saxutils.AttributeMap.__init__(self,map)
        self.elemdecl=elemdecl

        if elemdecl==None:
            self.getType=self.getTypeStatic

    def getTypeStatic(self,i):
        return "CDATA"        # Used for undeclared elements

    def getType(self, i):
        if type(i)==types.IntType:
            try:
                i=self.map.keys()[i]
            except KeyError,e:
                return "CDATA"

        try:
            return self.elemdecl.get_attr(i).get_type()
        except KeyError,e:
            return "CDATA"

# --- Global functions

def create_parser():
    return SAX_XPValParser()
