/*!**************************************************************************

  module      : vkb522.hpp

  -------------------------------------------------------------------------

  responsible : UlrichJ

  special area: SQL locks reader
  description : This class implements a reader for SQL locks.

  last changed: 2002-08-14
  see also    :

  -------------------------------------------------------------------------

  copyright:    (c) 2001-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/


#ifndef VKB522_HPP
#define VKB522_HPP


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "vak001.h"
#include "ggg91.h"
#include "gkb05.h"
#include "SAPDBCommon/SAPDB_Types.hpp"
#include "Container/Container_List.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"

 /*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!***************************************************************************

   class: k521_SQLLockReader

   description: This class implements a reader object for the SQL locks to be
                able to read all locks sequentially.

******************************************************************************/

class ckb522_TransReader
{

public:

    struct TransElement
    {
        tgg91_SessionNo             teSessionID_kb522;
        tgg91_TransNo               teTransID_kb522;
        tsp00_Timestamp             teStartDate_kb522;
        tgg91_TransNo               teWriteTransID_kb522;
        tsp00_Int4                  teSQLLockReqTimeout_kb522;
        SAPDB_Int4                  teOMSLockReqTimeout_kb522;  // DUMMY!
        tsp00_Int4                  teLastWrite_kb522;
        tkb05_TransLockMode_Enum    teSQLLockMode_kb522;
        SAPDB_Int4                  teOMSLockMode_kb522;        // DUMMY!
        tkb05_TransLockMode_Enum    teRequestMode_kb522;
        SAPDB_Int4                  teHistoryRoot_kb522;        // DUMMY!
        SAPDB_Int4                  teHistoryLast_kb522;        // DUMMY!
        SAPDB_Int4                  teHistoryPageCount_kb522;   // DUMMY!
        SAPDB_Int4                  teLastHistorySeq_kb522;     // DUMMY!
        tgg91_TransNo               teConsistentViewID_kb522;
    };

    typedef Container_List<TransElement> TransList;



    /* -----------------------------------------------------------------------*/
    /*! chapter: Constructors and initialization                              */
    /* -----------------------------------------------------------------------*/

    /*!-------------------------------------------------------------------------
    function    : k521_SQLLockReader()
    description : constructor 
    arguments   : none
    return value: none
    --------------------------------------------------------------------------*/

    ckb522_TransReader(SAPDBMem_IRawAllocator	&alloc,
                       tgg00_TransContext        &trans);
    ~ckb522_TransReader(void);

    /* -----------------------------------------------------------------------*/
    /*! endchapter: Constructors and initialization                           */
    /* -----------------------------------------------------------------------*/

    SAPDB_Bool Begin (void);
    TransElement * Next (void);
    void FreeAll (void);

private:

    SAPDB_Bool ReadList(void);

    void PutLoopError (const SAPDB_Char  *msg,
                       SAPDB_Int4        iError);

    void ToTimestamp (tsp00_Timestamp    &datetime, 
                      tsp00_Date         &date,
                      tsp00_Time         &time);

    void ToTimestamp (tsp00_Timestamp    &datetime,
                      tsp00_Int4         &date,
                      tsp00_Int4         &time);



    SAPDBMem_IRawAllocator	                &m_Allocator;
    tgg00_TransContext                      &m_Trans;
    TransList                               *m_List;
    TransList::Iterator                     m_Current;
};

/*!***************************************************************************

   endclass: SysView_ActiveConfiguration

******************************************************************************/

#endif  /* VKB522_HPP */

