/*!******************************************************************************

  @file         hkb511.h

  ------------------------------------------------------------------------------

  @author       FerdiF

  @brief        KB_ConsistView_lock

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB511_H
#define HKB511_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x84\x88\x35\x44\x2b\xf1\xe4\xe5\xf2\x29\x5a\x9d\x23\x35\x6c\x6b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void kb511EnterConsistView (
    tsp00_TaskId                         Taskid,
    pasbool                              exclusiveRequest);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511LeaveConsistView (
    tsp00_TaskId                         Taskid,
    pasbool                              exclusiveRequest);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511InitRWConsistLocks ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511PrintSignal (
    tsp00_TaskId                         srcTaskid,
    tsp00_TaskId                         destTaskid,
    pasbool                              destWasWaiting);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511PrintTransEntry (
    tkb05_TransEntryPtr                  entry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511PrintTabLock (
    tsp00_Int4                           ident,
    tkb05_TabLockPtr                     tab,
    tkb05_TransEntryPtr                  thisTrans,
    pasbool                              collided,
    tgg00_BasisError                     berr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511PrintRequest (
    tsp00_Int4                           ident,
    tkb05_ReqPtr                         req,
    tgg00_BasisError                     collisionErr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511PrintWantedLock (
    tsp00_Int4                           ident,
    tkb05_WantedLock      VAR_VALUE_REF  wanted);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb511WriteStringToTrace (
    tsp00_C40             VAR_ARRAY_REF  string,
    tgg00_TransIndex                     index,
    tgg00_BasisError                     err);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

