/*!******************************************************************************

  module:        SAPDBFields_FieldMap.cpp

  ------------------------------------------------------------------------------

  responsible:  UweH
  authors:      StefanB, TillW

  special area: Field Container classes

  description:  class definitions for SAPDBFields_FieldMap

  ------------------------------------------------------------------------------

  copyright:                 (c) 1999-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*******************************************************************************/


#include "SAPDBCommon/Fields/SAPDBFields_FieldMap.hpp"

/*******************************************************************************
     class SAPDBFields_FieldMap
*******************************************************************************/

/*******************************************************************************
     protected member functions
*******************************************************************************/

SAPDBFields_FieldMap::SAPDBFields_FieldMap(SAPDBMem_IRawAllocator& RawAllocator, 
                                                         IndexType Max)
 : m_Content(RawAllocator)
{
    m_Content.Reserve(Max);
}

void SAPDBFields_FieldMap::Fill(IndexType Pos, IndexType Index, const SAPDBFields_Field& Field)
{
    SAPDBERR_ASSERT_ARGUMENT(Pos < m_Content.GetCapacity());
    if (!(Pos < m_Content.GetSize()))
        m_Content.Resize(Pos+1);
    m_Content[Pos] = EntryType(Index, Field);
}

SAPDBFields_Field::SizeType SAPDBFields_FieldMap::GetTotalLength() const
{
    IndexType n;
    SAPDBFields_Field::SizeType Sum = 0;
    SAPDBFields_Field Field;

    for (n=0; n<GetFieldCount(); ++n) {
        Sum += GetField(n, Field).GetLength();
    }
    return Sum;
}


SAPDBFields_Field::SizeType 
SAPDBFields_FieldMap::Write(SAPDBFields_Field            &Destination, 
                            SAPDBFields_Field::IndexType  Offset,
                            IndexType                     Begin, 
                            IndexType                     End) const
{
/*    
    SAPDBERR_ASSERT_ARGUMENT(Begin < GetFieldCount());
    SAPDBERR_ASSERT_ARGUMENT(End <= GetFieldCount());

    SAPDBFields_Field            Field;
    SAPDBFields_Field::IndexType Pos = Offset;

    for (IndexType i=Begin; i<End; ++i) {
        GetField(i, Field);
        Destination.SetFieldAt(Pos, Field);
        Pos += Field.GetLength();
    }
    return (Pos - Offset);
*/
    return 0;
}


void SAPDBFields_FieldMap::Sort()
{
    EntryType Entry;
    IndexType i, j;
    for (i=0; i<GetFieldCount(); ++i) {
        for (j=i+1; j<GetFieldCount(); ++j) {
            if (GetIndex(i) > GetIndex(j)) {
                Entry = m_Content[i];
                m_Content[i] = m_Content[j];
                m_Content[j] = Entry;
            }
        }
    }
}


void SAPDBFields_FieldMap::Print(SAPDB_OStream& os) const
{
/*+++++++++++++++++++++++++++++++++++++++++++++++++++
    SAPDBFields_Field F;
    IndexType n;

    IndexType Count = GetFieldCount();
    os << "Field map:" << NewLine;
    for (n=0; n<Count; ++n) {
        GetField(n, F);
        os << ToStr(n) << ": " << F << NewLine;
    }
+++++++++++++++++++++++++++++++++++++++++++++++++++*/
}
