/****************************************************************************

  module      : RTETask_Context.cpp

  -------------------------------------------------------------------------

  responsible : JoergM

  special area: Task Context
  description : Class defining a kernel task context

  last changed: 2000-07-24  18:13
  see also    : example.html ...
  first created:2000-02-24  18:50

  -------------------------------------------------------------------------





    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "RunTime/Tasking/RTETask_Context.hpp"
#include "heo51.h" // vgetpid
#include "heo56.h" // all other v... routines
#define TRACEWRITER_RESUME_ID 53

/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

RTETask_Context::RTETask_Context() 
{
  vgetpid(m_TaskId); 
}

/*---------------------------------------------------------------------------*/

RTETask_Context::RTETask_Context(const RTE_TaskId Id) 
{
  m_TaskId = Id; 
}

/*---------------------------------------------------------------------------*/

const RTE_TaskId RTETask_Context::GetTaskId() const 
{
  return m_TaskId; 
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Suspend( const RTE_Reason Reason )
{
  vsuspend(m_TaskId, Reason);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Resume( RTETask_IContext &TaskResuming,
                              const RTE_Reason /* Reason */ )
{
  vresume(m_TaskId);
}

/*---------------------------------------------------------------------------*/

bool RTETask_Context::IsResumed( )
{
  return ( visresume(m_TaskId) != 0 );
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::SuspendWhileTraceBusy( )
{
  vsuspend(m_TaskId, TRACEWRITER_RESUME_ID);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::ResumeByTracewriter( RTETask_IContext &TaskResuming )
{
  vresume(m_TaskId);
}

/*---------------------------------------------------------------------------*/

bool RTETask_Context::IsResumedByTracewriter( )
{
  return ( visresume(m_TaskId) != 0 );
}

/*---------------------------------------------------------------------------*/
  
void RTETask_Context::Wait ( bool &Ok  )
{
  tsp00_Bool PascalOk;
  vwait(m_TaskId, PascalOk);
  Ok = (PascalOk != 0);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Signal ( RTETask_IContext & TaskSignaling,
                               const bool Ok )
{
  vsignal(m_TaskId, Ok);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Sleep ( const SAPDB_Int2 SleepLimitInSeconds )
{
  vsleep(m_TaskId, SleepLimitInSeconds);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::RescheduleMsec( SAPDB_Int4 & StartMsec,
                                      SAPDB_Int4 & RemainMsec )
{
  vreschedule_msec ( m_TaskId, StartMsec, RemainMsec );
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Stop ( )
{
  vstop(m_TaskId);
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::Continue( )
{
  vcontinue(m_TaskId);
}

//void RTETask_Context::LockUKT()
//{
//  vLockDispatcher( m_TaskId );
//}

//void RTETask_Context::UnlockUKT()
//{
//  vUnlockDispatcher( m_TaskId );
//}

/*---------------------------------------------------------------------------*/

AK_TransContext *RTETask_Context::SetTransContext( AK_TransContext *pTaskTransContext )
{
  AK_TransContext *pFormerTransContext = m_pTransContext;
  m_pTransContext = pTaskTransContext;
  return pFormerTransContext;
}

/*---------------------------------------------------------------------------*/

AK_TransContext *RTETask_Context::GetTransContext( )
{
  return m_pTransContext;
}

/*---------------------------------------------------------------------------*/

const SAPDBErr_MessageList & RTETask_Context::GetLastErrorMessage()
{
  return m_LastErrorMessage;
}

/*---------------------------------------------------------------------------*/

void RTETask_Context::SetLastErrorMessage(const SAPDBErr_MessageList & LastErrorMessage, SAPDB_Bool DoAppend)
{
  if ( DoAppend )
  {
    m_LastErrorMessage.AppendNewMessage(LastErrorMessage);
  }
  else
  {
    m_LastErrorMessage = LastErrorMessage;
  }
}
/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
