#!/usr/bin/perl
# @(#) killsut   2001-02-13
#
# kills e running sut database after a defined time interval
# to prevent endless running suts
#
# Changes:
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use DBTools;


$USAGE = "usage: killsut <dbname> <prot file> [ <time interval> ]\n";

if  ( (@ARGV < 2) || (@ARGV > 3) || ((@ARGV == 3) && !($ARGV[2] =~ /^\d+$/)) ) {
    print "$USAGE";
    exit 1;
}

my $myDBName        = $ARGV[0];
my $myTouchFileName = $ARGV[1];

my $WaitForSut = 600; # default time interval is 10 minutes
$WaitForSut = $ARGV[2] if (@ARGV == 3);

#print "\n$myDBName, $myTouchFileName, $WaitForSut\n";

sleep "$WaitForSut";

# first touch a dummy file to handle this error in calling script
open (TFILE,">$myTouchFileName");
close (TFILE);

#than stop db
DBTools::stopdump_db($myDBName);



