# ipretty       [-m] parameter
#
# Beautifier for PASCAL sources packed in module frames.
# Parameter must be a standard module name, i.e. the directory "$SRC/$L",
# where L=`expr "parameter" : "v\(..\)"`, must exist.
# An implicit "iget -e0 parameter" is performed.
# If the option -m is specified, it is propagated to "iget".
# If an error occurred, the files "parameter.err", which contains the
# error messages, and "parameter.pre", which contains the generated
# output, are moved to "$WRK/fast/prot".
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#


use Env;
use File::Copy;

$BASEDIR = "$WRK/fast/prot";
$USAGE = "Usage: ipretty [-m]  parameter";

if ( $ARGV[0] eq "-m" ) {
  if ( @ARGV != 2 ) { print "$USAGE\n"; exit 1 };
  $OPT="m";
  $MOD=$ARGV[1];
} else {
  if ( @ARGV != 1 ) { print "$USAGE\n"; exit 1 };
  $MOD=$ARGV[0];
}

($LAYER) = $MOD =~ /^[vg]([a-z][a-z])/;

if ( ! -f "$SRC/$LAYER/$MOD" ) {
	die "Error: module doesn't exist.\n";
}

if ( ! -w "$SRC/$LAYER/$MOD" ) {
	die "Error: module isn't writeable.\n";
}

chdir ($BASEDIR);
copy ("$SRC/$LAYER/$MOD", "./$MOD");

if ($RELVER ge "R71") {
    $prettyexe = "prettyx";
}
else {
    $prettyexe = "pretty";
}

$RC = system ("%TOOL%/pgm/$prettyexe.exe $MOD");
unlink ("$MOD.prebak");
rename ($MOD, "$MOD.prebak");

if ( $RC != 0 ) {
  print "Error: more information in $WRK/fast/prot/$MOD.err" }
else {
        unlink "$SRC/$LAYER/$MOD";
        rename ("$MOD.pre", "$SRC/$LAYER/$MOD");
        if ( -f "$MOD.err" ) {
		unlink "$MOD.err"; }
}
caller() ? $RC : exit $RC ;

