# h.b. 23.09.1998  program to insert *.tpunx into sut.mac
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#



use ICopy;
use Env;

if ( @ARGV != 1 ) {
    print "USAGE: changesutmac <sut filename>\n";
    exit 1;
}

$file = ICopy::GetFilePath("sut.mac", 0, 1, 1);

if ( GetFile($file) == 0 ) {

    open (INFILE,"<$file");
    open (OUTFILE,">$TMP/sut.new");

    while (<INFILE>) {
       print OUTFILE $_;
       print OUTFILE "$ARGV[0].tpunx\n" if ( /^$ARGV[0]\.punix/i );
    }

    close (INFILE);
    close (OUTFILE);
    unlink ($file);
    rename ("$TMP/sut.new", $file);

    PutFile ($file);

} else {
    exit 1;
}


#################################################################
sub GetFile ()
{
    my ($file) = @_;

    if ( $ENV{DEPOT} ) {
        return system ("p4 edit $file");
    } else {
        $ENV{MGET} = "y";
        return system ("iget -e0 $file");
    }

}

#################################################################
sub PutFile ()
{
    my ($file) = @_;

    if ( $ENV{DEPOT} ) {
        return system ("p4put -d \"implicit submit from changesutmac\" $file");
    } else {
        $ENV{MGET} = "y";
        return system ("iput $file");
    }

}
