
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#
import nt, sys, ComponentTest

#-------------------------------------------------------------------
# Write information about the usage of this command and exit program
#

AllPlatforms = ["local", "aix32", "linux", "sun32", "hp32",
                "aix64", "dec", "sun64", "hp64", "ia64"]

def Usage():
  print "Usage:"
  print "  CompTest.py [-t<TestName>] [-l<TestListName>] [-u] < -a | <platform-list> >"
  print "Examples:"
  print "  CompTest -t::SAPDB/Test/TestTest_All.mac -u local linux sun32"
  print "  CompTest -lTests.lst -a"
  print "  CompTest aix32"
  print "Description:"
  print "  Compile and execute one or more tests (mac-description) on several"
  print "  platforms. If no test is specified, all available component tests"
  print "  are tested."
  print "Options:"
  print "  -t: Test only the mac-description <TestName>"
  print "  -l: Test only the mac-descriptions listet in file <TestListName>"
  print "      Lines in <TestListName> not beginning with :: are ignored"
  print "  -u: Unconditional, compile every source at least once"
  print "  -a: All, test the specified tests on all platforms"
  print "Platforms:"
  print "  ",
  for p in AllPlatforms:
    print p,
  sys.exit(-1)

#-------------------------------------------------------------------
# main program
#

# Check the arguments
if len(sys.argv) < 2:
  Usage()

# Initialize a log file
logfile = 'Test.log'
f = open(logfile, 'w')
f.write("COMPONENT TESTS\n")
f.close()

# Extract options and platforms from argument list
global unconditional
unconditional = 0
all = 0
TestName = ""
TestListName = ""
Platforms = []
for i in range(1, len(sys.argv)):
  arg = sys.argv[i]
  if arg[0] == "-":
    if arg[1] == "u":
      unconditional = 1
    elif arg[1] == "a":
      all = 1
    elif arg[1] == "t":
      TestName = arg[2:len(arg)]
    elif arg[1] == "l":
      TestListName = arg[2:len(arg)]
    else:
      print "Error: Unknown option <", arg, ">"
      Usage()
  else:
    Platforms.append(sys.argv[i])


# Check the platforms
if all and len(Platforms) != 0:
  print "Error: Don't specify platforms if option -a is set"
  Usage()
for p in Platforms:
  try:
    i = AllPlatforms.index(p)
  except ValueError:
    print "Error: Unknown platform <", p, ">"
    Usage()
if all == 1:
  Platforms = AllPlatforms
if len(Platforms) == 0:
  print "Error: No platform specified"
  Usage()

# Create the list of the tests to execute
TestList = []
if TestName != "":
  TestList.append(TestName)
else:
  if TestListName == "":
    TestPath = nt.environ['TEST']
    TestListName = TestPath + "\\jtest\\tests\\parameters\\ComponentTest.par"
  try:
    TestListFile = open(TestListName, "r")
    for Line in TestListFile.readlines():
      if len(Line) > 1:
        if Line[0] == ':' and Line[1] == ':':
          TestList.append(Line[0:len(Line)-1])
    TestListFile.close()
  except IOError:
    print "Error: File not found <", TestListName, ">"

# Evaluate the option -u
if unconditional:
  for p in Platforms:
    if p == "local":
      nt.system("del %OWN%\sys\wrk\incl /s /q > nul")
    else:
      nt.system("perl -S remfree.pl " + p)

for Test in TestList:
  Test = Test[0:len(Test)]
  print Test, Platforms
  ComponentTest.DoCompTest(logfile, Test, Platforms)


ComponentTest.EvaluateLogFile(logfile)

