/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdiag;

import com.sap.dbtech.jdiag.ByteUtil;
import com.sap.dbtech.jdiag.LongDescViewer;
import com.sap.dbtech.util.VDNNumber;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class JDiagGUI
extends JFrame {
    long londescCount = 0L;
    JComboBox ldwHistoryLB = new JComboBox();
    String inputBuffer;
    JTabbedPane tabPane = new JTabbedPane();
    JPanel longDescPanel = new JPanel();
    JPanel VDNNumberPanel = new JPanel();
    JPanel menu = new JPanel();
    JPanel status = new JPanel();
    JComboBox SwapKind = new JComboBox<Object>(new Object[]{"non-swap", "full-swap"});
    JButton Analyze = new JButton("Analyze");
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JScrollPane scrolli = new JScrollPane();
    JEditorPane longval = new JEditorPane();
    JSplitPane jSplitPane1 = new JSplitPane(0);
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout(0, 3, 1);
    GridLayout gridLayout1 = new GridLayout(10, 2);
    GridLayout gridLayout2 = new GridLayout();
    GridBagLayout VDNLayout = new GridBagLayout();
    JLabel lineal = new JLabel("|01|02|03|04| |05|06|07|08| |09|10|11|12| |13|14|15|16|");
    JTextField comment = new JTextField(String.valueOf(String.valueOf(new StringBuffer("Descriptor ").append(this.ldwHistoryLB.getItemCount()).append(1))));
    JLabel jLabelUndefSignal = new JLabel("UndefSignal:");
    JLabel jLabelUndefSignalVal = new JLabel();
    JLabel jLabelDescriptor = new JLabel("Descriptor:");
    JLabel jLabelDescriptorVal = new JLabel();
    JLabel jLabelTabid = new JLabel("Tabid:");
    JLabel jLabelTabidVal = new JLabel();
    JLabel jLabelMaxLen = new JLabel("MaxLen:");
    JLabel jLabelMaxLenVal = new JLabel();
    JLabel jLabelInternPos = new JLabel("InternPos:");
    JLabel jLabelInternPosVal = new JLabel();
    JLabel jLabelInfoset = new JLabel("Infoset:");
    JLabel jLabelInfosetVal = new JLabel();
    JLabel jLabelValmode = new JLabel("Valmode:");
    JLabel jLabelValmodeVal = new JLabel();
    JLabel jLabelValind = new JLabel("Valind:");
    JLabel jLabelValindVal = new JLabel();
    JLabel jLabelValpos = new JLabel("Valpos:");
    JLabel jLabelValposVal = new JLabel();
    JLabel jLabelVallen = new JLabel("Vallen:");
    JLabel jLabelVallenVal = new JLabel();
    TitledBorder titledBorder1;
    JButton ButtonVDNnative2VDN = new JButton("VDN -> Native");
    JButton ButtonVDN2Native = new JButton("Native -> VDN");
    JLabel labelNativeNumber = new JLabel("Native Number Value");
    JLabel LabelVDNNumber = new JLabel("VDN Number Value");
    JTextField textFieldVDNnativeValue = new JTextField();
    JTextField textFieldVDNNumberValue = new JTextField();
    JButton jButtonSave = new JButton(new ImageIcon((class$com$sap$dbtech$jdiag$JDiagGUI == null ? (class$com$sap$dbtech$jdiag$JDiagGUI = JDiagGUI.class$("com.sap.dbtech.jdiag.JDiagGUI")) : class$com$sap$dbtech$jdiag$JDiagGUI).getResource("JDiag_save.gif")));
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabelStatus = new JLabel();
    static Class class$com$sap$dbtech$jdiag$JDiagGUI;

    public JDiagGUI() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        this.setTitle("JDiagnose");
        ImageIcon myIcon = new ImageIcon((class$com$sap$dbtech$jdiag$JDiagGUI == null ? (class$com$sap$dbtech$jdiag$JDiagGUI = JDiagGUI.class$("com.sap.dbtech.jdiag.JDiagGUI")) : class$com$sap$dbtech$jdiag$JDiagGUI).getResource("JDiag.gif"));
        ((Frame)this).setIconImage(myIcon.getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDiagGUI.this.this_windowClosing(e);
            }
        });
        this.Analyze.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDiagGUI.this.Analyze_actionPerformed(e);
            }
        });
        this.jSplitPane1.setPreferredSize(new Dimension(415, 320));
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel3.setLayout(this.gridLayout1);
        this.lineal.setFont(new Font("Monospaced", 0, 12));
        this.lineal.setBorder(new TitledBorder(""));
        this.comment.setFont(new Font("Monospaced", 0, 12));
        this.comment.setBorder(new TitledBorder(""));
        this.ButtonVDN2Native.setPreferredSize(new Dimension(120, 27));
        this.ButtonVDN2Native.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDiagGUI.this.native2VDN_actionPerformed(e);
            }
        });
        this.textFieldVDNnativeValue.setPreferredSize(new Dimension(370, 21));
        this.labelNativeNumber.setPreferredSize(new Dimension(80, 17));
        this.labelNativeNumber.setText("Native Number Value: ");
        this.LabelVDNNumber.setAlignmentX(0.5f);
        this.LabelVDNNumber.setPreferredSize(new Dimension(130, 17));
        this.LabelVDNNumber.setHorizontalTextPosition(10);
        this.LabelVDNNumber.setText("VDN Number Value: ");
        this.textFieldVDNNumberValue.setPreferredSize(new Dimension(370, 21));
        this.ButtonVDNnative2VDN.setPreferredSize(new Dimension(120, 27));
        this.ButtonVDNnative2VDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDiagGUI.this.VDN2native_actionPerformed(e);
            }
        });
        this.getContentPane().setFont(new Font("Monospaced", 0, 12));
        this.longval.setFont(new Font("Monospaced", 0, 12));
        this.ldwHistoryLB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDiagGUI.this.ldwHistoryLB_actionPerformed(e);
            }
        });
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDiagGUI.this.jButtonSave_actionPerformed(e);
            }
        });
        this.status.setLayout(this.borderLayout2);
        this.getContentPane().add(this.tabPane);
        this.tabPane.add("Long Descriptor", this.longDescPanel);
        this.tabPane.add("VDN Number", this.VDNNumberPanel);
        this.VDNNumberPanel.setLayout(this.VDNLayout);
        this.VDNNumberPanel.add((Component)this.LabelVDNNumber, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.textFieldVDNnativeValue, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.labelNativeNumber, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.textFieldVDNNumberValue, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.ButtonVDNnative2VDN, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.VDNNumberPanel.add((Component)this.ButtonVDN2Native, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.longDescPanel.setLayout(this.borderLayout1);
        this.longDescPanel.add((Component)this.menu, "North");
        this.menu.setLayout(this.flowLayout1);
        this.menu.add((Component)this.SwapKind, null);
        this.menu.add((Component)this.Analyze, null);
        this.menu.add((Component)this.ldwHistoryLB, null);
        this.menu.add((Component)this.jButtonSave, null);
        this.longDescPanel.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jScrollPane2, "bottom");
        this.longDescPanel.add((Component)this.status, "South");
        this.status.add((Component)this.jLabelStatus, "Center");
        this.status.setPreferredSize(new Dimension(300, 25));
        this.jScrollPane2.getViewport().add((Component)this.jPanel3, null);
        this.jSplitPane1.add((Component)this.jPanel2, "top");
        this.jPanel2.add((Component)this.lineal, "North");
        this.jPanel2.add((Component)this.scrolli, "Center");
        this.jPanel2.add((Component)this.comment, "South");
        this.scrolli.getViewport().add((Component)this.longval, null);
        this.jPanel3.add((Component)this.jLabelUndefSignal, null);
        this.jPanel3.add((Component)this.jLabelUndefSignalVal, null);
        this.jPanel3.add((Component)this.jLabelDescriptor, null);
        this.jPanel3.add((Component)this.jLabelDescriptorVal, null);
        this.jPanel3.add((Component)this.jLabelTabid, null);
        this.jPanel3.add((Component)this.jLabelTabidVal, null);
        this.jPanel3.add((Component)this.jLabelMaxLen, null);
        this.jPanel3.add((Component)this.jLabelMaxLenVal, null);
        this.jPanel3.add((Component)this.jLabelInternPos, null);
        this.jPanel3.add((Component)this.jLabelInternPosVal, null);
        this.jPanel3.add((Component)this.jLabelInfoset, null);
        this.jPanel3.add((Component)this.jLabelInfosetVal, null);
        this.jPanel3.add((Component)this.jLabelValmode, null);
        this.jPanel3.add((Component)this.jLabelValmodeVal, null);
        this.jPanel3.add((Component)this.jLabelValind, null);
        this.jPanel3.add((Component)this.jLabelValindVal, null);
        this.jPanel3.add((Component)this.jLabelValpos, null);
        this.jPanel3.add((Component)this.jLabelValposVal, null);
        this.jPanel3.add((Component)this.jLabelVallen, null);
        this.jPanel3.add((Component)this.jLabelVallenVal, null);
        this.pack();
        ((Component)this).setVisible(true);
        this.jSplitPane1.setDividerLocation(135);
    }

    void this_windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public static void main(String[] args) {
        JDiagGUI ldg = new JDiagGUI();
        try {
            if (args.length > 0) {
                ldg.longval.setText(args[0]);
            }
            ldg.Analyze_actionPerformed(null);
        }
        catch (Exception ex) {
            JDiagGUI.logError(ex);
        }
    }

    void renderLongDesc(LongDescViewer ldw) {
        this.jLabelUndefSignalVal.setText(ldw.lDesc.getUndefSignal());
        this.jLabelDescriptorVal.setText(ldw.lDesc.getDescriptor());
        this.jLabelTabidVal.setText(ldw.lDesc.getTabid());
        this.jLabelMaxLenVal.setText(Integer.toString(ldw.lDesc.MaxLen));
        this.jLabelInternPosVal.setText(Integer.toString(ldw.lDesc.InternPos));
        this.jLabelInfosetVal.setText(ldw.lDesc.getInfoSet());
        this.jLabelValmodeVal.setText(ldw.lDesc.getValmode());
        this.jLabelValindVal.setText(Integer.toString(ldw.lDesc.Valind));
        this.jLabelValposVal.setText(Integer.toString(ldw.lDesc.Valpos));
        this.jLabelVallenVal.setText(Integer.toString(ldw.lDesc.Vallen));
        this.longval.setText(ByteUtil.printasHexPattern(ldw.lDesc.wholeDescriptor, '|'));
        this.comment.setText(ldw.comment);
    }

    void Analyze_actionPerformed(ActionEvent e) {
        try {
            this.inputBuffer = this.longval.getText();
            LongDescViewer ldw = new LongDescViewer(ByteUtil.parseBytes(this.inputBuffer, 42), this.SwapKind.getSelectedIndex() == 1 ? 2 : 1, this.comment.getText());
            this.ldwHistoryLB.addItem(ldw);
            this.ldwHistoryLB.setSelectedIndex(this.ldwHistoryLB.getItemCount() - 1);
            this.renderLongDesc(ldw);
        }
        catch (Exception ex) {
            JDiagGUI.logError(ex);
        }
    }

    void native2VDN_actionPerformed(ActionEvent e) {
        try {
            BigDecimal input = new BigDecimal(this.textFieldVDNnativeValue.getText());
            this.textFieldVDNNumberValue.setText(ByteUtil.printasHex(VDNNumber.bigDecimal2number(input)));
        }
        catch (NumberFormatException input) {
        }
        catch (Exception ex) {
            JDiagGUI.logError(ex);
        }
    }

    void VDN2native_actionPerformed(ActionEvent e) {
        try {
            if (this.textFieldVDNNumberValue.getText().equals("")) {
                this.textFieldVDNnativeValue.setText("0");
                return;
            }
            byte[] input = ByteUtil.parseBytes(this.textFieldVDNNumberValue.getText(), 20);
            this.textFieldVDNnativeValue.setText(VDNNumber.number2BigDecimal(input).toString());
        }
        catch (Exception ex) {
            JDiagGUI.logError(ex);
        }
    }

    public static void showInfo(String info) {
        JOptionPane.showMessageDialog(null, info, "Information", 1);
    }

    public static void logError(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        JDiagGUI.logError(sw.toString());
    }

    public static void logError(String error) {
        JOptionPane.showMessageDialog(null, error, "Error", 0);
    }

    void native2VDN_performed(ActionEvent e) {
    }

    void ldwHistoryLB_actionPerformed(ActionEvent e) {
        this.renderLongDesc((LongDescViewer)this.ldwHistoryLB.getSelectedItem());
    }

    void jButtonSave_actionPerformed(ActionEvent e) {
        FileWriter destFile = null;
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showDialog(null, "Save");
        if (returnVal != 0) {
            JDiagGUI.logError("Save long descriptors to file failed");
        }
        try {
            destFile = new FileWriter(fileChooser.getSelectedFile());
            for (int i = 0; i < this.ldwHistoryLB.getItemCount(); ++i) {
                LongDescViewer lwd = (LongDescViewer)this.ldwHistoryLB.getItemAt(i);
                lwd.dumpToStream(destFile);
                destFile.write("\n--------------------------------------------------\n");
            }
            this.jLabelStatus.setText("Data saved to ".concat(String.valueOf(String.valueOf(fileChooser.getSelectedFile()))));
            destFile.close();
        }
        catch (Exception ex) {
            JDiagGUI.logError(ex);
            this.jLabelStatus.setText("Save date failed");
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

