#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Uninstall/Start.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: start uninstallation SAP DB packages
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::Uninstall::Start;

$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Values',
		'System',
		'Registry',
		'StdIO',
		'InstallRegistry',
		'Version',
		'MD5Sum',
		'SetDebug',
		'Log',
		'Tools',
		'Cwd',
		'Getopt::Long',
		'Misc',
		'Cleaner',
		'Uninstall::Collector',
		'Diagnose::InstallRegistry',
		'Migrate::Registry',
		'SigHandler',
		'Cleaner',
		'Trace',
		'Templates::Setup'
	);

	$DEBUG = 0;

	push @neededPackages, 'Uninstall::RemoveFilesInUse' if ($^O =~ /mswin/i);
	push @neededPackages, 'Term::ReadKey' if $SAPDB::Install::Config{'HasOwnConsole'};

	
	@EXPORT=('main');
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
}


sub uninstall{
	my ($regpackobj)=@_;
	my @undeleted;
	defined $regpackobj || print2stderr("package not defined\n") && diesoft($diemsg);
	my %regmd5sums = %{$regpackobj->FileList};
	foreach my $file (keys(%regmd5sums)){
		my $fullpath = $regpackobj->Path."/$file";
		-f $fullpath or print2stderr("cannot delete file \"$fullpath\": no such file\n") and next; 
		if($regmd5sums{$file} eq MD5Sum($fullpath)){
			unless(unlink($fullpath)){
				push @undeleted, $fullpath;
				if($^O =~ /mswin/i){
					$regpackobj->Registry->Log->SetMsg("cannot delete file \"$fullpath\": $!\n");
				}
				else{	
					print2stderr("cannot delete file \"$fullpath\": $!\n");
				}
			}
			$regpackobj->Registry->Log->SetMsg("file \"$fullpath\" deleted\n");
		}
		else{
			print2stderr("dont delete file \"$fullpath\": file modified\n");
		}
	}
	return @undeleted;	
}


sub main {
 	local @ARGV=@_;
	my $argvstring = join(' ',@ARGV);
	SetDebug(\@ARGV);
	printVersion(\@ARGV);
 	%opt_ctrl=(
		'h' => \$opt_help,
		'help' => \$opt_help,
		'package=s' => \$opt_displayname,
		'packagetype=s' => \$opt_packname,
		'package_dir=s' => \$opt_instpath,
		'autoresolve' => \$opt_delete_dependent,
		'all' => \$opt_all,
		'l' => \$opt_list,
		'list' => \$opt_list
	);	
	
	my $usage= " [-h|--help] | [-v|--version] | [-l|--list] |\n".
				"\t-all | -package <package name> [-package_dir <package directory>] [-autoresolve] \n"; 
	my $usage_desc =	"\t\t-h --help\t\t\tshow this\n".
				"\t\t-v --version\t\t\tshow version\n".
				"\t\t-l --list\t\t\tlist installed packages\n".
				"\t\t-package <package name>\t\tuninstall a package with such name\n".
				"\t\t-package_dir <package directory>\t\tuninstall package <package name> installed in <package directory>\n".
				"\t\t-all\t\t\tuninstall all registered MaxDB packages\n".
				"\t\t-autoresolve\t\tuninstall package <package name> and all dependent packages\n";	
						
	SAPDB::Install::Getopt::Long::Configure ('no_pass_through');					
	if(!GetOptions(%opt_ctrl) || $opt_help){
		print ("\n\nusage: ".$SAPDB::Install::Config{'ProgramName'}."$usage \n\n $usage_desc\n\n\n");
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}
		die("\n\n\n");
	}
 	
	$SAPDB::Install::Values::diemsg = 'MaxDB uninstall tool exited abnormally';


	setSigHandler();
	
	unless($opt_list){
		 $> == 0 or print STDERR "please start as root\n" and die("\n\n");		
	}
	local $log = SAPDB::Install::Log->new();
	$log->SetMsg('CALL: '.$SAPDB::Install::Config{'ProgramName'}." $argvstring\n");
	$SAPDB::Install::Values::log=$log;
	$log->LogName("MaxDB Uninstall");
	local $cleaner = SAPDB::Install::Cleaner->new();
	$cleaner->SetRef(\$SAPDB::Install::Values::log);
	my ($data_path,$prog_path)=readIndepPath();
 	-d $data_path || print2stderr("no data path found\n") && diesoft($diemsg);
 	-d "$data_path/config/install" || print2stderr("path \"$data_path/config/install\" not found\n") && diesoft($diemsg);
 	setPathInEnv("$prog_path/bin");
	setPathInEnv("$prog_path/pgm") if $^O =~ /mswin/i;
	local $instRegistry=SAPDB::Install::InstallRegistry->new("$data_path/config/install",! $opt_list,$log);
 	defined $instRegistry || print2stderr("cannot find install registry\n") && diesoft($diemsg); 	
	migrateReg($instRegistry);
	if($opt_list){
		$log->LogOff(1); # write no logfile
		$instRegistry->printPackageList($opt_packname);
		if($SAPDB::Install::Config{'HasOwnConsole'}){
			print2stdout("\npress any key...");
			SAPDB::Install::Term::ReadKey::ReadMode('raw');
			SAPDB::Install::Term::ReadKey::ReadKey();
		}
		exit 0;
	}
	$cleaner->SetRef(\$instRegistry);
	my @packages;
	if($opt_all){
		@packages=collect('instreg' => \$instRegistry, 'collect_all' => 1);
	}	
	else{
		($opt_packname =~ /\S/ or $opt_displayname) or print2stdout("no packagename\n") and diesoft($diemsg);
		$DEBUG && print "DEBUG: start collection\n";
		my $instpath;
		if($opt_instpath){
			$instpath = $opt_instpath;	
			normalizePath(\$instpath);
		}
		@packages=collect('instreg' => \$instRegistry,'package_name' => $opt_packname,'display_name' => $opt_displayname,'package_path' => $instpath, 'auto_resolve' => $opt_delete_dependent); 	
		$DEBUG && print "DEBUG: collection finsished: ".($#packages+1)." packages\n";
	}
	$#packages == -1 && print2stderr("no package selected\n") && diesoft($diemsg);	
	
    	
	
	foreach my $regpackobj (@packages){	
		$regpackobj->evalScript;
		if(defined $regpackobj->preuninstall){
			eval{
				&{$regpackobj->preuninstall};
			}; $@ and print2stderr("error in preuninstall(): $@\n");
		}
	}
	
	$instRegistry->DenyWrite(0); # scharf schalten
	
	my @unremoved_dirs;
	my @removed_dirs;
	
	foreach my $regpackobj (@packages){	
		$DEBUG && print "DEBUG: uninstallation of package ".$regpackobj->DispName.' ('.$regpackobj->Path.")\n";
		$regpackobj->setValid(0);
		if(defined $regpackobj->unregister){
			eval{
				&{$regpackobj->unregister};
			}; $@ and print2stderr("error in unregister(): $@\n");
		}
		
		my @files_left = uninstall($regpackobj);
		
		my @undeleted_files;		
		if(defined $regpackobj->postuninstall){
				eval{
				@undeleted_files = &{$regpackobj->postuninstall};
			}; $@ and print2stderr("error in postuninstall(): $@\n");
		}
		
		if($#undeleted_files != -1){
			push @files_left,@undeleted_files;
		}
		
		$^O =~ /mswin/i and killUsedFiles(@files_left);
		
		# remove package from install registy
		$instRegistry->removePackage($regpackobj->Name,$regpackobj->Path);
		
		# try to delete directories
		my $main_path_inside = 0; 
		my $drive = '';
		
		if(defined $regpackobj->Pathes){
			foreach my $dirref (@{$regpackobj->Pathes}){	
				if(normalizePath(${%$dirref}{'value'}) eq normalizePath($regpackobj->Path)){
  					$main_path_inside = 1;
				}
				if($^O =~ /mswin/i){
					($drive) = (${%$dirref}{'value'} =~ /^([a-z]:)/i); 
					`$drive`;
				}
				chdir($drive.'/'); # change into root directory
				my ($rc,$ref_removed,$ref_unremoved) = removeEmptyDirs( ${%$dirref}{'value'});
				@unremoved_dirs = union (\@unremoved_dirs,$ref_unremoved);  
				@removed_dirs = union (\@removed_dirs,$ref_removed);  
			}
		}
		else{
			TraceMsg("member pathes not defined\n",4,\$DEBUG);
		}
		unless($main_path_inside){
			TraceMsg("main path not part of pathes\n",4,\$DEBUG);
			if($^O =~ /mswin/i){
					($drive) = ($regpackobj->Path =~ /^([a-z]:)/i); 
					`$drive`;
			}
			chdir($drive.'/'); # change into root directory
			my ($rc,$ref_removed,$ref_unremoved) = removeEmptyDirs($regpackobj->Path);
			@unremoved_dirs = union (\@unremoved_dirs,$ref_unremoved);  
			@removed_dirs = union (\@removed_dirs,$ref_removed);  
		}
	}
	
	
	# normalize pathes

	if($^O =~ /mswin/i){
		my @tmp;
		foreach my $path (@unremoved_dirs){
			my $tmp = $path;
			normalizePath(\$tmp);
			push @tmp,$tmp;
		}
		@unremoved_dirs=@tmp;
		
		@tmp=();
		foreach my $path (@removed_dirs){
			my $tmp = $path;
			normalizePath(\$tmp);
			push @tmp,$tmp;
		}
		@removed_dirs=@tmp;	
	}
	
	
	@unremoved_dirs = removeDoublesFromList(\@unremoved_dirs);
	@removed_dirs = removeDoublesFromList(\@removed_dirs);
	
	@unremoved_dirs = minus(\@unremoved_dirs,\@removed_dirs);
	
	$instRegistry->RefreshAllFilesList;
	my %existing_files = %{$instRegistry->AllFiles};
		
	foreach my $dir (sort @unremoved_dirs){
		my $found = 0;
		my $pattern = $dir;
		$pattern =~ s/\//\\\//g; # mask slashes
		$pattern = '^'.$pattern;
		foreach my $file (keys(%existing_files)){
			$file =~ /$pattern/ and $found = 1 and last;
		}
		print2stderr("cannot remove directory \"$dir\"\n") unless $found;
	}

	print2stdout("done\n");
	
	if($SAPDB::Install::Config{'HasOwnConsole'}){
		print2stdout("\npress any key...");
		SAPDB::Install::Term::ReadKey::ReadMode('raw');
		SAPDB::Install::Term::ReadKey::ReadKey();
	}

	return 0;
}

1;