#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Uninstall/RemoveFilesInUse.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: - Windows only
#		- for HPUX it isnt implemented yet
#		- all other supported plattforms are able to delete such files
#		- move busy binaries into a temp folder
#		- generate registry entry for deletion at next windows start 
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Uninstall::RemoveFilesInUse;

$VERSION = 1.01;

sub BEGIN {
    my $repo = SAPDB::Install::Repository::GetCurrent ();
	@EXPORT=('killUsedFiles');
	my @neededPackages=(
		'System',
		'Registry',
		'StdIO',
		'Values',
		'SetDebug',
		'Tools',
		'Misc',
		'Trace'
	);
	push @neededPackages,'System::Win32::API' if $^O =~ /mswin/i;
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
}
$DEBUG=0;

sub setFileRenamedOperation{
	my (@files) = @_;
	my $rc = 1;
	my $useOwnRegistryAccess = 0;
	if($useOwnRegistryAccess){
		$rc = setRenamedFiles(@files);
	}
	else{
		foreach my $file (@files){
			$file =~ s/\//\\/g;
			my ($lrc,$errtxt) = SAPDB::Install::System::Win32::API::MoveFileAfterReboot($file);	
			unless($lrc == 0){
				print2stderr("cannot mark \"".$file."\" for deletion after reboot: $errtxt\n");
				$rc = 0;
			}
		}	
	}
	return $rc;
}


my %tmps;

sub getTmpDir{
	my ($drive) = @_;
	defined $tmps{$drive} and return 1;
	my $found = 0;
	foreach my $dir ('TEMP','TMP'){
		if( -d "$drive/$dir"){
			$tmps{$drive} = "$drive/$dir";
			$found = 1;
			last;
		}
	}
	unless($found){
		# no tmp directory for drive found, make own one
		my $tmpdir = "$drive/TEMP";
		mkdir($tmpdir,0777) or print2stderr("cannot create temporary directory \"$tmpdir\"\n") and return 0; 
		$tmps{$drive} = $tmpdir;
	}
	return 1; 
}


sub killUsedFiles{
	return 0 unless($^O =~ /mswin/i); # only for win
	my (@files) = @_;
	my @renamedFiles;
	
	foreach my $file (@files){
		$file =~ s/\\/\//g;
		-f $file or TraceMsg("file \"$file\" not found\n",4,\$DEBUG) and next;	
		my ($drive,$filename) = ( $file =~ /^(..).*\/([^\/]+)$/) ;
		$filename =~ /\S/ or next;
		$drive =~ tr/[A-Z]/[a-z]/;
		unless($drive =~ /^[a-z]:$/){
			print2stderr("drive unknown\n");
			next;
		}
		getTmpDir($drive) or print2stderr("cannot get tmp dir of filesystem\n") and next;	
		my $destination = "$tmps{$drive}/$filename.del";
		if(-f $destination){
			my $count = 0;
			while(-f "$destination$count"){$count++;}
			$destination = "$destination$count";
			TraceMsg("move to $destination\n",4,\$DEBUG);
		}
		rename($file,$destination) or print2stderr("cannot rename used file \"$file\": $!\n") and next; 	
		$destination =~ s/\//\\/g; 
		push @renamedFiles,$destination;
	}
	setFileRenamedOperation(@renamedFiles) or return 0;	
	return 1;
}

1;