#!/usr/bin/perl -w
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

package SAPDB::Install::Templates::Test;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
        @EXPORT = qw( );
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=qw ( Templates::Setup Getopt::Long Templates::MobileInfra Registry  System);
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die ("Error loading:  SAPDB::Install::$package\n");
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
        bootstrap SAPDB::Install::DBMCmd;
}

my ($template,$install,$uninstall,$list,$help);
sub main {
  my $retVal=0;
  my ($indep_data,$indep_prog)=readIndepPath(); # try to get independent pathes from earlier installation
  $indep_data or die "Indepdata not found\n";
  $indep_prog or die "Indepprog not found\n";
  setPathInEnv("$indep_prog/bin");
  setPathInEnv("$indep_prog/pgm") if $^O =~ /mswin/i;
  GetOptions( 'template=s' => \$template , 'i' =>\$install,'u'=>\$uninstall, 'l'=> \$list,'h' => \$help);
  if ($template) {
    -f $template or die "Template '$template' not found!\n";
  } else {
    $template = 'Template.config'; 
    -f $template or print "WARNING: No template specified and default template 'Template.config' not found."; 
  }
     
  print "Using template '$template' ...\n";
  my $t = SAPDB::Install::Templates::MobileInfra::new();
  -f $template and list($t);
  $list and $t->writeConfig(sub{print $_[0];});
  $install and $t->createInstance();
  $uninstall and $t->deleteInstance();
  $help and usage(); 
  return $retVal;
}

sub usage{
  print "Options: -template <TEMPLATE> [-i|-u|-l|-h]\n".
    "-i: install\n" .
      "-u: uninstall\n" .
        "-l: list\n" .
          "-h: help\n" .
            "";
  return 1;
}
sub list{
  my $t = shift;
  $t->configureFromFile($template);
#  $t->dbmcliCall("dbmcli db_enum");
}

1;

## compile-command:  "c:\\Sapdevelop\\V75\\c_00\\develop\\sys\\wrk\\fast\\install56\\sdbrun.exe --tree c:\\SapDevelop\\V75\\c_00\\develop\\sys\\src\\install56\\perl  --main SAPDB::Install::Templates::Test::main -template c:\\SapDevelop\\V75\\c_00\\develop\\sys\\src\\install56\\perl\\SAPDB\\Install\\Templates\\Template.config" ***

# Local Variables: ***
# eval:  (setq sdb-current-own (sdb-get-current-own)) ***
# eval:  (setq sdb-current-exe (format "%s\\sys\\wrk\\fast\\install56\\sdbrun.exe" sdb-current-own)) ***
# eval:  (setq sdb-current-tree (format "%s\\sys\\src\\install56\\perl" sdb-current-own)) ***
# eval:  (setq sdb-current-main "SAPDB::Install::Templates::Test::main") ***
# eval:  (setq sdb-current-template (format "%s\\sys\\src\\install56\\perl\\SAPDB\\Install\\Templates\\Template.config" sdb-current-own)) ***
# eval:  (setq compile-command (format "%s --tree %s --main %s -template  %s" sdb-current-exe sdb-current-tree sdb-current-main sdb-current-template)) ***
# End: ***
