#!/usr/bin/perl
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

package SAPDB::Install::Templates::Simple;

#ifdef SCRIPTING
#use strict;
#use SAPDB::Install::Templates::Base;
#endif
  #ifdef PERL5.6.1
#  require Exporter;
#  our @ISA = qw ( SAPDB::Install::Templates::Base Exporter );
#  our @EXPORT=qw(  );
  #endif
  #ifdef PERL5.0.0
#  require Exporter;
#  @ISA = qw ( SAPDB::Install::Templates::Base  Exporter );
#  @EXPORT=qw( );
  #endif

#ifdef doc
#<h1>SAPDB::Install::Templates::Simple </h1>
#<h2><code>Extends <a href="Base.html">Base</a> </code></h2>
#<p>
#Template for simple database  instances.
#</p>
#<h2>Usage</h2>
#<pre>
#  my $mi = SAPDB::Install::Templates::Simple::new();
#  my $mi->set...();
#  my $mi->createInstance();
#</pre>
#endif
#because SDBINST
sub BEGIN {
  my $repo = SAPDB::Install::Repository::GetCurrent ();
  my @neededPackages=(
                      'Templates::Base'

                     );
  @ISA = qw(SAPDB::Install::Templates::Base);
  @EXPORT= qw( );
  foreach my $package (@neededPackages) {
    unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
      print join ("\n", $repo->GetErr)."\n";
      die ("error loading:  SAPDB::Install::$package\n");
    }
    SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
  }
}
#endbecause


#Konstruktor fr Simple-Instanzen
#+sub():Simple:Default-Konstruktor
sub new(){
  my $this = createThis();
  bless $this;
  $this->setType('simple');
  $this->setDrive("c"); #Implicitly sets dependend path, data path and log path
  #defaults for volume sizes
  $this->setDataSize(64000);#500MB
  $this->setLogSize(25600);#200MB
  $this->setDataVolCount(1);
  $this->setLogVolCount(1);
  #DB defaults for users and passwords
  $this->setDBA("dba");
  $this->setDBName("MAXDB1");
  $this->setDBAPass("dba");
  $this->setDBM("dbm");
  $this->setDBMPass("dbm");
  $this->setSQLU("maxdbsql");
  $this->setSQLPass("maxdbsql");
  $this->setDomainPass("domain");
  #set Autoextend and log overwrite on
  $this->setAutoExtend("YES");
  $this->setLogAutoOverwrite("YES");
  #DB-Defaults: database parameters
  $this->setDBParams({});
  $this->addDBParam("CACHE_SIZE","2500");
  $this->addDBParam("MAXDATAVOLUMES","64");
  $this->addDBParam("MAXUSERTASKS","20");
  $this->addDBParam("RESTART_SHUTDOWN","AUTO");
  $this->addDBParam("_UNICODE","YES");
  $this->addDBParam("SESSION_TIMEOUT","0");

  return $this;
}
#new







1;
# Local Variables: ***
# perl-dbg-flags:"-w      -I../../../../../../wrk/script -I../../../sdbrun  " ***
# sdbinst-defines: "-define SCRIPTING -define PERL5.6.1" ***
# sdbinst-testfile: "SimpleTest.pl" ***
# sdbinst-script-directory:  "sys/wrk/script/SAPDB/Install/Templates" ***
# End: ***



