#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/PackageObj.pm#4 $
# $DateTime: 2004/01/15 09:17:16 $
# $Change: 61975 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::PackageObj;


$VERSION = 1.01;

sub BEGIN {
      my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Tools',
		'Base',
		'Values',
		'MD5Sum',
		'Trace'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

@ISA=qw(SAPDB::Install::Base);

my %members=(
	ID => undef,
	InterfaceVersion => undef,
	Name => undef,						# unique package type identifier
	Version => undef,
	PackageVersion => undef,
	Mode => undef,
	Type => undef,
	MinVersion => undef,
	Profiles => undef,
	TopOf => undef,
	Require => undef,
	Required => undef,
	FileList => undef,
	Script => undef,
	TestFile => undef,
	MagicMode => undef,
	AllowSkip => undef,
	preinstall => undef,
	preunpack => undef,
	postprepare => undef,
	postinstall => undef,
	register => undef,
	unregister => undef,
	framestart => undef,
	framestop => undef,
	Paths => undef,
	MainPath => undef,
	Archive => undef,
	Opts => undef,
	RegData=> undef,
	Usage => undef,
	UsageDesc => undef,
	Skip => undef,
	Update => undef,
	User => undef,
	UID => undef,
	Group => undef,
	GID => undef,
	MagicString => undef,
	Untgz => undef,
	IsSubPackage => undef,			# boolean value 
	SubDir => undef,				# part of package path for subpackage
	SubPackages => undef,				# array of subpackage objects
	ParentPackage => undef,			# parent package object, only if IsSubPackage is set 
	FlushIntoReg => 0,				# flag to activate / deactivate changes in regpackobj, needed for prepare phase
	CheckSum => undef,				# checksum of archive file
	WithParent => undef, 			# subpackage will be installed together with its parent package
	SubPackObjs => undef,			# list of subpackage objects that will be installed togeter with this package
	DispName => undef,				# name of pakages visible from outside
	IgnoreBusyFiles => undef		# list of files which won't break unpack check
);


$members{'MappedFiles'} = undef if ($^O =~ /mswin/i);


my $id=0;

sub evalScript{
	my ($self) = @_;
	defined $self->Script or return 0;
	my $newpackagename='SAPDB::Install::Pkg'.$self->ID;
	sub getPerlPackageName{
		my ($package,$filename,$line)=caller;
		return $package;
	}
	my $packagename=getPerlPackageName();	
	my $varname='SELFOBJ['.$self->ID.']';
	#my $svid=$self->ID;
	#my $script= "package $newpackagename;\n local *SELFOBJ=\$$packagename\::refTmp;\n".${$self->Script};
	my $script= "package $newpackagename;\n".${$self->Script};
	$script=~s/\$packobj/\$$packagename\::$varname/g;
	#$script=~s/\$packobj/\$SAPDB::Install::StartInstall::packageref[$svid]/g;
	$script=~s/\$instRegistry/\$SAPDB::Install::StartInstall::instRegistry/g;
	if($DEBUG){
		my @text= split("\n",$script);
		my $linecount=1;
		foreach my $line (@text){
			print "$linecount: $line\n";
			$linecount++;
		}
	}
	defined(%{"${newpackagename}::"}) and $SAPDB::Install::StartInstall::log->SetMsg("WRN: generated package exists in mem - now overwrite it\n");
	eval($script) or print $self->Name."ERR: $@\n" and return 0;
	foreach my $func ('preinstall','preunpack','postprepare','postinstall','register','unregister','framestart','framestop'){
		if(defined &{"${newpackagename}::$func"}){
			TraceMsg("MSG: set function reference \"$func\" in package ".$self->Name."\n",3,\$DEBUG);
			$self->$func(\&{"${newpackagename}::$func"});
		}
		else{
			TraceMsg("MSG: no function \"$func\" in package ".$self->Name."\n",3,\$DEBUG);
		}
	}
	defined ${"${newpackagename}::usage"} and $self->Usage(${"${newpackagename}::usage"});
	defined ${"${newpackagename}::usage_desc"} and $self->UsageDesc(${"${newpackagename}::usage_desc"});
	defined ${"${newpackagename}::main_path"} and $self->MainPath(${"${newpackagename}::main_path"});
	defined ${"${newpackagename}::skip"} and $self->Skip(\${"${newpackagename}::skip"});
	my @newArray;
	defined @{"${newpackagename}::paths"} and $self->Paths(\@{"${newpackagename}::paths"}) or $self->Paths(\@newArray);
	defined @{"${newpackagename}::opts"} and $self->Opts(\@{"${newpackagename}::opts"}) or $self->Opts(\@newArray);

}
	
sub initData{
	my ($self,$rhData)=@_;
	ref($rhData) ne 'HASH' and return 0;
	my %data = %$rhData;
	$self->InterfaceVersion($data{'INTERFACE_VERSION'});
	$self->Name($data{'PACKAGE_NAME'});
	$self->Version($data{'SOFTWARE_VERSION'});
	$self->PackageVersion($data{'PACKAGE_VERSION'});
	$self->Mode($data{'MODE'});
	$self->Type($data{'TYPE'});
	my @profiles=split(',',$data{'PART_OF'});
	$self->Profiles(\@profiles);
	my @require=split(',',$data{'REQUIRE'});
	$self->Require(\@require);
	$self->Archive($data{'ARCHIVE_NAME'});
	$self->MinVersion($data{'MIN_VERSION'});
	$self->AllowSkip($data{'ALLOW_SKIP'});
	$self->TopOf($data{'IS_TOP_OF'});
	$self->IsSubPackage($data{'IS_SUBPACKAGE'});
	$self->SubDir($data{'SUB_DIR'});
	$self->MagicMode($data{'MAGIC_MODE'});
	unless($^O=~/mswin/i){
		$self->User($data{'DEFAULT_USER'});
		$self->Group($data{'DEFAULT_GROUP'});
	}
	$self->Untgz($data{'UNTGZ'});

	if($data{'TEST_FILE'}){
		$self->TestFile($data{'TEST_FILE'});
		$self->MagicString($data{'MAGIC'});
	}
	if(defined $data{'DISPLAY_NAME'}){
		$self->DispName($data{'DISPLAY_NAME'});
	}
	else{
		$self->DispName($data{'PACKAGE_NAME'});
	}

	my $text = readFileInTGZ($data{'UNTGZ'},$data{'SCRIPT'});
	
	$self->Script(\$text);
	
	my $md5sum = MD5Sum($data{'ARCHIVE_NAME'});
	
	if(defined $md5sum && $md5sum =~ /^[0-9a-f]{32}$/){
		$self->CheckSum($md5sum);
	}

	my $filelist = readFileInTGZ($data{'UNTGZ'},$data{'FILELIST'});
	my %md5sums;
	foreach my $file (split("\n",$filelist)){
		$file=~/^\s*"(\S.*\S)"\s*([0-9a-z]{32})\s*$/ and $md5sums{$1}=$2;# and print "#####MATCH#####\n" or print "#####DONT MATCH#####\n";
	}
	$self->FileList(\%md5sums);
	$self->evalScript; 
}






@SELFOBJ;


sub new{
	my ($type) = @_;
	$id==0 and $SAPDB::Install::StartInstall::cleaner->SetRef(\@SELFOBJ);
	my $self= SAPDB::Install::Base->new;
	foreach my $key (keys(%members)){
		$self->{$key}=$members{$key};
	}
	$self = bless $self,$type;
	$SELFOBJ[$id]=$self;
	$self->ID($id++);
	$self->SubPackObjs([]);
	$self->SubPackages([]);
	return $self;
}


sub freeSELFOBJ{
	#workaround for problem with simple perl garbage collection (no cycle detection)  
	my ($self)=@_;
	$SELFOBJ[$self->ID]=undef; # free $SELFOBJ[ID] 
}


sub setDataInRegistry{
	my ($self)=@_;
	$self->FlushIntoReg or TraceMsg("data not flushable - flag disabled\n",3,\$DEBUG) and return 1;
	$self->RegData->Version($self->Version);
	$self->RegData->Require($self->Require);
	$self->RegData->User($self->User);
	$self->RegData->Group($self->Group);
	$self->RegData->PackageVersion($self->PackageVersion);
	$self->RegData->Profiles($self->Profiles);
	$self->RegData->Pathes($self->Paths);
	defined $self->CheckSum and $self->RegData->CheckSum($self->CheckSum);

	$self->RegData->TestFile($self->TestFile) if $self->TestFile =~ /\S/;

	if($self->DispName ne $self->Name){
		$self->RegData->DispName($self->DispName);
	}
	$self->RegData->Mode($self->Mode);
	$self->RegData->IsSubPackage($self->IsSubPackage);
	#$self->RegData->SubPackages($self->SubPackages);
	$self->RegData->ParentPackage($self->ParentPackage);
	#if (defined $self->ParentPackage){
	#	if(ref($self->ParentPackage) =~ /SAPDB::Install::InstallRegistry::Package/){
	#			$self->RegData->ParentPackage([${$self->ParentPackage}->Name,${$self->ParentPackage}->Path]);
	#	}
	#	elsif(ref($self->ParentPackage) =~ /SAPDB::Install::PackageObj/){
	#			$self->RegData->ParentPackage([${$self->ParentPackage}->Name,${%{${$self->ParentPackage}->MainPath}}{'value'}]);
	#	}
	#}
}

sub DESTROY{
	my ($self)=@_;
	defined $self->RegData && $self->setDataInRegistry;
	$self->SAPDB::Install::Base::DESTROY;
}


1;

