#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Migrate/DBRegistrations.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
# Desc: 
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end



package SAPDB::Install::Migrate::DBRegistrations;

$VERSION = 1.01;

sub BEGIN {
      $DEBUG=0;
	  @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('migrateDBRegistrations');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Values',
		'Registry',
		'Tools',
		'MD5Sum',
		'System',
		'Trace',
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


sub migrateDBRegistrations{
	my ($instPath) = @_;
	return if $^O =~ /mswin/i;
	my ($indep_data,$indep_prog) = readIndepPath();
	my $db_reg_ini = $indep_data.'/config/Databases.ini';
	
	my %ini_data = readini($ini_path) if -f ($ini_path);
	my $old_dbs = {};
	if(defined %ini_data and exists $ini_data{'Databases'} and ref($ini_data{'Databases'}) eq 'HASH'){
		$old_dbs = $ini_data{'Databases'}; 
	} 
	
	%ini_data = ();

	%ini_data = readini($db_reg_ini) if -f ($db_reg_ini);
	my $new_dbs = {};
	if(defined %ini_data and exists $ini_data{'Databases'} and ref($ini_data{'Databases'}) eq 'HASH'){
		$new_dbs = $ini_data{'Databases'}; 
	}

	my @dbs2mig;
	foreach my $db (keys(%$old_dbs)){
		next if $db =~ /^[\._]/;
		if($old_dbs->{$db} eq $instPath){
			push @dbs2mig,$db; 
		}
	}
	my @already_migrated;
	foreach my $db (keys(%$new_dbs)){
		next if $db =~ /^[\._]/;
		if($new_dbs->{$db} eq $instPath){
			push @already_migrated,$db; 
		}
	}	
	my @migrate_now = minus(\@dbs2mig,\@already_migrated);
	
	if($#migrate_now > -1){
		my %db_reg;
		foreach my $db (@migrate_now){
			$SAPDB::Install::Values::log->SetMsg("MSG: add new registration of instance $db\n");
			$db_reg{$db} = $instPath; 	
		}
		writeini($db_reg_ini,{'add_key' => {'Databases' => \%db_reg}});	
	}

	if($#dbs2mig > -1){
		my %db_reg;
		foreach my $db (@dbs2mig){
			$db_reg{$db} = $instPath;
			$SAPDB::Install::Values::log->SetMsg("MSG: remove old registration of instance $db\n");
 		}
		writeini($ini_path,{'delete_key' => {'Databases' => \%db_reg}});	
	}
}

1;