#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/develop/sys/src/install/perl/SAPDB/Install/Instance/Operate.pm#3 $
# $DateTime: 2003/12/11 13:40:27 $
# $Change: 59245 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Operate;

#
# usually these function are called in 
# the pre- or postinstall step of SDBUPD
#
sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
       	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

push @ISA, 'SAPDB::Install::Instance::Base'; 

#
# bring database in admin mode exec migrate database
#
sub exec_migrate_database {
	my ($self) = @_; 
	my $dbm = $self->{dbm};
	my $rc;

	$self->set_errorstate ('ERROR');

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	$self->msgbegin ("migrating ".$self->{instancetypename});

	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}
	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");
	
	#
	# first switch to offline mode
	#
	if ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		$self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1); 
		}

	} elsif (!($state =~ /OFFLINE/i)) {
		$state = 
		$self->switchto ('CLEAR', "clear ".
		$self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1); 
		}
	}

	#
	# check parameters in offline mode
	#
	$self->msg0 ("checking parameters...\n");
	unless ($dbm->param_checkall () eq 'OK'){
		$self->msg0 ("parameter check failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	#
	# first try to bring instance into cold mode
	#
	if ($self->{'can_db_admin'}) {
		$state = $self->switchto ('ADMIN', "switch ".
		$self->{instancetypename}." state to ADMIN\n");
	} else {
		$state = $self->switchto ('COLD', "switch ".
		$self->{instancetypename}." state to COLD\n");
	}

	unless ($state =~ /COLD|ADMIN/) {
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return (-1); 
	}

	$self->msg0 ("migrating database...\n");	
	$rc = $dbm->util_execute ('migrate database');	
	unless (defined $rc && $rc =~ /^OK/) {
		$self->msg0 ("cannot migrate database\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return -1;
	}

	$state = $self->switchto ('OFFLINE', "switch ".
	$self->{instancetypename}." state to OFFLINE\n");
	unless ($state =~ /OFFLINE/) {
		$state =
		$self->switchto ('CLEAR', "clear ".
		$self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1);
		}
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
}

#
# bring database in offline mode and migrate catalog to unicode
#
sub migrate_catalog_to_unicode {
	my ($self) = @_;
	my $dbm = $self->{dbm};
	my $rc;

	$self->set_errorstate ('ERROR');

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	my $uses_unicode_catalog = $dbm->param_directget ('_UNICODE');
	unless (defined $uses_unicode_catalog) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	$uses_unicode_catalog = $uses_unicode_catalog =~ /YES/ ? 1 : 0;
	if ($uses_unicode_catalog) {
		$self->msg1
		($self->{instancetypename}." already uses unicode catalog\n");
		$self->set_errorstate ('OK');
		$self->msgend ();
		return 0;
	}

	$self->msgbegin ("migrating catalog to unicode");

	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");

	#
	# first switch to offline mode
	#
	if ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		$self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return -1;
		}
	} elsif (!($state =~ /OFFLINE/i)) {
		$state =
		$self->switchto ('CLEAR', "clear ".
		$self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return -1;
		}
	}

	$self->msg0 ("migrating catalog to unicode...\n");
	$rc = $dbm->db_migratecatalog ();
	unless (defined $rc && $rc =~ /^OK/) {
		$self->msg0 ("migration of catalog to unicode failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return -1;
	}

	$state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
}

#
# set catalog to unicode in paramfile
# only useable for liveCache migrations with init config
#
sub set_catalog_to_unicode {
	my ($self) = @_; 
	my $dbm = $self->{dbm};
	my $rc;

	# get current parameter
	my $uses_unicode_catalog = $dbm->param_directget ('_UNICODE');
	unless (defined $uses_unicode_catalog) {
		$self->msg1 ("cannot get catalog type\n");
		$self->msg1 ($dbm->lastdialog ());
		return -1;
	}

	$uses_unicode_catalog = $uses_unicode_catalog eq 'YES' ? 1 : 0;
	if ($uses_unicode_catalog == 1) {
		$self->msg0 ("catalog uses already unicode\n");
		return 0;
	}

	$self->msg0 ("setting catalog to unicode\n");
	$rc = $dbm->param_directput ('_UNICODE', 'YES');
	unless (defined $rc && $rc eq 'OK') {
		$self->msg1 ("cannot set catalog type\n");
		$self->msg1 ($dbm->lastdialog ());
		return -1;
	}

	# check parameters
	$self->msg0 ("checking parameters...\n");
	$rc = $dbm->param_checkall ();
	unless (defined $rc && $rc eq 'OK'){
		$self->msg0 ("parameter check failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		return -1;
	}

	return 0;
}

#
# initialize_for_recovery ()
# bring instance in cold mode and format volumes
#
sub initialize_for_recovery {
	my ($self) = @_; 
	my $rc;

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("initializing instance for recovery");

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	my $dbm = $self->{dbm};
	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}
	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");
	
	#
	# first switch to offline mode
	#
	if ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		$self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1); 
		}

	} elsif (!($state =~ /OFFLINE/i)) {
		$state = 
		$self->switchto ('CLEAR', "clear ".
		$self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1); 
		}
	}

	#
	# check parameters in offline mode
	#
	$self->msg0 ("checking parameters...\n");
	unless ($dbm->param_checkall () eq 'OK'){
		$self->msg0 ("parameter check failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	#
	# set catalog to unicode for liveCache 7.4.x x >= 3 and APO >= 4
	#
	if (
	$self->{target_release} =~ /^7\.4\.(\d+)/ && $1 >= 3 &&
	$self->{apo_target_release} =~ /^(\d+)\./ && $1 >= 4) {
		unless ($self->set_catalog_to_unicode () == 0) {
			$self->msgend ();
			return -1;
		}
	}

	#
	# first try to bring instance into cold mode
	#
	if ($self->{'can_db_admin'}) {
		$state = $self->switchto ('ADMIN', "switch ".
		$self->{instancetypename}." state to ADMIN\n");
	} else {
		$state = $self->switchto ('COLD', "switch ".
		$self->{instancetypename}." state to COLD\n");
	}

	unless ($state =~ /COLD|ADMIN/) {
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return (-1); 
	}

	#
	# after that format devspaces
	#
	$self->msg0 ("initialize ".$self->{instancetypename}."...\n");
	$rc = $dbm->util_execute ('init config');
	unless ($rc && $rc eq 'OK'){
		$self->msg1 ($dbm->lastdialog ());
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return (-1); 
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
}

#
# initialize_for_report ()
# bring instance in cold mode and format devspaces
#
sub initialize_for_report {
	my ($self) = @_; 
	my $rc;

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("initializing instance for report");

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	my $dbm = $self->{dbm};
	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}
	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");
	
	#
	# first switch to offline mode
	#
	if ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		$self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return -1; 
		}
	} elsif (!($state =~ /OFFLINE/i)) {
		$state = 
		$self->switchto ('CLEAR', "clear ".
		$self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return -1; 
		}
	}

	#
	# check parameters in offline mode
	#
	$self->msg0 ("checking parameters...\n");
	unless ($dbm->param_checkall () eq 'OK') {
		$self->msg0 ("parameter check failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	#
	# set catalog to unicode for liveCache 7.4.x x >= 3 and APO >= 4
	#
	if (
	$self->{target_release} =~ /^7\.4\.(\d+)/ && $1 >= 3 &&
	$self->{apo_target_release} =~ /^(\d+)\./ && $1 >= 4) {
		unless ($self->set_catalog_to_unicode () == 0) {
			$self->msgend ();
			return -1;
		}
	}

	#
	# first try to bring instance into cold mode
	#
	if ($self->{'can_db_admin'}) {
		$state = $self->switchto ('ADMIN', "switch ".
		$self->{instancetypename}." state to ADMIN\n");
	} else {
		$state = $self->switchto ('COLD', "switch ".
		$self->{instancetypename}." state to COLD\n");
	}

	unless ($state =~ /COLD|ADMIN/){
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return -1; 
	}

	#
	# after that format devspaces if they can init config
	#
	if ($self->candbm ('db_activate') == 1) {
		$self->msg1 ("dbmsrv uses db_activate\n");
	} else {
		$self->msg0 ("initialize ".$self->{instancetypename}."...\n");
		$self->msg1 ("dbmsrv uses util_execute init config\n");

		$rc = $dbm->util_execute ('init config');
		unless ($rc && $rc eq 'OK'){
			$self->msg1 ($dbm->lastdialog ());
			$self->get_errmsg_from_knldiag ();
			$self->msgend ();
			return -1; 
		}
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
}

#
# shutdown ()
# switch instance in offline mode
#
sub shutdown {
	my ($self) = @_; 
	my $rc;

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("shutting down instance");

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	my $dbm = $self->{dbm};
	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	$self->msg1 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");

	if ($state =~ /OFFLINE/) {
		$self->set_errorstate ('OK');
		$self->msgend ();
		return 0;
	} elsif ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		         $self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE'){
			$self->msgend ();
			return (-1); 
		}
	} elsif (!($state =~ /OFFLINE/)) {
		$state = $self->switchto ('CLEAR', "clear ".
		         $self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE'){
			$self->msgend ();
			return (-1); 
		}
	}

	$self->msg1 ($self->{instancetypename}." is OFFLINE now\n");
	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;	
}

#
# restart ()
# bring instance in warm state and load system tables
#
sub restart {
	my ($self, $domain_passwrd) = @_; 
	my $rc;

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("restarting instance");

	unless (defined $self->{instancetypename}) {
		$self->{instancetypename} =
		$self->{instancetype} =~ /LVC/ ? 'liveCache' : 'database';
	}

	my $dbm = $self->{dbm};
	my $state = $dbm->db_state ();
	unless (defined $state) {
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}
	$self->msg0 ("current ".$self->{instancetypename}.
	             " state is ".$state."\n");
	
	#
	# first switch to offline mode
	#
	if ($state =~ /WARM|COLD|ONLINE|ADMIN/) {
		$state = $self->switchto ('OFFLINE', "switch ".
		         $self->{instancetypename}." state to OFFLINE\n");

		unless ($state eq 'OFFLINE') {
			$self->msgend ();
			return (-1); 
		}
	} elsif (!($state =~ /OFFLINE/)) {
		$state = $self->switchto ('CLEAR', "clear ".
		         $self->{instancetypename}." state\n");

		unless ($state eq 'OFFLINE'){
			$self->msgend ();
			return (-1); 
		}
	}

	#
	# check parameters in offline mode
	#
	$self->msg0 ("checking parameters...\n");
	unless ($dbm->param_checkall () eq 'OK'){
		$self->msg0 ("parameter check failed\n");	
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return -1;
	}

	#
	# first try to bring instance into cold mode
	#
	if ($self->{'can_db_admin'}) {
		$state = $self->switchto ('ADMIN', "switch ".
		$self->{instancetypename}." state to ADMIN\n");
	} else {
		$state = $self->switchto ('COLD', "switch ".
		$self->{instancetypename}." state to COLD\n");
	}

	unless ($state =~ /COLD|ADMIN/){
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return (-1); 
	}

	#
	# after that bring it into warm mode
	#
	if ($self->{'can_db_online'}) {
		$state = $self->switchto ('ONLINE', "switch ".
		$self->{instancetypename}." state to ONLINE\n");
	} else {
		$state = $self->switchto ('WARM', "switch ".
		$self->{instancetypename}." state to WARM\n");
	}

	unless ($state =~ /WARM|ONLINE/){
		$self->get_errmsg_from_knldiag ();
		$self->msgend ();
		return (-1); 
	}

	#
	# and load system tables
	#	
	$self->msg0 ("loading system tables...\n");	
	unless ($self->load_systab ($domain_passwrd) eq 'OK'){
		$self->msg0 ("loading system tables failed\n");	
		$self->msg0 ($dbm->lastdialog ()."\n");
		return -1;
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
}

sub operate {
	my ($self, $function) = @_; 

	if ($function =~ /restart/) {
		my $rc = $self->restart ();
		return ($rc);
	}

	if ($function =~ /shutdown/) {
		my $rc = $self->shutdown ();
		return ($rc);
	}

	if ($function =~ /knldiag/) {
		my $rc = $self->get_errmsg_from_knldiag ();
		return ($rc);
	}

	return undef;
}

#
# main
#
sub main {
	return (SAPDB::Install::Instance::Operate::Test::main (@_));
}

package SAPDB::Install::Instance::Operate::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

sub main {
	local @ARGV = @_;

	my $dbname, $userpwd, $dbhost, $verbose, $help;

	# allow interpretation of '-v' as '--verbose'
	SAPDB::Install::Getopt::Long::Configure ('auto_abbrev');
	GetOptions (
		'dbname=s', \$dbname, 
		'node:s', \$dbhost, 
		'user=s', \$userpwd,
		'help', \$help,
		'verbose', \$verbose);

	my ($function) = @ARGV;

	if (defined $help) {
		print "SAPDB::Install::Instance::Check::main\n";
		print "check, if instance will be ready\n";
		print "for software upgrade or patch\n";
		print "usage:\n";
		print "  -d (--dbname) <dbname>\n";
		print "  -n (--node)   <dbhost>\n";
		print "  -u (--user)   <dbmusr,dbmpasswd>\n";
		print "  -v (--verbose)\n";
		print "\n";
		return 0;
	}

	$DEBUG = 1 if ($verbose);

	my $ic = SAPDB::Install::Instance::Operate->new ();

	$ic->{msg0} = \&msg0;
	$ic->{msg1} = \&msg1 if ($DEBUG);

	unless (defined $dbname) {
		printmsg ("missing instance name\n");		
		return 0;
	}

	unless (defined $userpwd) {
		printmsg ("missing user,password of dbm-user\n");
		return 0;
	}

	unless (defined $function) {
		printmsg ("missing function\n");
		return 0;
	}

	unless ($function =~ /^restart|^shutdown|^knldiag/) {
		printmsg ("function <restart|shutdown|knldiag>\n");
		return 0;
	}
	
	my $rc;
	if (defined $dbhost) {
		$rc = $ic->session (
			'dbname' => $dbname,
			'userpwd' => $userpwd,
			'dbhost' => $dbhost);
	} else {
		$rc = $ic->session ('dbname' => $dbname, 'userpwd' => $userpwd);
	}

	unless (defined $rc)  {
		printmsg ($ic->{msgtxt});
		return 0;
	}

	if ($ic->operate ($function) == 0) {
		printmsg ("\n");
		printmsg ("instance operate ok\n");
		printmsg ("errorstate = ".$ic->get_errorstate ()."\n");
	} else {
		printmsg ("\n");
		printmsg ("instance operate failed\n");
		printmsg ("\n");
		printmsg ($ic->{msgtxt});
		printmsg ("errorstate = ".$ic->get_errorstate ()."\n");
	}
	return;
}

sub msg1 {
	print "INFO>>> ";
	print @_;
}

sub msg0 {
	print "MSG >>> ";
	print @_;
}

sub printmsg {
	my $txt = shift;

	msg0 ($txt) if ($txt) eq "\n";

	foreach (split '\n', $txt) {
		msg0 ($_."\n");
	}
}

1;
