#!/usr/bin/perl
#
# $Header: //sapdb/I00/develop/sys/src/install/perl/SAPDB/Install/Instance/Check/Instances.pm#4 $
# $DateTime: 2001/12/03 16:06:37 $
# $Change: 12137 $
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end


package SAPDB::Install::Instance::Check::DomainUser;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Conditions'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Conditions';

sub domainuser {
	my ($self) = @_;
	my $dbm = $self->{dbm};

	#
	# find out instance type if not already known
	#
	unless (defined $self->{'instancetype'}) {
		my $rc = $self->conditions ();
		return undef unless (defined $rc && $rc == 0);
	}

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("looking for domain user");	
	$self->msg0 ("looking for domain user...\n");

	my $userlist = $dbm->user_getall ();
	unless (defined $userlist) {
		$self->msg1 ("\n");
		$self->msg1 ($dbm->lastdialog ());
		$self->msgend ();
		return undef;
	}

	$self->msg1 ("user profile container contains:\n");
	$self->msg1 ("\n");
	foreach my $user (@$userlist) {
		$self->msg1 ("  ".$user."\n");
	}
	$self->msg1 ("\n");

	foreach my $user (@$userlist) {
		if ($user =~ /^domain$/i) {
			$self->msg1
			("found domain user in user profile container\n");
			$self->set_errorstate ('OK');
			$self->msgend ();
			return 0;
		}
	}

	$self->msg1 ("domain user not found in user profile container\n");
	$self->msg1 ("unable to load system tables\n");
	$self->msg1 ("\n");
	$self->msg1 ("load system tables and run SDBUPD again\n");
	$self->msg1 ("\n");

	$self->msgend ();
	return undef;
} 

1;

